/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeActionConnectorResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeActionConnectorResponse.Builder, DescribeActionConnectorResponse> {
    private static final SdkField<ActionConnector> ACTION_CONNECTOR_FIELD = SdkField
            .<ActionConnector> builder(MarshallingType.SDK_POJO).memberName("ActionConnector")
            .getter(getter(DescribeActionConnectorResponse::actionConnector)).setter(setter(Builder::actionConnector))
            .constructor(ActionConnector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionConnector").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeActionConnectorResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(DescribeActionConnectorResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_CONNECTOR_FIELD,
            REQUEST_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ActionConnector actionConnector;

    private final String requestId;

    private final Integer status;

    private DescribeActionConnectorResponse(BuilderImpl builder) {
        super(builder);
        this.actionConnector = builder.actionConnector;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The detailed information about the action connector, including its configuration and current state.
     * </p>
     * 
     * @return The detailed information about the action connector, including its configuration and current state.
     */
    public final ActionConnector actionConnector() {
        return actionConnector;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status code of the request.
     * </p>
     * 
     * @return The HTTP status code of the request.
     */
    public final Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionConnector());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActionConnectorResponse)) {
            return false;
        }
        DescribeActionConnectorResponse other = (DescribeActionConnectorResponse) obj;
        return Objects.equals(actionConnector(), other.actionConnector()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeActionConnectorResponse").add("ActionConnector", actionConnector())
                .add("RequestId", requestId()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionConnector":
            return Optional.ofNullable(clazz.cast(actionConnector()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ActionConnector", ACTION_CONNECTOR_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeActionConnectorResponse, T> g) {
        return obj -> g.apply((DescribeActionConnectorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeActionConnectorResponse> {
        /**
         * <p>
         * The detailed information about the action connector, including its configuration and current state.
         * </p>
         * 
         * @param actionConnector
         *        The detailed information about the action connector, including its configuration and current state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionConnector(ActionConnector actionConnector);

        /**
         * <p>
         * The detailed information about the action connector, including its configuration and current state.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionConnector.Builder} avoiding the
         * need to create one manually via {@link ActionConnector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionConnector.Builder#build()} is called immediately and its
         * result is passed to {@link #actionConnector(ActionConnector)}.
         * 
         * @param actionConnector
         *        a consumer that will call methods on {@link ActionConnector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionConnector(ActionConnector)
         */
        default Builder actionConnector(Consumer<ActionConnector.Builder> actionConnector) {
            return actionConnector(ActionConnector.builder().applyMutation(actionConnector).build());
        }

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status code of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status code of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private ActionConnector actionConnector;

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActionConnectorResponse model) {
            super(model);
            actionConnector(model.actionConnector);
            requestId(model.requestId);
            status(model.status);
        }

        public final ActionConnector.Builder getActionConnector() {
            return actionConnector != null ? actionConnector.toBuilder() : null;
        }

        public final void setActionConnector(ActionConnector.BuilderImpl actionConnector) {
            this.actionConnector = actionConnector != null ? actionConnector.build() : null;
        }

        @Override
        public final Builder actionConnector(ActionConnector actionConnector) {
            this.actionConnector = actionConnector;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public DescribeActionConnectorResponse build() {
            return new DescribeActionConnectorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
