/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A grouping of individual filters. Filter groups are applied to the same group of visuals.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/quicksight/latest/user/add-a-compound-filter.html">Adding filter conditions (group
 * filters) with AND and OR operators</a> in the <i>Amazon Quick Suite User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterGroup implements SdkPojo, Serializable, ToCopyableBuilder<FilterGroup.Builder, FilterGroup> {
    private static final SdkField<String> FILTER_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterGroupId").getter(getter(FilterGroup::filterGroupId)).setter(setter(Builder::filterGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterGroupId").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(FilterGroup::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FilterScopeConfiguration> SCOPE_CONFIGURATION_FIELD = SdkField
            .<FilterScopeConfiguration> builder(MarshallingType.SDK_POJO).memberName("ScopeConfiguration")
            .getter(getter(FilterGroup::scopeConfiguration)).setter(setter(Builder::scopeConfiguration))
            .constructor(FilterScopeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScopeConfiguration").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(FilterGroup::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> CROSS_DATASET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CrossDataset").getter(getter(FilterGroup::crossDatasetAsString)).setter(setter(Builder::crossDataset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossDataset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_GROUP_ID_FIELD,
            FILTERS_FIELD, SCOPE_CONFIGURATION_FIELD, STATUS_FIELD, CROSS_DATASET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String filterGroupId;

    private final List<Filter> filters;

    private final FilterScopeConfiguration scopeConfiguration;

    private final String status;

    private final String crossDataset;

    private FilterGroup(BuilderImpl builder) {
        this.filterGroupId = builder.filterGroupId;
        this.filters = builder.filters;
        this.scopeConfiguration = builder.scopeConfiguration;
        this.status = builder.status;
        this.crossDataset = builder.crossDataset;
    }

    /**
     * <p>
     * The value that uniquely identifies a <code>FilterGroup</code> within a dashboard, template, or analysis.
     * </p>
     * 
     * @return The value that uniquely identifies a <code>FilterGroup</code> within a dashboard, template, or analysis.
     */
    public final String filterGroupId() {
        return filterGroupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of filters that are present in a <code>FilterGroup</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The list of filters that are present in a <code>FilterGroup</code>.
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The configuration that specifies what scope to apply to a <code>FilterGroup</code>.
     * </p>
     * <p>
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     * </p>
     * 
     * @return The configuration that specifies what scope to apply to a <code>FilterGroup</code>.</p>
     *         <p>
     *         This is a union type structure. For this structure to be valid, only one of the attributes can be
     *         defined.
     */
    public final FilterScopeConfiguration scopeConfiguration() {
        return scopeConfiguration;
    }

    /**
     * <p>
     * The status of the <code>FilterGroup</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WidgetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the <code>FilterGroup</code>.
     * @see WidgetStatus
     */
    public final WidgetStatus status() {
        return WidgetStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the <code>FilterGroup</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WidgetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the <code>FilterGroup</code>.
     * @see WidgetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The filter new feature which can apply filter group to all data sets. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_DATASETS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SINGLE_DATASET</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #crossDataset} will
     * return {@link CrossDatasetTypes#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #crossDatasetAsString}.
     * </p>
     * 
     * @return The filter new feature which can apply filter group to all data sets. Choose one of the following
     *         options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_DATASETS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SINGLE_DATASET</code>
     *         </p>
     *         </li>
     * @see CrossDatasetTypes
     */
    public final CrossDatasetTypes crossDataset() {
        return CrossDatasetTypes.fromValue(crossDataset);
    }

    /**
     * <p>
     * The filter new feature which can apply filter group to all data sets. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_DATASETS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SINGLE_DATASET</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #crossDataset} will
     * return {@link CrossDatasetTypes#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #crossDatasetAsString}.
     * </p>
     * 
     * @return The filter new feature which can apply filter group to all data sets. Choose one of the following
     *         options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_DATASETS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SINGLE_DATASET</code>
     *         </p>
     *         </li>
     * @see CrossDatasetTypes
     */
    public final String crossDatasetAsString() {
        return crossDataset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scopeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(crossDatasetAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterGroup)) {
            return false;
        }
        FilterGroup other = (FilterGroup) obj;
        return Objects.equals(filterGroupId(), other.filterGroupId()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(scopeConfiguration(), other.scopeConfiguration())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(crossDatasetAsString(), other.crossDatasetAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterGroup").add("FilterGroupId", filterGroupId())
                .add("Filters", hasFilters() ? filters() : null).add("ScopeConfiguration", scopeConfiguration())
                .add("Status", statusAsString()).add("CrossDataset", crossDatasetAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterGroupId":
            return Optional.ofNullable(clazz.cast(filterGroupId()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "ScopeConfiguration":
            return Optional.ofNullable(clazz.cast(scopeConfiguration()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CrossDataset":
            return Optional.ofNullable(clazz.cast(crossDatasetAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FilterGroupId", FILTER_GROUP_ID_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("ScopeConfiguration", SCOPE_CONFIGURATION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CrossDataset", CROSS_DATASET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterGroup, T> g) {
        return obj -> g.apply((FilterGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterGroup> {
        /**
         * <p>
         * The value that uniquely identifies a <code>FilterGroup</code> within a dashboard, template, or analysis.
         * </p>
         * 
         * @param filterGroupId
         *        The value that uniquely identifies a <code>FilterGroup</code> within a dashboard, template, or
         *        analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterGroupId(String filterGroupId);

        /**
         * <p>
         * The list of filters that are present in a <code>FilterGroup</code>.
         * </p>
         * 
         * @param filters
         *        The list of filters that are present in a <code>FilterGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The list of filters that are present in a <code>FilterGroup</code>.
         * </p>
         * 
         * @param filters
         *        The list of filters that are present in a <code>FilterGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The list of filters that are present in a <code>FilterGroup</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.Filter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.Filter.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The configuration that specifies what scope to apply to a <code>FilterGroup</code>.
         * </p>
         * <p>
         * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
         * </p>
         * 
         * @param scopeConfiguration
         *        The configuration that specifies what scope to apply to a <code>FilterGroup</code>.</p>
         *        <p>
         *        This is a union type structure. For this structure to be valid, only one of the attributes can be
         *        defined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopeConfiguration(FilterScopeConfiguration scopeConfiguration);

        /**
         * <p>
         * The configuration that specifies what scope to apply to a <code>FilterGroup</code>.
         * </p>
         * <p>
         * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterScopeConfiguration.Builder}
         * avoiding the need to create one manually via {@link FilterScopeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterScopeConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #scopeConfiguration(FilterScopeConfiguration)}.
         * 
         * @param scopeConfiguration
         *        a consumer that will call methods on {@link FilterScopeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scopeConfiguration(FilterScopeConfiguration)
         */
        default Builder scopeConfiguration(Consumer<FilterScopeConfiguration.Builder> scopeConfiguration) {
            return scopeConfiguration(FilterScopeConfiguration.builder().applyMutation(scopeConfiguration).build());
        }

        /**
         * <p>
         * The status of the <code>FilterGroup</code>.
         * </p>
         * 
         * @param status
         *        The status of the <code>FilterGroup</code>.
         * @see WidgetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WidgetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the <code>FilterGroup</code>.
         * </p>
         * 
         * @param status
         *        The status of the <code>FilterGroup</code>.
         * @see WidgetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WidgetStatus
         */
        Builder status(WidgetStatus status);

        /**
         * <p>
         * The filter new feature which can apply filter group to all data sets. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_DATASETS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SINGLE_DATASET</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param crossDataset
         *        The filter new feature which can apply filter group to all data sets. Choose one of the following
         *        options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_DATASETS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SINGLE_DATASET</code>
         *        </p>
         *        </li>
         * @see CrossDatasetTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CrossDatasetTypes
         */
        Builder crossDataset(String crossDataset);

        /**
         * <p>
         * The filter new feature which can apply filter group to all data sets. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_DATASETS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SINGLE_DATASET</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param crossDataset
         *        The filter new feature which can apply filter group to all data sets. Choose one of the following
         *        options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_DATASETS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SINGLE_DATASET</code>
         *        </p>
         *        </li>
         * @see CrossDatasetTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CrossDatasetTypes
         */
        Builder crossDataset(CrossDatasetTypes crossDataset);
    }

    static final class BuilderImpl implements Builder {
        private String filterGroupId;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private FilterScopeConfiguration scopeConfiguration;

        private String status;

        private String crossDataset;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterGroup model) {
            filterGroupId(model.filterGroupId);
            filters(model.filters);
            scopeConfiguration(model.scopeConfiguration);
            status(model.status);
            crossDataset(model.crossDataset);
        }

        public final String getFilterGroupId() {
            return filterGroupId;
        }

        public final void setFilterGroupId(String filterGroupId) {
            this.filterGroupId = filterGroupId;
        }

        @Override
        public final Builder filterGroupId(String filterGroupId) {
            this.filterGroupId = filterGroupId;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final FilterScopeConfiguration.Builder getScopeConfiguration() {
            return scopeConfiguration != null ? scopeConfiguration.toBuilder() : null;
        }

        public final void setScopeConfiguration(FilterScopeConfiguration.BuilderImpl scopeConfiguration) {
            this.scopeConfiguration = scopeConfiguration != null ? scopeConfiguration.build() : null;
        }

        @Override
        public final Builder scopeConfiguration(FilterScopeConfiguration scopeConfiguration) {
            this.scopeConfiguration = scopeConfiguration;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WidgetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCrossDataset() {
            return crossDataset;
        }

        public final void setCrossDataset(String crossDataset) {
            this.crossDataset = crossDataset;
        }

        @Override
        public final Builder crossDataset(String crossDataset) {
            this.crossDataset = crossDataset;
            return this;
        }

        @Override
        public final Builder crossDataset(CrossDatasetTypes crossDataset) {
            this.crossDataset(crossDataset == null ? null : crossDataset.toString());
            return this;
        }

        @Override
        public FilterGroup build() {
            return new FilterGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
