/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A transform operation that filters rows based on a condition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterOperation implements SdkPojo, Serializable, ToCopyableBuilder<FilterOperation.Builder, FilterOperation> {
    private static final SdkField<String> CONDITION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConditionExpression").getter(getter(FilterOperation::conditionExpression))
            .setter(setter(Builder::conditionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionExpression").build())
            .build();

    private static final SdkField<DataSetStringFilterCondition> STRING_FILTER_CONDITION_FIELD = SdkField
            .<DataSetStringFilterCondition> builder(MarshallingType.SDK_POJO).memberName("StringFilterCondition")
            .getter(getter(FilterOperation::stringFilterCondition)).setter(setter(Builder::stringFilterCondition))
            .constructor(DataSetStringFilterCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringFilterCondition").build())
            .build();

    private static final SdkField<DataSetNumericFilterCondition> NUMERIC_FILTER_CONDITION_FIELD = SdkField
            .<DataSetNumericFilterCondition> builder(MarshallingType.SDK_POJO).memberName("NumericFilterCondition")
            .getter(getter(FilterOperation::numericFilterCondition)).setter(setter(Builder::numericFilterCondition))
            .constructor(DataSetNumericFilterCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumericFilterCondition").build())
            .build();

    private static final SdkField<DataSetDateFilterCondition> DATE_FILTER_CONDITION_FIELD = SdkField
            .<DataSetDateFilterCondition> builder(MarshallingType.SDK_POJO).memberName("DateFilterCondition")
            .getter(getter(FilterOperation::dateFilterCondition)).setter(setter(Builder::dateFilterCondition))
            .constructor(DataSetDateFilterCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateFilterCondition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_EXPRESSION_FIELD,
            STRING_FILTER_CONDITION_FIELD, NUMERIC_FILTER_CONDITION_FIELD, DATE_FILTER_CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String conditionExpression;

    private final DataSetStringFilterCondition stringFilterCondition;

    private final DataSetNumericFilterCondition numericFilterCondition;

    private final DataSetDateFilterCondition dateFilterCondition;

    private FilterOperation(BuilderImpl builder) {
        this.conditionExpression = builder.conditionExpression;
        this.stringFilterCondition = builder.stringFilterCondition;
        this.numericFilterCondition = builder.numericFilterCondition;
        this.dateFilterCondition = builder.dateFilterCondition;
    }

    /**
     * <p>
     * An expression that must evaluate to a Boolean value. Rows for which the expression evaluates to true are kept in
     * the dataset.
     * </p>
     * 
     * @return An expression that must evaluate to a Boolean value. Rows for which the expression evaluates to true are
     *         kept in the dataset.
     */
    public final String conditionExpression() {
        return conditionExpression;
    }

    /**
     * <p>
     * A string-based filter condition within a filter operation.
     * </p>
     * 
     * @return A string-based filter condition within a filter operation.
     */
    public final DataSetStringFilterCondition stringFilterCondition() {
        return stringFilterCondition;
    }

    /**
     * <p>
     * A numeric-based filter condition within a filter operation.
     * </p>
     * 
     * @return A numeric-based filter condition within a filter operation.
     */
    public final DataSetNumericFilterCondition numericFilterCondition() {
        return numericFilterCondition;
    }

    /**
     * <p>
     * A date-based filter condition within a filter operation.
     * </p>
     * 
     * @return A date-based filter condition within a filter operation.
     */
    public final DataSetDateFilterCondition dateFilterCondition() {
        return dateFilterCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conditionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(stringFilterCondition());
        hashCode = 31 * hashCode + Objects.hashCode(numericFilterCondition());
        hashCode = 31 * hashCode + Objects.hashCode(dateFilterCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterOperation)) {
            return false;
        }
        FilterOperation other = (FilterOperation) obj;
        return Objects.equals(conditionExpression(), other.conditionExpression())
                && Objects.equals(stringFilterCondition(), other.stringFilterCondition())
                && Objects.equals(numericFilterCondition(), other.numericFilterCondition())
                && Objects.equals(dateFilterCondition(), other.dateFilterCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterOperation")
                .add("ConditionExpression", conditionExpression() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StringFilterCondition", stringFilterCondition()).add("NumericFilterCondition", numericFilterCondition())
                .add("DateFilterCondition", dateFilterCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConditionExpression":
            return Optional.ofNullable(clazz.cast(conditionExpression()));
        case "StringFilterCondition":
            return Optional.ofNullable(clazz.cast(stringFilterCondition()));
        case "NumericFilterCondition":
            return Optional.ofNullable(clazz.cast(numericFilterCondition()));
        case "DateFilterCondition":
            return Optional.ofNullable(clazz.cast(dateFilterCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConditionExpression", CONDITION_EXPRESSION_FIELD);
        map.put("StringFilterCondition", STRING_FILTER_CONDITION_FIELD);
        map.put("NumericFilterCondition", NUMERIC_FILTER_CONDITION_FIELD);
        map.put("DateFilterCondition", DATE_FILTER_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterOperation, T> g) {
        return obj -> g.apply((FilterOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterOperation> {
        /**
         * <p>
         * An expression that must evaluate to a Boolean value. Rows for which the expression evaluates to true are kept
         * in the dataset.
         * </p>
         * 
         * @param conditionExpression
         *        An expression that must evaluate to a Boolean value. Rows for which the expression evaluates to true
         *        are kept in the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionExpression(String conditionExpression);

        /**
         * <p>
         * A string-based filter condition within a filter operation.
         * </p>
         * 
         * @param stringFilterCondition
         *        A string-based filter condition within a filter operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringFilterCondition(DataSetStringFilterCondition stringFilterCondition);

        /**
         * <p>
         * A string-based filter condition within a filter operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSetStringFilterCondition.Builder}
         * avoiding the need to create one manually via {@link DataSetStringFilterCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSetStringFilterCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #stringFilterCondition(DataSetStringFilterCondition)}.
         * 
         * @param stringFilterCondition
         *        a consumer that will call methods on {@link DataSetStringFilterCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringFilterCondition(DataSetStringFilterCondition)
         */
        default Builder stringFilterCondition(Consumer<DataSetStringFilterCondition.Builder> stringFilterCondition) {
            return stringFilterCondition(DataSetStringFilterCondition.builder().applyMutation(stringFilterCondition).build());
        }

        /**
         * <p>
         * A numeric-based filter condition within a filter operation.
         * </p>
         * 
         * @param numericFilterCondition
         *        A numeric-based filter condition within a filter operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numericFilterCondition(DataSetNumericFilterCondition numericFilterCondition);

        /**
         * <p>
         * A numeric-based filter condition within a filter operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSetNumericFilterCondition.Builder}
         * avoiding the need to create one manually via {@link DataSetNumericFilterCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSetNumericFilterCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #numericFilterCondition(DataSetNumericFilterCondition)}.
         * 
         * @param numericFilterCondition
         *        a consumer that will call methods on {@link DataSetNumericFilterCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #numericFilterCondition(DataSetNumericFilterCondition)
         */
        default Builder numericFilterCondition(Consumer<DataSetNumericFilterCondition.Builder> numericFilterCondition) {
            return numericFilterCondition(DataSetNumericFilterCondition.builder().applyMutation(numericFilterCondition).build());
        }

        /**
         * <p>
         * A date-based filter condition within a filter operation.
         * </p>
         * 
         * @param dateFilterCondition
         *        A date-based filter condition within a filter operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateFilterCondition(DataSetDateFilterCondition dateFilterCondition);

        /**
         * <p>
         * A date-based filter condition within a filter operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSetDateFilterCondition.Builder}
         * avoiding the need to create one manually via {@link DataSetDateFilterCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSetDateFilterCondition.Builder#build()} is called immediately
         * and its result is passed to {@link #dateFilterCondition(DataSetDateFilterCondition)}.
         * 
         * @param dateFilterCondition
         *        a consumer that will call methods on {@link DataSetDateFilterCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateFilterCondition(DataSetDateFilterCondition)
         */
        default Builder dateFilterCondition(Consumer<DataSetDateFilterCondition.Builder> dateFilterCondition) {
            return dateFilterCondition(DataSetDateFilterCondition.builder().applyMutation(dateFilterCondition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String conditionExpression;

        private DataSetStringFilterCondition stringFilterCondition;

        private DataSetNumericFilterCondition numericFilterCondition;

        private DataSetDateFilterCondition dateFilterCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterOperation model) {
            conditionExpression(model.conditionExpression);
            stringFilterCondition(model.stringFilterCondition);
            numericFilterCondition(model.numericFilterCondition);
            dateFilterCondition(model.dateFilterCondition);
        }

        public final String getConditionExpression() {
            return conditionExpression;
        }

        public final void setConditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
        }

        @Override
        public final Builder conditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public final DataSetStringFilterCondition.Builder getStringFilterCondition() {
            return stringFilterCondition != null ? stringFilterCondition.toBuilder() : null;
        }

        public final void setStringFilterCondition(DataSetStringFilterCondition.BuilderImpl stringFilterCondition) {
            this.stringFilterCondition = stringFilterCondition != null ? stringFilterCondition.build() : null;
        }

        @Override
        public final Builder stringFilterCondition(DataSetStringFilterCondition stringFilterCondition) {
            this.stringFilterCondition = stringFilterCondition;
            return this;
        }

        public final DataSetNumericFilterCondition.Builder getNumericFilterCondition() {
            return numericFilterCondition != null ? numericFilterCondition.toBuilder() : null;
        }

        public final void setNumericFilterCondition(DataSetNumericFilterCondition.BuilderImpl numericFilterCondition) {
            this.numericFilterCondition = numericFilterCondition != null ? numericFilterCondition.build() : null;
        }

        @Override
        public final Builder numericFilterCondition(DataSetNumericFilterCondition numericFilterCondition) {
            this.numericFilterCondition = numericFilterCondition;
            return this;
        }

        public final DataSetDateFilterCondition.Builder getDateFilterCondition() {
            return dateFilterCondition != null ? dateFilterCondition.toBuilder() : null;
        }

        public final void setDateFilterCondition(DataSetDateFilterCondition.BuilderImpl dateFilterCondition) {
            this.dateFilterCondition = dateFilterCondition != null ? dateFilterCondition.build() : null;
        }

        @Override
        public final Builder dateFilterCondition(DataSetDateFilterCondition dateFilterCondition) {
            this.dateFilterCondition = dateFilterCondition;
            return this;
        }

        @Override
        public FilterOperation build() {
            return new FilterOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
