/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A transform operation that applies one or more filter conditions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FiltersOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<FiltersOperation.Builder, FiltersOperation> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Alias")
            .getter(getter(FiltersOperation::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final SdkField<TransformOperationSource> SOURCE_FIELD = SdkField
            .<TransformOperationSource> builder(MarshallingType.SDK_POJO).memberName("Source")
            .getter(getter(FiltersOperation::source)).setter(setter(Builder::source))
            .constructor(TransformOperationSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<List<FilterOperation>> FILTER_OPERATIONS_FIELD = SdkField
            .<List<FilterOperation>> builder(MarshallingType.LIST)
            .memberName("FilterOperations")
            .getter(getter(FiltersOperation::filterOperations))
            .setter(setter(Builder::filterOperations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterOperations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterOperation> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterOperation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, SOURCE_FIELD,
            FILTER_OPERATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String alias;

    private final TransformOperationSource source;

    private final List<FilterOperation> filterOperations;

    private FiltersOperation(BuilderImpl builder) {
        this.alias = builder.alias;
        this.source = builder.source;
        this.filterOperations = builder.filterOperations;
    }

    /**
     * <p>
     * Alias for this operation.
     * </p>
     * 
     * @return Alias for this operation.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The source transform operation that provides input data for filtering.
     * </p>
     * 
     * @return The source transform operation that provides input data for filtering.
     */
    public final TransformOperationSource source() {
        return source;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterOperations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFilterOperations() {
        return filterOperations != null && !(filterOperations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of filter operations to apply.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterOperations} method.
     * </p>
     * 
     * @return The list of filter operations to apply.
     */
    public final List<FilterOperation> filterOperations() {
        return filterOperations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterOperations() ? filterOperations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FiltersOperation)) {
            return false;
        }
        FiltersOperation other = (FiltersOperation) obj;
        return Objects.equals(alias(), other.alias()) && Objects.equals(source(), other.source())
                && hasFilterOperations() == other.hasFilterOperations()
                && Objects.equals(filterOperations(), other.filterOperations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FiltersOperation").add("Alias", alias()).add("Source", source())
                .add("FilterOperations", hasFilterOperations() ? filterOperations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "FilterOperations":
            return Optional.ofNullable(clazz.cast(filterOperations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Alias", ALIAS_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("FilterOperations", FILTER_OPERATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FiltersOperation, T> g) {
        return obj -> g.apply((FiltersOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FiltersOperation> {
        /**
         * <p>
         * Alias for this operation.
         * </p>
         * 
         * @param alias
         *        Alias for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The source transform operation that provides input data for filtering.
         * </p>
         * 
         * @param source
         *        The source transform operation that provides input data for filtering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(TransformOperationSource source);

        /**
         * <p>
         * The source transform operation that provides input data for filtering.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransformOperationSource.Builder}
         * avoiding the need to create one manually via {@link TransformOperationSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransformOperationSource.Builder#build()} is called immediately
         * and its result is passed to {@link #source(TransformOperationSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link TransformOperationSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(TransformOperationSource)
         */
        default Builder source(Consumer<TransformOperationSource.Builder> source) {
            return source(TransformOperationSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The list of filter operations to apply.
         * </p>
         * 
         * @param filterOperations
         *        The list of filter operations to apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterOperations(Collection<FilterOperation> filterOperations);

        /**
         * <p>
         * The list of filter operations to apply.
         * </p>
         * 
         * @param filterOperations
         *        The list of filter operations to apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterOperations(FilterOperation... filterOperations);

        /**
         * <p>
         * The list of filter operations to apply.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.FilterOperation.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.FilterOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.FilterOperation.Builder#build()} is called
         * immediately and its result is passed to {@link #filterOperations(List<FilterOperation>)}.
         * 
         * @param filterOperations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.FilterOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterOperations(java.util.Collection<FilterOperation>)
         */
        Builder filterOperations(Consumer<FilterOperation.Builder>... filterOperations);
    }

    static final class BuilderImpl implements Builder {
        private String alias;

        private TransformOperationSource source;

        private List<FilterOperation> filterOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FiltersOperation model) {
            alias(model.alias);
            source(model.source);
            filterOperations(model.filterOperations);
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final TransformOperationSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(TransformOperationSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(TransformOperationSource source) {
            this.source = source;
            return this;
        }

        public final List<FilterOperation.Builder> getFilterOperations() {
            List<FilterOperation.Builder> result = FilterOperationListCopier.copyToBuilder(this.filterOperations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterOperations(Collection<FilterOperation.BuilderImpl> filterOperations) {
            this.filterOperations = FilterOperationListCopier.copyFromBuilder(filterOperations);
        }

        @Override
        public final Builder filterOperations(Collection<FilterOperation> filterOperations) {
            this.filterOperations = FilterOperationListCopier.copy(filterOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterOperations(FilterOperation... filterOperations) {
            filterOperations(Arrays.asList(filterOperations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterOperations(Consumer<FilterOperation.Builder>... filterOperations) {
            filterOperations(Stream.of(filterOperations).map(c -> FilterOperation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public FiltersOperation build() {
            return new FiltersOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
