/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A transform operation that combines data from two sources based on specified join conditions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JoinOperation implements SdkPojo, Serializable, ToCopyableBuilder<JoinOperation.Builder, JoinOperation> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Alias")
            .getter(getter(JoinOperation::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final SdkField<TransformOperationSource> LEFT_OPERAND_FIELD = SdkField
            .<TransformOperationSource> builder(MarshallingType.SDK_POJO).memberName("LeftOperand")
            .getter(getter(JoinOperation::leftOperand)).setter(setter(Builder::leftOperand))
            .constructor(TransformOperationSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LeftOperand").build()).build();

    private static final SdkField<TransformOperationSource> RIGHT_OPERAND_FIELD = SdkField
            .<TransformOperationSource> builder(MarshallingType.SDK_POJO).memberName("RightOperand")
            .getter(getter(JoinOperation::rightOperand)).setter(setter(Builder::rightOperand))
            .constructor(TransformOperationSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RightOperand").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(JoinOperation::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> ON_CLAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OnClause").getter(getter(JoinOperation::onClause)).setter(setter(Builder::onClause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnClause").build()).build();

    private static final SdkField<JoinOperandProperties> LEFT_OPERAND_PROPERTIES_FIELD = SdkField
            .<JoinOperandProperties> builder(MarshallingType.SDK_POJO).memberName("LeftOperandProperties")
            .getter(getter(JoinOperation::leftOperandProperties)).setter(setter(Builder::leftOperandProperties))
            .constructor(JoinOperandProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LeftOperandProperties").build())
            .build();

    private static final SdkField<JoinOperandProperties> RIGHT_OPERAND_PROPERTIES_FIELD = SdkField
            .<JoinOperandProperties> builder(MarshallingType.SDK_POJO).memberName("RightOperandProperties")
            .getter(getter(JoinOperation::rightOperandProperties)).setter(setter(Builder::rightOperandProperties))
            .constructor(JoinOperandProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RightOperandProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD,
            LEFT_OPERAND_FIELD, RIGHT_OPERAND_FIELD, TYPE_FIELD, ON_CLAUSE_FIELD, LEFT_OPERAND_PROPERTIES_FIELD,
            RIGHT_OPERAND_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String alias;

    private final TransformOperationSource leftOperand;

    private final TransformOperationSource rightOperand;

    private final String type;

    private final String onClause;

    private final JoinOperandProperties leftOperandProperties;

    private final JoinOperandProperties rightOperandProperties;

    private JoinOperation(BuilderImpl builder) {
        this.alias = builder.alias;
        this.leftOperand = builder.leftOperand;
        this.rightOperand = builder.rightOperand;
        this.type = builder.type;
        this.onClause = builder.onClause;
        this.leftOperandProperties = builder.leftOperandProperties;
        this.rightOperandProperties = builder.rightOperandProperties;
    }

    /**
     * <p>
     * Alias for this operation.
     * </p>
     * 
     * @return Alias for this operation.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The left operand for the join operation.
     * </p>
     * 
     * @return The left operand for the join operation.
     */
    public final TransformOperationSource leftOperand() {
        return leftOperand;
    }

    /**
     * <p>
     * The right operand for the join operation.
     * </p>
     * 
     * @return The right operand for the join operation.
     */
    public final TransformOperationSource rightOperand() {
        return rightOperand;
    }

    /**
     * <p>
     * The type of join to perform, such as <code>INNER</code>, <code>LEFT</code>, <code>RIGHT</code>, or
     * <code>OUTER</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link JoinOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of join to perform, such as <code>INNER</code>, <code>LEFT</code>, <code>RIGHT</code>, or
     *         <code>OUTER</code>.
     * @see JoinOperationType
     */
    public final JoinOperationType type() {
        return JoinOperationType.fromValue(type);
    }

    /**
     * <p>
     * The type of join to perform, such as <code>INNER</code>, <code>LEFT</code>, <code>RIGHT</code>, or
     * <code>OUTER</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link JoinOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of join to perform, such as <code>INNER</code>, <code>LEFT</code>, <code>RIGHT</code>, or
     *         <code>OUTER</code>.
     * @see JoinOperationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The join condition that specifies how to match rows between the left and right operands.
     * </p>
     * 
     * @return The join condition that specifies how to match rows between the left and right operands.
     */
    public final String onClause() {
        return onClause;
    }

    /**
     * <p>
     * Properties that control how the left operand's columns are handled in the join result.
     * </p>
     * 
     * @return Properties that control how the left operand's columns are handled in the join result.
     */
    public final JoinOperandProperties leftOperandProperties() {
        return leftOperandProperties;
    }

    /**
     * <p>
     * Properties that control how the right operand's columns are handled in the join result.
     * </p>
     * 
     * @return Properties that control how the right operand's columns are handled in the join result.
     */
    public final JoinOperandProperties rightOperandProperties() {
        return rightOperandProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(leftOperand());
        hashCode = 31 * hashCode + Objects.hashCode(rightOperand());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(onClause());
        hashCode = 31 * hashCode + Objects.hashCode(leftOperandProperties());
        hashCode = 31 * hashCode + Objects.hashCode(rightOperandProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JoinOperation)) {
            return false;
        }
        JoinOperation other = (JoinOperation) obj;
        return Objects.equals(alias(), other.alias()) && Objects.equals(leftOperand(), other.leftOperand())
                && Objects.equals(rightOperand(), other.rightOperand()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(onClause(), other.onClause())
                && Objects.equals(leftOperandProperties(), other.leftOperandProperties())
                && Objects.equals(rightOperandProperties(), other.rightOperandProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JoinOperation").add("Alias", alias()).add("LeftOperand", leftOperand())
                .add("RightOperand", rightOperand()).add("Type", typeAsString())
                .add("OnClause", onClause() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LeftOperandProperties", leftOperandProperties()).add("RightOperandProperties", rightOperandProperties())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "LeftOperand":
            return Optional.ofNullable(clazz.cast(leftOperand()));
        case "RightOperand":
            return Optional.ofNullable(clazz.cast(rightOperand()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "OnClause":
            return Optional.ofNullable(clazz.cast(onClause()));
        case "LeftOperandProperties":
            return Optional.ofNullable(clazz.cast(leftOperandProperties()));
        case "RightOperandProperties":
            return Optional.ofNullable(clazz.cast(rightOperandProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Alias", ALIAS_FIELD);
        map.put("LeftOperand", LEFT_OPERAND_FIELD);
        map.put("RightOperand", RIGHT_OPERAND_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("OnClause", ON_CLAUSE_FIELD);
        map.put("LeftOperandProperties", LEFT_OPERAND_PROPERTIES_FIELD);
        map.put("RightOperandProperties", RIGHT_OPERAND_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JoinOperation, T> g) {
        return obj -> g.apply((JoinOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JoinOperation> {
        /**
         * <p>
         * Alias for this operation.
         * </p>
         * 
         * @param alias
         *        Alias for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The left operand for the join operation.
         * </p>
         * 
         * @param leftOperand
         *        The left operand for the join operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder leftOperand(TransformOperationSource leftOperand);

        /**
         * <p>
         * The left operand for the join operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransformOperationSource.Builder}
         * avoiding the need to create one manually via {@link TransformOperationSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransformOperationSource.Builder#build()} is called immediately
         * and its result is passed to {@link #leftOperand(TransformOperationSource)}.
         * 
         * @param leftOperand
         *        a consumer that will call methods on {@link TransformOperationSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #leftOperand(TransformOperationSource)
         */
        default Builder leftOperand(Consumer<TransformOperationSource.Builder> leftOperand) {
            return leftOperand(TransformOperationSource.builder().applyMutation(leftOperand).build());
        }

        /**
         * <p>
         * The right operand for the join operation.
         * </p>
         * 
         * @param rightOperand
         *        The right operand for the join operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rightOperand(TransformOperationSource rightOperand);

        /**
         * <p>
         * The right operand for the join operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransformOperationSource.Builder}
         * avoiding the need to create one manually via {@link TransformOperationSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransformOperationSource.Builder#build()} is called immediately
         * and its result is passed to {@link #rightOperand(TransformOperationSource)}.
         * 
         * @param rightOperand
         *        a consumer that will call methods on {@link TransformOperationSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rightOperand(TransformOperationSource)
         */
        default Builder rightOperand(Consumer<TransformOperationSource.Builder> rightOperand) {
            return rightOperand(TransformOperationSource.builder().applyMutation(rightOperand).build());
        }

        /**
         * <p>
         * The type of join to perform, such as <code>INNER</code>, <code>LEFT</code>, <code>RIGHT</code>, or
         * <code>OUTER</code>.
         * </p>
         * 
         * @param type
         *        The type of join to perform, such as <code>INNER</code>, <code>LEFT</code>, <code>RIGHT</code>, or
         *        <code>OUTER</code>.
         * @see JoinOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JoinOperationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of join to perform, such as <code>INNER</code>, <code>LEFT</code>, <code>RIGHT</code>, or
         * <code>OUTER</code>.
         * </p>
         * 
         * @param type
         *        The type of join to perform, such as <code>INNER</code>, <code>LEFT</code>, <code>RIGHT</code>, or
         *        <code>OUTER</code>.
         * @see JoinOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JoinOperationType
         */
        Builder type(JoinOperationType type);

        /**
         * <p>
         * The join condition that specifies how to match rows between the left and right operands.
         * </p>
         * 
         * @param onClause
         *        The join condition that specifies how to match rows between the left and right operands.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onClause(String onClause);

        /**
         * <p>
         * Properties that control how the left operand's columns are handled in the join result.
         * </p>
         * 
         * @param leftOperandProperties
         *        Properties that control how the left operand's columns are handled in the join result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder leftOperandProperties(JoinOperandProperties leftOperandProperties);

        /**
         * <p>
         * Properties that control how the left operand's columns are handled in the join result.
         * </p>
         * This is a convenience method that creates an instance of the {@link JoinOperandProperties.Builder} avoiding
         * the need to create one manually via {@link JoinOperandProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JoinOperandProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #leftOperandProperties(JoinOperandProperties)}.
         * 
         * @param leftOperandProperties
         *        a consumer that will call methods on {@link JoinOperandProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #leftOperandProperties(JoinOperandProperties)
         */
        default Builder leftOperandProperties(Consumer<JoinOperandProperties.Builder> leftOperandProperties) {
            return leftOperandProperties(JoinOperandProperties.builder().applyMutation(leftOperandProperties).build());
        }

        /**
         * <p>
         * Properties that control how the right operand's columns are handled in the join result.
         * </p>
         * 
         * @param rightOperandProperties
         *        Properties that control how the right operand's columns are handled in the join result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rightOperandProperties(JoinOperandProperties rightOperandProperties);

        /**
         * <p>
         * Properties that control how the right operand's columns are handled in the join result.
         * </p>
         * This is a convenience method that creates an instance of the {@link JoinOperandProperties.Builder} avoiding
         * the need to create one manually via {@link JoinOperandProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JoinOperandProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #rightOperandProperties(JoinOperandProperties)}.
         * 
         * @param rightOperandProperties
         *        a consumer that will call methods on {@link JoinOperandProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rightOperandProperties(JoinOperandProperties)
         */
        default Builder rightOperandProperties(Consumer<JoinOperandProperties.Builder> rightOperandProperties) {
            return rightOperandProperties(JoinOperandProperties.builder().applyMutation(rightOperandProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String alias;

        private TransformOperationSource leftOperand;

        private TransformOperationSource rightOperand;

        private String type;

        private String onClause;

        private JoinOperandProperties leftOperandProperties;

        private JoinOperandProperties rightOperandProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(JoinOperation model) {
            alias(model.alias);
            leftOperand(model.leftOperand);
            rightOperand(model.rightOperand);
            type(model.type);
            onClause(model.onClause);
            leftOperandProperties(model.leftOperandProperties);
            rightOperandProperties(model.rightOperandProperties);
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final TransformOperationSource.Builder getLeftOperand() {
            return leftOperand != null ? leftOperand.toBuilder() : null;
        }

        public final void setLeftOperand(TransformOperationSource.BuilderImpl leftOperand) {
            this.leftOperand = leftOperand != null ? leftOperand.build() : null;
        }

        @Override
        public final Builder leftOperand(TransformOperationSource leftOperand) {
            this.leftOperand = leftOperand;
            return this;
        }

        public final TransformOperationSource.Builder getRightOperand() {
            return rightOperand != null ? rightOperand.toBuilder() : null;
        }

        public final void setRightOperand(TransformOperationSource.BuilderImpl rightOperand) {
            this.rightOperand = rightOperand != null ? rightOperand.build() : null;
        }

        @Override
        public final Builder rightOperand(TransformOperationSource rightOperand) {
            this.rightOperand = rightOperand;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(JoinOperationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getOnClause() {
            return onClause;
        }

        public final void setOnClause(String onClause) {
            this.onClause = onClause;
        }

        @Override
        public final Builder onClause(String onClause) {
            this.onClause = onClause;
            return this;
        }

        public final JoinOperandProperties.Builder getLeftOperandProperties() {
            return leftOperandProperties != null ? leftOperandProperties.toBuilder() : null;
        }

        public final void setLeftOperandProperties(JoinOperandProperties.BuilderImpl leftOperandProperties) {
            this.leftOperandProperties = leftOperandProperties != null ? leftOperandProperties.build() : null;
        }

        @Override
        public final Builder leftOperandProperties(JoinOperandProperties leftOperandProperties) {
            this.leftOperandProperties = leftOperandProperties;
            return this;
        }

        public final JoinOperandProperties.Builder getRightOperandProperties() {
            return rightOperandProperties != null ? rightOperandProperties.toBuilder() : null;
        }

        public final void setRightOperandProperties(JoinOperandProperties.BuilderImpl rightOperandProperties) {
            this.rightOperandProperties = rightOperandProperties != null ? rightOperandProperties.build() : null;
        }

        @Override
        public final Builder rightOperandProperties(JoinOperandProperties rightOperandProperties) {
            this.rightOperandProperties = rightOperandProperties;
            return this;
        }

        @Override
        public JoinOperation build() {
            return new JoinOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
