/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a mapping to override the name of an output column from a transform operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputColumnNameOverride implements SdkPojo, Serializable,
        ToCopyableBuilder<OutputColumnNameOverride.Builder, OutputColumnNameOverride> {
    private static final SdkField<String> SOURCE_COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceColumnName").getter(getter(OutputColumnNameOverride::sourceColumnName))
            .setter(setter(Builder::sourceColumnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceColumnName").build()).build();

    private static final SdkField<String> OUTPUT_COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputColumnName").getter(getter(OutputColumnNameOverride::outputColumnName))
            .setter(setter(Builder::outputColumnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputColumnName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_COLUMN_NAME_FIELD,
            OUTPUT_COLUMN_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceColumnName;

    private final String outputColumnName;

    private OutputColumnNameOverride(BuilderImpl builder) {
        this.sourceColumnName = builder.sourceColumnName;
        this.outputColumnName = builder.outputColumnName;
    }

    /**
     * <p>
     * The original name of the column from the source transform operation.
     * </p>
     * 
     * @return The original name of the column from the source transform operation.
     */
    public final String sourceColumnName() {
        return sourceColumnName;
    }

    /**
     * <p>
     * The new name to assign to the column in the output.
     * </p>
     * 
     * @return The new name to assign to the column in the output.
     */
    public final String outputColumnName() {
        return outputColumnName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(outputColumnName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputColumnNameOverride)) {
            return false;
        }
        OutputColumnNameOverride other = (OutputColumnNameOverride) obj;
        return Objects.equals(sourceColumnName(), other.sourceColumnName())
                && Objects.equals(outputColumnName(), other.outputColumnName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputColumnNameOverride").add("SourceColumnName", sourceColumnName())
                .add("OutputColumnName", outputColumnName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceColumnName":
            return Optional.ofNullable(clazz.cast(sourceColumnName()));
        case "OutputColumnName":
            return Optional.ofNullable(clazz.cast(outputColumnName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceColumnName", SOURCE_COLUMN_NAME_FIELD);
        map.put("OutputColumnName", OUTPUT_COLUMN_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutputColumnNameOverride, T> g) {
        return obj -> g.apply((OutputColumnNameOverride) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputColumnNameOverride> {
        /**
         * <p>
         * The original name of the column from the source transform operation.
         * </p>
         * 
         * @param sourceColumnName
         *        The original name of the column from the source transform operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceColumnName(String sourceColumnName);

        /**
         * <p>
         * The new name to assign to the column in the output.
         * </p>
         * 
         * @param outputColumnName
         *        The new name to assign to the column in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputColumnName(String outputColumnName);
    }

    static final class BuilderImpl implements Builder {
        private String sourceColumnName;

        private String outputColumnName;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputColumnNameOverride model) {
            sourceColumnName(model.sourceColumnName);
            outputColumnName(model.outputColumnName);
        }

        public final String getSourceColumnName() {
            return sourceColumnName;
        }

        public final void setSourceColumnName(String sourceColumnName) {
            this.sourceColumnName = sourceColumnName;
        }

        @Override
        public final Builder sourceColumnName(String sourceColumnName) {
            this.sourceColumnName = sourceColumnName;
            return this;
        }

        public final String getOutputColumnName() {
            return outputColumnName;
        }

        public final void setOutputColumnName(String outputColumnName) {
            this.outputColumnName = outputColumnName;
        }

        @Override
        public final Builder outputColumnName(String outputColumnName) {
            this.outputColumnName = outputColumnName;
            return this;
        }

        @Override
        public OutputColumnNameOverride build() {
            return new OutputColumnNameOverride(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
