/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the permission information for one principal against one flow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Permission implements SdkPojo, Serializable, ToCopyableBuilder<Permission.Builder, Permission> {
    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Actions")
            .getter(getter(Permission::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Principal").getter(getter(Permission::principal)).setter(setter(Builder::principal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ACTIONS_FIELD, PRINCIPAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> actions;

    private final String principal;

    private Permission(BuilderImpl builder) {
        this.actions = builder.actions;
        this.principal = builder.principal;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of actions that the principal can perform against the flow.
     * </p>
     * <p>
     * The following are the list of values to set a principal as a flow owner:
     * </p>
     * <ul>
     * <li>
     * <p>
     * quicksight:PublishFlow
     * </p>
     * </li>
     * <li>
     * <p>
     * quicksight:GetFlow
     * </p>
     * </li>
     * <li>
     * <p>
     * quicksight:UpdateFlowPermissions
     * </p>
     * </li>
     * <li>
     * <p>
     * quicksight:GetFlowSession
     * </p>
     * </li>
     * <li>
     * <p>
     * quicksight:StartFlowSession
     * </p>
     * </li>
     * <li>
     * <p>
     * quicksight:StopFlowSession
     * </p>
     * </li>
     * <li>
     * <p>
     * quicksight:UpdateFlowSession
     * </p>
     * </li>
     * <li>
     * <p>
     * quicksight:UnpublishFlow
     * </p>
     * </li>
     * <li>
     * <p>
     * quicksight:GetFlowStages
     * </p>
     * </li>
     * <li>
     * <p>
     * quicksight:DeleteFlow
     * </p>
     * </li>
     * <li>
     * <p>
     * quicksight:DescribeFlowPermissions
     * </p>
     * </li>
     * <li>
     * <p>
     * quicksight:UpdateFlow
     * </p>
     * </li>
     * <li>
     * <p>
     * quicksight:CreatePresignedUrl
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following are the list of values to set a principal as a flow viewer:
     * </p>
     * <ul>
     * <li>
     * <p>
     * quicksight:GetFlow
     * </p>
     * </li>
     * <li>
     * <p>
     * quicksight:UpdateFlowSession
     * </p>
     * </li>
     * <li>
     * <p>
     * quicksight:StartFlowSession
     * </p>
     * </li>
     * <li>
     * <p>
     * quicksight:StopFlowSession
     * </p>
     * </li>
     * <li>
     * <p>
     * quicksight:GetFlowSession
     * </p>
     * </li>
     * <li>
     * <p>
     * quicksight:CreatePresignedUrl
     * </p>
     * </li>
     * <li>
     * <p>
     * quicksight:GetFlowStages
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return A list of actions that the principal can perform against the flow.</p>
     *         <p>
     *         The following are the list of values to set a principal as a flow owner:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         quicksight:PublishFlow
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         quicksight:GetFlow
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         quicksight:UpdateFlowPermissions
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         quicksight:GetFlowSession
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         quicksight:StartFlowSession
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         quicksight:StopFlowSession
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         quicksight:UpdateFlowSession
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         quicksight:UnpublishFlow
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         quicksight:GetFlowStages
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         quicksight:DeleteFlow
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         quicksight:DescribeFlowPermissions
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         quicksight:UpdateFlow
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         quicksight:CreatePresignedUrl
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following are the list of values to set a principal as a flow viewer:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         quicksight:GetFlow
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         quicksight:UpdateFlowSession
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         quicksight:StartFlowSession
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         quicksight:StopFlowSession
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         quicksight:GetFlowSession
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         quicksight:CreatePresignedUrl
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         quicksight:GetFlowStages
     *         </p>
     *         </li>
     */
    public final List<String> actions() {
        return actions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the principal. This can be an Amazon Quick Suite user, group or namespace
     * associated with the flow. Namespace principal can only be set as a viewer and will grant everyone in the same
     * namespace viewer permissions.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the principal. This can be an Amazon Quick Suite user, group or
     *         namespace associated with the flow. Namespace principal can only be set as a viewer and will grant
     *         everyone in the same namespace viewer permissions.
     */
    public final String principal() {
        return principal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Permission)) {
            return false;
        }
        Permission other = (Permission) obj;
        return hasActions() == other.hasActions() && Objects.equals(actions(), other.actions())
                && Objects.equals(principal(), other.principal());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Permission").add("Actions", hasActions() ? actions() : null).add("Principal", principal())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "Principal":
            return Optional.ofNullable(clazz.cast(principal()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Actions", ACTIONS_FIELD);
        map.put("Principal", PRINCIPAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Permission, T> g) {
        return obj -> g.apply((Permission) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Permission> {
        /**
         * <p>
         * A list of actions that the principal can perform against the flow.
         * </p>
         * <p>
         * The following are the list of values to set a principal as a flow owner:
         * </p>
         * <ul>
         * <li>
         * <p>
         * quicksight:PublishFlow
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:GetFlow
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:UpdateFlowPermissions
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:GetFlowSession
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:StartFlowSession
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:StopFlowSession
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:UpdateFlowSession
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:UnpublishFlow
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:GetFlowStages
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:DeleteFlow
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:DescribeFlowPermissions
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:UpdateFlow
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:CreatePresignedUrl
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following are the list of values to set a principal as a flow viewer:
         * </p>
         * <ul>
         * <li>
         * <p>
         * quicksight:GetFlow
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:UpdateFlowSession
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:StartFlowSession
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:StopFlowSession
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:GetFlowSession
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:CreatePresignedUrl
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:GetFlowStages
         * </p>
         * </li>
         * </ul>
         * 
         * @param actions
         *        A list of actions that the principal can perform against the flow.</p>
         *        <p>
         *        The following are the list of values to set a principal as a flow owner:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        quicksight:PublishFlow
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:GetFlow
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:UpdateFlowPermissions
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:GetFlowSession
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:StartFlowSession
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:StopFlowSession
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:UpdateFlowSession
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:UnpublishFlow
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:GetFlowStages
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:DeleteFlow
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:DescribeFlowPermissions
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:UpdateFlow
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:CreatePresignedUrl
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following are the list of values to set a principal as a flow viewer:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        quicksight:GetFlow
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:UpdateFlowSession
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:StartFlowSession
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:StopFlowSession
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:GetFlowSession
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:CreatePresignedUrl
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:GetFlowStages
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<String> actions);

        /**
         * <p>
         * A list of actions that the principal can perform against the flow.
         * </p>
         * <p>
         * The following are the list of values to set a principal as a flow owner:
         * </p>
         * <ul>
         * <li>
         * <p>
         * quicksight:PublishFlow
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:GetFlow
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:UpdateFlowPermissions
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:GetFlowSession
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:StartFlowSession
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:StopFlowSession
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:UpdateFlowSession
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:UnpublishFlow
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:GetFlowStages
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:DeleteFlow
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:DescribeFlowPermissions
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:UpdateFlow
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:CreatePresignedUrl
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following are the list of values to set a principal as a flow viewer:
         * </p>
         * <ul>
         * <li>
         * <p>
         * quicksight:GetFlow
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:UpdateFlowSession
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:StartFlowSession
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:StopFlowSession
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:GetFlowSession
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:CreatePresignedUrl
         * </p>
         * </li>
         * <li>
         * <p>
         * quicksight:GetFlowStages
         * </p>
         * </li>
         * </ul>
         * 
         * @param actions
         *        A list of actions that the principal can perform against the flow.</p>
         *        <p>
         *        The following are the list of values to set a principal as a flow owner:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        quicksight:PublishFlow
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:GetFlow
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:UpdateFlowPermissions
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:GetFlowSession
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:StartFlowSession
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:StopFlowSession
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:UpdateFlowSession
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:UnpublishFlow
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:GetFlowStages
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:DeleteFlow
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:DescribeFlowPermissions
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:UpdateFlow
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:CreatePresignedUrl
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following are the list of values to set a principal as a flow viewer:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        quicksight:GetFlow
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:UpdateFlowSession
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:StartFlowSession
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:StopFlowSession
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:GetFlowSession
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:CreatePresignedUrl
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        quicksight:GetFlowStages
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(String... actions);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the principal. This can be an Amazon Quick Suite user, group or namespace
         * associated with the flow. Namespace principal can only be set as a viewer and will grant everyone in the same
         * namespace viewer permissions.
         * </p>
         * 
         * @param principal
         *        The Amazon Resource Name (ARN) of the principal. This can be an Amazon Quick Suite user, group or
         *        namespace associated with the flow. Namespace principal can only be set as a viewer and will grant
         *        everyone in the same namespace viewer permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String principal);
    }

    static final class BuilderImpl implements Builder {
        private List<String> actions = DefaultSdkAutoConstructList.getInstance();

        private String principal;

        private BuilderImpl() {
        }

        private BuilderImpl(Permission model) {
            actions(model.actions);
            principal(model.principal);
        }

        public final Collection<String> getActions() {
            if (actions instanceof SdkAutoConstructList) {
                return null;
            }
            return actions;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = ActionsListCopier.copy(actions);
        }

        @Override
        public final Builder actions(Collection<String> actions) {
            this.actions = ActionsListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(String... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        public final String getPrincipal() {
            return principal;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        @Override
        public Permission build() {
            return new Permission(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
