/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for a pivot operation, specifying which column contains labels and how to pivot them.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PivotConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PivotConfiguration.Builder, PivotConfiguration> {
    private static final SdkField<String> LABEL_COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelColumnName").getter(getter(PivotConfiguration::labelColumnName))
            .setter(setter(Builder::labelColumnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelColumnName").build()).build();

    private static final SdkField<List<PivotedLabel>> PIVOTED_LABELS_FIELD = SdkField
            .<List<PivotedLabel>> builder(MarshallingType.LIST)
            .memberName("PivotedLabels")
            .getter(getter(PivotConfiguration::pivotedLabels))
            .setter(setter(Builder::pivotedLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PivotedLabels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PivotedLabel> builder(MarshallingType.SDK_POJO)
                                            .constructor(PivotedLabel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_COLUMN_NAME_FIELD,
            PIVOTED_LABELS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String labelColumnName;

    private final List<PivotedLabel> pivotedLabels;

    private PivotConfiguration(BuilderImpl builder) {
        this.labelColumnName = builder.labelColumnName;
        this.pivotedLabels = builder.pivotedLabels;
    }

    /**
     * <p>
     * The name of the column that contains the labels to be pivoted into separate columns.
     * </p>
     * 
     * @return The name of the column that contains the labels to be pivoted into separate columns.
     */
    public final String labelColumnName() {
        return labelColumnName;
    }

    /**
     * For responses, this returns true if the service returned a value for the PivotedLabels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPivotedLabels() {
        return pivotedLabels != null && !(pivotedLabels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of specific label values to pivot into separate columns.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPivotedLabels} method.
     * </p>
     * 
     * @return The list of specific label values to pivot into separate columns.
     */
    public final List<PivotedLabel> pivotedLabels() {
        return pivotedLabels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(labelColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(hasPivotedLabels() ? pivotedLabels() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotConfiguration)) {
            return false;
        }
        PivotConfiguration other = (PivotConfiguration) obj;
        return Objects.equals(labelColumnName(), other.labelColumnName()) && hasPivotedLabels() == other.hasPivotedLabels()
                && Objects.equals(pivotedLabels(), other.pivotedLabels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PivotConfiguration").add("LabelColumnName", labelColumnName())
                .add("PivotedLabels", hasPivotedLabels() ? pivotedLabels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LabelColumnName":
            return Optional.ofNullable(clazz.cast(labelColumnName()));
        case "PivotedLabels":
            return Optional.ofNullable(clazz.cast(pivotedLabels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LabelColumnName", LABEL_COLUMN_NAME_FIELD);
        map.put("PivotedLabels", PIVOTED_LABELS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PivotConfiguration, T> g) {
        return obj -> g.apply((PivotConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PivotConfiguration> {
        /**
         * <p>
         * The name of the column that contains the labels to be pivoted into separate columns.
         * </p>
         * 
         * @param labelColumnName
         *        The name of the column that contains the labels to be pivoted into separate columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelColumnName(String labelColumnName);

        /**
         * <p>
         * The list of specific label values to pivot into separate columns.
         * </p>
         * 
         * @param pivotedLabels
         *        The list of specific label values to pivot into separate columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pivotedLabels(Collection<PivotedLabel> pivotedLabels);

        /**
         * <p>
         * The list of specific label values to pivot into separate columns.
         * </p>
         * 
         * @param pivotedLabels
         *        The list of specific label values to pivot into separate columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pivotedLabels(PivotedLabel... pivotedLabels);

        /**
         * <p>
         * The list of specific label values to pivot into separate columns.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.PivotedLabel.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.PivotedLabel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.PivotedLabel.Builder#build()} is called immediately
         * and its result is passed to {@link #pivotedLabels(List<PivotedLabel>)}.
         * 
         * @param pivotedLabels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.PivotedLabel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pivotedLabels(java.util.Collection<PivotedLabel>)
         */
        Builder pivotedLabels(Consumer<PivotedLabel.Builder>... pivotedLabels);
    }

    static final class BuilderImpl implements Builder {
        private String labelColumnName;

        private List<PivotedLabel> pivotedLabels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PivotConfiguration model) {
            labelColumnName(model.labelColumnName);
            pivotedLabels(model.pivotedLabels);
        }

        public final String getLabelColumnName() {
            return labelColumnName;
        }

        public final void setLabelColumnName(String labelColumnName) {
            this.labelColumnName = labelColumnName;
        }

        @Override
        public final Builder labelColumnName(String labelColumnName) {
            this.labelColumnName = labelColumnName;
            return this;
        }

        public final List<PivotedLabel.Builder> getPivotedLabels() {
            List<PivotedLabel.Builder> result = PivotedLabelListCopier.copyToBuilder(this.pivotedLabels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPivotedLabels(Collection<PivotedLabel.BuilderImpl> pivotedLabels) {
            this.pivotedLabels = PivotedLabelListCopier.copyFromBuilder(pivotedLabels);
        }

        @Override
        public final Builder pivotedLabels(Collection<PivotedLabel> pivotedLabels) {
            this.pivotedLabels = PivotedLabelListCopier.copy(pivotedLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pivotedLabels(PivotedLabel... pivotedLabels) {
            pivotedLabels(Arrays.asList(pivotedLabels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pivotedLabels(Consumer<PivotedLabel.Builder>... pivotedLabels) {
            pivotedLabels(Stream.of(pivotedLabels).map(c -> PivotedLabel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PivotConfiguration build() {
            return new PivotConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
