/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A transform operation that pivots data by converting row values into columns.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PivotOperation implements SdkPojo, Serializable, ToCopyableBuilder<PivotOperation.Builder, PivotOperation> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Alias")
            .getter(getter(PivotOperation::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final SdkField<TransformOperationSource> SOURCE_FIELD = SdkField
            .<TransformOperationSource> builder(MarshallingType.SDK_POJO).memberName("Source")
            .getter(getter(PivotOperation::source)).setter(setter(Builder::source))
            .constructor(TransformOperationSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<List<String>> GROUP_BY_COLUMN_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GroupByColumnNames")
            .getter(getter(PivotOperation::groupByColumnNames))
            .setter(setter(Builder::groupByColumnNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByColumnNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ValueColumnConfiguration> VALUE_COLUMN_CONFIGURATION_FIELD = SdkField
            .<ValueColumnConfiguration> builder(MarshallingType.SDK_POJO).memberName("ValueColumnConfiguration")
            .getter(getter(PivotOperation::valueColumnConfiguration)).setter(setter(Builder::valueColumnConfiguration))
            .constructor(ValueColumnConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueColumnConfiguration").build())
            .build();

    private static final SdkField<PivotConfiguration> PIVOT_CONFIGURATION_FIELD = SdkField
            .<PivotConfiguration> builder(MarshallingType.SDK_POJO).memberName("PivotConfiguration")
            .getter(getter(PivotOperation::pivotConfiguration)).setter(setter(Builder::pivotConfiguration))
            .constructor(PivotConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PivotConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, SOURCE_FIELD,
            GROUP_BY_COLUMN_NAMES_FIELD, VALUE_COLUMN_CONFIGURATION_FIELD, PIVOT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String alias;

    private final TransformOperationSource source;

    private final List<String> groupByColumnNames;

    private final ValueColumnConfiguration valueColumnConfiguration;

    private final PivotConfiguration pivotConfiguration;

    private PivotOperation(BuilderImpl builder) {
        this.alias = builder.alias;
        this.source = builder.source;
        this.groupByColumnNames = builder.groupByColumnNames;
        this.valueColumnConfiguration = builder.valueColumnConfiguration;
        this.pivotConfiguration = builder.pivotConfiguration;
    }

    /**
     * <p>
     * Alias for this operation.
     * </p>
     * 
     * @return Alias for this operation.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The source transform operation that provides input data for pivoting.
     * </p>
     * 
     * @return The source transform operation that provides input data for pivoting.
     */
    public final TransformOperationSource source() {
        return source;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupByColumnNames property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroupByColumnNames() {
        return groupByColumnNames != null && !(groupByColumnNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of column names to group by when performing the pivot operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupByColumnNames} method.
     * </p>
     * 
     * @return The list of column names to group by when performing the pivot operation.
     */
    public final List<String> groupByColumnNames() {
        return groupByColumnNames;
    }

    /**
     * <p>
     * Configuration for how to aggregate values when multiple rows map to the same pivoted column.
     * </p>
     * 
     * @return Configuration for how to aggregate values when multiple rows map to the same pivoted column.
     */
    public final ValueColumnConfiguration valueColumnConfiguration() {
        return valueColumnConfiguration;
    }

    /**
     * <p>
     * Configuration that specifies which labels to pivot and how to structure the resulting columns.
     * </p>
     * 
     * @return Configuration that specifies which labels to pivot and how to structure the resulting columns.
     */
    public final PivotConfiguration pivotConfiguration() {
        return pivotConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupByColumnNames() ? groupByColumnNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(valueColumnConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(pivotConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotOperation)) {
            return false;
        }
        PivotOperation other = (PivotOperation) obj;
        return Objects.equals(alias(), other.alias()) && Objects.equals(source(), other.source())
                && hasGroupByColumnNames() == other.hasGroupByColumnNames()
                && Objects.equals(groupByColumnNames(), other.groupByColumnNames())
                && Objects.equals(valueColumnConfiguration(), other.valueColumnConfiguration())
                && Objects.equals(pivotConfiguration(), other.pivotConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PivotOperation").add("Alias", alias()).add("Source", source())
                .add("GroupByColumnNames", hasGroupByColumnNames() ? groupByColumnNames() : null)
                .add("ValueColumnConfiguration", valueColumnConfiguration()).add("PivotConfiguration", pivotConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "GroupByColumnNames":
            return Optional.ofNullable(clazz.cast(groupByColumnNames()));
        case "ValueColumnConfiguration":
            return Optional.ofNullable(clazz.cast(valueColumnConfiguration()));
        case "PivotConfiguration":
            return Optional.ofNullable(clazz.cast(pivotConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Alias", ALIAS_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("GroupByColumnNames", GROUP_BY_COLUMN_NAMES_FIELD);
        map.put("ValueColumnConfiguration", VALUE_COLUMN_CONFIGURATION_FIELD);
        map.put("PivotConfiguration", PIVOT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PivotOperation, T> g) {
        return obj -> g.apply((PivotOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PivotOperation> {
        /**
         * <p>
         * Alias for this operation.
         * </p>
         * 
         * @param alias
         *        Alias for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The source transform operation that provides input data for pivoting.
         * </p>
         * 
         * @param source
         *        The source transform operation that provides input data for pivoting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(TransformOperationSource source);

        /**
         * <p>
         * The source transform operation that provides input data for pivoting.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransformOperationSource.Builder}
         * avoiding the need to create one manually via {@link TransformOperationSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransformOperationSource.Builder#build()} is called immediately
         * and its result is passed to {@link #source(TransformOperationSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link TransformOperationSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(TransformOperationSource)
         */
        default Builder source(Consumer<TransformOperationSource.Builder> source) {
            return source(TransformOperationSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The list of column names to group by when performing the pivot operation.
         * </p>
         * 
         * @param groupByColumnNames
         *        The list of column names to group by when performing the pivot operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByColumnNames(Collection<String> groupByColumnNames);

        /**
         * <p>
         * The list of column names to group by when performing the pivot operation.
         * </p>
         * 
         * @param groupByColumnNames
         *        The list of column names to group by when performing the pivot operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByColumnNames(String... groupByColumnNames);

        /**
         * <p>
         * Configuration for how to aggregate values when multiple rows map to the same pivoted column.
         * </p>
         * 
         * @param valueColumnConfiguration
         *        Configuration for how to aggregate values when multiple rows map to the same pivoted column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueColumnConfiguration(ValueColumnConfiguration valueColumnConfiguration);

        /**
         * <p>
         * Configuration for how to aggregate values when multiple rows map to the same pivoted column.
         * </p>
         * This is a convenience method that creates an instance of the {@link ValueColumnConfiguration.Builder}
         * avoiding the need to create one manually via {@link ValueColumnConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ValueColumnConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #valueColumnConfiguration(ValueColumnConfiguration)}.
         * 
         * @param valueColumnConfiguration
         *        a consumer that will call methods on {@link ValueColumnConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueColumnConfiguration(ValueColumnConfiguration)
         */
        default Builder valueColumnConfiguration(Consumer<ValueColumnConfiguration.Builder> valueColumnConfiguration) {
            return valueColumnConfiguration(ValueColumnConfiguration.builder().applyMutation(valueColumnConfiguration).build());
        }

        /**
         * <p>
         * Configuration that specifies which labels to pivot and how to structure the resulting columns.
         * </p>
         * 
         * @param pivotConfiguration
         *        Configuration that specifies which labels to pivot and how to structure the resulting columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pivotConfiguration(PivotConfiguration pivotConfiguration);

        /**
         * <p>
         * Configuration that specifies which labels to pivot and how to structure the resulting columns.
         * </p>
         * This is a convenience method that creates an instance of the {@link PivotConfiguration.Builder} avoiding the
         * need to create one manually via {@link PivotConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PivotConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #pivotConfiguration(PivotConfiguration)}.
         * 
         * @param pivotConfiguration
         *        a consumer that will call methods on {@link PivotConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pivotConfiguration(PivotConfiguration)
         */
        default Builder pivotConfiguration(Consumer<PivotConfiguration.Builder> pivotConfiguration) {
            return pivotConfiguration(PivotConfiguration.builder().applyMutation(pivotConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String alias;

        private TransformOperationSource source;

        private List<String> groupByColumnNames = DefaultSdkAutoConstructList.getInstance();

        private ValueColumnConfiguration valueColumnConfiguration;

        private PivotConfiguration pivotConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PivotOperation model) {
            alias(model.alias);
            source(model.source);
            groupByColumnNames(model.groupByColumnNames);
            valueColumnConfiguration(model.valueColumnConfiguration);
            pivotConfiguration(model.pivotConfiguration);
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final TransformOperationSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(TransformOperationSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(TransformOperationSource source) {
            this.source = source;
            return this;
        }

        public final Collection<String> getGroupByColumnNames() {
            if (groupByColumnNames instanceof SdkAutoConstructList) {
                return null;
            }
            return groupByColumnNames;
        }

        public final void setGroupByColumnNames(Collection<String> groupByColumnNames) {
            this.groupByColumnNames = PivotGroupByColumnNameListCopier.copy(groupByColumnNames);
        }

        @Override
        public final Builder groupByColumnNames(Collection<String> groupByColumnNames) {
            this.groupByColumnNames = PivotGroupByColumnNameListCopier.copy(groupByColumnNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByColumnNames(String... groupByColumnNames) {
            groupByColumnNames(Arrays.asList(groupByColumnNames));
            return this;
        }

        public final ValueColumnConfiguration.Builder getValueColumnConfiguration() {
            return valueColumnConfiguration != null ? valueColumnConfiguration.toBuilder() : null;
        }

        public final void setValueColumnConfiguration(ValueColumnConfiguration.BuilderImpl valueColumnConfiguration) {
            this.valueColumnConfiguration = valueColumnConfiguration != null ? valueColumnConfiguration.build() : null;
        }

        @Override
        public final Builder valueColumnConfiguration(ValueColumnConfiguration valueColumnConfiguration) {
            this.valueColumnConfiguration = valueColumnConfiguration;
            return this;
        }

        public final PivotConfiguration.Builder getPivotConfiguration() {
            return pivotConfiguration != null ? pivotConfiguration.toBuilder() : null;
        }

        public final void setPivotConfiguration(PivotConfiguration.BuilderImpl pivotConfiguration) {
            this.pivotConfiguration = pivotConfiguration != null ? pivotConfiguration.build() : null;
        }

        @Override
        public final Builder pivotConfiguration(PivotConfiguration pivotConfiguration) {
            this.pivotConfiguration = pivotConfiguration;
            return this;
        }

        @Override
        public PivotOperation build() {
            return new PivotOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
