/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a label value to be pivoted into a separate column, including the new column name and identifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PivotedLabel implements SdkPojo, Serializable, ToCopyableBuilder<PivotedLabel.Builder, PivotedLabel> {
    private static final SdkField<String> LABEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelName").getter(getter(PivotedLabel::labelName)).setter(setter(Builder::labelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelName").build()).build();

    private static final SdkField<String> NEW_COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewColumnName").getter(getter(PivotedLabel::newColumnName)).setter(setter(Builder::newColumnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewColumnName").build()).build();

    private static final SdkField<String> NEW_COLUMN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewColumnId").getter(getter(PivotedLabel::newColumnId)).setter(setter(Builder::newColumnId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewColumnId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_NAME_FIELD,
            NEW_COLUMN_NAME_FIELD, NEW_COLUMN_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String labelName;

    private final String newColumnName;

    private final String newColumnId;

    private PivotedLabel(BuilderImpl builder) {
        this.labelName = builder.labelName;
        this.newColumnName = builder.newColumnName;
        this.newColumnId = builder.newColumnId;
    }

    /**
     * <p>
     * The label value from the source data to be pivoted.
     * </p>
     * 
     * @return The label value from the source data to be pivoted.
     */
    public final String labelName() {
        return labelName;
    }

    /**
     * <p>
     * The name for the new column created from this pivoted label.
     * </p>
     * 
     * @return The name for the new column created from this pivoted label.
     */
    public final String newColumnName() {
        return newColumnName;
    }

    /**
     * <p>
     * A unique identifier for the new column created from this pivoted label.
     * </p>
     * 
     * @return A unique identifier for the new column created from this pivoted label.
     */
    public final String newColumnId() {
        return newColumnId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(labelName());
        hashCode = 31 * hashCode + Objects.hashCode(newColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(newColumnId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotedLabel)) {
            return false;
        }
        PivotedLabel other = (PivotedLabel) obj;
        return Objects.equals(labelName(), other.labelName()) && Objects.equals(newColumnName(), other.newColumnName())
                && Objects.equals(newColumnId(), other.newColumnId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PivotedLabel").add("LabelName", labelName()).add("NewColumnName", newColumnName())
                .add("NewColumnId", newColumnId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LabelName":
            return Optional.ofNullable(clazz.cast(labelName()));
        case "NewColumnName":
            return Optional.ofNullable(clazz.cast(newColumnName()));
        case "NewColumnId":
            return Optional.ofNullable(clazz.cast(newColumnId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LabelName", LABEL_NAME_FIELD);
        map.put("NewColumnName", NEW_COLUMN_NAME_FIELD);
        map.put("NewColumnId", NEW_COLUMN_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PivotedLabel, T> g) {
        return obj -> g.apply((PivotedLabel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PivotedLabel> {
        /**
         * <p>
         * The label value from the source data to be pivoted.
         * </p>
         * 
         * @param labelName
         *        The label value from the source data to be pivoted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelName(String labelName);

        /**
         * <p>
         * The name for the new column created from this pivoted label.
         * </p>
         * 
         * @param newColumnName
         *        The name for the new column created from this pivoted label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newColumnName(String newColumnName);

        /**
         * <p>
         * A unique identifier for the new column created from this pivoted label.
         * </p>
         * 
         * @param newColumnId
         *        A unique identifier for the new column created from this pivoted label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newColumnId(String newColumnId);
    }

    static final class BuilderImpl implements Builder {
        private String labelName;

        private String newColumnName;

        private String newColumnId;

        private BuilderImpl() {
        }

        private BuilderImpl(PivotedLabel model) {
            labelName(model.labelName);
            newColumnName(model.newColumnName);
            newColumnId(model.newColumnId);
        }

        public final String getLabelName() {
            return labelName;
        }

        public final void setLabelName(String labelName) {
            this.labelName = labelName;
        }

        @Override
        public final Builder labelName(String labelName) {
            this.labelName = labelName;
            return this;
        }

        public final String getNewColumnName() {
            return newColumnName;
        }

        public final void setNewColumnName(String newColumnName) {
            this.newColumnName = newColumnName;
        }

        @Override
        public final Builder newColumnName(String newColumnName) {
            this.newColumnName = newColumnName;
            return this;
        }

        public final String getNewColumnId() {
            return newColumnId;
        }

        public final void setNewColumnId(String newColumnId) {
            this.newColumnId = newColumnId;
        }

        @Override
        public final Builder newColumnId(String newColumnId) {
            this.newColumnId = newColumnId;
            return this;
        }

        @Override
        public PivotedLabel build() {
            return new PivotedLabel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
