/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Read-only authentication metadata union containing non-sensitive configuration details for different authentication
 * types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReadAuthenticationMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ReadAuthenticationMetadata.Builder, ReadAuthenticationMetadata> {
    private static final SdkField<ReadAuthorizationCodeGrantMetadata> AUTHORIZATION_CODE_GRANT_METADATA_FIELD = SdkField
            .<ReadAuthorizationCodeGrantMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("AuthorizationCodeGrantMetadata")
            .getter(getter(ReadAuthenticationMetadata::authorizationCodeGrantMetadata))
            .setter(setter(Builder::authorizationCodeGrantMetadata))
            .constructor(ReadAuthorizationCodeGrantMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationCodeGrantMetadata")
                    .build()).build();

    private static final SdkField<ReadClientCredentialsGrantMetadata> CLIENT_CREDENTIALS_GRANT_METADATA_FIELD = SdkField
            .<ReadClientCredentialsGrantMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("ClientCredentialsGrantMetadata")
            .getter(getter(ReadAuthenticationMetadata::clientCredentialsGrantMetadata))
            .setter(setter(Builder::clientCredentialsGrantMetadata))
            .constructor(ReadClientCredentialsGrantMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCredentialsGrantMetadata")
                    .build()).build();

    private static final SdkField<ReadBasicAuthConnectionMetadata> BASIC_AUTH_CONNECTION_METADATA_FIELD = SdkField
            .<ReadBasicAuthConnectionMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("BasicAuthConnectionMetadata")
            .getter(getter(ReadAuthenticationMetadata::basicAuthConnectionMetadata))
            .setter(setter(Builder::basicAuthConnectionMetadata))
            .constructor(ReadBasicAuthConnectionMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BasicAuthConnectionMetadata")
                    .build()).build();

    private static final SdkField<ReadAPIKeyConnectionMetadata> API_KEY_CONNECTION_METADATA_FIELD = SdkField
            .<ReadAPIKeyConnectionMetadata> builder(MarshallingType.SDK_POJO).memberName("ApiKeyConnectionMetadata")
            .getter(getter(ReadAuthenticationMetadata::apiKeyConnectionMetadata))
            .setter(setter(Builder::apiKeyConnectionMetadata)).constructor(ReadAPIKeyConnectionMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKeyConnectionMetadata").build())
            .build();

    private static final SdkField<ReadNoneConnectionMetadata> NONE_CONNECTION_METADATA_FIELD = SdkField
            .<ReadNoneConnectionMetadata> builder(MarshallingType.SDK_POJO).memberName("NoneConnectionMetadata")
            .getter(getter(ReadAuthenticationMetadata::noneConnectionMetadata)).setter(setter(Builder::noneConnectionMetadata))
            .constructor(ReadNoneConnectionMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoneConnectionMetadata").build())
            .build();

    private static final SdkField<ReadIamConnectionMetadata> IAM_CONNECTION_METADATA_FIELD = SdkField
            .<ReadIamConnectionMetadata> builder(MarshallingType.SDK_POJO).memberName("IamConnectionMetadata")
            .getter(getter(ReadAuthenticationMetadata::iamConnectionMetadata)).setter(setter(Builder::iamConnectionMetadata))
            .constructor(ReadIamConnectionMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamConnectionMetadata").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTHORIZATION_CODE_GRANT_METADATA_FIELD, CLIENT_CREDENTIALS_GRANT_METADATA_FIELD,
            BASIC_AUTH_CONNECTION_METADATA_FIELD, API_KEY_CONNECTION_METADATA_FIELD, NONE_CONNECTION_METADATA_FIELD,
            IAM_CONNECTION_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ReadAuthorizationCodeGrantMetadata authorizationCodeGrantMetadata;

    private final ReadClientCredentialsGrantMetadata clientCredentialsGrantMetadata;

    private final ReadBasicAuthConnectionMetadata basicAuthConnectionMetadata;

    private final ReadAPIKeyConnectionMetadata apiKeyConnectionMetadata;

    private final ReadNoneConnectionMetadata noneConnectionMetadata;

    private final ReadIamConnectionMetadata iamConnectionMetadata;

    private final Type type;

    private ReadAuthenticationMetadata(BuilderImpl builder) {
        this.authorizationCodeGrantMetadata = builder.authorizationCodeGrantMetadata;
        this.clientCredentialsGrantMetadata = builder.clientCredentialsGrantMetadata;
        this.basicAuthConnectionMetadata = builder.basicAuthConnectionMetadata;
        this.apiKeyConnectionMetadata = builder.apiKeyConnectionMetadata;
        this.noneConnectionMetadata = builder.noneConnectionMetadata;
        this.iamConnectionMetadata = builder.iamConnectionMetadata;
        this.type = builder.type;
    }

    /**
     * <p>
     * Read-only metadata for OAuth2 authorization code grant flow configuration.
     * </p>
     * 
     * @return Read-only metadata for OAuth2 authorization code grant flow configuration.
     */
    public final ReadAuthorizationCodeGrantMetadata authorizationCodeGrantMetadata() {
        return authorizationCodeGrantMetadata;
    }

    /**
     * <p>
     * Read-only metadata for OAuth2 client credentials grant flow configuration.
     * </p>
     * 
     * @return Read-only metadata for OAuth2 client credentials grant flow configuration.
     */
    public final ReadClientCredentialsGrantMetadata clientCredentialsGrantMetadata() {
        return clientCredentialsGrantMetadata;
    }

    /**
     * <p>
     * Read-only metadata for basic authentication configuration.
     * </p>
     * 
     * @return Read-only metadata for basic authentication configuration.
     */
    public final ReadBasicAuthConnectionMetadata basicAuthConnectionMetadata() {
        return basicAuthConnectionMetadata;
    }

    /**
     * <p>
     * Read-only metadata for API key authentication configuration.
     * </p>
     * 
     * @return Read-only metadata for API key authentication configuration.
     */
    public final ReadAPIKeyConnectionMetadata apiKeyConnectionMetadata() {
        return apiKeyConnectionMetadata;
    }

    /**
     * <p>
     * Read-only metadata for connections that do not require authentication.
     * </p>
     * 
     * @return Read-only metadata for connections that do not require authentication.
     */
    public final ReadNoneConnectionMetadata noneConnectionMetadata() {
        return noneConnectionMetadata;
    }

    /**
     * <p>
     * Read-only metadata for IAM-based authentication configuration.
     * </p>
     * 
     * @return Read-only metadata for IAM-based authentication configuration.
     */
    public final ReadIamConnectionMetadata iamConnectionMetadata() {
        return iamConnectionMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizationCodeGrantMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(clientCredentialsGrantMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(basicAuthConnectionMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(apiKeyConnectionMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(noneConnectionMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(iamConnectionMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReadAuthenticationMetadata)) {
            return false;
        }
        ReadAuthenticationMetadata other = (ReadAuthenticationMetadata) obj;
        return Objects.equals(authorizationCodeGrantMetadata(), other.authorizationCodeGrantMetadata())
                && Objects.equals(clientCredentialsGrantMetadata(), other.clientCredentialsGrantMetadata())
                && Objects.equals(basicAuthConnectionMetadata(), other.basicAuthConnectionMetadata())
                && Objects.equals(apiKeyConnectionMetadata(), other.apiKeyConnectionMetadata())
                && Objects.equals(noneConnectionMetadata(), other.noneConnectionMetadata())
                && Objects.equals(iamConnectionMetadata(), other.iamConnectionMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReadAuthenticationMetadata")
                .add("AuthorizationCodeGrantMetadata", authorizationCodeGrantMetadata())
                .add("ClientCredentialsGrantMetadata", clientCredentialsGrantMetadata())
                .add("BasicAuthConnectionMetadata", basicAuthConnectionMetadata())
                .add("ApiKeyConnectionMetadata", apiKeyConnectionMetadata())
                .add("NoneConnectionMetadata", noneConnectionMetadata()).add("IamConnectionMetadata", iamConnectionMetadata())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthorizationCodeGrantMetadata":
            return Optional.ofNullable(clazz.cast(authorizationCodeGrantMetadata()));
        case "ClientCredentialsGrantMetadata":
            return Optional.ofNullable(clazz.cast(clientCredentialsGrantMetadata()));
        case "BasicAuthConnectionMetadata":
            return Optional.ofNullable(clazz.cast(basicAuthConnectionMetadata()));
        case "ApiKeyConnectionMetadata":
            return Optional.ofNullable(clazz.cast(apiKeyConnectionMetadata()));
        case "NoneConnectionMetadata":
            return Optional.ofNullable(clazz.cast(noneConnectionMetadata()));
        case "IamConnectionMetadata":
            return Optional.ofNullable(clazz.cast(iamConnectionMetadata()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #authorizationCodeGrantMetadata()} initialized to the given value.
     *
     * <p>
     * Read-only metadata for OAuth2 authorization code grant flow configuration.
     * </p>
     * 
     * @param authorizationCodeGrantMetadata
     *        Read-only metadata for OAuth2 authorization code grant flow configuration.
     */
    public static ReadAuthenticationMetadata fromAuthorizationCodeGrantMetadata(
            ReadAuthorizationCodeGrantMetadata authorizationCodeGrantMetadata) {
        return builder().authorizationCodeGrantMetadata(authorizationCodeGrantMetadata).build();
    }

    /**
     * Create an instance of this class with {@link #authorizationCodeGrantMetadata()} initialized to the given value.
     *
     * <p>
     * Read-only metadata for OAuth2 authorization code grant flow configuration.
     * </p>
     * 
     * @param authorizationCodeGrantMetadata
     *        Read-only metadata for OAuth2 authorization code grant flow configuration.
     */
    public static ReadAuthenticationMetadata fromAuthorizationCodeGrantMetadata(
            Consumer<ReadAuthorizationCodeGrantMetadata.Builder> authorizationCodeGrantMetadata) {
        ReadAuthorizationCodeGrantMetadata.Builder builder = ReadAuthorizationCodeGrantMetadata.builder();
        authorizationCodeGrantMetadata.accept(builder);
        return fromAuthorizationCodeGrantMetadata(builder.build());
    }

    /**
     * Create an instance of this class with {@link #clientCredentialsGrantMetadata()} initialized to the given value.
     *
     * <p>
     * Read-only metadata for OAuth2 client credentials grant flow configuration.
     * </p>
     * 
     * @param clientCredentialsGrantMetadata
     *        Read-only metadata for OAuth2 client credentials grant flow configuration.
     */
    public static ReadAuthenticationMetadata fromClientCredentialsGrantMetadata(
            ReadClientCredentialsGrantMetadata clientCredentialsGrantMetadata) {
        return builder().clientCredentialsGrantMetadata(clientCredentialsGrantMetadata).build();
    }

    /**
     * Create an instance of this class with {@link #clientCredentialsGrantMetadata()} initialized to the given value.
     *
     * <p>
     * Read-only metadata for OAuth2 client credentials grant flow configuration.
     * </p>
     * 
     * @param clientCredentialsGrantMetadata
     *        Read-only metadata for OAuth2 client credentials grant flow configuration.
     */
    public static ReadAuthenticationMetadata fromClientCredentialsGrantMetadata(
            Consumer<ReadClientCredentialsGrantMetadata.Builder> clientCredentialsGrantMetadata) {
        ReadClientCredentialsGrantMetadata.Builder builder = ReadClientCredentialsGrantMetadata.builder();
        clientCredentialsGrantMetadata.accept(builder);
        return fromClientCredentialsGrantMetadata(builder.build());
    }

    /**
     * Create an instance of this class with {@link #basicAuthConnectionMetadata()} initialized to the given value.
     *
     * <p>
     * Read-only metadata for basic authentication configuration.
     * </p>
     * 
     * @param basicAuthConnectionMetadata
     *        Read-only metadata for basic authentication configuration.
     */
    public static ReadAuthenticationMetadata fromBasicAuthConnectionMetadata(
            ReadBasicAuthConnectionMetadata basicAuthConnectionMetadata) {
        return builder().basicAuthConnectionMetadata(basicAuthConnectionMetadata).build();
    }

    /**
     * Create an instance of this class with {@link #basicAuthConnectionMetadata()} initialized to the given value.
     *
     * <p>
     * Read-only metadata for basic authentication configuration.
     * </p>
     * 
     * @param basicAuthConnectionMetadata
     *        Read-only metadata for basic authentication configuration.
     */
    public static ReadAuthenticationMetadata fromBasicAuthConnectionMetadata(
            Consumer<ReadBasicAuthConnectionMetadata.Builder> basicAuthConnectionMetadata) {
        ReadBasicAuthConnectionMetadata.Builder builder = ReadBasicAuthConnectionMetadata.builder();
        basicAuthConnectionMetadata.accept(builder);
        return fromBasicAuthConnectionMetadata(builder.build());
    }

    /**
     * Create an instance of this class with {@link #apiKeyConnectionMetadata()} initialized to the given value.
     *
     * <p>
     * Read-only metadata for API key authentication configuration.
     * </p>
     * 
     * @param apiKeyConnectionMetadata
     *        Read-only metadata for API key authentication configuration.
     */
    public static ReadAuthenticationMetadata fromApiKeyConnectionMetadata(ReadAPIKeyConnectionMetadata apiKeyConnectionMetadata) {
        return builder().apiKeyConnectionMetadata(apiKeyConnectionMetadata).build();
    }

    /**
     * Create an instance of this class with {@link #apiKeyConnectionMetadata()} initialized to the given value.
     *
     * <p>
     * Read-only metadata for API key authentication configuration.
     * </p>
     * 
     * @param apiKeyConnectionMetadata
     *        Read-only metadata for API key authentication configuration.
     */
    public static ReadAuthenticationMetadata fromApiKeyConnectionMetadata(
            Consumer<ReadAPIKeyConnectionMetadata.Builder> apiKeyConnectionMetadata) {
        ReadAPIKeyConnectionMetadata.Builder builder = ReadAPIKeyConnectionMetadata.builder();
        apiKeyConnectionMetadata.accept(builder);
        return fromApiKeyConnectionMetadata(builder.build());
    }

    /**
     * Create an instance of this class with {@link #noneConnectionMetadata()} initialized to the given value.
     *
     * <p>
     * Read-only metadata for connections that do not require authentication.
     * </p>
     * 
     * @param noneConnectionMetadata
     *        Read-only metadata for connections that do not require authentication.
     */
    public static ReadAuthenticationMetadata fromNoneConnectionMetadata(ReadNoneConnectionMetadata noneConnectionMetadata) {
        return builder().noneConnectionMetadata(noneConnectionMetadata).build();
    }

    /**
     * Create an instance of this class with {@link #noneConnectionMetadata()} initialized to the given value.
     *
     * <p>
     * Read-only metadata for connections that do not require authentication.
     * </p>
     * 
     * @param noneConnectionMetadata
     *        Read-only metadata for connections that do not require authentication.
     */
    public static ReadAuthenticationMetadata fromNoneConnectionMetadata(
            Consumer<ReadNoneConnectionMetadata.Builder> noneConnectionMetadata) {
        ReadNoneConnectionMetadata.Builder builder = ReadNoneConnectionMetadata.builder();
        noneConnectionMetadata.accept(builder);
        return fromNoneConnectionMetadata(builder.build());
    }

    /**
     * Create an instance of this class with {@link #iamConnectionMetadata()} initialized to the given value.
     *
     * <p>
     * Read-only metadata for IAM-based authentication configuration.
     * </p>
     * 
     * @param iamConnectionMetadata
     *        Read-only metadata for IAM-based authentication configuration.
     */
    public static ReadAuthenticationMetadata fromIamConnectionMetadata(ReadIamConnectionMetadata iamConnectionMetadata) {
        return builder().iamConnectionMetadata(iamConnectionMetadata).build();
    }

    /**
     * Create an instance of this class with {@link #iamConnectionMetadata()} initialized to the given value.
     *
     * <p>
     * Read-only metadata for IAM-based authentication configuration.
     * </p>
     * 
     * @param iamConnectionMetadata
     *        Read-only metadata for IAM-based authentication configuration.
     */
    public static ReadAuthenticationMetadata fromIamConnectionMetadata(
            Consumer<ReadIamConnectionMetadata.Builder> iamConnectionMetadata) {
        ReadIamConnectionMetadata.Builder builder = ReadIamConnectionMetadata.builder();
        iamConnectionMetadata.accept(builder);
        return fromIamConnectionMetadata(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AuthorizationCodeGrantMetadata", AUTHORIZATION_CODE_GRANT_METADATA_FIELD);
        map.put("ClientCredentialsGrantMetadata", CLIENT_CREDENTIALS_GRANT_METADATA_FIELD);
        map.put("BasicAuthConnectionMetadata", BASIC_AUTH_CONNECTION_METADATA_FIELD);
        map.put("ApiKeyConnectionMetadata", API_KEY_CONNECTION_METADATA_FIELD);
        map.put("NoneConnectionMetadata", NONE_CONNECTION_METADATA_FIELD);
        map.put("IamConnectionMetadata", IAM_CONNECTION_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReadAuthenticationMetadata, T> g) {
        return obj -> g.apply((ReadAuthenticationMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReadAuthenticationMetadata> {
        /**
         * <p>
         * Read-only metadata for OAuth2 authorization code grant flow configuration.
         * </p>
         * 
         * @param authorizationCodeGrantMetadata
         *        Read-only metadata for OAuth2 authorization code grant flow configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationCodeGrantMetadata(ReadAuthorizationCodeGrantMetadata authorizationCodeGrantMetadata);

        /**
         * <p>
         * Read-only metadata for OAuth2 authorization code grant flow configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ReadAuthorizationCodeGrantMetadata.Builder} avoiding the need to create one manually via
         * {@link ReadAuthorizationCodeGrantMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReadAuthorizationCodeGrantMetadata.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #authorizationCodeGrantMetadata(ReadAuthorizationCodeGrantMetadata)}.
         * 
         * @param authorizationCodeGrantMetadata
         *        a consumer that will call methods on {@link ReadAuthorizationCodeGrantMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizationCodeGrantMetadata(ReadAuthorizationCodeGrantMetadata)
         */
        default Builder authorizationCodeGrantMetadata(
                Consumer<ReadAuthorizationCodeGrantMetadata.Builder> authorizationCodeGrantMetadata) {
            return authorizationCodeGrantMetadata(ReadAuthorizationCodeGrantMetadata.builder()
                    .applyMutation(authorizationCodeGrantMetadata).build());
        }

        /**
         * <p>
         * Read-only metadata for OAuth2 client credentials grant flow configuration.
         * </p>
         * 
         * @param clientCredentialsGrantMetadata
         *        Read-only metadata for OAuth2 client credentials grant flow configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCredentialsGrantMetadata(ReadClientCredentialsGrantMetadata clientCredentialsGrantMetadata);

        /**
         * <p>
         * Read-only metadata for OAuth2 client credentials grant flow configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ReadClientCredentialsGrantMetadata.Builder} avoiding the need to create one manually via
         * {@link ReadClientCredentialsGrantMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReadClientCredentialsGrantMetadata.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #clientCredentialsGrantMetadata(ReadClientCredentialsGrantMetadata)}.
         * 
         * @param clientCredentialsGrantMetadata
         *        a consumer that will call methods on {@link ReadClientCredentialsGrantMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientCredentialsGrantMetadata(ReadClientCredentialsGrantMetadata)
         */
        default Builder clientCredentialsGrantMetadata(
                Consumer<ReadClientCredentialsGrantMetadata.Builder> clientCredentialsGrantMetadata) {
            return clientCredentialsGrantMetadata(ReadClientCredentialsGrantMetadata.builder()
                    .applyMutation(clientCredentialsGrantMetadata).build());
        }

        /**
         * <p>
         * Read-only metadata for basic authentication configuration.
         * </p>
         * 
         * @param basicAuthConnectionMetadata
         *        Read-only metadata for basic authentication configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basicAuthConnectionMetadata(ReadBasicAuthConnectionMetadata basicAuthConnectionMetadata);

        /**
         * <p>
         * Read-only metadata for basic authentication configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReadBasicAuthConnectionMetadata.Builder}
         * avoiding the need to create one manually via {@link ReadBasicAuthConnectionMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReadBasicAuthConnectionMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #basicAuthConnectionMetadata(ReadBasicAuthConnectionMetadata)}.
         * 
         * @param basicAuthConnectionMetadata
         *        a consumer that will call methods on {@link ReadBasicAuthConnectionMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #basicAuthConnectionMetadata(ReadBasicAuthConnectionMetadata)
         */
        default Builder basicAuthConnectionMetadata(Consumer<ReadBasicAuthConnectionMetadata.Builder> basicAuthConnectionMetadata) {
            return basicAuthConnectionMetadata(ReadBasicAuthConnectionMetadata.builder()
                    .applyMutation(basicAuthConnectionMetadata).build());
        }

        /**
         * <p>
         * Read-only metadata for API key authentication configuration.
         * </p>
         * 
         * @param apiKeyConnectionMetadata
         *        Read-only metadata for API key authentication configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKeyConnectionMetadata(ReadAPIKeyConnectionMetadata apiKeyConnectionMetadata);

        /**
         * <p>
         * Read-only metadata for API key authentication configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReadAPIKeyConnectionMetadata.Builder}
         * avoiding the need to create one manually via {@link ReadAPIKeyConnectionMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReadAPIKeyConnectionMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #apiKeyConnectionMetadata(ReadAPIKeyConnectionMetadata)}.
         * 
         * @param apiKeyConnectionMetadata
         *        a consumer that will call methods on {@link ReadAPIKeyConnectionMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apiKeyConnectionMetadata(ReadAPIKeyConnectionMetadata)
         */
        default Builder apiKeyConnectionMetadata(Consumer<ReadAPIKeyConnectionMetadata.Builder> apiKeyConnectionMetadata) {
            return apiKeyConnectionMetadata(ReadAPIKeyConnectionMetadata.builder().applyMutation(apiKeyConnectionMetadata)
                    .build());
        }

        /**
         * <p>
         * Read-only metadata for connections that do not require authentication.
         * </p>
         * 
         * @param noneConnectionMetadata
         *        Read-only metadata for connections that do not require authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noneConnectionMetadata(ReadNoneConnectionMetadata noneConnectionMetadata);

        /**
         * <p>
         * Read-only metadata for connections that do not require authentication.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReadNoneConnectionMetadata.Builder}
         * avoiding the need to create one manually via {@link ReadNoneConnectionMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReadNoneConnectionMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #noneConnectionMetadata(ReadNoneConnectionMetadata)}.
         * 
         * @param noneConnectionMetadata
         *        a consumer that will call methods on {@link ReadNoneConnectionMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #noneConnectionMetadata(ReadNoneConnectionMetadata)
         */
        default Builder noneConnectionMetadata(Consumer<ReadNoneConnectionMetadata.Builder> noneConnectionMetadata) {
            return noneConnectionMetadata(ReadNoneConnectionMetadata.builder().applyMutation(noneConnectionMetadata).build());
        }

        /**
         * <p>
         * Read-only metadata for IAM-based authentication configuration.
         * </p>
         * 
         * @param iamConnectionMetadata
         *        Read-only metadata for IAM-based authentication configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamConnectionMetadata(ReadIamConnectionMetadata iamConnectionMetadata);

        /**
         * <p>
         * Read-only metadata for IAM-based authentication configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReadIamConnectionMetadata.Builder}
         * avoiding the need to create one manually via {@link ReadIamConnectionMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReadIamConnectionMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #iamConnectionMetadata(ReadIamConnectionMetadata)}.
         * 
         * @param iamConnectionMetadata
         *        a consumer that will call methods on {@link ReadIamConnectionMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamConnectionMetadata(ReadIamConnectionMetadata)
         */
        default Builder iamConnectionMetadata(Consumer<ReadIamConnectionMetadata.Builder> iamConnectionMetadata) {
            return iamConnectionMetadata(ReadIamConnectionMetadata.builder().applyMutation(iamConnectionMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ReadAuthorizationCodeGrantMetadata authorizationCodeGrantMetadata;

        private ReadClientCredentialsGrantMetadata clientCredentialsGrantMetadata;

        private ReadBasicAuthConnectionMetadata basicAuthConnectionMetadata;

        private ReadAPIKeyConnectionMetadata apiKeyConnectionMetadata;

        private ReadNoneConnectionMetadata noneConnectionMetadata;

        private ReadIamConnectionMetadata iamConnectionMetadata;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ReadAuthenticationMetadata model) {
            authorizationCodeGrantMetadata(model.authorizationCodeGrantMetadata);
            clientCredentialsGrantMetadata(model.clientCredentialsGrantMetadata);
            basicAuthConnectionMetadata(model.basicAuthConnectionMetadata);
            apiKeyConnectionMetadata(model.apiKeyConnectionMetadata);
            noneConnectionMetadata(model.noneConnectionMetadata);
            iamConnectionMetadata(model.iamConnectionMetadata);
        }

        public final ReadAuthorizationCodeGrantMetadata.Builder getAuthorizationCodeGrantMetadata() {
            return authorizationCodeGrantMetadata != null ? authorizationCodeGrantMetadata.toBuilder() : null;
        }

        public final void setAuthorizationCodeGrantMetadata(
                ReadAuthorizationCodeGrantMetadata.BuilderImpl authorizationCodeGrantMetadata) {
            Object oldValue = this.authorizationCodeGrantMetadata;
            this.authorizationCodeGrantMetadata = authorizationCodeGrantMetadata != null ? authorizationCodeGrantMetadata.build()
                    : null;
            handleUnionValueChange(Type.AUTHORIZATION_CODE_GRANT_METADATA, oldValue, this.authorizationCodeGrantMetadata);
        }

        @Override
        public final Builder authorizationCodeGrantMetadata(ReadAuthorizationCodeGrantMetadata authorizationCodeGrantMetadata) {
            Object oldValue = this.authorizationCodeGrantMetadata;
            this.authorizationCodeGrantMetadata = authorizationCodeGrantMetadata;
            handleUnionValueChange(Type.AUTHORIZATION_CODE_GRANT_METADATA, oldValue, this.authorizationCodeGrantMetadata);
            return this;
        }

        public final ReadClientCredentialsGrantMetadata.Builder getClientCredentialsGrantMetadata() {
            return clientCredentialsGrantMetadata != null ? clientCredentialsGrantMetadata.toBuilder() : null;
        }

        public final void setClientCredentialsGrantMetadata(
                ReadClientCredentialsGrantMetadata.BuilderImpl clientCredentialsGrantMetadata) {
            Object oldValue = this.clientCredentialsGrantMetadata;
            this.clientCredentialsGrantMetadata = clientCredentialsGrantMetadata != null ? clientCredentialsGrantMetadata.build()
                    : null;
            handleUnionValueChange(Type.CLIENT_CREDENTIALS_GRANT_METADATA, oldValue, this.clientCredentialsGrantMetadata);
        }

        @Override
        public final Builder clientCredentialsGrantMetadata(ReadClientCredentialsGrantMetadata clientCredentialsGrantMetadata) {
            Object oldValue = this.clientCredentialsGrantMetadata;
            this.clientCredentialsGrantMetadata = clientCredentialsGrantMetadata;
            handleUnionValueChange(Type.CLIENT_CREDENTIALS_GRANT_METADATA, oldValue, this.clientCredentialsGrantMetadata);
            return this;
        }

        public final ReadBasicAuthConnectionMetadata.Builder getBasicAuthConnectionMetadata() {
            return basicAuthConnectionMetadata != null ? basicAuthConnectionMetadata.toBuilder() : null;
        }

        public final void setBasicAuthConnectionMetadata(ReadBasicAuthConnectionMetadata.BuilderImpl basicAuthConnectionMetadata) {
            Object oldValue = this.basicAuthConnectionMetadata;
            this.basicAuthConnectionMetadata = basicAuthConnectionMetadata != null ? basicAuthConnectionMetadata.build() : null;
            handleUnionValueChange(Type.BASIC_AUTH_CONNECTION_METADATA, oldValue, this.basicAuthConnectionMetadata);
        }

        @Override
        public final Builder basicAuthConnectionMetadata(ReadBasicAuthConnectionMetadata basicAuthConnectionMetadata) {
            Object oldValue = this.basicAuthConnectionMetadata;
            this.basicAuthConnectionMetadata = basicAuthConnectionMetadata;
            handleUnionValueChange(Type.BASIC_AUTH_CONNECTION_METADATA, oldValue, this.basicAuthConnectionMetadata);
            return this;
        }

        public final ReadAPIKeyConnectionMetadata.Builder getApiKeyConnectionMetadata() {
            return apiKeyConnectionMetadata != null ? apiKeyConnectionMetadata.toBuilder() : null;
        }

        public final void setApiKeyConnectionMetadata(ReadAPIKeyConnectionMetadata.BuilderImpl apiKeyConnectionMetadata) {
            Object oldValue = this.apiKeyConnectionMetadata;
            this.apiKeyConnectionMetadata = apiKeyConnectionMetadata != null ? apiKeyConnectionMetadata.build() : null;
            handleUnionValueChange(Type.API_KEY_CONNECTION_METADATA, oldValue, this.apiKeyConnectionMetadata);
        }

        @Override
        public final Builder apiKeyConnectionMetadata(ReadAPIKeyConnectionMetadata apiKeyConnectionMetadata) {
            Object oldValue = this.apiKeyConnectionMetadata;
            this.apiKeyConnectionMetadata = apiKeyConnectionMetadata;
            handleUnionValueChange(Type.API_KEY_CONNECTION_METADATA, oldValue, this.apiKeyConnectionMetadata);
            return this;
        }

        public final ReadNoneConnectionMetadata.Builder getNoneConnectionMetadata() {
            return noneConnectionMetadata != null ? noneConnectionMetadata.toBuilder() : null;
        }

        public final void setNoneConnectionMetadata(ReadNoneConnectionMetadata.BuilderImpl noneConnectionMetadata) {
            Object oldValue = this.noneConnectionMetadata;
            this.noneConnectionMetadata = noneConnectionMetadata != null ? noneConnectionMetadata.build() : null;
            handleUnionValueChange(Type.NONE_CONNECTION_METADATA, oldValue, this.noneConnectionMetadata);
        }

        @Override
        public final Builder noneConnectionMetadata(ReadNoneConnectionMetadata noneConnectionMetadata) {
            Object oldValue = this.noneConnectionMetadata;
            this.noneConnectionMetadata = noneConnectionMetadata;
            handleUnionValueChange(Type.NONE_CONNECTION_METADATA, oldValue, this.noneConnectionMetadata);
            return this;
        }

        public final ReadIamConnectionMetadata.Builder getIamConnectionMetadata() {
            return iamConnectionMetadata != null ? iamConnectionMetadata.toBuilder() : null;
        }

        public final void setIamConnectionMetadata(ReadIamConnectionMetadata.BuilderImpl iamConnectionMetadata) {
            Object oldValue = this.iamConnectionMetadata;
            this.iamConnectionMetadata = iamConnectionMetadata != null ? iamConnectionMetadata.build() : null;
            handleUnionValueChange(Type.IAM_CONNECTION_METADATA, oldValue, this.iamConnectionMetadata);
        }

        @Override
        public final Builder iamConnectionMetadata(ReadIamConnectionMetadata iamConnectionMetadata) {
            Object oldValue = this.iamConnectionMetadata;
            this.iamConnectionMetadata = iamConnectionMetadata;
            handleUnionValueChange(Type.IAM_CONNECTION_METADATA, oldValue, this.iamConnectionMetadata);
            return this;
        }

        @Override
        public ReadAuthenticationMetadata build() {
            return new ReadAuthenticationMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ReadAuthenticationMetadata#type()
     */
    public enum Type {
        AUTHORIZATION_CODE_GRANT_METADATA,

        CLIENT_CREDENTIALS_GRANT_METADATA,

        BASIC_AUTH_CONNECTION_METADATA,

        API_KEY_CONNECTION_METADATA,

        NONE_CONNECTION_METADATA,

        IAM_CONNECTION_METADATA,

        UNKNOWN_TO_SDK_VERSION
    }
}
