/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Read-only credentials details for OAuth2 authorization code grant flow, containing non-sensitive configuration
 * information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReadAuthorizationCodeGrantCredentialsDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ReadAuthorizationCodeGrantCredentialsDetails.Builder, ReadAuthorizationCodeGrantCredentialsDetails> {
    private static final SdkField<ReadAuthorizationCodeGrantDetails> READ_AUTHORIZATION_CODE_GRANT_DETAILS_FIELD = SdkField
            .<ReadAuthorizationCodeGrantDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ReadAuthorizationCodeGrantDetails")
            .getter(getter(ReadAuthorizationCodeGrantCredentialsDetails::readAuthorizationCodeGrantDetails))
            .setter(setter(Builder::readAuthorizationCodeGrantDetails))
            .constructor(ReadAuthorizationCodeGrantDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadAuthorizationCodeGrantDetails")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(READ_AUTHORIZATION_CODE_GRANT_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ReadAuthorizationCodeGrantDetails readAuthorizationCodeGrantDetails;

    private final Type type;

    private ReadAuthorizationCodeGrantCredentialsDetails(BuilderImpl builder) {
        this.readAuthorizationCodeGrantDetails = builder.readAuthorizationCodeGrantDetails;
        this.type = builder.type;
    }

    /**
     * <p>
     * The read-only authorization code grant configuration details.
     * </p>
     * 
     * @return The read-only authorization code grant configuration details.
     */
    public final ReadAuthorizationCodeGrantDetails readAuthorizationCodeGrantDetails() {
        return readAuthorizationCodeGrantDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(readAuthorizationCodeGrantDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReadAuthorizationCodeGrantCredentialsDetails)) {
            return false;
        }
        ReadAuthorizationCodeGrantCredentialsDetails other = (ReadAuthorizationCodeGrantCredentialsDetails) obj;
        return Objects.equals(readAuthorizationCodeGrantDetails(), other.readAuthorizationCodeGrantDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReadAuthorizationCodeGrantCredentialsDetails")
                .add("ReadAuthorizationCodeGrantDetails", readAuthorizationCodeGrantDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReadAuthorizationCodeGrantDetails":
            return Optional.ofNullable(clazz.cast(readAuthorizationCodeGrantDetails()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #readAuthorizationCodeGrantDetails()} initialized to the given
     * value.
     *
     * <p>
     * The read-only authorization code grant configuration details.
     * </p>
     * 
     * @param readAuthorizationCodeGrantDetails
     *        The read-only authorization code grant configuration details.
     */
    public static ReadAuthorizationCodeGrantCredentialsDetails fromReadAuthorizationCodeGrantDetails(
            ReadAuthorizationCodeGrantDetails readAuthorizationCodeGrantDetails) {
        return builder().readAuthorizationCodeGrantDetails(readAuthorizationCodeGrantDetails).build();
    }

    /**
     * Create an instance of this class with {@link #readAuthorizationCodeGrantDetails()} initialized to the given
     * value.
     *
     * <p>
     * The read-only authorization code grant configuration details.
     * </p>
     * 
     * @param readAuthorizationCodeGrantDetails
     *        The read-only authorization code grant configuration details.
     */
    public static ReadAuthorizationCodeGrantCredentialsDetails fromReadAuthorizationCodeGrantDetails(
            Consumer<ReadAuthorizationCodeGrantDetails.Builder> readAuthorizationCodeGrantDetails) {
        ReadAuthorizationCodeGrantDetails.Builder builder = ReadAuthorizationCodeGrantDetails.builder();
        readAuthorizationCodeGrantDetails.accept(builder);
        return fromReadAuthorizationCodeGrantDetails(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReadAuthorizationCodeGrantDetails", READ_AUTHORIZATION_CODE_GRANT_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReadAuthorizationCodeGrantCredentialsDetails, T> g) {
        return obj -> g.apply((ReadAuthorizationCodeGrantCredentialsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReadAuthorizationCodeGrantCredentialsDetails> {
        /**
         * <p>
         * The read-only authorization code grant configuration details.
         * </p>
         * 
         * @param readAuthorizationCodeGrantDetails
         *        The read-only authorization code grant configuration details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readAuthorizationCodeGrantDetails(ReadAuthorizationCodeGrantDetails readAuthorizationCodeGrantDetails);

        /**
         * <p>
         * The read-only authorization code grant configuration details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ReadAuthorizationCodeGrantDetails.Builder} avoiding the need to create one manually via
         * {@link ReadAuthorizationCodeGrantDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReadAuthorizationCodeGrantDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #readAuthorizationCodeGrantDetails(ReadAuthorizationCodeGrantDetails)}.
         * 
         * @param readAuthorizationCodeGrantDetails
         *        a consumer that will call methods on {@link ReadAuthorizationCodeGrantDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #readAuthorizationCodeGrantDetails(ReadAuthorizationCodeGrantDetails)
         */
        default Builder readAuthorizationCodeGrantDetails(
                Consumer<ReadAuthorizationCodeGrantDetails.Builder> readAuthorizationCodeGrantDetails) {
            return readAuthorizationCodeGrantDetails(ReadAuthorizationCodeGrantDetails.builder()
                    .applyMutation(readAuthorizationCodeGrantDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ReadAuthorizationCodeGrantDetails readAuthorizationCodeGrantDetails;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ReadAuthorizationCodeGrantCredentialsDetails model) {
            readAuthorizationCodeGrantDetails(model.readAuthorizationCodeGrantDetails);
        }

        public final ReadAuthorizationCodeGrantDetails.Builder getReadAuthorizationCodeGrantDetails() {
            return readAuthorizationCodeGrantDetails != null ? readAuthorizationCodeGrantDetails.toBuilder() : null;
        }

        public final void setReadAuthorizationCodeGrantDetails(
                ReadAuthorizationCodeGrantDetails.BuilderImpl readAuthorizationCodeGrantDetails) {
            Object oldValue = this.readAuthorizationCodeGrantDetails;
            this.readAuthorizationCodeGrantDetails = readAuthorizationCodeGrantDetails != null ? readAuthorizationCodeGrantDetails
                    .build() : null;
            handleUnionValueChange(Type.READ_AUTHORIZATION_CODE_GRANT_DETAILS, oldValue, this.readAuthorizationCodeGrantDetails);
        }

        @Override
        public final Builder readAuthorizationCodeGrantDetails(ReadAuthorizationCodeGrantDetails readAuthorizationCodeGrantDetails) {
            Object oldValue = this.readAuthorizationCodeGrantDetails;
            this.readAuthorizationCodeGrantDetails = readAuthorizationCodeGrantDetails;
            handleUnionValueChange(Type.READ_AUTHORIZATION_CODE_GRANT_DETAILS, oldValue, this.readAuthorizationCodeGrantDetails);
            return this;
        }

        @Override
        public ReadAuthorizationCodeGrantCredentialsDetails build() {
            return new ReadAuthorizationCodeGrantCredentialsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ReadAuthorizationCodeGrantCredentialsDetails#type()
     */
    public enum Type {
        READ_AUTHORIZATION_CODE_GRANT_DETAILS,

        UNKNOWN_TO_SDK_VERSION
    }
}
