/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Read-only configuration details for OAuth2 authorization code grant flow, including endpoints and client information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReadAuthorizationCodeGrantDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ReadAuthorizationCodeGrantDetails.Builder, ReadAuthorizationCodeGrantDetails> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientId").getter(getter(ReadAuthorizationCodeGrantDetails::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<String> TOKEN_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TokenEndpoint").getter(getter(ReadAuthorizationCodeGrantDetails::tokenEndpoint))
            .setter(setter(Builder::tokenEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenEndpoint").build()).build();

    private static final SdkField<String> AUTHORIZATION_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthorizationEndpoint").getter(getter(ReadAuthorizationCodeGrantDetails::authorizationEndpoint))
            .setter(setter(Builder::authorizationEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationEndpoint").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD,
            TOKEN_ENDPOINT_FIELD, AUTHORIZATION_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clientId;

    private final String tokenEndpoint;

    private final String authorizationEndpoint;

    private ReadAuthorizationCodeGrantDetails(BuilderImpl builder) {
        this.clientId = builder.clientId;
        this.tokenEndpoint = builder.tokenEndpoint;
        this.authorizationEndpoint = builder.authorizationEndpoint;
    }

    /**
     * <p>
     * The client identifier for the OAuth2 authorization code grant flow.
     * </p>
     * 
     * @return The client identifier for the OAuth2 authorization code grant flow.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The authorization server endpoint used to obtain access tokens via the authorization code grant flow.
     * </p>
     * 
     * @return The authorization server endpoint used to obtain access tokens via the authorization code grant flow.
     */
    public final String tokenEndpoint() {
        return tokenEndpoint;
    }

    /**
     * <p>
     * The authorization server endpoint used to obtain authorization codes from the resource owner.
     * </p>
     * 
     * @return The authorization server endpoint used to obtain authorization codes from the resource owner.
     */
    public final String authorizationEndpoint() {
        return authorizationEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(tokenEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReadAuthorizationCodeGrantDetails)) {
            return false;
        }
        ReadAuthorizationCodeGrantDetails other = (ReadAuthorizationCodeGrantDetails) obj;
        return Objects.equals(clientId(), other.clientId()) && Objects.equals(tokenEndpoint(), other.tokenEndpoint())
                && Objects.equals(authorizationEndpoint(), other.authorizationEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReadAuthorizationCodeGrantDetails").add("ClientId", clientId())
                .add("TokenEndpoint", tokenEndpoint()).add("AuthorizationEndpoint", authorizationEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "TokenEndpoint":
            return Optional.ofNullable(clazz.cast(tokenEndpoint()));
        case "AuthorizationEndpoint":
            return Optional.ofNullable(clazz.cast(authorizationEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientId", CLIENT_ID_FIELD);
        map.put("TokenEndpoint", TOKEN_ENDPOINT_FIELD);
        map.put("AuthorizationEndpoint", AUTHORIZATION_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReadAuthorizationCodeGrantDetails, T> g) {
        return obj -> g.apply((ReadAuthorizationCodeGrantDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReadAuthorizationCodeGrantDetails> {
        /**
         * <p>
         * The client identifier for the OAuth2 authorization code grant flow.
         * </p>
         * 
         * @param clientId
         *        The client identifier for the OAuth2 authorization code grant flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The authorization server endpoint used to obtain access tokens via the authorization code grant flow.
         * </p>
         * 
         * @param tokenEndpoint
         *        The authorization server endpoint used to obtain access tokens via the authorization code grant flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenEndpoint(String tokenEndpoint);

        /**
         * <p>
         * The authorization server endpoint used to obtain authorization codes from the resource owner.
         * </p>
         * 
         * @param authorizationEndpoint
         *        The authorization server endpoint used to obtain authorization codes from the resource owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationEndpoint(String authorizationEndpoint);
    }

    static final class BuilderImpl implements Builder {
        private String clientId;

        private String tokenEndpoint;

        private String authorizationEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(ReadAuthorizationCodeGrantDetails model) {
            clientId(model.clientId);
            tokenEndpoint(model.tokenEndpoint);
            authorizationEndpoint(model.authorizationEndpoint);
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getTokenEndpoint() {
            return tokenEndpoint;
        }

        public final void setTokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
        }

        @Override
        public final Builder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public final String getAuthorizationEndpoint() {
            return authorizationEndpoint;
        }

        public final void setAuthorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
        }

        @Override
        public final Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        @Override
        public ReadAuthorizationCodeGrantDetails build() {
            return new ReadAuthorizationCodeGrantDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
