/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Read-only details for OAuth2 client credentials, containing non-sensitive configuration information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReadClientCredentialsDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ReadClientCredentialsDetails.Builder, ReadClientCredentialsDetails> {
    private static final SdkField<ReadClientCredentialsGrantDetails> READ_CLIENT_CREDENTIALS_GRANT_DETAILS_FIELD = SdkField
            .<ReadClientCredentialsGrantDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ReadClientCredentialsGrantDetails")
            .getter(getter(ReadClientCredentialsDetails::readClientCredentialsGrantDetails))
            .setter(setter(Builder::readClientCredentialsGrantDetails))
            .constructor(ReadClientCredentialsGrantDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadClientCredentialsGrantDetails")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(READ_CLIENT_CREDENTIALS_GRANT_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ReadClientCredentialsGrantDetails readClientCredentialsGrantDetails;

    private final Type type;

    private ReadClientCredentialsDetails(BuilderImpl builder) {
        this.readClientCredentialsGrantDetails = builder.readClientCredentialsGrantDetails;
        this.type = builder.type;
    }

    /**
     * <p>
     * The read-only client credentials grant configuration details.
     * </p>
     * 
     * @return The read-only client credentials grant configuration details.
     */
    public final ReadClientCredentialsGrantDetails readClientCredentialsGrantDetails() {
        return readClientCredentialsGrantDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(readClientCredentialsGrantDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReadClientCredentialsDetails)) {
            return false;
        }
        ReadClientCredentialsDetails other = (ReadClientCredentialsDetails) obj;
        return Objects.equals(readClientCredentialsGrantDetails(), other.readClientCredentialsGrantDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReadClientCredentialsDetails")
                .add("ReadClientCredentialsGrantDetails", readClientCredentialsGrantDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReadClientCredentialsGrantDetails":
            return Optional.ofNullable(clazz.cast(readClientCredentialsGrantDetails()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #readClientCredentialsGrantDetails()} initialized to the given
     * value.
     *
     * <p>
     * The read-only client credentials grant configuration details.
     * </p>
     * 
     * @param readClientCredentialsGrantDetails
     *        The read-only client credentials grant configuration details.
     */
    public static ReadClientCredentialsDetails fromReadClientCredentialsGrantDetails(
            ReadClientCredentialsGrantDetails readClientCredentialsGrantDetails) {
        return builder().readClientCredentialsGrantDetails(readClientCredentialsGrantDetails).build();
    }

    /**
     * Create an instance of this class with {@link #readClientCredentialsGrantDetails()} initialized to the given
     * value.
     *
     * <p>
     * The read-only client credentials grant configuration details.
     * </p>
     * 
     * @param readClientCredentialsGrantDetails
     *        The read-only client credentials grant configuration details.
     */
    public static ReadClientCredentialsDetails fromReadClientCredentialsGrantDetails(
            Consumer<ReadClientCredentialsGrantDetails.Builder> readClientCredentialsGrantDetails) {
        ReadClientCredentialsGrantDetails.Builder builder = ReadClientCredentialsGrantDetails.builder();
        readClientCredentialsGrantDetails.accept(builder);
        return fromReadClientCredentialsGrantDetails(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReadClientCredentialsGrantDetails", READ_CLIENT_CREDENTIALS_GRANT_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReadClientCredentialsDetails, T> g) {
        return obj -> g.apply((ReadClientCredentialsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReadClientCredentialsDetails> {
        /**
         * <p>
         * The read-only client credentials grant configuration details.
         * </p>
         * 
         * @param readClientCredentialsGrantDetails
         *        The read-only client credentials grant configuration details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readClientCredentialsGrantDetails(ReadClientCredentialsGrantDetails readClientCredentialsGrantDetails);

        /**
         * <p>
         * The read-only client credentials grant configuration details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ReadClientCredentialsGrantDetails.Builder} avoiding the need to create one manually via
         * {@link ReadClientCredentialsGrantDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReadClientCredentialsGrantDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #readClientCredentialsGrantDetails(ReadClientCredentialsGrantDetails)}.
         * 
         * @param readClientCredentialsGrantDetails
         *        a consumer that will call methods on {@link ReadClientCredentialsGrantDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #readClientCredentialsGrantDetails(ReadClientCredentialsGrantDetails)
         */
        default Builder readClientCredentialsGrantDetails(
                Consumer<ReadClientCredentialsGrantDetails.Builder> readClientCredentialsGrantDetails) {
            return readClientCredentialsGrantDetails(ReadClientCredentialsGrantDetails.builder()
                    .applyMutation(readClientCredentialsGrantDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ReadClientCredentialsGrantDetails readClientCredentialsGrantDetails;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ReadClientCredentialsDetails model) {
            readClientCredentialsGrantDetails(model.readClientCredentialsGrantDetails);
        }

        public final ReadClientCredentialsGrantDetails.Builder getReadClientCredentialsGrantDetails() {
            return readClientCredentialsGrantDetails != null ? readClientCredentialsGrantDetails.toBuilder() : null;
        }

        public final void setReadClientCredentialsGrantDetails(
                ReadClientCredentialsGrantDetails.BuilderImpl readClientCredentialsGrantDetails) {
            Object oldValue = this.readClientCredentialsGrantDetails;
            this.readClientCredentialsGrantDetails = readClientCredentialsGrantDetails != null ? readClientCredentialsGrantDetails
                    .build() : null;
            handleUnionValueChange(Type.READ_CLIENT_CREDENTIALS_GRANT_DETAILS, oldValue, this.readClientCredentialsGrantDetails);
        }

        @Override
        public final Builder readClientCredentialsGrantDetails(ReadClientCredentialsGrantDetails readClientCredentialsGrantDetails) {
            Object oldValue = this.readClientCredentialsGrantDetails;
            this.readClientCredentialsGrantDetails = readClientCredentialsGrantDetails;
            handleUnionValueChange(Type.READ_CLIENT_CREDENTIALS_GRANT_DETAILS, oldValue, this.readClientCredentialsGrantDetails);
            return this;
        }

        @Override
        public ReadClientCredentialsDetails build() {
            return new ReadClientCredentialsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ReadClientCredentialsDetails#type()
     */
    public enum Type {
        READ_CLIENT_CREDENTIALS_GRANT_DETAILS,

        UNKNOWN_TO_SDK_VERSION
    }
}
