/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Read-only metadata for OAuth2 client credentials grant authentication configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReadClientCredentialsGrantMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ReadClientCredentialsGrantMetadata.Builder, ReadClientCredentialsGrantMetadata> {
    private static final SdkField<String> BASE_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseEndpoint").getter(getter(ReadClientCredentialsGrantMetadata::baseEndpoint))
            .setter(setter(Builder::baseEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseEndpoint").build()).build();

    private static final SdkField<ReadClientCredentialsDetails> READ_CLIENT_CREDENTIALS_DETAILS_FIELD = SdkField
            .<ReadClientCredentialsDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ReadClientCredentialsDetails")
            .getter(getter(ReadClientCredentialsGrantMetadata::readClientCredentialsDetails))
            .setter(setter(Builder::readClientCredentialsDetails))
            .constructor(ReadClientCredentialsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadClientCredentialsDetails")
                    .build()).build();

    private static final SdkField<String> CLIENT_CREDENTIALS_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientCredentialsSource")
            .getter(getter(ReadClientCredentialsGrantMetadata::clientCredentialsSourceAsString))
            .setter(setter(Builder::clientCredentialsSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCredentialsSource").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_ENDPOINT_FIELD,
            READ_CLIENT_CREDENTIALS_DETAILS_FIELD, CLIENT_CREDENTIALS_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String baseEndpoint;

    private final ReadClientCredentialsDetails readClientCredentialsDetails;

    private final String clientCredentialsSource;

    private ReadClientCredentialsGrantMetadata(BuilderImpl builder) {
        this.baseEndpoint = builder.baseEndpoint;
        this.readClientCredentialsDetails = builder.readClientCredentialsDetails;
        this.clientCredentialsSource = builder.clientCredentialsSource;
    }

    /**
     * <p>
     * The base endpoint URL for the OAuth2 client credentials grant flow.
     * </p>
     * 
     * @return The base endpoint URL for the OAuth2 client credentials grant flow.
     */
    public final String baseEndpoint() {
        return baseEndpoint;
    }

    /**
     * <p>
     * The read-only client credentials configuration details.
     * </p>
     * 
     * @return The read-only client credentials configuration details.
     */
    public final ReadClientCredentialsDetails readClientCredentialsDetails() {
        return readClientCredentialsDetails;
    }

    /**
     * <p>
     * The source of client credentials for the OAuth2 client credentials grant flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #clientCredentialsSource} will return {@link ClientCredentialsSource#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #clientCredentialsSourceAsString}.
     * </p>
     * 
     * @return The source of client credentials for the OAuth2 client credentials grant flow.
     * @see ClientCredentialsSource
     */
    public final ClientCredentialsSource clientCredentialsSource() {
        return ClientCredentialsSource.fromValue(clientCredentialsSource);
    }

    /**
     * <p>
     * The source of client credentials for the OAuth2 client credentials grant flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #clientCredentialsSource} will return {@link ClientCredentialsSource#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #clientCredentialsSourceAsString}.
     * </p>
     * 
     * @return The source of client credentials for the OAuth2 client credentials grant flow.
     * @see ClientCredentialsSource
     */
    public final String clientCredentialsSourceAsString() {
        return clientCredentialsSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baseEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(readClientCredentialsDetails());
        hashCode = 31 * hashCode + Objects.hashCode(clientCredentialsSourceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReadClientCredentialsGrantMetadata)) {
            return false;
        }
        ReadClientCredentialsGrantMetadata other = (ReadClientCredentialsGrantMetadata) obj;
        return Objects.equals(baseEndpoint(), other.baseEndpoint())
                && Objects.equals(readClientCredentialsDetails(), other.readClientCredentialsDetails())
                && Objects.equals(clientCredentialsSourceAsString(), other.clientCredentialsSourceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReadClientCredentialsGrantMetadata").add("BaseEndpoint", baseEndpoint())
                .add("ReadClientCredentialsDetails", readClientCredentialsDetails())
                .add("ClientCredentialsSource", clientCredentialsSourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaseEndpoint":
            return Optional.ofNullable(clazz.cast(baseEndpoint()));
        case "ReadClientCredentialsDetails":
            return Optional.ofNullable(clazz.cast(readClientCredentialsDetails()));
        case "ClientCredentialsSource":
            return Optional.ofNullable(clazz.cast(clientCredentialsSourceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BaseEndpoint", BASE_ENDPOINT_FIELD);
        map.put("ReadClientCredentialsDetails", READ_CLIENT_CREDENTIALS_DETAILS_FIELD);
        map.put("ClientCredentialsSource", CLIENT_CREDENTIALS_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReadClientCredentialsGrantMetadata, T> g) {
        return obj -> g.apply((ReadClientCredentialsGrantMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReadClientCredentialsGrantMetadata> {
        /**
         * <p>
         * The base endpoint URL for the OAuth2 client credentials grant flow.
         * </p>
         * 
         * @param baseEndpoint
         *        The base endpoint URL for the OAuth2 client credentials grant flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseEndpoint(String baseEndpoint);

        /**
         * <p>
         * The read-only client credentials configuration details.
         * </p>
         * 
         * @param readClientCredentialsDetails
         *        The read-only client credentials configuration details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readClientCredentialsDetails(ReadClientCredentialsDetails readClientCredentialsDetails);

        /**
         * <p>
         * The read-only client credentials configuration details.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReadClientCredentialsDetails.Builder}
         * avoiding the need to create one manually via {@link ReadClientCredentialsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReadClientCredentialsDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #readClientCredentialsDetails(ReadClientCredentialsDetails)}.
         * 
         * @param readClientCredentialsDetails
         *        a consumer that will call methods on {@link ReadClientCredentialsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #readClientCredentialsDetails(ReadClientCredentialsDetails)
         */
        default Builder readClientCredentialsDetails(Consumer<ReadClientCredentialsDetails.Builder> readClientCredentialsDetails) {
            return readClientCredentialsDetails(ReadClientCredentialsDetails.builder()
                    .applyMutation(readClientCredentialsDetails).build());
        }

        /**
         * <p>
         * The source of client credentials for the OAuth2 client credentials grant flow.
         * </p>
         * 
         * @param clientCredentialsSource
         *        The source of client credentials for the OAuth2 client credentials grant flow.
         * @see ClientCredentialsSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientCredentialsSource
         */
        Builder clientCredentialsSource(String clientCredentialsSource);

        /**
         * <p>
         * The source of client credentials for the OAuth2 client credentials grant flow.
         * </p>
         * 
         * @param clientCredentialsSource
         *        The source of client credentials for the OAuth2 client credentials grant flow.
         * @see ClientCredentialsSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientCredentialsSource
         */
        Builder clientCredentialsSource(ClientCredentialsSource clientCredentialsSource);
    }

    static final class BuilderImpl implements Builder {
        private String baseEndpoint;

        private ReadClientCredentialsDetails readClientCredentialsDetails;

        private String clientCredentialsSource;

        private BuilderImpl() {
        }

        private BuilderImpl(ReadClientCredentialsGrantMetadata model) {
            baseEndpoint(model.baseEndpoint);
            readClientCredentialsDetails(model.readClientCredentialsDetails);
            clientCredentialsSource(model.clientCredentialsSource);
        }

        public final String getBaseEndpoint() {
            return baseEndpoint;
        }

        public final void setBaseEndpoint(String baseEndpoint) {
            this.baseEndpoint = baseEndpoint;
        }

        @Override
        public final Builder baseEndpoint(String baseEndpoint) {
            this.baseEndpoint = baseEndpoint;
            return this;
        }

        public final ReadClientCredentialsDetails.Builder getReadClientCredentialsDetails() {
            return readClientCredentialsDetails != null ? readClientCredentialsDetails.toBuilder() : null;
        }

        public final void setReadClientCredentialsDetails(ReadClientCredentialsDetails.BuilderImpl readClientCredentialsDetails) {
            this.readClientCredentialsDetails = readClientCredentialsDetails != null ? readClientCredentialsDetails.build()
                    : null;
        }

        @Override
        public final Builder readClientCredentialsDetails(ReadClientCredentialsDetails readClientCredentialsDetails) {
            this.readClientCredentialsDetails = readClientCredentialsDetails;
            return this;
        }

        public final String getClientCredentialsSource() {
            return clientCredentialsSource;
        }

        public final void setClientCredentialsSource(String clientCredentialsSource) {
            this.clientCredentialsSource = clientCredentialsSource;
        }

        @Override
        public final Builder clientCredentialsSource(String clientCredentialsSource) {
            this.clientCredentialsSource = clientCredentialsSource;
            return this;
        }

        @Override
        public final Builder clientCredentialsSource(ClientCredentialsSource clientCredentialsSource) {
            this.clientCredentialsSource(clientCredentialsSource == null ? null : clientCredentialsSource.toString());
            return this;
        }

        @Override
        public ReadClientCredentialsGrantMetadata build() {
            return new ReadClientCredentialsGrantMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
