/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Permission for the resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourcePermission implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourcePermission.Builder, ResourcePermission> {
    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Principal").getter(getter(ResourcePermission::principal)).setter(setter(Builder::principal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal").build()).build();

    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Actions")
            .getter(getter(ResourcePermission::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PRINCIPAL_FIELD, ACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String principal;

    private final List<String> actions;

    private ResourcePermission(BuilderImpl builder) {
        this.principal = builder.principal;
        this.actions = builder.actions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the principal. This can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The ARN of an Quick Sight user or group associated with a data source or dataset. (This is common.)
     * </p>
     * </li>
     * <li>
     * <p>
     * The ARN of an Quick Sight user, group, or namespace associated with an analysis, dashboard, template, or theme.
     * Namespace sharing is not supported for action connectors. (This is common.)
     * </p>
     * </li>
     * <li>
     * <p>
     * The ARN of an Amazon Web Services account root: This is an IAM ARN rather than a Quick Sight ARN. Use this option
     * only to share resources (templates) across Amazon Web Services accounts. Account root sharing is not supported
     * for action connectors. (This is less common.)
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) of the principal. This can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The ARN of an Quick Sight user or group associated with a data source or dataset. (This is common.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The ARN of an Quick Sight user, group, or namespace associated with an analysis, dashboard, template, or
     *         theme. Namespace sharing is not supported for action connectors. (This is common.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The ARN of an Amazon Web Services account root: This is an IAM ARN rather than a Quick Sight ARN. Use
     *         this option only to share resources (templates) across Amazon Web Services accounts. Account root sharing
     *         is not supported for action connectors. (This is less common.)
     *         </p>
     *         </li>
     */
    public final String principal() {
        return principal;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IAM action to grant or revoke permissions on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The IAM action to grant or revoke permissions on.
     */
    public final List<String> actions() {
        return actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePermission)) {
            return false;
        }
        ResourcePermission other = (ResourcePermission) obj;
        return Objects.equals(principal(), other.principal()) && hasActions() == other.hasActions()
                && Objects.equals(actions(), other.actions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourcePermission").add("Principal", principal())
                .add("Actions", hasActions() ? actions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Principal", PRINCIPAL_FIELD);
        map.put("Actions", ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourcePermission, T> g) {
        return obj -> g.apply((ResourcePermission) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourcePermission> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the principal. This can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The ARN of an Quick Sight user or group associated with a data source or dataset. (This is common.)
         * </p>
         * </li>
         * <li>
         * <p>
         * The ARN of an Quick Sight user, group, or namespace associated with an analysis, dashboard, template, or
         * theme. Namespace sharing is not supported for action connectors. (This is common.)
         * </p>
         * </li>
         * <li>
         * <p>
         * The ARN of an Amazon Web Services account root: This is an IAM ARN rather than a Quick Sight ARN. Use this
         * option only to share resources (templates) across Amazon Web Services accounts. Account root sharing is not
         * supported for action connectors. (This is less common.)
         * </p>
         * </li>
         * </ul>
         * 
         * @param principal
         *        The Amazon Resource Name (ARN) of the principal. This can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The ARN of an Quick Sight user or group associated with a data source or dataset. (This is common.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The ARN of an Quick Sight user, group, or namespace associated with an analysis, dashboard, template,
         *        or theme. Namespace sharing is not supported for action connectors. (This is common.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The ARN of an Amazon Web Services account root: This is an IAM ARN rather than a Quick Sight ARN. Use
         *        this option only to share resources (templates) across Amazon Web Services accounts. Account root
         *        sharing is not supported for action connectors. (This is less common.)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String principal);

        /**
         * <p>
         * The IAM action to grant or revoke permissions on.
         * </p>
         * 
         * @param actions
         *        The IAM action to grant or revoke permissions on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<String> actions);

        /**
         * <p>
         * The IAM action to grant or revoke permissions on.
         * </p>
         * 
         * @param actions
         *        The IAM action to grant or revoke permissions on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(String... actions);
    }

    static final class BuilderImpl implements Builder {
        private String principal;

        private List<String> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcePermission model) {
            principal(model.principal);
            actions(model.actions);
        }

        public final String getPrincipal() {
            return principal;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final Collection<String> getActions() {
            if (actions instanceof SdkAutoConstructList) {
                return null;
            }
            return actions;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = ActionListCopier.copy(actions);
        }

        @Override
        public final Builder actions(Collection<String> actions) {
            this.actions = ActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(String... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        public ResourcePermission build() {
            return new ResourcePermission(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
