/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for row level security.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RowLevelPermissionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RowLevelPermissionConfiguration.Builder, RowLevelPermissionConfiguration> {
    private static final SdkField<RowLevelPermissionTagConfiguration> TAG_CONFIGURATION_FIELD = SdkField
            .<RowLevelPermissionTagConfiguration> builder(MarshallingType.SDK_POJO).memberName("TagConfiguration")
            .getter(getter(RowLevelPermissionConfiguration::tagConfiguration)).setter(setter(Builder::tagConfiguration))
            .constructor(RowLevelPermissionTagConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagConfiguration").build()).build();

    private static final SdkField<RowLevelPermissionDataSet> ROW_LEVEL_PERMISSION_DATA_SET_FIELD = SdkField
            .<RowLevelPermissionDataSet> builder(MarshallingType.SDK_POJO).memberName("RowLevelPermissionDataSet")
            .getter(getter(RowLevelPermissionConfiguration::rowLevelPermissionDataSet))
            .setter(setter(Builder::rowLevelPermissionDataSet)).constructor(RowLevelPermissionDataSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowLevelPermissionDataSet").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_CONFIGURATION_FIELD,
            ROW_LEVEL_PERMISSION_DATA_SET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RowLevelPermissionTagConfiguration tagConfiguration;

    private final RowLevelPermissionDataSet rowLevelPermissionDataSet;

    private RowLevelPermissionConfiguration(BuilderImpl builder) {
        this.tagConfiguration = builder.tagConfiguration;
        this.rowLevelPermissionDataSet = builder.rowLevelPermissionDataSet;
    }

    /**
     * Returns the value of the TagConfiguration property for this object.
     * 
     * @return The value of the TagConfiguration property for this object.
     */
    public final RowLevelPermissionTagConfiguration tagConfiguration() {
        return tagConfiguration;
    }

    /**
     * Returns the value of the RowLevelPermissionDataSet property for this object.
     * 
     * @return The value of the RowLevelPermissionDataSet property for this object.
     */
    public final RowLevelPermissionDataSet rowLevelPermissionDataSet() {
        return rowLevelPermissionDataSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tagConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(rowLevelPermissionDataSet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RowLevelPermissionConfiguration)) {
            return false;
        }
        RowLevelPermissionConfiguration other = (RowLevelPermissionConfiguration) obj;
        return Objects.equals(tagConfiguration(), other.tagConfiguration())
                && Objects.equals(rowLevelPermissionDataSet(), other.rowLevelPermissionDataSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RowLevelPermissionConfiguration").add("TagConfiguration", tagConfiguration())
                .add("RowLevelPermissionDataSet", rowLevelPermissionDataSet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TagConfiguration":
            return Optional.ofNullable(clazz.cast(tagConfiguration()));
        case "RowLevelPermissionDataSet":
            return Optional.ofNullable(clazz.cast(rowLevelPermissionDataSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TagConfiguration", TAG_CONFIGURATION_FIELD);
        map.put("RowLevelPermissionDataSet", ROW_LEVEL_PERMISSION_DATA_SET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RowLevelPermissionConfiguration, T> g) {
        return obj -> g.apply((RowLevelPermissionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RowLevelPermissionConfiguration> {
        /**
         * Sets the value of the TagConfiguration property for this object.
         *
         * @param tagConfiguration
         *        The new value for the TagConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagConfiguration(RowLevelPermissionTagConfiguration tagConfiguration);

        /**
         * Sets the value of the TagConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link RowLevelPermissionTagConfiguration.Builder} avoiding the need to create one manually via
         * {@link RowLevelPermissionTagConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RowLevelPermissionTagConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #tagConfiguration(RowLevelPermissionTagConfiguration)}.
         * 
         * @param tagConfiguration
         *        a consumer that will call methods on {@link RowLevelPermissionTagConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagConfiguration(RowLevelPermissionTagConfiguration)
         */
        default Builder tagConfiguration(Consumer<RowLevelPermissionTagConfiguration.Builder> tagConfiguration) {
            return tagConfiguration(RowLevelPermissionTagConfiguration.builder().applyMutation(tagConfiguration).build());
        }

        /**
         * Sets the value of the RowLevelPermissionDataSet property for this object.
         *
         * @param rowLevelPermissionDataSet
         *        The new value for the RowLevelPermissionDataSet property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowLevelPermissionDataSet(RowLevelPermissionDataSet rowLevelPermissionDataSet);

        /**
         * Sets the value of the RowLevelPermissionDataSet property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RowLevelPermissionDataSet.Builder}
         * avoiding the need to create one manually via {@link RowLevelPermissionDataSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RowLevelPermissionDataSet.Builder#build()} is called immediately
         * and its result is passed to {@link #rowLevelPermissionDataSet(RowLevelPermissionDataSet)}.
         * 
         * @param rowLevelPermissionDataSet
         *        a consumer that will call methods on {@link RowLevelPermissionDataSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowLevelPermissionDataSet(RowLevelPermissionDataSet)
         */
        default Builder rowLevelPermissionDataSet(Consumer<RowLevelPermissionDataSet.Builder> rowLevelPermissionDataSet) {
            return rowLevelPermissionDataSet(RowLevelPermissionDataSet.builder().applyMutation(rowLevelPermissionDataSet).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RowLevelPermissionTagConfiguration tagConfiguration;

        private RowLevelPermissionDataSet rowLevelPermissionDataSet;

        private BuilderImpl() {
        }

        private BuilderImpl(RowLevelPermissionConfiguration model) {
            tagConfiguration(model.tagConfiguration);
            rowLevelPermissionDataSet(model.rowLevelPermissionDataSet);
        }

        public final RowLevelPermissionTagConfiguration.Builder getTagConfiguration() {
            return tagConfiguration != null ? tagConfiguration.toBuilder() : null;
        }

        public final void setTagConfiguration(RowLevelPermissionTagConfiguration.BuilderImpl tagConfiguration) {
            this.tagConfiguration = tagConfiguration != null ? tagConfiguration.build() : null;
        }

        @Override
        public final Builder tagConfiguration(RowLevelPermissionTagConfiguration tagConfiguration) {
            this.tagConfiguration = tagConfiguration;
            return this;
        }

        public final RowLevelPermissionDataSet.Builder getRowLevelPermissionDataSet() {
            return rowLevelPermissionDataSet != null ? rowLevelPermissionDataSet.toBuilder() : null;
        }

        public final void setRowLevelPermissionDataSet(RowLevelPermissionDataSet.BuilderImpl rowLevelPermissionDataSet) {
            this.rowLevelPermissionDataSet = rowLevelPermissionDataSet != null ? rowLevelPermissionDataSet.build() : null;
        }

        @Override
        public final Builder rowLevelPermissionDataSet(RowLevelPermissionDataSet rowLevelPermissionDataSet) {
            this.rowLevelPermissionDataSet = rowLevelPermissionDataSet;
            return this;
        }

        @Override
        public RowLevelPermissionConfiguration build() {
            return new RowLevelPermissionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
