/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class RowLevelPermissionDataSetMapCopier {
    static Map<String, RowLevelPermissionDataSet> copy(
            Map<String, ? extends RowLevelPermissionDataSet> rowLevelPermissionDataSetMapParam) {
        Map<String, RowLevelPermissionDataSet> map;
        if (rowLevelPermissionDataSetMapParam == null || rowLevelPermissionDataSetMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, RowLevelPermissionDataSet> modifiableMap = new LinkedHashMap<>(rowLevelPermissionDataSetMapParam.size());
            rowLevelPermissionDataSetMapParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, RowLevelPermissionDataSet> copyFromBuilder(
            Map<String, ? extends RowLevelPermissionDataSet.Builder> rowLevelPermissionDataSetMapParam) {
        Map<String, RowLevelPermissionDataSet> map;
        if (rowLevelPermissionDataSetMapParam == null || rowLevelPermissionDataSetMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, RowLevelPermissionDataSet> modifiableMap = new LinkedHashMap<>(rowLevelPermissionDataSetMapParam.size());
            rowLevelPermissionDataSetMapParam.forEach((key, value) -> {
                RowLevelPermissionDataSet member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, RowLevelPermissionDataSet.Builder> copyToBuilder(
            Map<String, ? extends RowLevelPermissionDataSet> rowLevelPermissionDataSetMapParam) {
        Map<String, RowLevelPermissionDataSet.Builder> map;
        if (rowLevelPermissionDataSetMapParam == null || rowLevelPermissionDataSetMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, RowLevelPermissionDataSet.Builder> modifiableMap = new LinkedHashMap<>(
                    rowLevelPermissionDataSetMapParam.size());
            rowLevelPermissionDataSetMapParam.forEach((key, value) -> {
                RowLevelPermissionDataSet.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
