/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Parameters implements SdkPojo, Serializable, ToCopyableBuilder<S3Parameters.Builder, S3Parameters> {
    private static final SdkField<ManifestFileLocation> MANIFEST_FILE_LOCATION_FIELD = SdkField
            .<ManifestFileLocation> builder(MarshallingType.SDK_POJO).memberName("ManifestFileLocation")
            .getter(getter(S3Parameters::manifestFileLocation)).setter(setter(Builder::manifestFileLocation))
            .constructor(ManifestFileLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestFileLocation").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(S3Parameters::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFEST_FILE_LOCATION_FIELD,
            ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ManifestFileLocation manifestFileLocation;

    private final String roleArn;

    private S3Parameters(BuilderImpl builder) {
        this.manifestFileLocation = builder.manifestFileLocation;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * Location of the Amazon S3 manifest file. This is NULL if the manifest file was uploaded into Quick Sight.
     * </p>
     * 
     * @return Location of the Amazon S3 manifest file. This is NULL if the manifest file was uploaded into Quick Sight.
     */
    public final ManifestFileLocation manifestFileLocation() {
        return manifestFileLocation;
    }

    /**
     * <p>
     * Use the <code>RoleArn</code> structure to override an account-wide role for a specific S3 data source. For
     * example, say an account administrator has turned off all S3 access with an account-wide role. The administrator
     * can then use <code>RoleArn</code> to bypass the account-wide role and allow S3 access for the single S3 data
     * source that is specified in the structure, even if the account-wide role forbidding S3 access is still active.
     * </p>
     * 
     * @return Use the <code>RoleArn</code> structure to override an account-wide role for a specific S3 data source.
     *         For example, say an account administrator has turned off all S3 access with an account-wide role. The
     *         administrator can then use <code>RoleArn</code> to bypass the account-wide role and allow S3 access for
     *         the single S3 data source that is specified in the structure, even if the account-wide role forbidding S3
     *         access is still active.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(manifestFileLocation());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Parameters)) {
            return false;
        }
        S3Parameters other = (S3Parameters) obj;
        return Objects.equals(manifestFileLocation(), other.manifestFileLocation()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Parameters").add("ManifestFileLocation", manifestFileLocation()).add("RoleArn", roleArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManifestFileLocation":
            return Optional.ofNullable(clazz.cast(manifestFileLocation()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ManifestFileLocation", MANIFEST_FILE_LOCATION_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3Parameters, T> g) {
        return obj -> g.apply((S3Parameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Parameters> {
        /**
         * <p>
         * Location of the Amazon S3 manifest file. This is NULL if the manifest file was uploaded into Quick Sight.
         * </p>
         * 
         * @param manifestFileLocation
         *        Location of the Amazon S3 manifest file. This is NULL if the manifest file was uploaded into Quick
         *        Sight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestFileLocation(ManifestFileLocation manifestFileLocation);

        /**
         * <p>
         * Location of the Amazon S3 manifest file. This is NULL if the manifest file was uploaded into Quick Sight.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManifestFileLocation.Builder} avoiding
         * the need to create one manually via {@link ManifestFileLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManifestFileLocation.Builder#build()} is called immediately and
         * its result is passed to {@link #manifestFileLocation(ManifestFileLocation)}.
         * 
         * @param manifestFileLocation
         *        a consumer that will call methods on {@link ManifestFileLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #manifestFileLocation(ManifestFileLocation)
         */
        default Builder manifestFileLocation(Consumer<ManifestFileLocation.Builder> manifestFileLocation) {
            return manifestFileLocation(ManifestFileLocation.builder().applyMutation(manifestFileLocation).build());
        }

        /**
         * <p>
         * Use the <code>RoleArn</code> structure to override an account-wide role for a specific S3 data source. For
         * example, say an account administrator has turned off all S3 access with an account-wide role. The
         * administrator can then use <code>RoleArn</code> to bypass the account-wide role and allow S3 access for the
         * single S3 data source that is specified in the structure, even if the account-wide role forbidding S3 access
         * is still active.
         * </p>
         * 
         * @param roleArn
         *        Use the <code>RoleArn</code> structure to override an account-wide role for a specific S3 data source.
         *        For example, say an account administrator has turned off all S3 access with an account-wide role. The
         *        administrator can then use <code>RoleArn</code> to bypass the account-wide role and allow S3 access
         *        for the single S3 data source that is specified in the structure, even if the account-wide role
         *        forbidding S3 access is still active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private ManifestFileLocation manifestFileLocation;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Parameters model) {
            manifestFileLocation(model.manifestFileLocation);
            roleArn(model.roleArn);
        }

        public final ManifestFileLocation.Builder getManifestFileLocation() {
            return manifestFileLocation != null ? manifestFileLocation.toBuilder() : null;
        }

        public final void setManifestFileLocation(ManifestFileLocation.BuilderImpl manifestFileLocation) {
            this.manifestFileLocation = manifestFileLocation != null ? manifestFileLocation.build() : null;
        }

        @Override
        public final Builder manifestFileLocation(ManifestFileLocation manifestFileLocation) {
            this.manifestFileLocation = manifestFileLocation;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public S3Parameters build() {
            return new S3Parameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
