/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A table from a Software-as-a-Service (SaaS) data source, including connection details and column definitions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SaaSTable implements SdkPojo, Serializable, ToCopyableBuilder<SaaSTable.Builder, SaaSTable> {
    private static final SdkField<String> DATA_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceArn").getter(getter(SaaSTable::dataSourceArn)).setter(setter(Builder::dataSourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceArn").build()).build();

    private static final SdkField<List<TablePathElement>> TABLE_PATH_FIELD = SdkField
            .<List<TablePathElement>> builder(MarshallingType.LIST)
            .memberName("TablePath")
            .getter(getter(SaaSTable::tablePath))
            .setter(setter(Builder::tablePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablePath").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TablePathElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(TablePathElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<InputColumn>> INPUT_COLUMNS_FIELD = SdkField
            .<List<InputColumn>> builder(MarshallingType.LIST)
            .memberName("InputColumns")
            .getter(getter(SaaSTable::inputColumns))
            .setter(setter(Builder::inputColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputColumn> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputColumn::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ARN_FIELD,
            TABLE_PATH_FIELD, INPUT_COLUMNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataSourceArn;

    private final List<TablePathElement> tablePath;

    private final List<InputColumn> inputColumns;

    private SaaSTable(BuilderImpl builder) {
        this.dataSourceArn = builder.dataSourceArn;
        this.tablePath = builder.tablePath;
        this.inputColumns = builder.inputColumns;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SaaS data source.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SaaS data source.
     */
    public final String dataSourceArn() {
        return dataSourceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the TablePath property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTablePath() {
        return tablePath != null && !(tablePath instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The hierarchical path to the table within the SaaS data source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTablePath} method.
     * </p>
     * 
     * @return The hierarchical path to the table within the SaaS data source.
     */
    public final List<TablePathElement> tablePath() {
        return tablePath;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputColumns() {
        return inputColumns != null && !(inputColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of input columns available from the SaaS table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputColumns} method.
     * </p>
     * 
     * @return The list of input columns available from the SaaS table.
     */
    public final List<InputColumn> inputColumns() {
        return inputColumns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTablePath() ? tablePath() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInputColumns() ? inputColumns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SaaSTable)) {
            return false;
        }
        SaaSTable other = (SaaSTable) obj;
        return Objects.equals(dataSourceArn(), other.dataSourceArn()) && hasTablePath() == other.hasTablePath()
                && Objects.equals(tablePath(), other.tablePath()) && hasInputColumns() == other.hasInputColumns()
                && Objects.equals(inputColumns(), other.inputColumns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SaaSTable").add("DataSourceArn", dataSourceArn())
                .add("TablePath", hasTablePath() ? tablePath() : null)
                .add("InputColumns", hasInputColumns() ? inputColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceArn":
            return Optional.ofNullable(clazz.cast(dataSourceArn()));
        case "TablePath":
            return Optional.ofNullable(clazz.cast(tablePath()));
        case "InputColumns":
            return Optional.ofNullable(clazz.cast(inputColumns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataSourceArn", DATA_SOURCE_ARN_FIELD);
        map.put("TablePath", TABLE_PATH_FIELD);
        map.put("InputColumns", INPUT_COLUMNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SaaSTable, T> g) {
        return obj -> g.apply((SaaSTable) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SaaSTable> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the SaaS data source.
         * </p>
         * 
         * @param dataSourceArn
         *        The Amazon Resource Name (ARN) of the SaaS data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceArn(String dataSourceArn);

        /**
         * <p>
         * The hierarchical path to the table within the SaaS data source.
         * </p>
         * 
         * @param tablePath
         *        The hierarchical path to the table within the SaaS data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablePath(Collection<TablePathElement> tablePath);

        /**
         * <p>
         * The hierarchical path to the table within the SaaS data source.
         * </p>
         * 
         * @param tablePath
         *        The hierarchical path to the table within the SaaS data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablePath(TablePathElement... tablePath);

        /**
         * <p>
         * The hierarchical path to the table within the SaaS data source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.TablePathElement.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.TablePathElement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.TablePathElement.Builder#build()} is called
         * immediately and its result is passed to {@link #tablePath(List<TablePathElement>)}.
         * 
         * @param tablePath
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.TablePathElement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tablePath(java.util.Collection<TablePathElement>)
         */
        Builder tablePath(Consumer<TablePathElement.Builder>... tablePath);

        /**
         * <p>
         * The list of input columns available from the SaaS table.
         * </p>
         * 
         * @param inputColumns
         *        The list of input columns available from the SaaS table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputColumns(Collection<InputColumn> inputColumns);

        /**
         * <p>
         * The list of input columns available from the SaaS table.
         * </p>
         * 
         * @param inputColumns
         *        The list of input columns available from the SaaS table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputColumns(InputColumn... inputColumns);

        /**
         * <p>
         * The list of input columns available from the SaaS table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.InputColumn.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.InputColumn#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.InputColumn.Builder#build()} is called immediately
         * and its result is passed to {@link #inputColumns(List<InputColumn>)}.
         * 
         * @param inputColumns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.InputColumn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputColumns(java.util.Collection<InputColumn>)
         */
        Builder inputColumns(Consumer<InputColumn.Builder>... inputColumns);
    }

    static final class BuilderImpl implements Builder {
        private String dataSourceArn;

        private List<TablePathElement> tablePath = DefaultSdkAutoConstructList.getInstance();

        private List<InputColumn> inputColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SaaSTable model) {
            dataSourceArn(model.dataSourceArn);
            tablePath(model.tablePath);
            inputColumns(model.inputColumns);
        }

        public final String getDataSourceArn() {
            return dataSourceArn;
        }

        public final void setDataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
        }

        @Override
        public final Builder dataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
            return this;
        }

        public final List<TablePathElement.Builder> getTablePath() {
            List<TablePathElement.Builder> result = TablePathElementListCopier.copyToBuilder(this.tablePath);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTablePath(Collection<TablePathElement.BuilderImpl> tablePath) {
            this.tablePath = TablePathElementListCopier.copyFromBuilder(tablePath);
        }

        @Override
        public final Builder tablePath(Collection<TablePathElement> tablePath) {
            this.tablePath = TablePathElementListCopier.copy(tablePath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tablePath(TablePathElement... tablePath) {
            tablePath(Arrays.asList(tablePath));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tablePath(Consumer<TablePathElement.Builder>... tablePath) {
            tablePath(Stream.of(tablePath).map(c -> TablePathElement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<InputColumn.Builder> getInputColumns() {
            List<InputColumn.Builder> result = InputColumnListCopier.copyToBuilder(this.inputColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputColumns(Collection<InputColumn.BuilderImpl> inputColumns) {
            this.inputColumns = InputColumnListCopier.copyFromBuilder(inputColumns);
        }

        @Override
        public final Builder inputColumns(Collection<InputColumn> inputColumns) {
            this.inputColumns = InputColumnListCopier.copy(inputColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputColumns(InputColumn... inputColumns) {
            inputColumns(Arrays.asList(inputColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputColumns(Consumer<InputColumn.Builder>... inputColumns) {
            inputColumns(Stream.of(inputColumns).map(c -> InputColumn.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SaaSTable build() {
            return new SaaSTable(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
