/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The visual display options for a data zoom scroll bar.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScrollBarOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<ScrollBarOptions.Builder, ScrollBarOptions> {
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(ScrollBarOptions::visibilityAsString)).setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final SdkField<VisibleRangeOptions> VISIBLE_RANGE_FIELD = SdkField
            .<VisibleRangeOptions> builder(MarshallingType.SDK_POJO).memberName("VisibleRange")
            .getter(getter(ScrollBarOptions::visibleRange)).setter(setter(Builder::visibleRange))
            .constructor(VisibleRangeOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisibleRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISIBILITY_FIELD,
            VISIBLE_RANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String visibility;

    private final VisibleRangeOptions visibleRange;

    private ScrollBarOptions(BuilderImpl builder) {
        this.visibility = builder.visibility;
        this.visibleRange = builder.visibleRange;
    }

    /**
     * <p>
     * The visibility of the data zoom scroll bar.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of the data zoom scroll bar.
     * @see Visibility
     */
    public final Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * The visibility of the data zoom scroll bar.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of the data zoom scroll bar.
     * @see Visibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    /**
     * <p>
     * The visibility range for the data zoom scroll bar.
     * </p>
     * 
     * @return The visibility range for the data zoom scroll bar.
     */
    public final VisibleRangeOptions visibleRange() {
        return visibleRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(visibleRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScrollBarOptions)) {
            return false;
        }
        ScrollBarOptions other = (ScrollBarOptions) obj;
        return Objects.equals(visibilityAsString(), other.visibilityAsString())
                && Objects.equals(visibleRange(), other.visibleRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScrollBarOptions").add("Visibility", visibilityAsString()).add("VisibleRange", visibleRange())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        case "VisibleRange":
            return Optional.ofNullable(clazz.cast(visibleRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Visibility", VISIBILITY_FIELD);
        map.put("VisibleRange", VISIBLE_RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScrollBarOptions, T> g) {
        return obj -> g.apply((ScrollBarOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScrollBarOptions> {
        /**
         * <p>
         * The visibility of the data zoom scroll bar.
         * </p>
         * 
         * @param visibility
         *        The visibility of the data zoom scroll bar.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * The visibility of the data zoom scroll bar.
         * </p>
         * 
         * @param visibility
         *        The visibility of the data zoom scroll bar.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);

        /**
         * <p>
         * The visibility range for the data zoom scroll bar.
         * </p>
         * 
         * @param visibleRange
         *        The visibility range for the data zoom scroll bar.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visibleRange(VisibleRangeOptions visibleRange);

        /**
         * <p>
         * The visibility range for the data zoom scroll bar.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisibleRangeOptions.Builder} avoiding the
         * need to create one manually via {@link VisibleRangeOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisibleRangeOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #visibleRange(VisibleRangeOptions)}.
         * 
         * @param visibleRange
         *        a consumer that will call methods on {@link VisibleRangeOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visibleRange(VisibleRangeOptions)
         */
        default Builder visibleRange(Consumer<VisibleRangeOptions.Builder> visibleRange) {
            return visibleRange(VisibleRangeOptions.builder().applyMutation(visibleRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String visibility;

        private VisibleRangeOptions visibleRange;

        private BuilderImpl() {
        }

        private BuilderImpl(ScrollBarOptions model) {
            visibility(model.visibility);
            visibleRange(model.visibleRange);
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final VisibleRangeOptions.Builder getVisibleRange() {
            return visibleRange != null ? visibleRange.toBuilder() : null;
        }

        public final void setVisibleRange(VisibleRangeOptions.BuilderImpl visibleRange) {
            this.visibleRange = visibleRange != null ? visibleRange.build() : null;
        }

        @Override
        public final Builder visibleRange(VisibleRangeOptions visibleRange) {
            this.visibleRange = visibleRange;
            return this;
        }

        @Override
        public ScrollBarOptions build() {
            return new ScrollBarOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
