/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchActionConnectorsResponse extends QuickSightResponse implements
        ToCopyableBuilder<SearchActionConnectorsResponse.Builder, SearchActionConnectorsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchActionConnectorsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(SearchActionConnectorsResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(SearchActionConnectorsResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<List<ActionConnectorSummary>> ACTION_CONNECTOR_SUMMARIES_FIELD = SdkField
            .<List<ActionConnectorSummary>> builder(MarshallingType.LIST)
            .memberName("ActionConnectorSummaries")
            .getter(getter(SearchActionConnectorsResponse::actionConnectorSummaries))
            .setter(setter(Builder::actionConnectorSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionConnectorSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActionConnectorSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActionConnectorSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            REQUEST_ID_FIELD, STATUS_FIELD, ACTION_CONNECTOR_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final String requestId;

    private final Integer status;

    private final List<ActionConnectorSummary> actionConnectorSummaries;

    private SearchActionConnectorsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.requestId = builder.requestId;
        this.status = builder.status;
        this.actionConnectorSummaries = builder.actionConnectorSummaries;
    }

    /**
     * <p>
     * A pagination token to retrieve the next set of results. If null, there are no more results to retrieve.
     * </p>
     * 
     * @return A pagination token to retrieve the next set of results. If null, there are no more results to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status code of the request.
     * </p>
     * 
     * @return The HTTP status code of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActionConnectorSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasActionConnectorSummaries() {
        return actionConnectorSummaries != null && !(actionConnectorSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of action connector summaries that match the search criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActionConnectorSummaries} method.
     * </p>
     * 
     * @return A list of action connector summaries that match the search criteria.
     */
    public final List<ActionConnectorSummary> actionConnectorSummaries() {
        return actionConnectorSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasActionConnectorSummaries() ? actionConnectorSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchActionConnectorsResponse)) {
            return false;
        }
        SearchActionConnectorsResponse other = (SearchActionConnectorsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(status(), other.status())
                && hasActionConnectorSummaries() == other.hasActionConnectorSummaries()
                && Objects.equals(actionConnectorSummaries(), other.actionConnectorSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchActionConnectorsResponse").add("NextToken", nextToken()).add("RequestId", requestId())
                .add("Status", status())
                .add("ActionConnectorSummaries", hasActionConnectorSummaries() ? actionConnectorSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "ActionConnectorSummaries":
            return Optional.ofNullable(clazz.cast(actionConnectorSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ActionConnectorSummaries", ACTION_CONNECTOR_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchActionConnectorsResponse, T> g) {
        return obj -> g.apply((SearchActionConnectorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchActionConnectorsResponse> {
        /**
         * <p>
         * A pagination token to retrieve the next set of results. If null, there are no more results to retrieve.
         * </p>
         * 
         * @param nextToken
         *        A pagination token to retrieve the next set of results. If null, there are no more results to
         *        retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status code of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status code of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * A list of action connector summaries that match the search criteria.
         * </p>
         * 
         * @param actionConnectorSummaries
         *        A list of action connector summaries that match the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionConnectorSummaries(Collection<ActionConnectorSummary> actionConnectorSummaries);

        /**
         * <p>
         * A list of action connector summaries that match the search criteria.
         * </p>
         * 
         * @param actionConnectorSummaries
         *        A list of action connector summaries that match the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionConnectorSummaries(ActionConnectorSummary... actionConnectorSummaries);

        /**
         * <p>
         * A list of action connector summaries that match the search criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ActionConnectorSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.ActionConnectorSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ActionConnectorSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #actionConnectorSummaries(List<ActionConnectorSummary>)}.
         * 
         * @param actionConnectorSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ActionConnectorSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionConnectorSummaries(java.util.Collection<ActionConnectorSummary>)
         */
        Builder actionConnectorSummaries(Consumer<ActionConnectorSummary.Builder>... actionConnectorSummaries);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String nextToken;

        private String requestId;

        private Integer status;

        private List<ActionConnectorSummary> actionConnectorSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchActionConnectorsResponse model) {
            super(model);
            nextToken(model.nextToken);
            requestId(model.requestId);
            status(model.status);
            actionConnectorSummaries(model.actionConnectorSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final List<ActionConnectorSummary.Builder> getActionConnectorSummaries() {
            List<ActionConnectorSummary.Builder> result = ActionConnectorSummaryListCopier
                    .copyToBuilder(this.actionConnectorSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionConnectorSummaries(Collection<ActionConnectorSummary.BuilderImpl> actionConnectorSummaries) {
            this.actionConnectorSummaries = ActionConnectorSummaryListCopier.copyFromBuilder(actionConnectorSummaries);
        }

        @Override
        public final Builder actionConnectorSummaries(Collection<ActionConnectorSummary> actionConnectorSummaries) {
            this.actionConnectorSummaries = ActionConnectorSummaryListCopier.copy(actionConnectorSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionConnectorSummaries(ActionConnectorSummary... actionConnectorSummaries) {
            actionConnectorSummaries(Arrays.asList(actionConnectorSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionConnectorSummaries(Consumer<ActionConnectorSummary.Builder>... actionConnectorSummaries) {
            actionConnectorSummaries(Stream.of(actionConnectorSummaries)
                    .map(c -> ActionConnectorSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SearchActionConnectorsResponse build() {
            return new SearchActionConnectorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
