/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A semantic table that represents the final analytical structure of the data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SemanticTable implements SdkPojo, Serializable, ToCopyableBuilder<SemanticTable.Builder, SemanticTable> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Alias")
            .getter(getter(SemanticTable::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final SdkField<String> DESTINATION_TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationTableId").getter(getter(SemanticTable::destinationTableId))
            .setter(setter(Builder::destinationTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationTableId").build())
            .build();

    private static final SdkField<RowLevelPermissionConfiguration> ROW_LEVEL_PERMISSION_CONFIGURATION_FIELD = SdkField
            .<RowLevelPermissionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("RowLevelPermissionConfiguration")
            .getter(getter(SemanticTable::rowLevelPermissionConfiguration))
            .setter(setter(Builder::rowLevelPermissionConfiguration))
            .constructor(RowLevelPermissionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowLevelPermissionConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD,
            DESTINATION_TABLE_ID_FIELD, ROW_LEVEL_PERMISSION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String alias;

    private final String destinationTableId;

    private final RowLevelPermissionConfiguration rowLevelPermissionConfiguration;

    private SemanticTable(BuilderImpl builder) {
        this.alias = builder.alias;
        this.destinationTableId = builder.destinationTableId;
        this.rowLevelPermissionConfiguration = builder.rowLevelPermissionConfiguration;
    }

    /**
     * <p>
     * Alias for the semantic table.
     * </p>
     * 
     * @return Alias for the semantic table.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The identifier of the destination table from data preparation that provides data to this semantic table.
     * </p>
     * 
     * @return The identifier of the destination table from data preparation that provides data to this semantic table.
     */
    public final String destinationTableId() {
        return destinationTableId;
    }

    /**
     * <p>
     * Configuration for row level security that control data access for this semantic table.
     * </p>
     * 
     * @return Configuration for row level security that control data access for this semantic table.
     */
    public final RowLevelPermissionConfiguration rowLevelPermissionConfiguration() {
        return rowLevelPermissionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(destinationTableId());
        hashCode = 31 * hashCode + Objects.hashCode(rowLevelPermissionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SemanticTable)) {
            return false;
        }
        SemanticTable other = (SemanticTable) obj;
        return Objects.equals(alias(), other.alias()) && Objects.equals(destinationTableId(), other.destinationTableId())
                && Objects.equals(rowLevelPermissionConfiguration(), other.rowLevelPermissionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SemanticTable").add("Alias", alias()).add("DestinationTableId", destinationTableId())
                .add("RowLevelPermissionConfiguration", rowLevelPermissionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "DestinationTableId":
            return Optional.ofNullable(clazz.cast(destinationTableId()));
        case "RowLevelPermissionConfiguration":
            return Optional.ofNullable(clazz.cast(rowLevelPermissionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Alias", ALIAS_FIELD);
        map.put("DestinationTableId", DESTINATION_TABLE_ID_FIELD);
        map.put("RowLevelPermissionConfiguration", ROW_LEVEL_PERMISSION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SemanticTable, T> g) {
        return obj -> g.apply((SemanticTable) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SemanticTable> {
        /**
         * <p>
         * Alias for the semantic table.
         * </p>
         * 
         * @param alias
         *        Alias for the semantic table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The identifier of the destination table from data preparation that provides data to this semantic table.
         * </p>
         * 
         * @param destinationTableId
         *        The identifier of the destination table from data preparation that provides data to this semantic
         *        table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationTableId(String destinationTableId);

        /**
         * <p>
         * Configuration for row level security that control data access for this semantic table.
         * </p>
         * 
         * @param rowLevelPermissionConfiguration
         *        Configuration for row level security that control data access for this semantic table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowLevelPermissionConfiguration(RowLevelPermissionConfiguration rowLevelPermissionConfiguration);

        /**
         * <p>
         * Configuration for row level security that control data access for this semantic table.
         * </p>
         * This is a convenience method that creates an instance of the {@link RowLevelPermissionConfiguration.Builder}
         * avoiding the need to create one manually via {@link RowLevelPermissionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RowLevelPermissionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #rowLevelPermissionConfiguration(RowLevelPermissionConfiguration)}.
         * 
         * @param rowLevelPermissionConfiguration
         *        a consumer that will call methods on {@link RowLevelPermissionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowLevelPermissionConfiguration(RowLevelPermissionConfiguration)
         */
        default Builder rowLevelPermissionConfiguration(
                Consumer<RowLevelPermissionConfiguration.Builder> rowLevelPermissionConfiguration) {
            return rowLevelPermissionConfiguration(RowLevelPermissionConfiguration.builder()
                    .applyMutation(rowLevelPermissionConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String alias;

        private String destinationTableId;

        private RowLevelPermissionConfiguration rowLevelPermissionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SemanticTable model) {
            alias(model.alias);
            destinationTableId(model.destinationTableId);
            rowLevelPermissionConfiguration(model.rowLevelPermissionConfiguration);
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getDestinationTableId() {
            return destinationTableId;
        }

        public final void setDestinationTableId(String destinationTableId) {
            this.destinationTableId = destinationTableId;
        }

        @Override
        public final Builder destinationTableId(String destinationTableId) {
            this.destinationTableId = destinationTableId;
            return this;
        }

        public final RowLevelPermissionConfiguration.Builder getRowLevelPermissionConfiguration() {
            return rowLevelPermissionConfiguration != null ? rowLevelPermissionConfiguration.toBuilder() : null;
        }

        public final void setRowLevelPermissionConfiguration(
                RowLevelPermissionConfiguration.BuilderImpl rowLevelPermissionConfiguration) {
            this.rowLevelPermissionConfiguration = rowLevelPermissionConfiguration != null ? rowLevelPermissionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder rowLevelPermissionConfiguration(RowLevelPermissionConfiguration rowLevelPermissionConfiguration) {
            this.rowLevelPermissionConfiguration = rowLevelPermissionConfiguration;
            return this;
        }

        @Override
        public SemanticTable build() {
            return new SemanticTable(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
