/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A source table that provides initial data from either a physical table or parent dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceTable implements SdkPojo, Serializable, ToCopyableBuilder<SourceTable.Builder, SourceTable> {
    private static final SdkField<String> PHYSICAL_TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhysicalTableId").getter(getter(SourceTable::physicalTableId)).setter(setter(Builder::physicalTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalTableId").build()).build();

    private static final SdkField<ParentDataSet> DATA_SET_FIELD = SdkField.<ParentDataSet> builder(MarshallingType.SDK_POJO)
            .memberName("DataSet").getter(getter(SourceTable::dataSet)).setter(setter(Builder::dataSet))
            .constructor(ParentDataSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHYSICAL_TABLE_ID_FIELD,
            DATA_SET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String physicalTableId;

    private final ParentDataSet dataSet;

    private SourceTable(BuilderImpl builder) {
        this.physicalTableId = builder.physicalTableId;
        this.dataSet = builder.dataSet;
    }

    /**
     * <p>
     * The identifier of the physical table that serves as the data source.
     * </p>
     * 
     * @return The identifier of the physical table that serves as the data source.
     */
    public final String physicalTableId() {
        return physicalTableId;
    }

    /**
     * <p>
     * A parent dataset that serves as the data source instead of a physical table.
     * </p>
     * 
     * @return A parent dataset that serves as the data source instead of a physical table.
     */
    public final ParentDataSet dataSet() {
        return dataSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(physicalTableId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceTable)) {
            return false;
        }
        SourceTable other = (SourceTable) obj;
        return Objects.equals(physicalTableId(), other.physicalTableId()) && Objects.equals(dataSet(), other.dataSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceTable").add("PhysicalTableId", physicalTableId()).add("DataSet", dataSet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhysicalTableId":
            return Optional.ofNullable(clazz.cast(physicalTableId()));
        case "DataSet":
            return Optional.ofNullable(clazz.cast(dataSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PhysicalTableId", PHYSICAL_TABLE_ID_FIELD);
        map.put("DataSet", DATA_SET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceTable, T> g) {
        return obj -> g.apply((SourceTable) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceTable> {
        /**
         * <p>
         * The identifier of the physical table that serves as the data source.
         * </p>
         * 
         * @param physicalTableId
         *        The identifier of the physical table that serves as the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalTableId(String physicalTableId);

        /**
         * <p>
         * A parent dataset that serves as the data source instead of a physical table.
         * </p>
         * 
         * @param dataSet
         *        A parent dataset that serves as the data source instead of a physical table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSet(ParentDataSet dataSet);

        /**
         * <p>
         * A parent dataset that serves as the data source instead of a physical table.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParentDataSet.Builder} avoiding the need
         * to create one manually via {@link ParentDataSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParentDataSet.Builder#build()} is called immediately and its
         * result is passed to {@link #dataSet(ParentDataSet)}.
         * 
         * @param dataSet
         *        a consumer that will call methods on {@link ParentDataSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSet(ParentDataSet)
         */
        default Builder dataSet(Consumer<ParentDataSet.Builder> dataSet) {
            return dataSet(ParentDataSet.builder().applyMutation(dataSet).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String physicalTableId;

        private ParentDataSet dataSet;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceTable model) {
            physicalTableId(model.physicalTableId);
            dataSet(model.dataSet);
        }

        public final String getPhysicalTableId() {
            return physicalTableId;
        }

        public final void setPhysicalTableId(String physicalTableId) {
            this.physicalTableId = physicalTableId;
        }

        @Override
        public final Builder physicalTableId(String physicalTableId) {
            this.physicalTableId = physicalTableId;
            return this;
        }

        public final ParentDataSet.Builder getDataSet() {
            return dataSet != null ? dataSet.toBuilder() : null;
        }

        public final void setDataSet(ParentDataSet.BuilderImpl dataSet) {
            this.dataSet = dataSet != null ? dataSet.build() : null;
        }

        @Override
        public final Builder dataSet(ParentDataSet dataSet) {
            this.dataSet = dataSet;
            return this;
        }

        @Override
        public SourceTable build() {
            return new SourceTable(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
