/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartAssetBundleExportJobRequest extends QuickSightRequest implements
        ToCopyableBuilder<StartAssetBundleExportJobRequest.Builder, StartAssetBundleExportJobRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(StartAssetBundleExportJobRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> ASSET_BUNDLE_EXPORT_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssetBundleExportJobId").getter(getter(StartAssetBundleExportJobRequest::assetBundleExportJobId))
            .setter(setter(Builder::assetBundleExportJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetBundleExportJobId").build())
            .build();

    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceArns")
            .getter(getter(StartAssetBundleExportJobRequest::resourceArns))
            .setter(setter(Builder::resourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> INCLUDE_ALL_DEPENDENCIES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeAllDependencies").getter(getter(StartAssetBundleExportJobRequest::includeAllDependencies))
            .setter(setter(Builder::includeAllDependencies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeAllDependencies").build())
            .build();

    private static final SdkField<String> EXPORT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportFormat").getter(getter(StartAssetBundleExportJobRequest::exportFormatAsString))
            .setter(setter(Builder::exportFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportFormat").build()).build();

    private static final SdkField<AssetBundleCloudFormationOverridePropertyConfiguration> CLOUD_FORMATION_OVERRIDE_PROPERTY_CONFIGURATION_FIELD = SdkField
            .<AssetBundleCloudFormationOverridePropertyConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CloudFormationOverridePropertyConfiguration")
            .getter(getter(StartAssetBundleExportJobRequest::cloudFormationOverridePropertyConfiguration))
            .setter(setter(Builder::cloudFormationOverridePropertyConfiguration))
            .constructor(AssetBundleCloudFormationOverridePropertyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CloudFormationOverridePropertyConfiguration").build()).build();

    private static final SdkField<Boolean> INCLUDE_PERMISSIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludePermissions").getter(getter(StartAssetBundleExportJobRequest::includePermissions))
            .setter(setter(Builder::includePermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludePermissions").build())
            .build();

    private static final SdkField<Boolean> INCLUDE_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeTags").getter(getter(StartAssetBundleExportJobRequest::includeTags))
            .setter(setter(Builder::includeTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeTags").build()).build();

    private static final SdkField<AssetBundleExportJobValidationStrategy> VALIDATION_STRATEGY_FIELD = SdkField
            .<AssetBundleExportJobValidationStrategy> builder(MarshallingType.SDK_POJO).memberName("ValidationStrategy")
            .getter(getter(StartAssetBundleExportJobRequest::validationStrategy)).setter(setter(Builder::validationStrategy))
            .constructor(AssetBundleExportJobValidationStrategy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStrategy").build())
            .build();

    private static final SdkField<Boolean> INCLUDE_FOLDER_MEMBERSHIPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeFolderMemberships").getter(getter(StartAssetBundleExportJobRequest::includeFolderMemberships))
            .setter(setter(Builder::includeFolderMemberships))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeFolderMemberships").build())
            .build();

    private static final SdkField<String> INCLUDE_FOLDER_MEMBERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IncludeFolderMembers").getter(getter(StartAssetBundleExportJobRequest::includeFolderMembersAsString))
            .setter(setter(Builder::includeFolderMembers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeFolderMembers").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            ASSET_BUNDLE_EXPORT_JOB_ID_FIELD, RESOURCE_ARNS_FIELD, INCLUDE_ALL_DEPENDENCIES_FIELD, EXPORT_FORMAT_FIELD,
            CLOUD_FORMATION_OVERRIDE_PROPERTY_CONFIGURATION_FIELD, INCLUDE_PERMISSIONS_FIELD, INCLUDE_TAGS_FIELD,
            VALIDATION_STRATEGY_FIELD, INCLUDE_FOLDER_MEMBERSHIPS_FIELD, INCLUDE_FOLDER_MEMBERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String assetBundleExportJobId;

    private final List<String> resourceArns;

    private final Boolean includeAllDependencies;

    private final String exportFormat;

    private final AssetBundleCloudFormationOverridePropertyConfiguration cloudFormationOverridePropertyConfiguration;

    private final Boolean includePermissions;

    private final Boolean includeTags;

    private final AssetBundleExportJobValidationStrategy validationStrategy;

    private final Boolean includeFolderMemberships;

    private final String includeFolderMembers;

    private StartAssetBundleExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.assetBundleExportJobId = builder.assetBundleExportJobId;
        this.resourceArns = builder.resourceArns;
        this.includeAllDependencies = builder.includeAllDependencies;
        this.exportFormat = builder.exportFormat;
        this.cloudFormationOverridePropertyConfiguration = builder.cloudFormationOverridePropertyConfiguration;
        this.includePermissions = builder.includePermissions;
        this.includeTags = builder.includeTags;
        this.validationStrategy = builder.validationStrategy;
        this.includeFolderMemberships = builder.includeFolderMemberships;
        this.includeFolderMembers = builder.includeFolderMembers;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account to export assets from.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account to export assets from.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID of the job. This ID is unique while the job is running. After the job is completed, you can reuse this ID
     * for another job.
     * </p>
     * 
     * @return The ID of the job. This ID is unique while the job is running. After the job is completed, you can reuse
     *         this ID for another job.
     */
    public final String assetBundleExportJobId() {
        return assetBundleExportJobId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceArns() {
        return resourceArns != null && !(resourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of resource ARNs to export. The following resources are supported.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Analysis</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Dashboard</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DataSet</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DataSource</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RefreshSchedule</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Theme</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VPCConnection</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The API caller must have the necessary permissions in their IAM role to access each resource before the resources
     * can be exported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceArns} method.
     * </p>
     * 
     * @return An array of resource ARNs to export. The following resources are supported.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Analysis</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Dashboard</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DataSet</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DataSource</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RefreshSchedule</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Theme</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VPCConnection</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The API caller must have the necessary permissions in their IAM role to access each resource before the
     *         resources can be exported.
     */
    public final List<String> resourceArns() {
        return resourceArns;
    }

    /**
     * <p>
     * A Boolean that determines whether all dependencies of each resource ARN are recursively exported with the job.
     * For example, say you provided a Dashboard ARN to the <code>ResourceArns</code> parameter. If you set
     * <code>IncludeAllDependencies</code> to <code>TRUE</code>, any theme, dataset, and data source resource that is a
     * dependency of the dashboard is also exported.
     * </p>
     * 
     * @return A Boolean that determines whether all dependencies of each resource ARN are recursively exported with the
     *         job. For example, say you provided a Dashboard ARN to the <code>ResourceArns</code> parameter. If you set
     *         <code>IncludeAllDependencies</code> to <code>TRUE</code>, any theme, dataset, and data source resource
     *         that is a dependency of the dashboard is also exported.
     */
    public final Boolean includeAllDependencies() {
        return includeAllDependencies;
    }

    /**
     * <p>
     * The export data format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportFormat} will
     * return {@link AssetBundleExportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exportFormatAsString}.
     * </p>
     * 
     * @return The export data format.
     * @see AssetBundleExportFormat
     */
    public final AssetBundleExportFormat exportFormat() {
        return AssetBundleExportFormat.fromValue(exportFormat);
    }

    /**
     * <p>
     * The export data format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportFormat} will
     * return {@link AssetBundleExportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exportFormatAsString}.
     * </p>
     * 
     * @return The export data format.
     * @see AssetBundleExportFormat
     */
    public final String exportFormatAsString() {
        return exportFormat;
    }

    /**
     * <p>
     * An optional collection of structures that generate CloudFormation parameters to override the existing resource
     * property values when the resource is exported to a new CloudFormation template.
     * </p>
     * <p>
     * Use this field if the <code>ExportFormat</code> field of a <code>StartAssetBundleExportJobRequest</code> API call
     * is set to <code>CLOUDFORMATION_JSON</code>.
     * </p>
     * 
     * @return An optional collection of structures that generate CloudFormation parameters to override the existing
     *         resource property values when the resource is exported to a new CloudFormation template.</p>
     *         <p>
     *         Use this field if the <code>ExportFormat</code> field of a <code>StartAssetBundleExportJobRequest</code>
     *         API call is set to <code>CLOUDFORMATION_JSON</code>.
     */
    public final AssetBundleCloudFormationOverridePropertyConfiguration cloudFormationOverridePropertyConfiguration() {
        return cloudFormationOverridePropertyConfiguration;
    }

    /**
     * <p>
     * A Boolean that determines whether all permissions for each resource ARN are exported with the job. If you set
     * <code>IncludePermissions</code> to <code>TRUE</code>, any permissions associated with each resource are exported.
     * </p>
     * 
     * @return A Boolean that determines whether all permissions for each resource ARN are exported with the job. If you
     *         set <code>IncludePermissions</code> to <code>TRUE</code>, any permissions associated with each resource
     *         are exported.
     */
    public final Boolean includePermissions() {
        return includePermissions;
    }

    /**
     * <p>
     * A Boolean that determines whether all tags for each resource ARN are exported with the job. If you set
     * <code>IncludeTags</code> to <code>TRUE</code>, any tags associated with each resource are exported.
     * </p>
     * 
     * @return A Boolean that determines whether all tags for each resource ARN are exported with the job. If you set
     *         <code>IncludeTags</code> to <code>TRUE</code>, any tags associated with each resource are exported.
     */
    public final Boolean includeTags() {
        return includeTags;
    }

    /**
     * <p>
     * An optional parameter that determines which validation strategy to use for the export job. If
     * <code>StrictModeForAllResources</code> is set to <code>TRUE</code>, strict validation for every error is
     * enforced. If it is set to <code>FALSE</code>, validation is skipped for specific UI errors that are shown as
     * warnings. The default value for <code>StrictModeForAllResources</code> is <code>FALSE</code>.
     * </p>
     * 
     * @return An optional parameter that determines which validation strategy to use for the export job. If
     *         <code>StrictModeForAllResources</code> is set to <code>TRUE</code>, strict validation for every error is
     *         enforced. If it is set to <code>FALSE</code>, validation is skipped for specific UI errors that are shown
     *         as warnings. The default value for <code>StrictModeForAllResources</code> is <code>FALSE</code>.
     */
    public final AssetBundleExportJobValidationStrategy validationStrategy() {
        return validationStrategy;
    }

    /**
     * <p>
     * A Boolean that determines if the exported asset carries over information about the folders that the asset is a
     * member of.
     * </p>
     * 
     * @return A Boolean that determines if the exported asset carries over information about the folders that the asset
     *         is a member of.
     */
    public final Boolean includeFolderMemberships() {
        return includeFolderMemberships;
    }

    /**
     * <p>
     * A setting that indicates whether you want to include folder assets. You can also use this setting to recusrsively
     * include all subfolders of an exported folder.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #includeFolderMembers} will return {@link IncludeFolderMembers#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #includeFolderMembersAsString}.
     * </p>
     * 
     * @return A setting that indicates whether you want to include folder assets. You can also use this setting to
     *         recusrsively include all subfolders of an exported folder.
     * @see IncludeFolderMembers
     */
    public final IncludeFolderMembers includeFolderMembers() {
        return IncludeFolderMembers.fromValue(includeFolderMembers);
    }

    /**
     * <p>
     * A setting that indicates whether you want to include folder assets. You can also use this setting to recusrsively
     * include all subfolders of an exported folder.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #includeFolderMembers} will return {@link IncludeFolderMembers#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #includeFolderMembersAsString}.
     * </p>
     * 
     * @return A setting that indicates whether you want to include folder assets. You can also use this setting to
     *         recusrsively include all subfolders of an exported folder.
     * @see IncludeFolderMembers
     */
    public final String includeFolderMembersAsString() {
        return includeFolderMembers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(assetBundleExportJobId());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceArns() ? resourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(includeAllDependencies());
        hashCode = 31 * hashCode + Objects.hashCode(exportFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cloudFormationOverridePropertyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(includePermissions());
        hashCode = 31 * hashCode + Objects.hashCode(includeTags());
        hashCode = 31 * hashCode + Objects.hashCode(validationStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(includeFolderMemberships());
        hashCode = 31 * hashCode + Objects.hashCode(includeFolderMembersAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAssetBundleExportJobRequest)) {
            return false;
        }
        StartAssetBundleExportJobRequest other = (StartAssetBundleExportJobRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(assetBundleExportJobId(), other.assetBundleExportJobId())
                && hasResourceArns() == other.hasResourceArns()
                && Objects.equals(resourceArns(), other.resourceArns())
                && Objects.equals(includeAllDependencies(), other.includeAllDependencies())
                && Objects.equals(exportFormatAsString(), other.exportFormatAsString())
                && Objects.equals(cloudFormationOverridePropertyConfiguration(),
                        other.cloudFormationOverridePropertyConfiguration())
                && Objects.equals(includePermissions(), other.includePermissions())
                && Objects.equals(includeTags(), other.includeTags())
                && Objects.equals(validationStrategy(), other.validationStrategy())
                && Objects.equals(includeFolderMemberships(), other.includeFolderMemberships())
                && Objects.equals(includeFolderMembersAsString(), other.includeFolderMembersAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartAssetBundleExportJobRequest").add("AwsAccountId", awsAccountId())
                .add("AssetBundleExportJobId", assetBundleExportJobId())
                .add("ResourceArns", hasResourceArns() ? resourceArns() : null)
                .add("IncludeAllDependencies", includeAllDependencies()).add("ExportFormat", exportFormatAsString())
                .add("CloudFormationOverridePropertyConfiguration", cloudFormationOverridePropertyConfiguration())
                .add("IncludePermissions", includePermissions()).add("IncludeTags", includeTags())
                .add("ValidationStrategy", validationStrategy()).add("IncludeFolderMemberships", includeFolderMemberships())
                .add("IncludeFolderMembers", includeFolderMembersAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "AssetBundleExportJobId":
            return Optional.ofNullable(clazz.cast(assetBundleExportJobId()));
        case "ResourceArns":
            return Optional.ofNullable(clazz.cast(resourceArns()));
        case "IncludeAllDependencies":
            return Optional.ofNullable(clazz.cast(includeAllDependencies()));
        case "ExportFormat":
            return Optional.ofNullable(clazz.cast(exportFormatAsString()));
        case "CloudFormationOverridePropertyConfiguration":
            return Optional.ofNullable(clazz.cast(cloudFormationOverridePropertyConfiguration()));
        case "IncludePermissions":
            return Optional.ofNullable(clazz.cast(includePermissions()));
        case "IncludeTags":
            return Optional.ofNullable(clazz.cast(includeTags()));
        case "ValidationStrategy":
            return Optional.ofNullable(clazz.cast(validationStrategy()));
        case "IncludeFolderMemberships":
            return Optional.ofNullable(clazz.cast(includeFolderMemberships()));
        case "IncludeFolderMembers":
            return Optional.ofNullable(clazz.cast(includeFolderMembersAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("AssetBundleExportJobId", ASSET_BUNDLE_EXPORT_JOB_ID_FIELD);
        map.put("ResourceArns", RESOURCE_ARNS_FIELD);
        map.put("IncludeAllDependencies", INCLUDE_ALL_DEPENDENCIES_FIELD);
        map.put("ExportFormat", EXPORT_FORMAT_FIELD);
        map.put("CloudFormationOverridePropertyConfiguration", CLOUD_FORMATION_OVERRIDE_PROPERTY_CONFIGURATION_FIELD);
        map.put("IncludePermissions", INCLUDE_PERMISSIONS_FIELD);
        map.put("IncludeTags", INCLUDE_TAGS_FIELD);
        map.put("ValidationStrategy", VALIDATION_STRATEGY_FIELD);
        map.put("IncludeFolderMemberships", INCLUDE_FOLDER_MEMBERSHIPS_FIELD);
        map.put("IncludeFolderMembers", INCLUDE_FOLDER_MEMBERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartAssetBundleExportJobRequest, T> g) {
        return obj -> g.apply((StartAssetBundleExportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartAssetBundleExportJobRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account to export assets from.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account to export assets from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID of the job. This ID is unique while the job is running. After the job is completed, you can reuse this
         * ID for another job.
         * </p>
         * 
         * @param assetBundleExportJobId
         *        The ID of the job. This ID is unique while the job is running. After the job is completed, you can
         *        reuse this ID for another job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetBundleExportJobId(String assetBundleExportJobId);

        /**
         * <p>
         * An array of resource ARNs to export. The following resources are supported.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Analysis</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Dashboard</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DataSet</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DataSource</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RefreshSchedule</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Theme</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VPCConnection</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The API caller must have the necessary permissions in their IAM role to access each resource before the
         * resources can be exported.
         * </p>
         * 
         * @param resourceArns
         *        An array of resource ARNs to export. The following resources are supported.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Analysis</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Dashboard</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DataSet</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DataSource</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RefreshSchedule</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Theme</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VPCConnection</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The API caller must have the necessary permissions in their IAM role to access each resource before
         *        the resources can be exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(Collection<String> resourceArns);

        /**
         * <p>
         * An array of resource ARNs to export. The following resources are supported.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Analysis</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Dashboard</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DataSet</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DataSource</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RefreshSchedule</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Theme</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VPCConnection</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The API caller must have the necessary permissions in their IAM role to access each resource before the
         * resources can be exported.
         * </p>
         * 
         * @param resourceArns
         *        An array of resource ARNs to export. The following resources are supported.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Analysis</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Dashboard</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DataSet</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DataSource</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RefreshSchedule</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Theme</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VPCConnection</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The API caller must have the necessary permissions in their IAM role to access each resource before
         *        the resources can be exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(String... resourceArns);

        /**
         * <p>
         * A Boolean that determines whether all dependencies of each resource ARN are recursively exported with the
         * job. For example, say you provided a Dashboard ARN to the <code>ResourceArns</code> parameter. If you set
         * <code>IncludeAllDependencies</code> to <code>TRUE</code>, any theme, dataset, and data source resource that
         * is a dependency of the dashboard is also exported.
         * </p>
         * 
         * @param includeAllDependencies
         *        A Boolean that determines whether all dependencies of each resource ARN are recursively exported with
         *        the job. For example, say you provided a Dashboard ARN to the <code>ResourceArns</code> parameter. If
         *        you set <code>IncludeAllDependencies</code> to <code>TRUE</code>, any theme, dataset, and data source
         *        resource that is a dependency of the dashboard is also exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeAllDependencies(Boolean includeAllDependencies);

        /**
         * <p>
         * The export data format.
         * </p>
         * 
         * @param exportFormat
         *        The export data format.
         * @see AssetBundleExportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetBundleExportFormat
         */
        Builder exportFormat(String exportFormat);

        /**
         * <p>
         * The export data format.
         * </p>
         * 
         * @param exportFormat
         *        The export data format.
         * @see AssetBundleExportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetBundleExportFormat
         */
        Builder exportFormat(AssetBundleExportFormat exportFormat);

        /**
         * <p>
         * An optional collection of structures that generate CloudFormation parameters to override the existing
         * resource property values when the resource is exported to a new CloudFormation template.
         * </p>
         * <p>
         * Use this field if the <code>ExportFormat</code> field of a <code>StartAssetBundleExportJobRequest</code> API
         * call is set to <code>CLOUDFORMATION_JSON</code>.
         * </p>
         * 
         * @param cloudFormationOverridePropertyConfiguration
         *        An optional collection of structures that generate CloudFormation parameters to override the existing
         *        resource property values when the resource is exported to a new CloudFormation template.</p>
         *        <p>
         *        Use this field if the <code>ExportFormat</code> field of a
         *        <code>StartAssetBundleExportJobRequest</code> API call is set to <code>CLOUDFORMATION_JSON</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFormationOverridePropertyConfiguration(
                AssetBundleCloudFormationOverridePropertyConfiguration cloudFormationOverridePropertyConfiguration);

        /**
         * <p>
         * An optional collection of structures that generate CloudFormation parameters to override the existing
         * resource property values when the resource is exported to a new CloudFormation template.
         * </p>
         * <p>
         * Use this field if the <code>ExportFormat</code> field of a <code>StartAssetBundleExportJobRequest</code> API
         * call is set to <code>CLOUDFORMATION_JSON</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AssetBundleCloudFormationOverridePropertyConfiguration.Builder} avoiding the need to create one
         * manually via {@link AssetBundleCloudFormationOverridePropertyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AssetBundleCloudFormationOverridePropertyConfiguration.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #cloudFormationOverridePropertyConfiguration(AssetBundleCloudFormationOverridePropertyConfiguration)}.
         * 
         * @param cloudFormationOverridePropertyConfiguration
         *        a consumer that will call methods on
         *        {@link AssetBundleCloudFormationOverridePropertyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudFormationOverridePropertyConfiguration(AssetBundleCloudFormationOverridePropertyConfiguration)
         */
        default Builder cloudFormationOverridePropertyConfiguration(
                Consumer<AssetBundleCloudFormationOverridePropertyConfiguration.Builder> cloudFormationOverridePropertyConfiguration) {
            return cloudFormationOverridePropertyConfiguration(AssetBundleCloudFormationOverridePropertyConfiguration.builder()
                    .applyMutation(cloudFormationOverridePropertyConfiguration).build());
        }

        /**
         * <p>
         * A Boolean that determines whether all permissions for each resource ARN are exported with the job. If you set
         * <code>IncludePermissions</code> to <code>TRUE</code>, any permissions associated with each resource are
         * exported.
         * </p>
         * 
         * @param includePermissions
         *        A Boolean that determines whether all permissions for each resource ARN are exported with the job. If
         *        you set <code>IncludePermissions</code> to <code>TRUE</code>, any permissions associated with each
         *        resource are exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includePermissions(Boolean includePermissions);

        /**
         * <p>
         * A Boolean that determines whether all tags for each resource ARN are exported with the job. If you set
         * <code>IncludeTags</code> to <code>TRUE</code>, any tags associated with each resource are exported.
         * </p>
         * 
         * @param includeTags
         *        A Boolean that determines whether all tags for each resource ARN are exported with the job. If you set
         *        <code>IncludeTags</code> to <code>TRUE</code>, any tags associated with each resource are exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeTags(Boolean includeTags);

        /**
         * <p>
         * An optional parameter that determines which validation strategy to use for the export job. If
         * <code>StrictModeForAllResources</code> is set to <code>TRUE</code>, strict validation for every error is
         * enforced. If it is set to <code>FALSE</code>, validation is skipped for specific UI errors that are shown as
         * warnings. The default value for <code>StrictModeForAllResources</code> is <code>FALSE</code>.
         * </p>
         * 
         * @param validationStrategy
         *        An optional parameter that determines which validation strategy to use for the export job. If
         *        <code>StrictModeForAllResources</code> is set to <code>TRUE</code>, strict validation for every error
         *        is enforced. If it is set to <code>FALSE</code>, validation is skipped for specific UI errors that are
         *        shown as warnings. The default value for <code>StrictModeForAllResources</code> is <code>FALSE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationStrategy(AssetBundleExportJobValidationStrategy validationStrategy);

        /**
         * <p>
         * An optional parameter that determines which validation strategy to use for the export job. If
         * <code>StrictModeForAllResources</code> is set to <code>TRUE</code>, strict validation for every error is
         * enforced. If it is set to <code>FALSE</code>, validation is skipped for specific UI errors that are shown as
         * warnings. The default value for <code>StrictModeForAllResources</code> is <code>FALSE</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AssetBundleExportJobValidationStrategy.Builder} avoiding the need to create one manually via
         * {@link AssetBundleExportJobValidationStrategy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetBundleExportJobValidationStrategy.Builder#build()} is called
         * immediately and its result is passed to {@link #validationStrategy(AssetBundleExportJobValidationStrategy)}.
         * 
         * @param validationStrategy
         *        a consumer that will call methods on {@link AssetBundleExportJobValidationStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationStrategy(AssetBundleExportJobValidationStrategy)
         */
        default Builder validationStrategy(Consumer<AssetBundleExportJobValidationStrategy.Builder> validationStrategy) {
            return validationStrategy(AssetBundleExportJobValidationStrategy.builder().applyMutation(validationStrategy).build());
        }

        /**
         * <p>
         * A Boolean that determines if the exported asset carries over information about the folders that the asset is
         * a member of.
         * </p>
         * 
         * @param includeFolderMemberships
         *        A Boolean that determines if the exported asset carries over information about the folders that the
         *        asset is a member of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeFolderMemberships(Boolean includeFolderMemberships);

        /**
         * <p>
         * A setting that indicates whether you want to include folder assets. You can also use this setting to
         * recusrsively include all subfolders of an exported folder.
         * </p>
         * 
         * @param includeFolderMembers
         *        A setting that indicates whether you want to include folder assets. You can also use this setting to
         *        recusrsively include all subfolders of an exported folder.
         * @see IncludeFolderMembers
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncludeFolderMembers
         */
        Builder includeFolderMembers(String includeFolderMembers);

        /**
         * <p>
         * A setting that indicates whether you want to include folder assets. You can also use this setting to
         * recusrsively include all subfolders of an exported folder.
         * </p>
         * 
         * @param includeFolderMembers
         *        A setting that indicates whether you want to include folder assets. You can also use this setting to
         *        recusrsively include all subfolders of an exported folder.
         * @see IncludeFolderMembers
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncludeFolderMembers
         */
        Builder includeFolderMembers(IncludeFolderMembers includeFolderMembers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String assetBundleExportJobId;

        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();

        private Boolean includeAllDependencies;

        private String exportFormat;

        private AssetBundleCloudFormationOverridePropertyConfiguration cloudFormationOverridePropertyConfiguration;

        private Boolean includePermissions;

        private Boolean includeTags;

        private AssetBundleExportJobValidationStrategy validationStrategy;

        private Boolean includeFolderMemberships;

        private String includeFolderMembers;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAssetBundleExportJobRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            assetBundleExportJobId(model.assetBundleExportJobId);
            resourceArns(model.resourceArns);
            includeAllDependencies(model.includeAllDependencies);
            exportFormat(model.exportFormat);
            cloudFormationOverridePropertyConfiguration(model.cloudFormationOverridePropertyConfiguration);
            includePermissions(model.includePermissions);
            includeTags(model.includeTags);
            validationStrategy(model.validationStrategy);
            includeFolderMemberships(model.includeFolderMemberships);
            includeFolderMembers(model.includeFolderMembers);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAssetBundleExportJobId() {
            return assetBundleExportJobId;
        }

        public final void setAssetBundleExportJobId(String assetBundleExportJobId) {
            this.assetBundleExportJobId = assetBundleExportJobId;
        }

        @Override
        public final Builder assetBundleExportJobId(String assetBundleExportJobId) {
            this.assetBundleExportJobId = assetBundleExportJobId;
            return this;
        }

        public final Collection<String> getResourceArns() {
            if (resourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceArns;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = AssetBundleResourceArnsCopier.copy(resourceArns);
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = AssetBundleResourceArnsCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String... resourceArns) {
            resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final Boolean getIncludeAllDependencies() {
            return includeAllDependencies;
        }

        public final void setIncludeAllDependencies(Boolean includeAllDependencies) {
            this.includeAllDependencies = includeAllDependencies;
        }

        @Override
        public final Builder includeAllDependencies(Boolean includeAllDependencies) {
            this.includeAllDependencies = includeAllDependencies;
            return this;
        }

        public final String getExportFormat() {
            return exportFormat;
        }

        public final void setExportFormat(String exportFormat) {
            this.exportFormat = exportFormat;
        }

        @Override
        public final Builder exportFormat(String exportFormat) {
            this.exportFormat = exportFormat;
            return this;
        }

        @Override
        public final Builder exportFormat(AssetBundleExportFormat exportFormat) {
            this.exportFormat(exportFormat == null ? null : exportFormat.toString());
            return this;
        }

        public final AssetBundleCloudFormationOverridePropertyConfiguration.Builder getCloudFormationOverridePropertyConfiguration() {
            return cloudFormationOverridePropertyConfiguration != null ? cloudFormationOverridePropertyConfiguration.toBuilder()
                    : null;
        }

        public final void setCloudFormationOverridePropertyConfiguration(
                AssetBundleCloudFormationOverridePropertyConfiguration.BuilderImpl cloudFormationOverridePropertyConfiguration) {
            this.cloudFormationOverridePropertyConfiguration = cloudFormationOverridePropertyConfiguration != null ? cloudFormationOverridePropertyConfiguration
                    .build() : null;
        }

        @Override
        public final Builder cloudFormationOverridePropertyConfiguration(
                AssetBundleCloudFormationOverridePropertyConfiguration cloudFormationOverridePropertyConfiguration) {
            this.cloudFormationOverridePropertyConfiguration = cloudFormationOverridePropertyConfiguration;
            return this;
        }

        public final Boolean getIncludePermissions() {
            return includePermissions;
        }

        public final void setIncludePermissions(Boolean includePermissions) {
            this.includePermissions = includePermissions;
        }

        @Override
        public final Builder includePermissions(Boolean includePermissions) {
            this.includePermissions = includePermissions;
            return this;
        }

        public final Boolean getIncludeTags() {
            return includeTags;
        }

        public final void setIncludeTags(Boolean includeTags) {
            this.includeTags = includeTags;
        }

        @Override
        public final Builder includeTags(Boolean includeTags) {
            this.includeTags = includeTags;
            return this;
        }

        public final AssetBundleExportJobValidationStrategy.Builder getValidationStrategy() {
            return validationStrategy != null ? validationStrategy.toBuilder() : null;
        }

        public final void setValidationStrategy(AssetBundleExportJobValidationStrategy.BuilderImpl validationStrategy) {
            this.validationStrategy = validationStrategy != null ? validationStrategy.build() : null;
        }

        @Override
        public final Builder validationStrategy(AssetBundleExportJobValidationStrategy validationStrategy) {
            this.validationStrategy = validationStrategy;
            return this;
        }

        public final Boolean getIncludeFolderMemberships() {
            return includeFolderMemberships;
        }

        public final void setIncludeFolderMemberships(Boolean includeFolderMemberships) {
            this.includeFolderMemberships = includeFolderMemberships;
        }

        @Override
        public final Builder includeFolderMemberships(Boolean includeFolderMemberships) {
            this.includeFolderMemberships = includeFolderMemberships;
            return this;
        }

        public final String getIncludeFolderMembers() {
            return includeFolderMembers;
        }

        public final void setIncludeFolderMembers(String includeFolderMembers) {
            this.includeFolderMembers = includeFolderMembers;
        }

        @Override
        public final Builder includeFolderMembers(String includeFolderMembers) {
            this.includeFolderMembers = includeFolderMembers;
            return this;
        }

        @Override
        public final Builder includeFolderMembers(IncludeFolderMembers includeFolderMembers) {
            this.includeFolderMembers(includeFolderMembers == null ? null : includeFolderMembers.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAssetBundleExportJobRequest build() {
            return new StartAssetBundleExportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
