/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure that represents a null filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicNullFilter implements SdkPojo, Serializable, ToCopyableBuilder<TopicNullFilter.Builder, TopicNullFilter> {
    private static final SdkField<String> NULL_FILTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NullFilterType").getter(getter(TopicNullFilter::nullFilterTypeAsString))
            .setter(setter(Builder::nullFilterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullFilterType").build()).build();

    private static final SdkField<TopicSingularFilterConstant> CONSTANT_FIELD = SdkField
            .<TopicSingularFilterConstant> builder(MarshallingType.SDK_POJO).memberName("Constant")
            .getter(getter(TopicNullFilter::constant)).setter(setter(Builder::constant))
            .constructor(TopicSingularFilterConstant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Constant").build()).build();

    private static final SdkField<Boolean> INVERSE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Inverse").getter(getter(TopicNullFilter::inverse)).setter(setter(Builder::inverse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inverse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NULL_FILTER_TYPE_FIELD,
            CONSTANT_FIELD, INVERSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String nullFilterType;

    private final TopicSingularFilterConstant constant;

    private final Boolean inverse;

    private TopicNullFilter(BuilderImpl builder) {
        this.nullFilterType = builder.nullFilterType;
        this.constant = builder.constant;
        this.inverse = builder.inverse;
    }

    /**
     * <p>
     * The type of the null filter. Valid values for this type are <code>NULLS_ONLY</code>, <code>NON_NULLS_ONLY</code>,
     * and <code>ALL_VALUES</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nullFilterType}
     * will return {@link NullFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nullFilterTypeAsString}.
     * </p>
     * 
     * @return The type of the null filter. Valid values for this type are <code>NULLS_ONLY</code>,
     *         <code>NON_NULLS_ONLY</code>, and <code>ALL_VALUES</code>.
     * @see NullFilterType
     */
    public final NullFilterType nullFilterType() {
        return NullFilterType.fromValue(nullFilterType);
    }

    /**
     * <p>
     * The type of the null filter. Valid values for this type are <code>NULLS_ONLY</code>, <code>NON_NULLS_ONLY</code>,
     * and <code>ALL_VALUES</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nullFilterType}
     * will return {@link NullFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nullFilterTypeAsString}.
     * </p>
     * 
     * @return The type of the null filter. Valid values for this type are <code>NULLS_ONLY</code>,
     *         <code>NON_NULLS_ONLY</code>, and <code>ALL_VALUES</code>.
     * @see NullFilterType
     */
    public final String nullFilterTypeAsString() {
        return nullFilterType;
    }

    /**
     * Returns the value of the Constant property for this object.
     * 
     * @return The value of the Constant property for this object.
     */
    public final TopicSingularFilterConstant constant() {
        return constant;
    }

    /**
     * <p>
     * A Boolean value that indicates if the filter is inverse.
     * </p>
     * 
     * @return A Boolean value that indicates if the filter is inverse.
     */
    public final Boolean inverse() {
        return inverse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nullFilterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(constant());
        hashCode = 31 * hashCode + Objects.hashCode(inverse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicNullFilter)) {
            return false;
        }
        TopicNullFilter other = (TopicNullFilter) obj;
        return Objects.equals(nullFilterTypeAsString(), other.nullFilterTypeAsString())
                && Objects.equals(constant(), other.constant()) && Objects.equals(inverse(), other.inverse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicNullFilter").add("NullFilterType", nullFilterTypeAsString())
                .add("Constant", constant() == null ? null : "*** Sensitive Data Redacted ***").add("Inverse", inverse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NullFilterType":
            return Optional.ofNullable(clazz.cast(nullFilterTypeAsString()));
        case "Constant":
            return Optional.ofNullable(clazz.cast(constant()));
        case "Inverse":
            return Optional.ofNullable(clazz.cast(inverse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NullFilterType", NULL_FILTER_TYPE_FIELD);
        map.put("Constant", CONSTANT_FIELD);
        map.put("Inverse", INVERSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicNullFilter, T> g) {
        return obj -> g.apply((TopicNullFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicNullFilter> {
        /**
         * <p>
         * The type of the null filter. Valid values for this type are <code>NULLS_ONLY</code>,
         * <code>NON_NULLS_ONLY</code>, and <code>ALL_VALUES</code>.
         * </p>
         * 
         * @param nullFilterType
         *        The type of the null filter. Valid values for this type are <code>NULLS_ONLY</code>,
         *        <code>NON_NULLS_ONLY</code>, and <code>ALL_VALUES</code>.
         * @see NullFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NullFilterType
         */
        Builder nullFilterType(String nullFilterType);

        /**
         * <p>
         * The type of the null filter. Valid values for this type are <code>NULLS_ONLY</code>,
         * <code>NON_NULLS_ONLY</code>, and <code>ALL_VALUES</code>.
         * </p>
         * 
         * @param nullFilterType
         *        The type of the null filter. Valid values for this type are <code>NULLS_ONLY</code>,
         *        <code>NON_NULLS_ONLY</code>, and <code>ALL_VALUES</code>.
         * @see NullFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NullFilterType
         */
        Builder nullFilterType(NullFilterType nullFilterType);

        /**
         * Sets the value of the Constant property for this object.
         *
         * @param constant
         *        The new value for the Constant property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constant(TopicSingularFilterConstant constant);

        /**
         * Sets the value of the Constant property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TopicSingularFilterConstant.Builder}
         * avoiding the need to create one manually via {@link TopicSingularFilterConstant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicSingularFilterConstant.Builder#build()} is called
         * immediately and its result is passed to {@link #constant(TopicSingularFilterConstant)}.
         * 
         * @param constant
         *        a consumer that will call methods on {@link TopicSingularFilterConstant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #constant(TopicSingularFilterConstant)
         */
        default Builder constant(Consumer<TopicSingularFilterConstant.Builder> constant) {
            return constant(TopicSingularFilterConstant.builder().applyMutation(constant).build());
        }

        /**
         * <p>
         * A Boolean value that indicates if the filter is inverse.
         * </p>
         * 
         * @param inverse
         *        A Boolean value that indicates if the filter is inverse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inverse(Boolean inverse);
    }

    static final class BuilderImpl implements Builder {
        private String nullFilterType;

        private TopicSingularFilterConstant constant;

        private Boolean inverse;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicNullFilter model) {
            nullFilterType(model.nullFilterType);
            constant(model.constant);
            inverse(model.inverse);
        }

        public final String getNullFilterType() {
            return nullFilterType;
        }

        public final void setNullFilterType(String nullFilterType) {
            this.nullFilterType = nullFilterType;
        }

        @Override
        public final Builder nullFilterType(String nullFilterType) {
            this.nullFilterType = nullFilterType;
            return this;
        }

        @Override
        public final Builder nullFilterType(NullFilterType nullFilterType) {
            this.nullFilterType(nullFilterType == null ? null : nullFilterType.toString());
            return this;
        }

        public final TopicSingularFilterConstant.Builder getConstant() {
            return constant != null ? constant.toBuilder() : null;
        }

        public final void setConstant(TopicSingularFilterConstant.BuilderImpl constant) {
            this.constant = constant != null ? constant.build() : null;
        }

        @Override
        public final Builder constant(TopicSingularFilterConstant constant) {
            this.constant = constant;
            return this;
        }

        public final Boolean getInverse() {
            return inverse;
        }

        public final void setInverse(Boolean inverse) {
            this.inverse = inverse;
        }

        @Override
        public final Builder inverse(Boolean inverse) {
            this.inverse = inverse;
            return this;
        }

        @Override
        public TopicNullFilter build() {
            return new TopicNullFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
