/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A topic summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicSummary implements SdkPojo, Serializable, ToCopyableBuilder<TopicSummary.Builder, TopicSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(TopicSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> TOPIC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicId").getter(getter(TopicSummary::topicId)).setter(setter(Builder::topicId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(TopicSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> USER_EXPERIENCE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserExperienceVersion").getter(getter(TopicSummary::userExperienceVersionAsString))
            .setter(setter(Builder::userExperienceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserExperienceVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, TOPIC_ID_FIELD,
            NAME_FIELD, USER_EXPERIENCE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String topicId;

    private final String name;

    private final String userExperienceVersion;

    private TopicSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.topicId = builder.topicId;
        this.name = builder.name;
        this.userExperienceVersion = builder.userExperienceVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the topic.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the topic.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID for the topic. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.
     * </p>
     * 
     * @return The ID for the topic. This ID is unique per Amazon Web Services Region for each Amazon Web Services
     *         account.
     */
    public final String topicId() {
        return topicId;
    }

    /**
     * <p>
     * The name of the topic.
     * </p>
     * 
     * @return The name of the topic.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The user experience version of the topic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #userExperienceVersion} will return {@link TopicUserExperienceVersion#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #userExperienceVersionAsString}.
     * </p>
     * 
     * @return The user experience version of the topic.
     * @see TopicUserExperienceVersion
     */
    public final TopicUserExperienceVersion userExperienceVersion() {
        return TopicUserExperienceVersion.fromValue(userExperienceVersion);
    }

    /**
     * <p>
     * The user experience version of the topic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #userExperienceVersion} will return {@link TopicUserExperienceVersion#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #userExperienceVersionAsString}.
     * </p>
     * 
     * @return The user experience version of the topic.
     * @see TopicUserExperienceVersion
     */
    public final String userExperienceVersionAsString() {
        return userExperienceVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(topicId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(userExperienceVersionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicSummary)) {
            return false;
        }
        TopicSummary other = (TopicSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(topicId(), other.topicId())
                && Objects.equals(name(), other.name())
                && Objects.equals(userExperienceVersionAsString(), other.userExperienceVersionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicSummary").add("Arn", arn()).add("TopicId", topicId()).add("Name", name())
                .add("UserExperienceVersion", userExperienceVersionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "TopicId":
            return Optional.ofNullable(clazz.cast(topicId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "UserExperienceVersion":
            return Optional.ofNullable(clazz.cast(userExperienceVersionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("TopicId", TOPIC_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("UserExperienceVersion", USER_EXPERIENCE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicSummary, T> g) {
        return obj -> g.apply((TopicSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the topic.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID for the topic. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.
         * </p>
         * 
         * @param topicId
         *        The ID for the topic. This ID is unique per Amazon Web Services Region for each Amazon Web Services
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicId(String topicId);

        /**
         * <p>
         * The name of the topic.
         * </p>
         * 
         * @param name
         *        The name of the topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The user experience version of the topic.
         * </p>
         * 
         * @param userExperienceVersion
         *        The user experience version of the topic.
         * @see TopicUserExperienceVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicUserExperienceVersion
         */
        Builder userExperienceVersion(String userExperienceVersion);

        /**
         * <p>
         * The user experience version of the topic.
         * </p>
         * 
         * @param userExperienceVersion
         *        The user experience version of the topic.
         * @see TopicUserExperienceVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicUserExperienceVersion
         */
        Builder userExperienceVersion(TopicUserExperienceVersion userExperienceVersion);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String topicId;

        private String name;

        private String userExperienceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicSummary model) {
            arn(model.arn);
            topicId(model.topicId);
            name(model.name);
            userExperienceVersion(model.userExperienceVersion);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getTopicId() {
            return topicId;
        }

        public final void setTopicId(String topicId) {
            this.topicId = topicId;
        }

        @Override
        public final Builder topicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getUserExperienceVersion() {
            return userExperienceVersion;
        }

        public final void setUserExperienceVersion(String userExperienceVersion) {
            this.userExperienceVersion = userExperienceVersion;
        }

        @Override
        public final Builder userExperienceVersion(String userExperienceVersion) {
            this.userExperienceVersion = userExperienceVersion;
            return this;
        }

        @Override
        public final Builder userExperienceVersion(TopicUserExperienceVersion userExperienceVersion) {
            this.userExperienceVersion(userExperienceVersion == null ? null : userExperienceVersion.toString());
            return this;
        }

        @Override
        public TopicSummary build() {
            return new TopicSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
