/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the source of data for a transform operation, including the source operation and column mappings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransformOperationSource implements SdkPojo, Serializable,
        ToCopyableBuilder<TransformOperationSource.Builder, TransformOperationSource> {
    private static final SdkField<String> TRANSFORM_OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransformOperationId").getter(getter(TransformOperationSource::transformOperationId))
            .setter(setter(Builder::transformOperationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformOperationId").build())
            .build();

    private static final SdkField<List<DataSetColumnIdMapping>> COLUMN_ID_MAPPINGS_FIELD = SdkField
            .<List<DataSetColumnIdMapping>> builder(MarshallingType.LIST)
            .memberName("ColumnIdMappings")
            .getter(getter(TransformOperationSource::columnIdMappings))
            .setter(setter(Builder::columnIdMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnIdMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSetColumnIdMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSetColumnIdMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_OPERATION_ID_FIELD,
            COLUMN_ID_MAPPINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String transformOperationId;

    private final List<DataSetColumnIdMapping> columnIdMappings;

    private TransformOperationSource(BuilderImpl builder) {
        this.transformOperationId = builder.transformOperationId;
        this.columnIdMappings = builder.columnIdMappings;
    }

    /**
     * <p>
     * The identifier of the transform operation that provides input data.
     * </p>
     * 
     * @return The identifier of the transform operation that provides input data.
     */
    public final String transformOperationId() {
        return transformOperationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnIdMappings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasColumnIdMappings() {
        return columnIdMappings != null && !(columnIdMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The mappings between source column identifiers and target column identifiers for this transformation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnIdMappings} method.
     * </p>
     * 
     * @return The mappings between source column identifiers and target column identifiers for this transformation.
     */
    public final List<DataSetColumnIdMapping> columnIdMappings() {
        return columnIdMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transformOperationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnIdMappings() ? columnIdMappings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformOperationSource)) {
            return false;
        }
        TransformOperationSource other = (TransformOperationSource) obj;
        return Objects.equals(transformOperationId(), other.transformOperationId())
                && hasColumnIdMappings() == other.hasColumnIdMappings()
                && Objects.equals(columnIdMappings(), other.columnIdMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransformOperationSource").add("TransformOperationId", transformOperationId())
                .add("ColumnIdMappings", hasColumnIdMappings() ? columnIdMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransformOperationId":
            return Optional.ofNullable(clazz.cast(transformOperationId()));
        case "ColumnIdMappings":
            return Optional.ofNullable(clazz.cast(columnIdMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TransformOperationId", TRANSFORM_OPERATION_ID_FIELD);
        map.put("ColumnIdMappings", COLUMN_ID_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransformOperationSource, T> g) {
        return obj -> g.apply((TransformOperationSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransformOperationSource> {
        /**
         * <p>
         * The identifier of the transform operation that provides input data.
         * </p>
         * 
         * @param transformOperationId
         *        The identifier of the transform operation that provides input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformOperationId(String transformOperationId);

        /**
         * <p>
         * The mappings between source column identifiers and target column identifiers for this transformation.
         * </p>
         * 
         * @param columnIdMappings
         *        The mappings between source column identifiers and target column identifiers for this transformation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnIdMappings(Collection<DataSetColumnIdMapping> columnIdMappings);

        /**
         * <p>
         * The mappings between source column identifiers and target column identifiers for this transformation.
         * </p>
         * 
         * @param columnIdMappings
         *        The mappings between source column identifiers and target column identifiers for this transformation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnIdMappings(DataSetColumnIdMapping... columnIdMappings);

        /**
         * <p>
         * The mappings between source column identifiers and target column identifiers for this transformation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DataSetColumnIdMapping.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.DataSetColumnIdMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DataSetColumnIdMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #columnIdMappings(List<DataSetColumnIdMapping>)}.
         * 
         * @param columnIdMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DataSetColumnIdMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnIdMappings(java.util.Collection<DataSetColumnIdMapping>)
         */
        Builder columnIdMappings(Consumer<DataSetColumnIdMapping.Builder>... columnIdMappings);
    }

    static final class BuilderImpl implements Builder {
        private String transformOperationId;

        private List<DataSetColumnIdMapping> columnIdMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransformOperationSource model) {
            transformOperationId(model.transformOperationId);
            columnIdMappings(model.columnIdMappings);
        }

        public final String getTransformOperationId() {
            return transformOperationId;
        }

        public final void setTransformOperationId(String transformOperationId) {
            this.transformOperationId = transformOperationId;
        }

        @Override
        public final Builder transformOperationId(String transformOperationId) {
            this.transformOperationId = transformOperationId;
            return this;
        }

        public final List<DataSetColumnIdMapping.Builder> getColumnIdMappings() {
            List<DataSetColumnIdMapping.Builder> result = DataSetColumnIdMappingListCopier.copyToBuilder(this.columnIdMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnIdMappings(Collection<DataSetColumnIdMapping.BuilderImpl> columnIdMappings) {
            this.columnIdMappings = DataSetColumnIdMappingListCopier.copyFromBuilder(columnIdMappings);
        }

        @Override
        public final Builder columnIdMappings(Collection<DataSetColumnIdMapping> columnIdMappings) {
            this.columnIdMappings = DataSetColumnIdMappingListCopier.copy(columnIdMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnIdMappings(DataSetColumnIdMapping... columnIdMappings) {
            columnIdMappings(Arrays.asList(columnIdMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnIdMappings(Consumer<DataSetColumnIdMapping.Builder>... columnIdMappings) {
            columnIdMappings(Stream.of(columnIdMappings).map(c -> DataSetColumnIdMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TransformOperationSource build() {
            return new TransformOperationSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
