/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A step in data preparation that performs a specific operation on the data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransformStep implements SdkPojo, Serializable, ToCopyableBuilder<TransformStep.Builder, TransformStep> {
    private static final SdkField<ImportTableOperation> IMPORT_TABLE_STEP_FIELD = SdkField
            .<ImportTableOperation> builder(MarshallingType.SDK_POJO).memberName("ImportTableStep")
            .getter(getter(TransformStep::importTableStep)).setter(setter(Builder::importTableStep))
            .constructor(ImportTableOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportTableStep").build()).build();

    private static final SdkField<ProjectOperation> PROJECT_STEP_FIELD = SdkField
            .<ProjectOperation> builder(MarshallingType.SDK_POJO).memberName("ProjectStep")
            .getter(getter(TransformStep::projectStep)).setter(setter(Builder::projectStep))
            .constructor(ProjectOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectStep").build()).build();

    private static final SdkField<FiltersOperation> FILTERS_STEP_FIELD = SdkField
            .<FiltersOperation> builder(MarshallingType.SDK_POJO).memberName("FiltersStep")
            .getter(getter(TransformStep::filtersStep)).setter(setter(Builder::filtersStep))
            .constructor(FiltersOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FiltersStep").build()).build();

    private static final SdkField<CreateColumnsOperation> CREATE_COLUMNS_STEP_FIELD = SdkField
            .<CreateColumnsOperation> builder(MarshallingType.SDK_POJO).memberName("CreateColumnsStep")
            .getter(getter(TransformStep::createColumnsStep)).setter(setter(Builder::createColumnsStep))
            .constructor(CreateColumnsOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateColumnsStep").build()).build();

    private static final SdkField<RenameColumnsOperation> RENAME_COLUMNS_STEP_FIELD = SdkField
            .<RenameColumnsOperation> builder(MarshallingType.SDK_POJO).memberName("RenameColumnsStep")
            .getter(getter(TransformStep::renameColumnsStep)).setter(setter(Builder::renameColumnsStep))
            .constructor(RenameColumnsOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenameColumnsStep").build()).build();

    private static final SdkField<CastColumnTypesOperation> CAST_COLUMN_TYPES_STEP_FIELD = SdkField
            .<CastColumnTypesOperation> builder(MarshallingType.SDK_POJO).memberName("CastColumnTypesStep")
            .getter(getter(TransformStep::castColumnTypesStep)).setter(setter(Builder::castColumnTypesStep))
            .constructor(CastColumnTypesOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CastColumnTypesStep").build())
            .build();

    private static final SdkField<JoinOperation> JOIN_STEP_FIELD = SdkField.<JoinOperation> builder(MarshallingType.SDK_POJO)
            .memberName("JoinStep").getter(getter(TransformStep::joinStep)).setter(setter(Builder::joinStep))
            .constructor(JoinOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinStep").build()).build();

    private static final SdkField<AggregateOperation> AGGREGATE_STEP_FIELD = SdkField
            .<AggregateOperation> builder(MarshallingType.SDK_POJO).memberName("AggregateStep")
            .getter(getter(TransformStep::aggregateStep)).setter(setter(Builder::aggregateStep))
            .constructor(AggregateOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregateStep").build()).build();

    private static final SdkField<PivotOperation> PIVOT_STEP_FIELD = SdkField.<PivotOperation> builder(MarshallingType.SDK_POJO)
            .memberName("PivotStep").getter(getter(TransformStep::pivotStep)).setter(setter(Builder::pivotStep))
            .constructor(PivotOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PivotStep").build()).build();

    private static final SdkField<UnpivotOperation> UNPIVOT_STEP_FIELD = SdkField
            .<UnpivotOperation> builder(MarshallingType.SDK_POJO).memberName("UnpivotStep")
            .getter(getter(TransformStep::unpivotStep)).setter(setter(Builder::unpivotStep))
            .constructor(UnpivotOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnpivotStep").build()).build();

    private static final SdkField<AppendOperation> APPEND_STEP_FIELD = SdkField
            .<AppendOperation> builder(MarshallingType.SDK_POJO).memberName("AppendStep")
            .getter(getter(TransformStep::appendStep)).setter(setter(Builder::appendStep)).constructor(AppendOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppendStep").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_TABLE_STEP_FIELD,
            PROJECT_STEP_FIELD, FILTERS_STEP_FIELD, CREATE_COLUMNS_STEP_FIELD, RENAME_COLUMNS_STEP_FIELD,
            CAST_COLUMN_TYPES_STEP_FIELD, JOIN_STEP_FIELD, AGGREGATE_STEP_FIELD, PIVOT_STEP_FIELD, UNPIVOT_STEP_FIELD,
            APPEND_STEP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ImportTableOperation importTableStep;

    private final ProjectOperation projectStep;

    private final FiltersOperation filtersStep;

    private final CreateColumnsOperation createColumnsStep;

    private final RenameColumnsOperation renameColumnsStep;

    private final CastColumnTypesOperation castColumnTypesStep;

    private final JoinOperation joinStep;

    private final AggregateOperation aggregateStep;

    private final PivotOperation pivotStep;

    private final UnpivotOperation unpivotStep;

    private final AppendOperation appendStep;

    private TransformStep(BuilderImpl builder) {
        this.importTableStep = builder.importTableStep;
        this.projectStep = builder.projectStep;
        this.filtersStep = builder.filtersStep;
        this.createColumnsStep = builder.createColumnsStep;
        this.renameColumnsStep = builder.renameColumnsStep;
        this.castColumnTypesStep = builder.castColumnTypesStep;
        this.joinStep = builder.joinStep;
        this.aggregateStep = builder.aggregateStep;
        this.pivotStep = builder.pivotStep;
        this.unpivotStep = builder.unpivotStep;
        this.appendStep = builder.appendStep;
    }

    /**
     * <p>
     * A transform step that brings data from a source table.
     * </p>
     * 
     * @return A transform step that brings data from a source table.
     */
    public final ImportTableOperation importTableStep() {
        return importTableStep;
    }

    /**
     * Returns the value of the ProjectStep property for this object.
     * 
     * @return The value of the ProjectStep property for this object.
     */
    public final ProjectOperation projectStep() {
        return projectStep;
    }

    /**
     * <p>
     * A transform step that applies filter conditions.
     * </p>
     * 
     * @return A transform step that applies filter conditions.
     */
    public final FiltersOperation filtersStep() {
        return filtersStep;
    }

    /**
     * Returns the value of the CreateColumnsStep property for this object.
     * 
     * @return The value of the CreateColumnsStep property for this object.
     */
    public final CreateColumnsOperation createColumnsStep() {
        return createColumnsStep;
    }

    /**
     * <p>
     * A transform step that changes the names of one or more columns.
     * </p>
     * 
     * @return A transform step that changes the names of one or more columns.
     */
    public final RenameColumnsOperation renameColumnsStep() {
        return renameColumnsStep;
    }

    /**
     * <p>
     * A transform step that changes the data types of one or more columns.
     * </p>
     * 
     * @return A transform step that changes the data types of one or more columns.
     */
    public final CastColumnTypesOperation castColumnTypesStep() {
        return castColumnTypesStep;
    }

    /**
     * <p>
     * A transform step that combines data from two sources based on specified join conditions.
     * </p>
     * 
     * @return A transform step that combines data from two sources based on specified join conditions.
     */
    public final JoinOperation joinStep() {
        return joinStep;
    }

    /**
     * <p>
     * A transform step that groups data and applies aggregation functions to calculate summary values.
     * </p>
     * 
     * @return A transform step that groups data and applies aggregation functions to calculate summary values.
     */
    public final AggregateOperation aggregateStep() {
        return aggregateStep;
    }

    /**
     * <p>
     * A transform step that converts row values into columns to reshape the data structure.
     * </p>
     * 
     * @return A transform step that converts row values into columns to reshape the data structure.
     */
    public final PivotOperation pivotStep() {
        return pivotStep;
    }

    /**
     * <p>
     * A transform step that converts columns into rows to normalize the data structure.
     * </p>
     * 
     * @return A transform step that converts columns into rows to normalize the data structure.
     */
    public final UnpivotOperation unpivotStep() {
        return unpivotStep;
    }

    /**
     * <p>
     * A transform step that combines rows from multiple sources by stacking them vertically.
     * </p>
     * 
     * @return A transform step that combines rows from multiple sources by stacking them vertically.
     */
    public final AppendOperation appendStep() {
        return appendStep;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(importTableStep());
        hashCode = 31 * hashCode + Objects.hashCode(projectStep());
        hashCode = 31 * hashCode + Objects.hashCode(filtersStep());
        hashCode = 31 * hashCode + Objects.hashCode(createColumnsStep());
        hashCode = 31 * hashCode + Objects.hashCode(renameColumnsStep());
        hashCode = 31 * hashCode + Objects.hashCode(castColumnTypesStep());
        hashCode = 31 * hashCode + Objects.hashCode(joinStep());
        hashCode = 31 * hashCode + Objects.hashCode(aggregateStep());
        hashCode = 31 * hashCode + Objects.hashCode(pivotStep());
        hashCode = 31 * hashCode + Objects.hashCode(unpivotStep());
        hashCode = 31 * hashCode + Objects.hashCode(appendStep());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformStep)) {
            return false;
        }
        TransformStep other = (TransformStep) obj;
        return Objects.equals(importTableStep(), other.importTableStep()) && Objects.equals(projectStep(), other.projectStep())
                && Objects.equals(filtersStep(), other.filtersStep())
                && Objects.equals(createColumnsStep(), other.createColumnsStep())
                && Objects.equals(renameColumnsStep(), other.renameColumnsStep())
                && Objects.equals(castColumnTypesStep(), other.castColumnTypesStep())
                && Objects.equals(joinStep(), other.joinStep()) && Objects.equals(aggregateStep(), other.aggregateStep())
                && Objects.equals(pivotStep(), other.pivotStep()) && Objects.equals(unpivotStep(), other.unpivotStep())
                && Objects.equals(appendStep(), other.appendStep());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransformStep").add("ImportTableStep", importTableStep()).add("ProjectStep", projectStep())
                .add("FiltersStep", filtersStep()).add("CreateColumnsStep", createColumnsStep())
                .add("RenameColumnsStep", renameColumnsStep()).add("CastColumnTypesStep", castColumnTypesStep())
                .add("JoinStep", joinStep()).add("AggregateStep", aggregateStep()).add("PivotStep", pivotStep())
                .add("UnpivotStep", unpivotStep()).add("AppendStep", appendStep()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportTableStep":
            return Optional.ofNullable(clazz.cast(importTableStep()));
        case "ProjectStep":
            return Optional.ofNullable(clazz.cast(projectStep()));
        case "FiltersStep":
            return Optional.ofNullable(clazz.cast(filtersStep()));
        case "CreateColumnsStep":
            return Optional.ofNullable(clazz.cast(createColumnsStep()));
        case "RenameColumnsStep":
            return Optional.ofNullable(clazz.cast(renameColumnsStep()));
        case "CastColumnTypesStep":
            return Optional.ofNullable(clazz.cast(castColumnTypesStep()));
        case "JoinStep":
            return Optional.ofNullable(clazz.cast(joinStep()));
        case "AggregateStep":
            return Optional.ofNullable(clazz.cast(aggregateStep()));
        case "PivotStep":
            return Optional.ofNullable(clazz.cast(pivotStep()));
        case "UnpivotStep":
            return Optional.ofNullable(clazz.cast(unpivotStep()));
        case "AppendStep":
            return Optional.ofNullable(clazz.cast(appendStep()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ImportTableStep", IMPORT_TABLE_STEP_FIELD);
        map.put("ProjectStep", PROJECT_STEP_FIELD);
        map.put("FiltersStep", FILTERS_STEP_FIELD);
        map.put("CreateColumnsStep", CREATE_COLUMNS_STEP_FIELD);
        map.put("RenameColumnsStep", RENAME_COLUMNS_STEP_FIELD);
        map.put("CastColumnTypesStep", CAST_COLUMN_TYPES_STEP_FIELD);
        map.put("JoinStep", JOIN_STEP_FIELD);
        map.put("AggregateStep", AGGREGATE_STEP_FIELD);
        map.put("PivotStep", PIVOT_STEP_FIELD);
        map.put("UnpivotStep", UNPIVOT_STEP_FIELD);
        map.put("AppendStep", APPEND_STEP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransformStep, T> g) {
        return obj -> g.apply((TransformStep) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransformStep> {
        /**
         * <p>
         * A transform step that brings data from a source table.
         * </p>
         * 
         * @param importTableStep
         *        A transform step that brings data from a source table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTableStep(ImportTableOperation importTableStep);

        /**
         * <p>
         * A transform step that brings data from a source table.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportTableOperation.Builder} avoiding
         * the need to create one manually via {@link ImportTableOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportTableOperation.Builder#build()} is called immediately and
         * its result is passed to {@link #importTableStep(ImportTableOperation)}.
         * 
         * @param importTableStep
         *        a consumer that will call methods on {@link ImportTableOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importTableStep(ImportTableOperation)
         */
        default Builder importTableStep(Consumer<ImportTableOperation.Builder> importTableStep) {
            return importTableStep(ImportTableOperation.builder().applyMutation(importTableStep).build());
        }

        /**
         * Sets the value of the ProjectStep property for this object.
         *
         * @param projectStep
         *        The new value for the ProjectStep property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectStep(ProjectOperation projectStep);

        /**
         * Sets the value of the ProjectStep property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ProjectOperation.Builder} avoiding the
         * need to create one manually via {@link ProjectOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProjectOperation.Builder#build()} is called immediately and its
         * result is passed to {@link #projectStep(ProjectOperation)}.
         * 
         * @param projectStep
         *        a consumer that will call methods on {@link ProjectOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projectStep(ProjectOperation)
         */
        default Builder projectStep(Consumer<ProjectOperation.Builder> projectStep) {
            return projectStep(ProjectOperation.builder().applyMutation(projectStep).build());
        }

        /**
         * <p>
         * A transform step that applies filter conditions.
         * </p>
         * 
         * @param filtersStep
         *        A transform step that applies filter conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filtersStep(FiltersOperation filtersStep);

        /**
         * <p>
         * A transform step that applies filter conditions.
         * </p>
         * This is a convenience method that creates an instance of the {@link FiltersOperation.Builder} avoiding the
         * need to create one manually via {@link FiltersOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FiltersOperation.Builder#build()} is called immediately and its
         * result is passed to {@link #filtersStep(FiltersOperation)}.
         * 
         * @param filtersStep
         *        a consumer that will call methods on {@link FiltersOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filtersStep(FiltersOperation)
         */
        default Builder filtersStep(Consumer<FiltersOperation.Builder> filtersStep) {
            return filtersStep(FiltersOperation.builder().applyMutation(filtersStep).build());
        }

        /**
         * Sets the value of the CreateColumnsStep property for this object.
         *
         * @param createColumnsStep
         *        The new value for the CreateColumnsStep property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createColumnsStep(CreateColumnsOperation createColumnsStep);

        /**
         * Sets the value of the CreateColumnsStep property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CreateColumnsOperation.Builder} avoiding
         * the need to create one manually via {@link CreateColumnsOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateColumnsOperation.Builder#build()} is called immediately and
         * its result is passed to {@link #createColumnsStep(CreateColumnsOperation)}.
         * 
         * @param createColumnsStep
         *        a consumer that will call methods on {@link CreateColumnsOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createColumnsStep(CreateColumnsOperation)
         */
        default Builder createColumnsStep(Consumer<CreateColumnsOperation.Builder> createColumnsStep) {
            return createColumnsStep(CreateColumnsOperation.builder().applyMutation(createColumnsStep).build());
        }

        /**
         * <p>
         * A transform step that changes the names of one or more columns.
         * </p>
         * 
         * @param renameColumnsStep
         *        A transform step that changes the names of one or more columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renameColumnsStep(RenameColumnsOperation renameColumnsStep);

        /**
         * <p>
         * A transform step that changes the names of one or more columns.
         * </p>
         * This is a convenience method that creates an instance of the {@link RenameColumnsOperation.Builder} avoiding
         * the need to create one manually via {@link RenameColumnsOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RenameColumnsOperation.Builder#build()} is called immediately and
         * its result is passed to {@link #renameColumnsStep(RenameColumnsOperation)}.
         * 
         * @param renameColumnsStep
         *        a consumer that will call methods on {@link RenameColumnsOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #renameColumnsStep(RenameColumnsOperation)
         */
        default Builder renameColumnsStep(Consumer<RenameColumnsOperation.Builder> renameColumnsStep) {
            return renameColumnsStep(RenameColumnsOperation.builder().applyMutation(renameColumnsStep).build());
        }

        /**
         * <p>
         * A transform step that changes the data types of one or more columns.
         * </p>
         * 
         * @param castColumnTypesStep
         *        A transform step that changes the data types of one or more columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder castColumnTypesStep(CastColumnTypesOperation castColumnTypesStep);

        /**
         * <p>
         * A transform step that changes the data types of one or more columns.
         * </p>
         * This is a convenience method that creates an instance of the {@link CastColumnTypesOperation.Builder}
         * avoiding the need to create one manually via {@link CastColumnTypesOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CastColumnTypesOperation.Builder#build()} is called immediately
         * and its result is passed to {@link #castColumnTypesStep(CastColumnTypesOperation)}.
         * 
         * @param castColumnTypesStep
         *        a consumer that will call methods on {@link CastColumnTypesOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #castColumnTypesStep(CastColumnTypesOperation)
         */
        default Builder castColumnTypesStep(Consumer<CastColumnTypesOperation.Builder> castColumnTypesStep) {
            return castColumnTypesStep(CastColumnTypesOperation.builder().applyMutation(castColumnTypesStep).build());
        }

        /**
         * <p>
         * A transform step that combines data from two sources based on specified join conditions.
         * </p>
         * 
         * @param joinStep
         *        A transform step that combines data from two sources based on specified join conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder joinStep(JoinOperation joinStep);

        /**
         * <p>
         * A transform step that combines data from two sources based on specified join conditions.
         * </p>
         * This is a convenience method that creates an instance of the {@link JoinOperation.Builder} avoiding the need
         * to create one manually via {@link JoinOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JoinOperation.Builder#build()} is called immediately and its
         * result is passed to {@link #joinStep(JoinOperation)}.
         * 
         * @param joinStep
         *        a consumer that will call methods on {@link JoinOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #joinStep(JoinOperation)
         */
        default Builder joinStep(Consumer<JoinOperation.Builder> joinStep) {
            return joinStep(JoinOperation.builder().applyMutation(joinStep).build());
        }

        /**
         * <p>
         * A transform step that groups data and applies aggregation functions to calculate summary values.
         * </p>
         * 
         * @param aggregateStep
         *        A transform step that groups data and applies aggregation functions to calculate summary values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateStep(AggregateOperation aggregateStep);

        /**
         * <p>
         * A transform step that groups data and applies aggregation functions to calculate summary values.
         * </p>
         * This is a convenience method that creates an instance of the {@link AggregateOperation.Builder} avoiding the
         * need to create one manually via {@link AggregateOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AggregateOperation.Builder#build()} is called immediately and its
         * result is passed to {@link #aggregateStep(AggregateOperation)}.
         * 
         * @param aggregateStep
         *        a consumer that will call methods on {@link AggregateOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregateStep(AggregateOperation)
         */
        default Builder aggregateStep(Consumer<AggregateOperation.Builder> aggregateStep) {
            return aggregateStep(AggregateOperation.builder().applyMutation(aggregateStep).build());
        }

        /**
         * <p>
         * A transform step that converts row values into columns to reshape the data structure.
         * </p>
         * 
         * @param pivotStep
         *        A transform step that converts row values into columns to reshape the data structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pivotStep(PivotOperation pivotStep);

        /**
         * <p>
         * A transform step that converts row values into columns to reshape the data structure.
         * </p>
         * This is a convenience method that creates an instance of the {@link PivotOperation.Builder} avoiding the need
         * to create one manually via {@link PivotOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PivotOperation.Builder#build()} is called immediately and its
         * result is passed to {@link #pivotStep(PivotOperation)}.
         * 
         * @param pivotStep
         *        a consumer that will call methods on {@link PivotOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pivotStep(PivotOperation)
         */
        default Builder pivotStep(Consumer<PivotOperation.Builder> pivotStep) {
            return pivotStep(PivotOperation.builder().applyMutation(pivotStep).build());
        }

        /**
         * <p>
         * A transform step that converts columns into rows to normalize the data structure.
         * </p>
         * 
         * @param unpivotStep
         *        A transform step that converts columns into rows to normalize the data structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unpivotStep(UnpivotOperation unpivotStep);

        /**
         * <p>
         * A transform step that converts columns into rows to normalize the data structure.
         * </p>
         * This is a convenience method that creates an instance of the {@link UnpivotOperation.Builder} avoiding the
         * need to create one manually via {@link UnpivotOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UnpivotOperation.Builder#build()} is called immediately and its
         * result is passed to {@link #unpivotStep(UnpivotOperation)}.
         * 
         * @param unpivotStep
         *        a consumer that will call methods on {@link UnpivotOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unpivotStep(UnpivotOperation)
         */
        default Builder unpivotStep(Consumer<UnpivotOperation.Builder> unpivotStep) {
            return unpivotStep(UnpivotOperation.builder().applyMutation(unpivotStep).build());
        }

        /**
         * <p>
         * A transform step that combines rows from multiple sources by stacking them vertically.
         * </p>
         * 
         * @param appendStep
         *        A transform step that combines rows from multiple sources by stacking them vertically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appendStep(AppendOperation appendStep);

        /**
         * <p>
         * A transform step that combines rows from multiple sources by stacking them vertically.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppendOperation.Builder} avoiding the
         * need to create one manually via {@link AppendOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppendOperation.Builder#build()} is called immediately and its
         * result is passed to {@link #appendStep(AppendOperation)}.
         * 
         * @param appendStep
         *        a consumer that will call methods on {@link AppendOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appendStep(AppendOperation)
         */
        default Builder appendStep(Consumer<AppendOperation.Builder> appendStep) {
            return appendStep(AppendOperation.builder().applyMutation(appendStep).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ImportTableOperation importTableStep;

        private ProjectOperation projectStep;

        private FiltersOperation filtersStep;

        private CreateColumnsOperation createColumnsStep;

        private RenameColumnsOperation renameColumnsStep;

        private CastColumnTypesOperation castColumnTypesStep;

        private JoinOperation joinStep;

        private AggregateOperation aggregateStep;

        private PivotOperation pivotStep;

        private UnpivotOperation unpivotStep;

        private AppendOperation appendStep;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformStep model) {
            importTableStep(model.importTableStep);
            projectStep(model.projectStep);
            filtersStep(model.filtersStep);
            createColumnsStep(model.createColumnsStep);
            renameColumnsStep(model.renameColumnsStep);
            castColumnTypesStep(model.castColumnTypesStep);
            joinStep(model.joinStep);
            aggregateStep(model.aggregateStep);
            pivotStep(model.pivotStep);
            unpivotStep(model.unpivotStep);
            appendStep(model.appendStep);
        }

        public final ImportTableOperation.Builder getImportTableStep() {
            return importTableStep != null ? importTableStep.toBuilder() : null;
        }

        public final void setImportTableStep(ImportTableOperation.BuilderImpl importTableStep) {
            this.importTableStep = importTableStep != null ? importTableStep.build() : null;
        }

        @Override
        public final Builder importTableStep(ImportTableOperation importTableStep) {
            this.importTableStep = importTableStep;
            return this;
        }

        public final ProjectOperation.Builder getProjectStep() {
            return projectStep != null ? projectStep.toBuilder() : null;
        }

        public final void setProjectStep(ProjectOperation.BuilderImpl projectStep) {
            this.projectStep = projectStep != null ? projectStep.build() : null;
        }

        @Override
        public final Builder projectStep(ProjectOperation projectStep) {
            this.projectStep = projectStep;
            return this;
        }

        public final FiltersOperation.Builder getFiltersStep() {
            return filtersStep != null ? filtersStep.toBuilder() : null;
        }

        public final void setFiltersStep(FiltersOperation.BuilderImpl filtersStep) {
            this.filtersStep = filtersStep != null ? filtersStep.build() : null;
        }

        @Override
        public final Builder filtersStep(FiltersOperation filtersStep) {
            this.filtersStep = filtersStep;
            return this;
        }

        public final CreateColumnsOperation.Builder getCreateColumnsStep() {
            return createColumnsStep != null ? createColumnsStep.toBuilder() : null;
        }

        public final void setCreateColumnsStep(CreateColumnsOperation.BuilderImpl createColumnsStep) {
            this.createColumnsStep = createColumnsStep != null ? createColumnsStep.build() : null;
        }

        @Override
        public final Builder createColumnsStep(CreateColumnsOperation createColumnsStep) {
            this.createColumnsStep = createColumnsStep;
            return this;
        }

        public final RenameColumnsOperation.Builder getRenameColumnsStep() {
            return renameColumnsStep != null ? renameColumnsStep.toBuilder() : null;
        }

        public final void setRenameColumnsStep(RenameColumnsOperation.BuilderImpl renameColumnsStep) {
            this.renameColumnsStep = renameColumnsStep != null ? renameColumnsStep.build() : null;
        }

        @Override
        public final Builder renameColumnsStep(RenameColumnsOperation renameColumnsStep) {
            this.renameColumnsStep = renameColumnsStep;
            return this;
        }

        public final CastColumnTypesOperation.Builder getCastColumnTypesStep() {
            return castColumnTypesStep != null ? castColumnTypesStep.toBuilder() : null;
        }

        public final void setCastColumnTypesStep(CastColumnTypesOperation.BuilderImpl castColumnTypesStep) {
            this.castColumnTypesStep = castColumnTypesStep != null ? castColumnTypesStep.build() : null;
        }

        @Override
        public final Builder castColumnTypesStep(CastColumnTypesOperation castColumnTypesStep) {
            this.castColumnTypesStep = castColumnTypesStep;
            return this;
        }

        public final JoinOperation.Builder getJoinStep() {
            return joinStep != null ? joinStep.toBuilder() : null;
        }

        public final void setJoinStep(JoinOperation.BuilderImpl joinStep) {
            this.joinStep = joinStep != null ? joinStep.build() : null;
        }

        @Override
        public final Builder joinStep(JoinOperation joinStep) {
            this.joinStep = joinStep;
            return this;
        }

        public final AggregateOperation.Builder getAggregateStep() {
            return aggregateStep != null ? aggregateStep.toBuilder() : null;
        }

        public final void setAggregateStep(AggregateOperation.BuilderImpl aggregateStep) {
            this.aggregateStep = aggregateStep != null ? aggregateStep.build() : null;
        }

        @Override
        public final Builder aggregateStep(AggregateOperation aggregateStep) {
            this.aggregateStep = aggregateStep;
            return this;
        }

        public final PivotOperation.Builder getPivotStep() {
            return pivotStep != null ? pivotStep.toBuilder() : null;
        }

        public final void setPivotStep(PivotOperation.BuilderImpl pivotStep) {
            this.pivotStep = pivotStep != null ? pivotStep.build() : null;
        }

        @Override
        public final Builder pivotStep(PivotOperation pivotStep) {
            this.pivotStep = pivotStep;
            return this;
        }

        public final UnpivotOperation.Builder getUnpivotStep() {
            return unpivotStep != null ? unpivotStep.toBuilder() : null;
        }

        public final void setUnpivotStep(UnpivotOperation.BuilderImpl unpivotStep) {
            this.unpivotStep = unpivotStep != null ? unpivotStep.build() : null;
        }

        @Override
        public final Builder unpivotStep(UnpivotOperation unpivotStep) {
            this.unpivotStep = unpivotStep;
            return this;
        }

        public final AppendOperation.Builder getAppendStep() {
            return appendStep != null ? appendStep.toBuilder() : null;
        }

        public final void setAppendStep(AppendOperation.BuilderImpl appendStep) {
            this.appendStep = appendStep != null ? appendStep.build() : null;
        }

        @Override
        public final Builder appendStep(AppendOperation appendStep) {
            this.appendStep = appendStep;
            return this;
        }

        @Override
        public TransformStep build() {
            return new TransformStep(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
