/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateActionConnectorRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateActionConnectorRequest.Builder, UpdateActionConnectorRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(UpdateActionConnectorRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> ACTION_CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionConnectorId").getter(getter(UpdateActionConnectorRequest::actionConnectorId))
            .setter(setter(Builder::actionConnectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ActionConnectorId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateActionConnectorRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<AuthConfig> AUTHENTICATION_CONFIG_FIELD = SdkField
            .<AuthConfig> builder(MarshallingType.SDK_POJO).memberName("AuthenticationConfig")
            .getter(getter(UpdateActionConnectorRequest::authenticationConfig)).setter(setter(Builder::authenticationConfig))
            .constructor(AuthConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationConfig").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateActionConnectorRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> VPC_CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcConnectionArn").getter(getter(UpdateActionConnectorRequest::vpcConnectionArn))
            .setter(setter(Builder::vpcConnectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConnectionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            ACTION_CONNECTOR_ID_FIELD, NAME_FIELD, AUTHENTICATION_CONFIG_FIELD, DESCRIPTION_FIELD, VPC_CONNECTION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String actionConnectorId;

    private final String name;

    private final AuthConfig authenticationConfig;

    private final String description;

    private final String vpcConnectionArn;

    private UpdateActionConnectorRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.actionConnectorId = builder.actionConnectorId;
        this.name = builder.name;
        this.authenticationConfig = builder.authenticationConfig;
        this.description = builder.description;
        this.vpcConnectionArn = builder.vpcConnectionArn;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that contains the action connector to update.
     * </p>
     * 
     * @return The Amazon Web Services account ID that contains the action connector to update.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The unique identifier of the action connector to update.
     * </p>
     * 
     * @return The unique identifier of the action connector to update.
     */
    public final String actionConnectorId() {
        return actionConnectorId;
    }

    /**
     * <p>
     * The new name for the action connector.
     * </p>
     * 
     * @return The new name for the action connector.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The updated authentication configuration for connecting to the external service.
     * </p>
     * 
     * @return The updated authentication configuration for connecting to the external service.
     */
    public final AuthConfig authenticationConfig() {
        return authenticationConfig;
    }

    /**
     * <p>
     * The updated description of the action connector.
     * </p>
     * 
     * @return The updated description of the action connector.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The updated ARN of the VPC connection to use for secure connectivity.
     * </p>
     * 
     * @return The updated ARN of the VPC connection to use for secure connectivity.
     */
    public final String vpcConnectionArn() {
        return vpcConnectionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(actionConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConnectionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateActionConnectorRequest)) {
            return false;
        }
        UpdateActionConnectorRequest other = (UpdateActionConnectorRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(actionConnectorId(), other.actionConnectorId()) && Objects.equals(name(), other.name())
                && Objects.equals(authenticationConfig(), other.authenticationConfig())
                && Objects.equals(description(), other.description())
                && Objects.equals(vpcConnectionArn(), other.vpcConnectionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateActionConnectorRequest").add("AwsAccountId", awsAccountId())
                .add("ActionConnectorId", actionConnectorId())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AuthenticationConfig", authenticationConfig())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("VpcConnectionArn", vpcConnectionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "ActionConnectorId":
            return Optional.ofNullable(clazz.cast(actionConnectorId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "AuthenticationConfig":
            return Optional.ofNullable(clazz.cast(authenticationConfig()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "VpcConnectionArn":
            return Optional.ofNullable(clazz.cast(vpcConnectionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("ActionConnectorId", ACTION_CONNECTOR_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("AuthenticationConfig", AUTHENTICATION_CONFIG_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("VpcConnectionArn", VPC_CONNECTION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateActionConnectorRequest, T> g) {
        return obj -> g.apply((UpdateActionConnectorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateActionConnectorRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID that contains the action connector to update.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services account ID that contains the action connector to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The unique identifier of the action connector to update.
         * </p>
         * 
         * @param actionConnectorId
         *        The unique identifier of the action connector to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionConnectorId(String actionConnectorId);

        /**
         * <p>
         * The new name for the action connector.
         * </p>
         * 
         * @param name
         *        The new name for the action connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The updated authentication configuration for connecting to the external service.
         * </p>
         * 
         * @param authenticationConfig
         *        The updated authentication configuration for connecting to the external service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationConfig(AuthConfig authenticationConfig);

        /**
         * <p>
         * The updated authentication configuration for connecting to the external service.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthConfig.Builder} avoiding the need to
         * create one manually via {@link AuthConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #authenticationConfig(AuthConfig)}.
         * 
         * @param authenticationConfig
         *        a consumer that will call methods on {@link AuthConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationConfig(AuthConfig)
         */
        default Builder authenticationConfig(Consumer<AuthConfig.Builder> authenticationConfig) {
            return authenticationConfig(AuthConfig.builder().applyMutation(authenticationConfig).build());
        }

        /**
         * <p>
         * The updated description of the action connector.
         * </p>
         * 
         * @param description
         *        The updated description of the action connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The updated ARN of the VPC connection to use for secure connectivity.
         * </p>
         * 
         * @param vpcConnectionArn
         *        The updated ARN of the VPC connection to use for secure connectivity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConnectionArn(String vpcConnectionArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String actionConnectorId;

        private String name;

        private AuthConfig authenticationConfig;

        private String description;

        private String vpcConnectionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateActionConnectorRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            actionConnectorId(model.actionConnectorId);
            name(model.name);
            authenticationConfig(model.authenticationConfig);
            description(model.description);
            vpcConnectionArn(model.vpcConnectionArn);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getActionConnectorId() {
            return actionConnectorId;
        }

        public final void setActionConnectorId(String actionConnectorId) {
            this.actionConnectorId = actionConnectorId;
        }

        @Override
        public final Builder actionConnectorId(String actionConnectorId) {
            this.actionConnectorId = actionConnectorId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AuthConfig.Builder getAuthenticationConfig() {
            return authenticationConfig != null ? authenticationConfig.toBuilder() : null;
        }

        public final void setAuthenticationConfig(AuthConfig.BuilderImpl authenticationConfig) {
            this.authenticationConfig = authenticationConfig != null ? authenticationConfig.build() : null;
        }

        @Override
        public final Builder authenticationConfig(AuthConfig authenticationConfig) {
            this.authenticationConfig = authenticationConfig;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getVpcConnectionArn() {
            return vpcConnectionArn;
        }

        public final void setVpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
        }

        @Override
        public final Builder vpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateActionConnectorRequest build() {
            return new UpdateActionConnectorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
