/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateQuickSightQSearchConfigurationRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateQuickSightQSearchConfigurationRequest.Builder, UpdateQuickSightQSearchConfigurationRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(UpdateQuickSightQSearchConfigurationRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> Q_SEARCH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QSearchStatus").getter(getter(UpdateQuickSightQSearchConfigurationRequest::qSearchStatusAsString))
            .setter(setter(Builder::qSearchStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QSearchStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            Q_SEARCH_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String qSearchStatus;

    private UpdateQuickSightQSearchConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.qSearchStatus = builder.qSearchStatus;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that contains the Quick Sight Q Search configuration that you want to
     * update.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that contains the Quick Sight Q Search configuration that you
     *         want to update.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The status of the Quick Sight Q Search configuration that the user wants to update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #qSearchStatus}
     * will return {@link QSearchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #qSearchStatusAsString}.
     * </p>
     * 
     * @return The status of the Quick Sight Q Search configuration that the user wants to update.
     * @see QSearchStatus
     */
    public final QSearchStatus qSearchStatus() {
        return QSearchStatus.fromValue(qSearchStatus);
    }

    /**
     * <p>
     * The status of the Quick Sight Q Search configuration that the user wants to update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #qSearchStatus}
     * will return {@link QSearchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #qSearchStatusAsString}.
     * </p>
     * 
     * @return The status of the Quick Sight Q Search configuration that the user wants to update.
     * @see QSearchStatus
     */
    public final String qSearchStatusAsString() {
        return qSearchStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(qSearchStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQuickSightQSearchConfigurationRequest)) {
            return false;
        }
        UpdateQuickSightQSearchConfigurationRequest other = (UpdateQuickSightQSearchConfigurationRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(qSearchStatusAsString(), other.qSearchStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateQuickSightQSearchConfigurationRequest").add("AwsAccountId", awsAccountId())
                .add("QSearchStatus", qSearchStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "QSearchStatus":
            return Optional.ofNullable(clazz.cast(qSearchStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("QSearchStatus", Q_SEARCH_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateQuickSightQSearchConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateQuickSightQSearchConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateQuickSightQSearchConfigurationRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that contains the Quick Sight Q Search configuration that you want
         * to update.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that contains the Quick Sight Q Search configuration that
         *        you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The status of the Quick Sight Q Search configuration that the user wants to update.
         * </p>
         * 
         * @param qSearchStatus
         *        The status of the Quick Sight Q Search configuration that the user wants to update.
         * @see QSearchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QSearchStatus
         */
        Builder qSearchStatus(String qSearchStatus);

        /**
         * <p>
         * The status of the Quick Sight Q Search configuration that the user wants to update.
         * </p>
         * 
         * @param qSearchStatus
         *        The status of the Quick Sight Q Search configuration that the user wants to update.
         * @see QSearchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QSearchStatus
         */
        Builder qSearchStatus(QSearchStatus qSearchStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String qSearchStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQuickSightQSearchConfigurationRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            qSearchStatus(model.qSearchStatus);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getQSearchStatus() {
            return qSearchStatus;
        }

        public final void setQSearchStatus(String qSearchStatus) {
            this.qSearchStatus = qSearchStatus;
        }

        @Override
        public final Builder qSearchStatus(String qSearchStatus) {
            this.qSearchStatus = qSearchStatus;
            return this;
        }

        @Override
        public final Builder qSearchStatus(QSearchStatus qSearchStatus) {
            this.qSearchStatus(qSearchStatus == null ? null : qSearchStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQuickSightQSearchConfigurationRequest build() {
            return new UpdateQuickSightQSearchConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
