/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTopicRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateTopicRequest.Builder, UpdateTopicRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(UpdateTopicRequest::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> TOPIC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicId").getter(getter(UpdateTopicRequest::topicId)).setter(setter(Builder::topicId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TopicId").build()).build();

    private static final SdkField<TopicDetails> TOPIC_FIELD = SdkField.<TopicDetails> builder(MarshallingType.SDK_POJO)
            .memberName("Topic").getter(getter(UpdateTopicRequest::topic)).setter(setter(Builder::topic))
            .constructor(TopicDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Topic").build()).build();

    private static final SdkField<CustomInstructions> CUSTOM_INSTRUCTIONS_FIELD = SdkField
            .<CustomInstructions> builder(MarshallingType.SDK_POJO).memberName("CustomInstructions")
            .getter(getter(UpdateTopicRequest::customInstructions)).setter(setter(Builder::customInstructions))
            .constructor(CustomInstructions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomInstructions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            TOPIC_ID_FIELD, TOPIC_FIELD, CUSTOM_INSTRUCTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String topicId;

    private final TopicDetails topic;

    private final CustomInstructions customInstructions;

    private UpdateTopicRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.topicId = builder.topicId;
        this.topic = builder.topic;
        this.customInstructions = builder.customInstructions;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that contains the topic that you want to update.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that contains the topic that you want to update.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID of the topic that you want to modify. This ID is unique per Amazon Web Services Region for each Amazon Web
     * Services account.
     * </p>
     * 
     * @return The ID of the topic that you want to modify. This ID is unique per Amazon Web Services Region for each
     *         Amazon Web Services account.
     */
    public final String topicId() {
        return topicId;
    }

    /**
     * <p>
     * The definition of the topic that you want to update.
     * </p>
     * 
     * @return The definition of the topic that you want to update.
     */
    public final TopicDetails topic() {
        return topic;
    }

    /**
     * <p>
     * Custom instructions for the topic.
     * </p>
     * 
     * @return Custom instructions for the topic.
     */
    public final CustomInstructions customInstructions() {
        return customInstructions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(topicId());
        hashCode = 31 * hashCode + Objects.hashCode(topic());
        hashCode = 31 * hashCode + Objects.hashCode(customInstructions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTopicRequest)) {
            return false;
        }
        UpdateTopicRequest other = (UpdateTopicRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(topicId(), other.topicId())
                && Objects.equals(topic(), other.topic()) && Objects.equals(customInstructions(), other.customInstructions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTopicRequest").add("AwsAccountId", awsAccountId()).add("TopicId", topicId())
                .add("Topic", topic()).add("CustomInstructions", customInstructions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "TopicId":
            return Optional.ofNullable(clazz.cast(topicId()));
        case "Topic":
            return Optional.ofNullable(clazz.cast(topic()));
        case "CustomInstructions":
            return Optional.ofNullable(clazz.cast(customInstructions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("TopicId", TOPIC_ID_FIELD);
        map.put("Topic", TOPIC_FIELD);
        map.put("CustomInstructions", CUSTOM_INSTRUCTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTopicRequest, T> g) {
        return obj -> g.apply((UpdateTopicRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTopicRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that contains the topic that you want to update.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that contains the topic that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID of the topic that you want to modify. This ID is unique per Amazon Web Services Region for each Amazon
         * Web Services account.
         * </p>
         * 
         * @param topicId
         *        The ID of the topic that you want to modify. This ID is unique per Amazon Web Services Region for each
         *        Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicId(String topicId);

        /**
         * <p>
         * The definition of the topic that you want to update.
         * </p>
         * 
         * @param topic
         *        The definition of the topic that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topic(TopicDetails topic);

        /**
         * <p>
         * The definition of the topic that you want to update.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicDetails.Builder} avoiding the need
         * to create one manually via {@link TopicDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #topic(TopicDetails)}.
         * 
         * @param topic
         *        a consumer that will call methods on {@link TopicDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topic(TopicDetails)
         */
        default Builder topic(Consumer<TopicDetails.Builder> topic) {
            return topic(TopicDetails.builder().applyMutation(topic).build());
        }

        /**
         * <p>
         * Custom instructions for the topic.
         * </p>
         * 
         * @param customInstructions
         *        Custom instructions for the topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customInstructions(CustomInstructions customInstructions);

        /**
         * <p>
         * Custom instructions for the topic.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomInstructions.Builder} avoiding the
         * need to create one manually via {@link CustomInstructions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomInstructions.Builder#build()} is called immediately and its
         * result is passed to {@link #customInstructions(CustomInstructions)}.
         * 
         * @param customInstructions
         *        a consumer that will call methods on {@link CustomInstructions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customInstructions(CustomInstructions)
         */
        default Builder customInstructions(Consumer<CustomInstructions.Builder> customInstructions) {
            return customInstructions(CustomInstructions.builder().applyMutation(customInstructions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String topicId;

        private TopicDetails topic;

        private CustomInstructions customInstructions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTopicRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            topicId(model.topicId);
            topic(model.topic);
            customInstructions(model.customInstructions);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getTopicId() {
            return topicId;
        }

        public final void setTopicId(String topicId) {
            this.topicId = topicId;
        }

        @Override
        public final Builder topicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        public final TopicDetails.Builder getTopic() {
            return topic != null ? topic.toBuilder() : null;
        }

        public final void setTopic(TopicDetails.BuilderImpl topic) {
            this.topic = topic != null ? topic.build() : null;
        }

        @Override
        public final Builder topic(TopicDetails topic) {
            this.topic = topic;
            return this;
        }

        public final CustomInstructions.Builder getCustomInstructions() {
            return customInstructions != null ? customInstructions.toBuilder() : null;
        }

        public final void setCustomInstructions(CustomInstructions.BuilderImpl customInstructions) {
            this.customInstructions = customInstructions != null ? customInstructions.build() : null;
        }

        @Override
        public final Builder customInstructions(CustomInstructions customInstructions) {
            this.customInstructions = customInstructions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTopicRequest build() {
            return new UpdateTopicRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
