/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A visual displayed on a sheet in an analysis, dashboard, or template.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Visual implements SdkPojo, Serializable, ToCopyableBuilder<Visual.Builder, Visual> {
    private static final SdkField<TableVisual> TABLE_VISUAL_FIELD = SdkField.<TableVisual> builder(MarshallingType.SDK_POJO)
            .memberName("TableVisual").getter(getter(Visual::tableVisual)).setter(setter(Builder::tableVisual))
            .constructor(TableVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableVisual").build()).build();

    private static final SdkField<PivotTableVisual> PIVOT_TABLE_VISUAL_FIELD = SdkField
            .<PivotTableVisual> builder(MarshallingType.SDK_POJO).memberName("PivotTableVisual")
            .getter(getter(Visual::pivotTableVisual)).setter(setter(Builder::pivotTableVisual))
            .constructor(PivotTableVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PivotTableVisual").build()).build();

    private static final SdkField<BarChartVisual> BAR_CHART_VISUAL_FIELD = SdkField
            .<BarChartVisual> builder(MarshallingType.SDK_POJO).memberName("BarChartVisual")
            .getter(getter(Visual::barChartVisual)).setter(setter(Builder::barChartVisual)).constructor(BarChartVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BarChartVisual").build()).build();

    private static final SdkField<KPIVisual> KPI_VISUAL_FIELD = SdkField.<KPIVisual> builder(MarshallingType.SDK_POJO)
            .memberName("KPIVisual").getter(getter(Visual::kpiVisual)).setter(setter(Builder::kpiVisual))
            .constructor(KPIVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KPIVisual").build()).build();

    private static final SdkField<PieChartVisual> PIE_CHART_VISUAL_FIELD = SdkField
            .<PieChartVisual> builder(MarshallingType.SDK_POJO).memberName("PieChartVisual")
            .getter(getter(Visual::pieChartVisual)).setter(setter(Builder::pieChartVisual)).constructor(PieChartVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PieChartVisual").build()).build();

    private static final SdkField<GaugeChartVisual> GAUGE_CHART_VISUAL_FIELD = SdkField
            .<GaugeChartVisual> builder(MarshallingType.SDK_POJO).memberName("GaugeChartVisual")
            .getter(getter(Visual::gaugeChartVisual)).setter(setter(Builder::gaugeChartVisual))
            .constructor(GaugeChartVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GaugeChartVisual").build()).build();

    private static final SdkField<LineChartVisual> LINE_CHART_VISUAL_FIELD = SdkField
            .<LineChartVisual> builder(MarshallingType.SDK_POJO).memberName("LineChartVisual")
            .getter(getter(Visual::lineChartVisual)).setter(setter(Builder::lineChartVisual))
            .constructor(LineChartVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineChartVisual").build()).build();

    private static final SdkField<HeatMapVisual> HEAT_MAP_VISUAL_FIELD = SdkField
            .<HeatMapVisual> builder(MarshallingType.SDK_POJO).memberName("HeatMapVisual").getter(getter(Visual::heatMapVisual))
            .setter(setter(Builder::heatMapVisual)).constructor(HeatMapVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeatMapVisual").build()).build();

    private static final SdkField<TreeMapVisual> TREE_MAP_VISUAL_FIELD = SdkField
            .<TreeMapVisual> builder(MarshallingType.SDK_POJO).memberName("TreeMapVisual").getter(getter(Visual::treeMapVisual))
            .setter(setter(Builder::treeMapVisual)).constructor(TreeMapVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreeMapVisual").build()).build();

    private static final SdkField<GeospatialMapVisual> GEOSPATIAL_MAP_VISUAL_FIELD = SdkField
            .<GeospatialMapVisual> builder(MarshallingType.SDK_POJO).memberName("GeospatialMapVisual")
            .getter(getter(Visual::geospatialMapVisual)).setter(setter(Builder::geospatialMapVisual))
            .constructor(GeospatialMapVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeospatialMapVisual").build())
            .build();

    private static final SdkField<FilledMapVisual> FILLED_MAP_VISUAL_FIELD = SdkField
            .<FilledMapVisual> builder(MarshallingType.SDK_POJO).memberName("FilledMapVisual")
            .getter(getter(Visual::filledMapVisual)).setter(setter(Builder::filledMapVisual))
            .constructor(FilledMapVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilledMapVisual").build()).build();

    private static final SdkField<LayerMapVisual> LAYER_MAP_VISUAL_FIELD = SdkField
            .<LayerMapVisual> builder(MarshallingType.SDK_POJO).memberName("LayerMapVisual")
            .getter(getter(Visual::layerMapVisual)).setter(setter(Builder::layerMapVisual)).constructor(LayerMapVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerMapVisual").build()).build();

    private static final SdkField<FunnelChartVisual> FUNNEL_CHART_VISUAL_FIELD = SdkField
            .<FunnelChartVisual> builder(MarshallingType.SDK_POJO).memberName("FunnelChartVisual")
            .getter(getter(Visual::funnelChartVisual)).setter(setter(Builder::funnelChartVisual))
            .constructor(FunnelChartVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunnelChartVisual").build()).build();

    private static final SdkField<ScatterPlotVisual> SCATTER_PLOT_VISUAL_FIELD = SdkField
            .<ScatterPlotVisual> builder(MarshallingType.SDK_POJO).memberName("ScatterPlotVisual")
            .getter(getter(Visual::scatterPlotVisual)).setter(setter(Builder::scatterPlotVisual))
            .constructor(ScatterPlotVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScatterPlotVisual").build()).build();

    private static final SdkField<ComboChartVisual> COMBO_CHART_VISUAL_FIELD = SdkField
            .<ComboChartVisual> builder(MarshallingType.SDK_POJO).memberName("ComboChartVisual")
            .getter(getter(Visual::comboChartVisual)).setter(setter(Builder::comboChartVisual))
            .constructor(ComboChartVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComboChartVisual").build()).build();

    private static final SdkField<BoxPlotVisual> BOX_PLOT_VISUAL_FIELD = SdkField
            .<BoxPlotVisual> builder(MarshallingType.SDK_POJO).memberName("BoxPlotVisual").getter(getter(Visual::boxPlotVisual))
            .setter(setter(Builder::boxPlotVisual)).constructor(BoxPlotVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoxPlotVisual").build()).build();

    private static final SdkField<WaterfallVisual> WATERFALL_VISUAL_FIELD = SdkField
            .<WaterfallVisual> builder(MarshallingType.SDK_POJO).memberName("WaterfallVisual")
            .getter(getter(Visual::waterfallVisual)).setter(setter(Builder::waterfallVisual))
            .constructor(WaterfallVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaterfallVisual").build()).build();

    private static final SdkField<HistogramVisual> HISTOGRAM_VISUAL_FIELD = SdkField
            .<HistogramVisual> builder(MarshallingType.SDK_POJO).memberName("HistogramVisual")
            .getter(getter(Visual::histogramVisual)).setter(setter(Builder::histogramVisual))
            .constructor(HistogramVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HistogramVisual").build()).build();

    private static final SdkField<WordCloudVisual> WORD_CLOUD_VISUAL_FIELD = SdkField
            .<WordCloudVisual> builder(MarshallingType.SDK_POJO).memberName("WordCloudVisual")
            .getter(getter(Visual::wordCloudVisual)).setter(setter(Builder::wordCloudVisual))
            .constructor(WordCloudVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WordCloudVisual").build()).build();

    private static final SdkField<InsightVisual> INSIGHT_VISUAL_FIELD = SdkField
            .<InsightVisual> builder(MarshallingType.SDK_POJO).memberName("InsightVisual").getter(getter(Visual::insightVisual))
            .setter(setter(Builder::insightVisual)).constructor(InsightVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightVisual").build()).build();

    private static final SdkField<SankeyDiagramVisual> SANKEY_DIAGRAM_VISUAL_FIELD = SdkField
            .<SankeyDiagramVisual> builder(MarshallingType.SDK_POJO).memberName("SankeyDiagramVisual")
            .getter(getter(Visual::sankeyDiagramVisual)).setter(setter(Builder::sankeyDiagramVisual))
            .constructor(SankeyDiagramVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SankeyDiagramVisual").build())
            .build();

    private static final SdkField<CustomContentVisual> CUSTOM_CONTENT_VISUAL_FIELD = SdkField
            .<CustomContentVisual> builder(MarshallingType.SDK_POJO).memberName("CustomContentVisual")
            .getter(getter(Visual::customContentVisual)).setter(setter(Builder::customContentVisual))
            .constructor(CustomContentVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomContentVisual").build())
            .build();

    private static final SdkField<EmptyVisual> EMPTY_VISUAL_FIELD = SdkField.<EmptyVisual> builder(MarshallingType.SDK_POJO)
            .memberName("EmptyVisual").getter(getter(Visual::emptyVisual)).setter(setter(Builder::emptyVisual))
            .constructor(EmptyVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmptyVisual").build()).build();

    private static final SdkField<RadarChartVisual> RADAR_CHART_VISUAL_FIELD = SdkField
            .<RadarChartVisual> builder(MarshallingType.SDK_POJO).memberName("RadarChartVisual")
            .getter(getter(Visual::radarChartVisual)).setter(setter(Builder::radarChartVisual))
            .constructor(RadarChartVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RadarChartVisual").build()).build();

    private static final SdkField<PluginVisual> PLUGIN_VISUAL_FIELD = SdkField.<PluginVisual> builder(MarshallingType.SDK_POJO)
            .memberName("PluginVisual").getter(getter(Visual::pluginVisual)).setter(setter(Builder::pluginVisual))
            .constructor(PluginVisual::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginVisual").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_VISUAL_FIELD,
            PIVOT_TABLE_VISUAL_FIELD, BAR_CHART_VISUAL_FIELD, KPI_VISUAL_FIELD, PIE_CHART_VISUAL_FIELD, GAUGE_CHART_VISUAL_FIELD,
            LINE_CHART_VISUAL_FIELD, HEAT_MAP_VISUAL_FIELD, TREE_MAP_VISUAL_FIELD, GEOSPATIAL_MAP_VISUAL_FIELD,
            FILLED_MAP_VISUAL_FIELD, LAYER_MAP_VISUAL_FIELD, FUNNEL_CHART_VISUAL_FIELD, SCATTER_PLOT_VISUAL_FIELD,
            COMBO_CHART_VISUAL_FIELD, BOX_PLOT_VISUAL_FIELD, WATERFALL_VISUAL_FIELD, HISTOGRAM_VISUAL_FIELD,
            WORD_CLOUD_VISUAL_FIELD, INSIGHT_VISUAL_FIELD, SANKEY_DIAGRAM_VISUAL_FIELD, CUSTOM_CONTENT_VISUAL_FIELD,
            EMPTY_VISUAL_FIELD, RADAR_CHART_VISUAL_FIELD, PLUGIN_VISUAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TableVisual tableVisual;

    private final PivotTableVisual pivotTableVisual;

    private final BarChartVisual barChartVisual;

    private final KPIVisual kpiVisual;

    private final PieChartVisual pieChartVisual;

    private final GaugeChartVisual gaugeChartVisual;

    private final LineChartVisual lineChartVisual;

    private final HeatMapVisual heatMapVisual;

    private final TreeMapVisual treeMapVisual;

    private final GeospatialMapVisual geospatialMapVisual;

    private final FilledMapVisual filledMapVisual;

    private final LayerMapVisual layerMapVisual;

    private final FunnelChartVisual funnelChartVisual;

    private final ScatterPlotVisual scatterPlotVisual;

    private final ComboChartVisual comboChartVisual;

    private final BoxPlotVisual boxPlotVisual;

    private final WaterfallVisual waterfallVisual;

    private final HistogramVisual histogramVisual;

    private final WordCloudVisual wordCloudVisual;

    private final InsightVisual insightVisual;

    private final SankeyDiagramVisual sankeyDiagramVisual;

    private final CustomContentVisual customContentVisual;

    private final EmptyVisual emptyVisual;

    private final RadarChartVisual radarChartVisual;

    private final PluginVisual pluginVisual;

    private Visual(BuilderImpl builder) {
        this.tableVisual = builder.tableVisual;
        this.pivotTableVisual = builder.pivotTableVisual;
        this.barChartVisual = builder.barChartVisual;
        this.kpiVisual = builder.kpiVisual;
        this.pieChartVisual = builder.pieChartVisual;
        this.gaugeChartVisual = builder.gaugeChartVisual;
        this.lineChartVisual = builder.lineChartVisual;
        this.heatMapVisual = builder.heatMapVisual;
        this.treeMapVisual = builder.treeMapVisual;
        this.geospatialMapVisual = builder.geospatialMapVisual;
        this.filledMapVisual = builder.filledMapVisual;
        this.layerMapVisual = builder.layerMapVisual;
        this.funnelChartVisual = builder.funnelChartVisual;
        this.scatterPlotVisual = builder.scatterPlotVisual;
        this.comboChartVisual = builder.comboChartVisual;
        this.boxPlotVisual = builder.boxPlotVisual;
        this.waterfallVisual = builder.waterfallVisual;
        this.histogramVisual = builder.histogramVisual;
        this.wordCloudVisual = builder.wordCloudVisual;
        this.insightVisual = builder.insightVisual;
        this.sankeyDiagramVisual = builder.sankeyDiagramVisual;
        this.customContentVisual = builder.customContentVisual;
        this.emptyVisual = builder.emptyVisual;
        this.radarChartVisual = builder.radarChartVisual;
        this.pluginVisual = builder.pluginVisual;
    }

    /**
     * <p>
     * A table visual.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/tabular.html">Using tables
     * as visuals</a> in the <i>Amazon Quick Suite User Guide</i>.
     * </p>
     * 
     * @return A table visual.</p>
     *         <p>
     *         For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/tabular.html">Using
     *         tables as visuals</a> in the <i>Amazon Quick Suite User Guide</i>.
     */
    public final TableVisual tableVisual() {
        return tableVisual;
    }

    /**
     * <p>
     * A pivot table.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/pivot-table.html">Using
     * pivot tables</a> in the <i>Amazon Quick Suite User Guide</i>.
     * </p>
     * 
     * @return A pivot table.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/pivot-table.html">Using pivot tables</a> in the
     *         <i>Amazon Quick Suite User Guide</i>.
     */
    public final PivotTableVisual pivotTableVisual() {
        return pivotTableVisual;
    }

    /**
     * <p>
     * A bar chart.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/bar-charts.html">Using bar
     * charts</a> in the <i>Amazon Quick Suite User Guide</i>.
     * </p>
     * 
     * @return A bar chart.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/bar-charts.html">Using bar charts</a> in the
     *         <i>Amazon Quick Suite User Guide</i>.
     */
    public final BarChartVisual barChartVisual() {
        return barChartVisual;
    }

    /**
     * <p>
     * A key performance indicator (KPI).
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/kpi.html">Using KPIs</a> in
     * the <i>Amazon Quick Suite User Guide</i>.
     * </p>
     * 
     * @return A key performance indicator (KPI).</p>
     *         <p>
     *         For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/kpi.html">Using
     *         KPIs</a> in the <i>Amazon Quick Suite User Guide</i>.
     */
    public final KPIVisual kpiVisual() {
        return kpiVisual;
    }

    /**
     * <p>
     * A pie or donut chart.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/pie-chart.html">Using pie
     * charts</a> in the <i>Amazon Quick Suite User Guide</i>.
     * </p>
     * 
     * @return A pie or donut chart.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/pie-chart.html">Using pie charts</a> in the
     *         <i>Amazon Quick Suite User Guide</i>.
     */
    public final PieChartVisual pieChartVisual() {
        return pieChartVisual;
    }

    /**
     * <p>
     * A gauge chart.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/gauge-chart.html">Using
     * gauge charts</a> in the <i>Amazon Quick Suite User Guide</i>.
     * </p>
     * 
     * @return A gauge chart.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/gauge-chart.html">Using gauge charts</a> in the
     *         <i>Amazon Quick Suite User Guide</i>.
     */
    public final GaugeChartVisual gaugeChartVisual() {
        return gaugeChartVisual;
    }

    /**
     * <p>
     * A line chart.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/line-charts.html">Using
     * line charts</a> in the <i>Amazon Quick Suite User Guide</i>.
     * </p>
     * 
     * @return A line chart.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/line-charts.html">Using line charts</a> in the
     *         <i>Amazon Quick Suite User Guide</i>.
     */
    public final LineChartVisual lineChartVisual() {
        return lineChartVisual;
    }

    /**
     * <p>
     * A heat map.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/heat-map.html">Using heat
     * maps</a> in the <i>Amazon Quick Suite User Guide</i>.
     * </p>
     * 
     * @return A heat map.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/heat-map.html">Using heat maps</a> in the
     *         <i>Amazon Quick Suite User Guide</i>.
     */
    public final HeatMapVisual heatMapVisual() {
        return heatMapVisual;
    }

    /**
     * <p>
     * A tree map.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/tree-map.html">Using tree
     * maps</a> in the <i>Amazon Quick Suite User Guide</i>.
     * </p>
     * 
     * @return A tree map.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/tree-map.html">Using tree maps</a> in the
     *         <i>Amazon Quick Suite User Guide</i>.
     */
    public final TreeMapVisual treeMapVisual() {
        return treeMapVisual;
    }

    /**
     * <p>
     * A geospatial map or a points on map visual.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/point-maps.html">Creating
     * point maps</a> in the <i>Amazon Quick Suite User Guide</i>.
     * </p>
     * 
     * @return A geospatial map or a points on map visual.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/point-maps.html">Creating point maps</a> in the
     *         <i>Amazon Quick Suite User Guide</i>.
     */
    public final GeospatialMapVisual geospatialMapVisual() {
        return geospatialMapVisual;
    }

    /**
     * <p>
     * A filled map.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/filled-maps.html">Creating
     * filled maps</a> in the <i>Amazon Quick Suite User Guide</i>.
     * </p>
     * 
     * @return A filled map.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/filled-maps.html">Creating filled maps</a> in
     *         the <i>Amazon Quick Suite User Guide</i>.
     */
    public final FilledMapVisual filledMapVisual() {
        return filledMapVisual;
    }

    /**
     * <p>
     * The properties for a layer map visual
     * </p>
     * 
     * @return The properties for a layer map visual
     */
    public final LayerMapVisual layerMapVisual() {
        return layerMapVisual;
    }

    /**
     * <p>
     * A funnel chart.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/funnel-visual-content.html">Using funnel charts</a> in
     * the <i>Amazon Quick Suite User Guide</i>.
     * </p>
     * 
     * @return A funnel chart.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/funnel-visual-content.html">Using funnel
     *         charts</a> in the <i>Amazon Quick Suite User Guide</i>.
     */
    public final FunnelChartVisual funnelChartVisual() {
        return funnelChartVisual;
    }

    /**
     * <p>
     * A scatter plot.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/scatter-plot.html">Using
     * scatter plots</a> in the <i>Amazon Quick Suite User Guide</i>.
     * </p>
     * 
     * @return A scatter plot.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/scatter-plot.html">Using scatter plots</a> in
     *         the <i>Amazon Quick Suite User Guide</i>.
     */
    public final ScatterPlotVisual scatterPlotVisual() {
        return scatterPlotVisual;
    }

    /**
     * <p>
     * A combo chart.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/combo-charts.html">Using
     * combo charts</a> in the <i>Amazon Quick Suite User Guide</i>.
     * </p>
     * 
     * @return A combo chart.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/combo-charts.html">Using combo charts</a> in the
     *         <i>Amazon Quick Suite User Guide</i>.
     */
    public final ComboChartVisual comboChartVisual() {
        return comboChartVisual;
    }

    /**
     * <p>
     * A box plot.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/box-plots.html">Using box
     * plots</a> in the <i>Amazon Quick Suite User Guide</i>.
     * </p>
     * 
     * @return A box plot.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/box-plots.html">Using box plots</a> in the
     *         <i>Amazon Quick Suite User Guide</i>.
     */
    public final BoxPlotVisual boxPlotVisual() {
        return boxPlotVisual;
    }

    /**
     * <p>
     * A waterfall chart.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/waterfall-chart.html">Using
     * waterfall charts</a> in the <i>Amazon Quick Suite User Guide</i>.
     * </p>
     * 
     * @return A waterfall chart.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/waterfall-chart.html">Using waterfall charts</a>
     *         in the <i>Amazon Quick Suite User Guide</i>.
     */
    public final WaterfallVisual waterfallVisual() {
        return waterfallVisual;
    }

    /**
     * <p>
     * A histogram.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/histogram-charts.html">Using histograms</a> in the
     * <i>Amazon Quick Suite User Guide</i>.
     * </p>
     * 
     * @return A histogram.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/histogram-charts.html">Using histograms</a> in
     *         the <i>Amazon Quick Suite User Guide</i>.
     */
    public final HistogramVisual histogramVisual() {
        return histogramVisual;
    }

    /**
     * <p>
     * A word cloud.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/word-cloud.html">Using word
     * clouds</a> in the <i>Amazon Quick Suite User Guide</i>.
     * </p>
     * 
     * @return A word cloud.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/word-cloud.html">Using word clouds</a> in the
     *         <i>Amazon Quick Suite User Guide</i>.
     */
    public final WordCloudVisual wordCloudVisual() {
        return wordCloudVisual;
    }

    /**
     * <p>
     * An insight visual.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/computational-insights.html">Working with insights</a>
     * in the <i>Amazon Quick Suite User Guide</i>.
     * </p>
     * 
     * @return An insight visual.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/computational-insights.html">Working with
     *         insights</a> in the <i>Amazon Quick Suite User Guide</i>.
     */
    public final InsightVisual insightVisual() {
        return insightVisual;
    }

    /**
     * <p>
     * A sankey diagram.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/sankey-diagram.html">Using
     * Sankey diagrams</a> in the <i>Amazon Quick Suite User Guide</i>.
     * </p>
     * 
     * @return A sankey diagram.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/sankey-diagram.html">Using Sankey diagrams</a>
     *         in the <i>Amazon Quick Suite User Guide</i>.
     */
    public final SankeyDiagramVisual sankeyDiagramVisual() {
        return sankeyDiagramVisual;
    }

    /**
     * <p>
     * A visual that contains custom content.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/custom-visual-content.html">Using custom visual
     * content</a> in the <i>Amazon Quick Suite User Guide</i>.
     * </p>
     * 
     * @return A visual that contains custom content.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/custom-visual-content.html">Using custom visual
     *         content</a> in the <i>Amazon Quick Suite User Guide</i>.
     */
    public final CustomContentVisual customContentVisual() {
        return customContentVisual;
    }

    /**
     * <p>
     * An empty visual.
     * </p>
     * 
     * @return An empty visual.
     */
    public final EmptyVisual emptyVisual() {
        return emptyVisual;
    }

    /**
     * <p>
     * A radar chart visual.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/radar-chart.html">Using
     * radar charts</a> in the <i>Amazon Quick Suite User Guide</i>.
     * </p>
     * 
     * @return A radar chart visual.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/radar-chart.html">Using radar charts</a> in the
     *         <i>Amazon Quick Suite User Guide</i>.
     */
    public final RadarChartVisual radarChartVisual() {
        return radarChartVisual;
    }

    /**
     * <p>
     * The custom plugin visual type.
     * </p>
     * 
     * @return The custom plugin visual type.
     */
    public final PluginVisual pluginVisual() {
        return pluginVisual;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableVisual());
        hashCode = 31 * hashCode + Objects.hashCode(pivotTableVisual());
        hashCode = 31 * hashCode + Objects.hashCode(barChartVisual());
        hashCode = 31 * hashCode + Objects.hashCode(kpiVisual());
        hashCode = 31 * hashCode + Objects.hashCode(pieChartVisual());
        hashCode = 31 * hashCode + Objects.hashCode(gaugeChartVisual());
        hashCode = 31 * hashCode + Objects.hashCode(lineChartVisual());
        hashCode = 31 * hashCode + Objects.hashCode(heatMapVisual());
        hashCode = 31 * hashCode + Objects.hashCode(treeMapVisual());
        hashCode = 31 * hashCode + Objects.hashCode(geospatialMapVisual());
        hashCode = 31 * hashCode + Objects.hashCode(filledMapVisual());
        hashCode = 31 * hashCode + Objects.hashCode(layerMapVisual());
        hashCode = 31 * hashCode + Objects.hashCode(funnelChartVisual());
        hashCode = 31 * hashCode + Objects.hashCode(scatterPlotVisual());
        hashCode = 31 * hashCode + Objects.hashCode(comboChartVisual());
        hashCode = 31 * hashCode + Objects.hashCode(boxPlotVisual());
        hashCode = 31 * hashCode + Objects.hashCode(waterfallVisual());
        hashCode = 31 * hashCode + Objects.hashCode(histogramVisual());
        hashCode = 31 * hashCode + Objects.hashCode(wordCloudVisual());
        hashCode = 31 * hashCode + Objects.hashCode(insightVisual());
        hashCode = 31 * hashCode + Objects.hashCode(sankeyDiagramVisual());
        hashCode = 31 * hashCode + Objects.hashCode(customContentVisual());
        hashCode = 31 * hashCode + Objects.hashCode(emptyVisual());
        hashCode = 31 * hashCode + Objects.hashCode(radarChartVisual());
        hashCode = 31 * hashCode + Objects.hashCode(pluginVisual());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Visual)) {
            return false;
        }
        Visual other = (Visual) obj;
        return Objects.equals(tableVisual(), other.tableVisual()) && Objects.equals(pivotTableVisual(), other.pivotTableVisual())
                && Objects.equals(barChartVisual(), other.barChartVisual()) && Objects.equals(kpiVisual(), other.kpiVisual())
                && Objects.equals(pieChartVisual(), other.pieChartVisual())
                && Objects.equals(gaugeChartVisual(), other.gaugeChartVisual())
                && Objects.equals(lineChartVisual(), other.lineChartVisual())
                && Objects.equals(heatMapVisual(), other.heatMapVisual())
                && Objects.equals(treeMapVisual(), other.treeMapVisual())
                && Objects.equals(geospatialMapVisual(), other.geospatialMapVisual())
                && Objects.equals(filledMapVisual(), other.filledMapVisual())
                && Objects.equals(layerMapVisual(), other.layerMapVisual())
                && Objects.equals(funnelChartVisual(), other.funnelChartVisual())
                && Objects.equals(scatterPlotVisual(), other.scatterPlotVisual())
                && Objects.equals(comboChartVisual(), other.comboChartVisual())
                && Objects.equals(boxPlotVisual(), other.boxPlotVisual())
                && Objects.equals(waterfallVisual(), other.waterfallVisual())
                && Objects.equals(histogramVisual(), other.histogramVisual())
                && Objects.equals(wordCloudVisual(), other.wordCloudVisual())
                && Objects.equals(insightVisual(), other.insightVisual())
                && Objects.equals(sankeyDiagramVisual(), other.sankeyDiagramVisual())
                && Objects.equals(customContentVisual(), other.customContentVisual())
                && Objects.equals(emptyVisual(), other.emptyVisual())
                && Objects.equals(radarChartVisual(), other.radarChartVisual())
                && Objects.equals(pluginVisual(), other.pluginVisual());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Visual").add("TableVisual", tableVisual()).add("PivotTableVisual", pivotTableVisual())
                .add("BarChartVisual", barChartVisual()).add("KPIVisual", kpiVisual()).add("PieChartVisual", pieChartVisual())
                .add("GaugeChartVisual", gaugeChartVisual()).add("LineChartVisual", lineChartVisual())
                .add("HeatMapVisual", heatMapVisual()).add("TreeMapVisual", treeMapVisual())
                .add("GeospatialMapVisual", geospatialMapVisual()).add("FilledMapVisual", filledMapVisual())
                .add("LayerMapVisual", layerMapVisual()).add("FunnelChartVisual", funnelChartVisual())
                .add("ScatterPlotVisual", scatterPlotVisual()).add("ComboChartVisual", comboChartVisual())
                .add("BoxPlotVisual", boxPlotVisual()).add("WaterfallVisual", waterfallVisual())
                .add("HistogramVisual", histogramVisual()).add("WordCloudVisual", wordCloudVisual())
                .add("InsightVisual", insightVisual()).add("SankeyDiagramVisual", sankeyDiagramVisual())
                .add("CustomContentVisual", customContentVisual()).add("EmptyVisual", emptyVisual())
                .add("RadarChartVisual", radarChartVisual()).add("PluginVisual", pluginVisual()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableVisual":
            return Optional.ofNullable(clazz.cast(tableVisual()));
        case "PivotTableVisual":
            return Optional.ofNullable(clazz.cast(pivotTableVisual()));
        case "BarChartVisual":
            return Optional.ofNullable(clazz.cast(barChartVisual()));
        case "KPIVisual":
            return Optional.ofNullable(clazz.cast(kpiVisual()));
        case "PieChartVisual":
            return Optional.ofNullable(clazz.cast(pieChartVisual()));
        case "GaugeChartVisual":
            return Optional.ofNullable(clazz.cast(gaugeChartVisual()));
        case "LineChartVisual":
            return Optional.ofNullable(clazz.cast(lineChartVisual()));
        case "HeatMapVisual":
            return Optional.ofNullable(clazz.cast(heatMapVisual()));
        case "TreeMapVisual":
            return Optional.ofNullable(clazz.cast(treeMapVisual()));
        case "GeospatialMapVisual":
            return Optional.ofNullable(clazz.cast(geospatialMapVisual()));
        case "FilledMapVisual":
            return Optional.ofNullable(clazz.cast(filledMapVisual()));
        case "LayerMapVisual":
            return Optional.ofNullable(clazz.cast(layerMapVisual()));
        case "FunnelChartVisual":
            return Optional.ofNullable(clazz.cast(funnelChartVisual()));
        case "ScatterPlotVisual":
            return Optional.ofNullable(clazz.cast(scatterPlotVisual()));
        case "ComboChartVisual":
            return Optional.ofNullable(clazz.cast(comboChartVisual()));
        case "BoxPlotVisual":
            return Optional.ofNullable(clazz.cast(boxPlotVisual()));
        case "WaterfallVisual":
            return Optional.ofNullable(clazz.cast(waterfallVisual()));
        case "HistogramVisual":
            return Optional.ofNullable(clazz.cast(histogramVisual()));
        case "WordCloudVisual":
            return Optional.ofNullable(clazz.cast(wordCloudVisual()));
        case "InsightVisual":
            return Optional.ofNullable(clazz.cast(insightVisual()));
        case "SankeyDiagramVisual":
            return Optional.ofNullable(clazz.cast(sankeyDiagramVisual()));
        case "CustomContentVisual":
            return Optional.ofNullable(clazz.cast(customContentVisual()));
        case "EmptyVisual":
            return Optional.ofNullable(clazz.cast(emptyVisual()));
        case "RadarChartVisual":
            return Optional.ofNullable(clazz.cast(radarChartVisual()));
        case "PluginVisual":
            return Optional.ofNullable(clazz.cast(pluginVisual()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TableVisual", TABLE_VISUAL_FIELD);
        map.put("PivotTableVisual", PIVOT_TABLE_VISUAL_FIELD);
        map.put("BarChartVisual", BAR_CHART_VISUAL_FIELD);
        map.put("KPIVisual", KPI_VISUAL_FIELD);
        map.put("PieChartVisual", PIE_CHART_VISUAL_FIELD);
        map.put("GaugeChartVisual", GAUGE_CHART_VISUAL_FIELD);
        map.put("LineChartVisual", LINE_CHART_VISUAL_FIELD);
        map.put("HeatMapVisual", HEAT_MAP_VISUAL_FIELD);
        map.put("TreeMapVisual", TREE_MAP_VISUAL_FIELD);
        map.put("GeospatialMapVisual", GEOSPATIAL_MAP_VISUAL_FIELD);
        map.put("FilledMapVisual", FILLED_MAP_VISUAL_FIELD);
        map.put("LayerMapVisual", LAYER_MAP_VISUAL_FIELD);
        map.put("FunnelChartVisual", FUNNEL_CHART_VISUAL_FIELD);
        map.put("ScatterPlotVisual", SCATTER_PLOT_VISUAL_FIELD);
        map.put("ComboChartVisual", COMBO_CHART_VISUAL_FIELD);
        map.put("BoxPlotVisual", BOX_PLOT_VISUAL_FIELD);
        map.put("WaterfallVisual", WATERFALL_VISUAL_FIELD);
        map.put("HistogramVisual", HISTOGRAM_VISUAL_FIELD);
        map.put("WordCloudVisual", WORD_CLOUD_VISUAL_FIELD);
        map.put("InsightVisual", INSIGHT_VISUAL_FIELD);
        map.put("SankeyDiagramVisual", SANKEY_DIAGRAM_VISUAL_FIELD);
        map.put("CustomContentVisual", CUSTOM_CONTENT_VISUAL_FIELD);
        map.put("EmptyVisual", EMPTY_VISUAL_FIELD);
        map.put("RadarChartVisual", RADAR_CHART_VISUAL_FIELD);
        map.put("PluginVisual", PLUGIN_VISUAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Visual, T> g) {
        return obj -> g.apply((Visual) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Visual> {
        /**
         * <p>
         * A table visual.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/tabular.html">Using
         * tables as visuals</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * 
         * @param tableVisual
         *        A table visual.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/tabular.html">Using tables as visuals</a> in
         *        the <i>Amazon Quick Suite User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableVisual(TableVisual tableVisual);

        /**
         * <p>
         * A table visual.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/tabular.html">Using
         * tables as visuals</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableVisual.Builder} avoiding the need to
         * create one manually via {@link TableVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableVisual.Builder#build()} is called immediately and its result
         * is passed to {@link #tableVisual(TableVisual)}.
         * 
         * @param tableVisual
         *        a consumer that will call methods on {@link TableVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableVisual(TableVisual)
         */
        default Builder tableVisual(Consumer<TableVisual.Builder> tableVisual) {
            return tableVisual(TableVisual.builder().applyMutation(tableVisual).build());
        }

        /**
         * <p>
         * A pivot table.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/pivot-table.html">Using
         * pivot tables</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * 
         * @param pivotTableVisual
         *        A pivot table.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/pivot-table.html">Using pivot tables</a> in
         *        the <i>Amazon Quick Suite User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pivotTableVisual(PivotTableVisual pivotTableVisual);

        /**
         * <p>
         * A pivot table.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/pivot-table.html">Using
         * pivot tables</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link PivotTableVisual.Builder} avoiding the
         * need to create one manually via {@link PivotTableVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PivotTableVisual.Builder#build()} is called immediately and its
         * result is passed to {@link #pivotTableVisual(PivotTableVisual)}.
         * 
         * @param pivotTableVisual
         *        a consumer that will call methods on {@link PivotTableVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pivotTableVisual(PivotTableVisual)
         */
        default Builder pivotTableVisual(Consumer<PivotTableVisual.Builder> pivotTableVisual) {
            return pivotTableVisual(PivotTableVisual.builder().applyMutation(pivotTableVisual).build());
        }

        /**
         * <p>
         * A bar chart.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/bar-charts.html">Using
         * bar charts</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * 
         * @param barChartVisual
         *        A bar chart.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/bar-charts.html">Using bar charts</a> in the
         *        <i>Amazon Quick Suite User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder barChartVisual(BarChartVisual barChartVisual);

        /**
         * <p>
         * A bar chart.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/bar-charts.html">Using
         * bar charts</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link BarChartVisual.Builder} avoiding the need
         * to create one manually via {@link BarChartVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BarChartVisual.Builder#build()} is called immediately and its
         * result is passed to {@link #barChartVisual(BarChartVisual)}.
         * 
         * @param barChartVisual
         *        a consumer that will call methods on {@link BarChartVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #barChartVisual(BarChartVisual)
         */
        default Builder barChartVisual(Consumer<BarChartVisual.Builder> barChartVisual) {
            return barChartVisual(BarChartVisual.builder().applyMutation(barChartVisual).build());
        }

        /**
         * <p>
         * A key performance indicator (KPI).
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/kpi.html">Using
         * KPIs</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * 
         * @param kpiVisual
         *        A key performance indicator (KPI).</p>
         *        <p>
         *        For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/kpi.html">Using
         *        KPIs</a> in the <i>Amazon Quick Suite User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kpiVisual(KPIVisual kpiVisual);

        /**
         * <p>
         * A key performance indicator (KPI).
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/kpi.html">Using
         * KPIs</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link KPIVisual.Builder} avoiding the need to
         * create one manually via {@link KPIVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KPIVisual.Builder#build()} is called immediately and its result
         * is passed to {@link #kpiVisual(KPIVisual)}.
         * 
         * @param kpiVisual
         *        a consumer that will call methods on {@link KPIVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kpiVisual(KPIVisual)
         */
        default Builder kpiVisual(Consumer<KPIVisual.Builder> kpiVisual) {
            return kpiVisual(KPIVisual.builder().applyMutation(kpiVisual).build());
        }

        /**
         * <p>
         * A pie or donut chart.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/pie-chart.html">Using
         * pie charts</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * 
         * @param pieChartVisual
         *        A pie or donut chart.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/pie-chart.html">Using pie charts</a> in the
         *        <i>Amazon Quick Suite User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pieChartVisual(PieChartVisual pieChartVisual);

        /**
         * <p>
         * A pie or donut chart.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/pie-chart.html">Using
         * pie charts</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link PieChartVisual.Builder} avoiding the need
         * to create one manually via {@link PieChartVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PieChartVisual.Builder#build()} is called immediately and its
         * result is passed to {@link #pieChartVisual(PieChartVisual)}.
         * 
         * @param pieChartVisual
         *        a consumer that will call methods on {@link PieChartVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pieChartVisual(PieChartVisual)
         */
        default Builder pieChartVisual(Consumer<PieChartVisual.Builder> pieChartVisual) {
            return pieChartVisual(PieChartVisual.builder().applyMutation(pieChartVisual).build());
        }

        /**
         * <p>
         * A gauge chart.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/gauge-chart.html">Using
         * gauge charts</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * 
         * @param gaugeChartVisual
         *        A gauge chart.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/gauge-chart.html">Using gauge charts</a> in
         *        the <i>Amazon Quick Suite User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gaugeChartVisual(GaugeChartVisual gaugeChartVisual);

        /**
         * <p>
         * A gauge chart.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/gauge-chart.html">Using
         * gauge charts</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link GaugeChartVisual.Builder} avoiding the
         * need to create one manually via {@link GaugeChartVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GaugeChartVisual.Builder#build()} is called immediately and its
         * result is passed to {@link #gaugeChartVisual(GaugeChartVisual)}.
         * 
         * @param gaugeChartVisual
         *        a consumer that will call methods on {@link GaugeChartVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gaugeChartVisual(GaugeChartVisual)
         */
        default Builder gaugeChartVisual(Consumer<GaugeChartVisual.Builder> gaugeChartVisual) {
            return gaugeChartVisual(GaugeChartVisual.builder().applyMutation(gaugeChartVisual).build());
        }

        /**
         * <p>
         * A line chart.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/line-charts.html">Using
         * line charts</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * 
         * @param lineChartVisual
         *        A line chart.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/line-charts.html">Using line charts</a> in
         *        the <i>Amazon Quick Suite User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineChartVisual(LineChartVisual lineChartVisual);

        /**
         * <p>
         * A line chart.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/line-charts.html">Using
         * line charts</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link LineChartVisual.Builder} avoiding the
         * need to create one manually via {@link LineChartVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LineChartVisual.Builder#build()} is called immediately and its
         * result is passed to {@link #lineChartVisual(LineChartVisual)}.
         * 
         * @param lineChartVisual
         *        a consumer that will call methods on {@link LineChartVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lineChartVisual(LineChartVisual)
         */
        default Builder lineChartVisual(Consumer<LineChartVisual.Builder> lineChartVisual) {
            return lineChartVisual(LineChartVisual.builder().applyMutation(lineChartVisual).build());
        }

        /**
         * <p>
         * A heat map.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/heat-map.html">Using
         * heat maps</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * 
         * @param heatMapVisual
         *        A heat map.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/heat-map.html">Using heat maps</a> in the
         *        <i>Amazon Quick Suite User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heatMapVisual(HeatMapVisual heatMapVisual);

        /**
         * <p>
         * A heat map.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/heat-map.html">Using
         * heat maps</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link HeatMapVisual.Builder} avoiding the need
         * to create one manually via {@link HeatMapVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HeatMapVisual.Builder#build()} is called immediately and its
         * result is passed to {@link #heatMapVisual(HeatMapVisual)}.
         * 
         * @param heatMapVisual
         *        a consumer that will call methods on {@link HeatMapVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #heatMapVisual(HeatMapVisual)
         */
        default Builder heatMapVisual(Consumer<HeatMapVisual.Builder> heatMapVisual) {
            return heatMapVisual(HeatMapVisual.builder().applyMutation(heatMapVisual).build());
        }

        /**
         * <p>
         * A tree map.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/tree-map.html">Using
         * tree maps</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * 
         * @param treeMapVisual
         *        A tree map.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/tree-map.html">Using tree maps</a> in the
         *        <i>Amazon Quick Suite User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treeMapVisual(TreeMapVisual treeMapVisual);

        /**
         * <p>
         * A tree map.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/tree-map.html">Using
         * tree maps</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TreeMapVisual.Builder} avoiding the need
         * to create one manually via {@link TreeMapVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TreeMapVisual.Builder#build()} is called immediately and its
         * result is passed to {@link #treeMapVisual(TreeMapVisual)}.
         * 
         * @param treeMapVisual
         *        a consumer that will call methods on {@link TreeMapVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #treeMapVisual(TreeMapVisual)
         */
        default Builder treeMapVisual(Consumer<TreeMapVisual.Builder> treeMapVisual) {
            return treeMapVisual(TreeMapVisual.builder().applyMutation(treeMapVisual).build());
        }

        /**
         * <p>
         * A geospatial map or a points on map visual.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/point-maps.html">Creating point maps</a> in the
         * <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * 
         * @param geospatialMapVisual
         *        A geospatial map or a points on map visual.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/point-maps.html">Creating point maps</a> in
         *        the <i>Amazon Quick Suite User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geospatialMapVisual(GeospatialMapVisual geospatialMapVisual);

        /**
         * <p>
         * A geospatial map or a points on map visual.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/point-maps.html">Creating point maps</a> in the
         * <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialMapVisual.Builder} avoiding the
         * need to create one manually via {@link GeospatialMapVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialMapVisual.Builder#build()} is called immediately and
         * its result is passed to {@link #geospatialMapVisual(GeospatialMapVisual)}.
         * 
         * @param geospatialMapVisual
         *        a consumer that will call methods on {@link GeospatialMapVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geospatialMapVisual(GeospatialMapVisual)
         */
        default Builder geospatialMapVisual(Consumer<GeospatialMapVisual.Builder> geospatialMapVisual) {
            return geospatialMapVisual(GeospatialMapVisual.builder().applyMutation(geospatialMapVisual).build());
        }

        /**
         * <p>
         * A filled map.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/filled-maps.html">Creating filled maps</a> in the
         * <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * 
         * @param filledMapVisual
         *        A filled map.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/filled-maps.html">Creating filled maps</a> in
         *        the <i>Amazon Quick Suite User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filledMapVisual(FilledMapVisual filledMapVisual);

        /**
         * <p>
         * A filled map.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/filled-maps.html">Creating filled maps</a> in the
         * <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilledMapVisual.Builder} avoiding the
         * need to create one manually via {@link FilledMapVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilledMapVisual.Builder#build()} is called immediately and its
         * result is passed to {@link #filledMapVisual(FilledMapVisual)}.
         * 
         * @param filledMapVisual
         *        a consumer that will call methods on {@link FilledMapVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filledMapVisual(FilledMapVisual)
         */
        default Builder filledMapVisual(Consumer<FilledMapVisual.Builder> filledMapVisual) {
            return filledMapVisual(FilledMapVisual.builder().applyMutation(filledMapVisual).build());
        }

        /**
         * <p>
         * The properties for a layer map visual
         * </p>
         * 
         * @param layerMapVisual
         *        The properties for a layer map visual
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerMapVisual(LayerMapVisual layerMapVisual);

        /**
         * <p>
         * The properties for a layer map visual
         * </p>
         * This is a convenience method that creates an instance of the {@link LayerMapVisual.Builder} avoiding the need
         * to create one manually via {@link LayerMapVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LayerMapVisual.Builder#build()} is called immediately and its
         * result is passed to {@link #layerMapVisual(LayerMapVisual)}.
         * 
         * @param layerMapVisual
         *        a consumer that will call methods on {@link LayerMapVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #layerMapVisual(LayerMapVisual)
         */
        default Builder layerMapVisual(Consumer<LayerMapVisual.Builder> layerMapVisual) {
            return layerMapVisual(LayerMapVisual.builder().applyMutation(layerMapVisual).build());
        }

        /**
         * <p>
         * A funnel chart.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/funnel-visual-content.html">Using funnel charts</a>
         * in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * 
         * @param funnelChartVisual
         *        A funnel chart.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/funnel-visual-content.html">Using funnel
         *        charts</a> in the <i>Amazon Quick Suite User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder funnelChartVisual(FunnelChartVisual funnelChartVisual);

        /**
         * <p>
         * A funnel chart.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/funnel-visual-content.html">Using funnel charts</a>
         * in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link FunnelChartVisual.Builder} avoiding the
         * need to create one manually via {@link FunnelChartVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FunnelChartVisual.Builder#build()} is called immediately and its
         * result is passed to {@link #funnelChartVisual(FunnelChartVisual)}.
         * 
         * @param funnelChartVisual
         *        a consumer that will call methods on {@link FunnelChartVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #funnelChartVisual(FunnelChartVisual)
         */
        default Builder funnelChartVisual(Consumer<FunnelChartVisual.Builder> funnelChartVisual) {
            return funnelChartVisual(FunnelChartVisual.builder().applyMutation(funnelChartVisual).build());
        }

        /**
         * <p>
         * A scatter plot.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/scatter-plot.html">Using scatter plots</a> in the
         * <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * 
         * @param scatterPlotVisual
         *        A scatter plot.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/scatter-plot.html">Using scatter plots</a> in
         *        the <i>Amazon Quick Suite User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scatterPlotVisual(ScatterPlotVisual scatterPlotVisual);

        /**
         * <p>
         * A scatter plot.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/scatter-plot.html">Using scatter plots</a> in the
         * <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScatterPlotVisual.Builder} avoiding the
         * need to create one manually via {@link ScatterPlotVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScatterPlotVisual.Builder#build()} is called immediately and its
         * result is passed to {@link #scatterPlotVisual(ScatterPlotVisual)}.
         * 
         * @param scatterPlotVisual
         *        a consumer that will call methods on {@link ScatterPlotVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scatterPlotVisual(ScatterPlotVisual)
         */
        default Builder scatterPlotVisual(Consumer<ScatterPlotVisual.Builder> scatterPlotVisual) {
            return scatterPlotVisual(ScatterPlotVisual.builder().applyMutation(scatterPlotVisual).build());
        }

        /**
         * <p>
         * A combo chart.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/combo-charts.html">Using combo charts</a> in the
         * <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * 
         * @param comboChartVisual
         *        A combo chart.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/combo-charts.html">Using combo charts</a> in
         *        the <i>Amazon Quick Suite User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comboChartVisual(ComboChartVisual comboChartVisual);

        /**
         * <p>
         * A combo chart.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/combo-charts.html">Using combo charts</a> in the
         * <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComboChartVisual.Builder} avoiding the
         * need to create one manually via {@link ComboChartVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComboChartVisual.Builder#build()} is called immediately and its
         * result is passed to {@link #comboChartVisual(ComboChartVisual)}.
         * 
         * @param comboChartVisual
         *        a consumer that will call methods on {@link ComboChartVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comboChartVisual(ComboChartVisual)
         */
        default Builder comboChartVisual(Consumer<ComboChartVisual.Builder> comboChartVisual) {
            return comboChartVisual(ComboChartVisual.builder().applyMutation(comboChartVisual).build());
        }

        /**
         * <p>
         * A box plot.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/box-plots.html">Using
         * box plots</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * 
         * @param boxPlotVisual
         *        A box plot.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/box-plots.html">Using box plots</a> in the
         *        <i>Amazon Quick Suite User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boxPlotVisual(BoxPlotVisual boxPlotVisual);

        /**
         * <p>
         * A box plot.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/box-plots.html">Using
         * box plots</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link BoxPlotVisual.Builder} avoiding the need
         * to create one manually via {@link BoxPlotVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BoxPlotVisual.Builder#build()} is called immediately and its
         * result is passed to {@link #boxPlotVisual(BoxPlotVisual)}.
         * 
         * @param boxPlotVisual
         *        a consumer that will call methods on {@link BoxPlotVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #boxPlotVisual(BoxPlotVisual)
         */
        default Builder boxPlotVisual(Consumer<BoxPlotVisual.Builder> boxPlotVisual) {
            return boxPlotVisual(BoxPlotVisual.builder().applyMutation(boxPlotVisual).build());
        }

        /**
         * <p>
         * A waterfall chart.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/waterfall-chart.html">Using waterfall charts</a> in
         * the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * 
         * @param waterfallVisual
         *        A waterfall chart.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/waterfall-chart.html">Using waterfall
         *        charts</a> in the <i>Amazon Quick Suite User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waterfallVisual(WaterfallVisual waterfallVisual);

        /**
         * <p>
         * A waterfall chart.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/waterfall-chart.html">Using waterfall charts</a> in
         * the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link WaterfallVisual.Builder} avoiding the
         * need to create one manually via {@link WaterfallVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaterfallVisual.Builder#build()} is called immediately and its
         * result is passed to {@link #waterfallVisual(WaterfallVisual)}.
         * 
         * @param waterfallVisual
         *        a consumer that will call methods on {@link WaterfallVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #waterfallVisual(WaterfallVisual)
         */
        default Builder waterfallVisual(Consumer<WaterfallVisual.Builder> waterfallVisual) {
            return waterfallVisual(WaterfallVisual.builder().applyMutation(waterfallVisual).build());
        }

        /**
         * <p>
         * A histogram.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/histogram-charts.html">Using histograms</a> in the
         * <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * 
         * @param histogramVisual
         *        A histogram.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/histogram-charts.html">Using histograms</a>
         *        in the <i>Amazon Quick Suite User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder histogramVisual(HistogramVisual histogramVisual);

        /**
         * <p>
         * A histogram.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/histogram-charts.html">Using histograms</a> in the
         * <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link HistogramVisual.Builder} avoiding the
         * need to create one manually via {@link HistogramVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HistogramVisual.Builder#build()} is called immediately and its
         * result is passed to {@link #histogramVisual(HistogramVisual)}.
         * 
         * @param histogramVisual
         *        a consumer that will call methods on {@link HistogramVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #histogramVisual(HistogramVisual)
         */
        default Builder histogramVisual(Consumer<HistogramVisual.Builder> histogramVisual) {
            return histogramVisual(HistogramVisual.builder().applyMutation(histogramVisual).build());
        }

        /**
         * <p>
         * A word cloud.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/word-cloud.html">Using
         * word clouds</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * 
         * @param wordCloudVisual
         *        A word cloud.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/word-cloud.html">Using word clouds</a> in the
         *        <i>Amazon Quick Suite User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wordCloudVisual(WordCloudVisual wordCloudVisual);

        /**
         * <p>
         * A word cloud.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/word-cloud.html">Using
         * word clouds</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link WordCloudVisual.Builder} avoiding the
         * need to create one manually via {@link WordCloudVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WordCloudVisual.Builder#build()} is called immediately and its
         * result is passed to {@link #wordCloudVisual(WordCloudVisual)}.
         * 
         * @param wordCloudVisual
         *        a consumer that will call methods on {@link WordCloudVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #wordCloudVisual(WordCloudVisual)
         */
        default Builder wordCloudVisual(Consumer<WordCloudVisual.Builder> wordCloudVisual) {
            return wordCloudVisual(WordCloudVisual.builder().applyMutation(wordCloudVisual).build());
        }

        /**
         * <p>
         * An insight visual.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/computational-insights.html">Working with
         * insights</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * 
         * @param insightVisual
         *        An insight visual.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/computational-insights.html">Working with
         *        insights</a> in the <i>Amazon Quick Suite User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightVisual(InsightVisual insightVisual);

        /**
         * <p>
         * An insight visual.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/computational-insights.html">Working with
         * insights</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link InsightVisual.Builder} avoiding the need
         * to create one manually via {@link InsightVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InsightVisual.Builder#build()} is called immediately and its
         * result is passed to {@link #insightVisual(InsightVisual)}.
         * 
         * @param insightVisual
         *        a consumer that will call methods on {@link InsightVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insightVisual(InsightVisual)
         */
        default Builder insightVisual(Consumer<InsightVisual.Builder> insightVisual) {
            return insightVisual(InsightVisual.builder().applyMutation(insightVisual).build());
        }

        /**
         * <p>
         * A sankey diagram.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/sankey-diagram.html">Using Sankey diagrams</a> in
         * the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * 
         * @param sankeyDiagramVisual
         *        A sankey diagram.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/sankey-diagram.html">Using Sankey
         *        diagrams</a> in the <i>Amazon Quick Suite User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sankeyDiagramVisual(SankeyDiagramVisual sankeyDiagramVisual);

        /**
         * <p>
         * A sankey diagram.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/sankey-diagram.html">Using Sankey diagrams</a> in
         * the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link SankeyDiagramVisual.Builder} avoiding the
         * need to create one manually via {@link SankeyDiagramVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SankeyDiagramVisual.Builder#build()} is called immediately and
         * its result is passed to {@link #sankeyDiagramVisual(SankeyDiagramVisual)}.
         * 
         * @param sankeyDiagramVisual
         *        a consumer that will call methods on {@link SankeyDiagramVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sankeyDiagramVisual(SankeyDiagramVisual)
         */
        default Builder sankeyDiagramVisual(Consumer<SankeyDiagramVisual.Builder> sankeyDiagramVisual) {
            return sankeyDiagramVisual(SankeyDiagramVisual.builder().applyMutation(sankeyDiagramVisual).build());
        }

        /**
         * <p>
         * A visual that contains custom content.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/custom-visual-content.html">Using custom visual
         * content</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * 
         * @param customContentVisual
         *        A visual that contains custom content.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/custom-visual-content.html">Using custom
         *        visual content</a> in the <i>Amazon Quick Suite User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customContentVisual(CustomContentVisual customContentVisual);

        /**
         * <p>
         * A visual that contains custom content.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/custom-visual-content.html">Using custom visual
         * content</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomContentVisual.Builder} avoiding the
         * need to create one manually via {@link CustomContentVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomContentVisual.Builder#build()} is called immediately and
         * its result is passed to {@link #customContentVisual(CustomContentVisual)}.
         * 
         * @param customContentVisual
         *        a consumer that will call methods on {@link CustomContentVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customContentVisual(CustomContentVisual)
         */
        default Builder customContentVisual(Consumer<CustomContentVisual.Builder> customContentVisual) {
            return customContentVisual(CustomContentVisual.builder().applyMutation(customContentVisual).build());
        }

        /**
         * <p>
         * An empty visual.
         * </p>
         * 
         * @param emptyVisual
         *        An empty visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emptyVisual(EmptyVisual emptyVisual);

        /**
         * <p>
         * An empty visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmptyVisual.Builder} avoiding the need to
         * create one manually via {@link EmptyVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmptyVisual.Builder#build()} is called immediately and its result
         * is passed to {@link #emptyVisual(EmptyVisual)}.
         * 
         * @param emptyVisual
         *        a consumer that will call methods on {@link EmptyVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emptyVisual(EmptyVisual)
         */
        default Builder emptyVisual(Consumer<EmptyVisual.Builder> emptyVisual) {
            return emptyVisual(EmptyVisual.builder().applyMutation(emptyVisual).build());
        }

        /**
         * <p>
         * A radar chart visual.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/radar-chart.html">Using
         * radar charts</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * 
         * @param radarChartVisual
         *        A radar chart visual.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/radar-chart.html">Using radar charts</a> in
         *        the <i>Amazon Quick Suite User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder radarChartVisual(RadarChartVisual radarChartVisual);

        /**
         * <p>
         * A radar chart visual.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/radar-chart.html">Using
         * radar charts</a> in the <i>Amazon Quick Suite User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link RadarChartVisual.Builder} avoiding the
         * need to create one manually via {@link RadarChartVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RadarChartVisual.Builder#build()} is called immediately and its
         * result is passed to {@link #radarChartVisual(RadarChartVisual)}.
         * 
         * @param radarChartVisual
         *        a consumer that will call methods on {@link RadarChartVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #radarChartVisual(RadarChartVisual)
         */
        default Builder radarChartVisual(Consumer<RadarChartVisual.Builder> radarChartVisual) {
            return radarChartVisual(RadarChartVisual.builder().applyMutation(radarChartVisual).build());
        }

        /**
         * <p>
         * The custom plugin visual type.
         * </p>
         * 
         * @param pluginVisual
         *        The custom plugin visual type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginVisual(PluginVisual pluginVisual);

        /**
         * <p>
         * The custom plugin visual type.
         * </p>
         * This is a convenience method that creates an instance of the {@link PluginVisual.Builder} avoiding the need
         * to create one manually via {@link PluginVisual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PluginVisual.Builder#build()} is called immediately and its
         * result is passed to {@link #pluginVisual(PluginVisual)}.
         * 
         * @param pluginVisual
         *        a consumer that will call methods on {@link PluginVisual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pluginVisual(PluginVisual)
         */
        default Builder pluginVisual(Consumer<PluginVisual.Builder> pluginVisual) {
            return pluginVisual(PluginVisual.builder().applyMutation(pluginVisual).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TableVisual tableVisual;

        private PivotTableVisual pivotTableVisual;

        private BarChartVisual barChartVisual;

        private KPIVisual kpiVisual;

        private PieChartVisual pieChartVisual;

        private GaugeChartVisual gaugeChartVisual;

        private LineChartVisual lineChartVisual;

        private HeatMapVisual heatMapVisual;

        private TreeMapVisual treeMapVisual;

        private GeospatialMapVisual geospatialMapVisual;

        private FilledMapVisual filledMapVisual;

        private LayerMapVisual layerMapVisual;

        private FunnelChartVisual funnelChartVisual;

        private ScatterPlotVisual scatterPlotVisual;

        private ComboChartVisual comboChartVisual;

        private BoxPlotVisual boxPlotVisual;

        private WaterfallVisual waterfallVisual;

        private HistogramVisual histogramVisual;

        private WordCloudVisual wordCloudVisual;

        private InsightVisual insightVisual;

        private SankeyDiagramVisual sankeyDiagramVisual;

        private CustomContentVisual customContentVisual;

        private EmptyVisual emptyVisual;

        private RadarChartVisual radarChartVisual;

        private PluginVisual pluginVisual;

        private BuilderImpl() {
        }

        private BuilderImpl(Visual model) {
            tableVisual(model.tableVisual);
            pivotTableVisual(model.pivotTableVisual);
            barChartVisual(model.barChartVisual);
            kpiVisual(model.kpiVisual);
            pieChartVisual(model.pieChartVisual);
            gaugeChartVisual(model.gaugeChartVisual);
            lineChartVisual(model.lineChartVisual);
            heatMapVisual(model.heatMapVisual);
            treeMapVisual(model.treeMapVisual);
            geospatialMapVisual(model.geospatialMapVisual);
            filledMapVisual(model.filledMapVisual);
            layerMapVisual(model.layerMapVisual);
            funnelChartVisual(model.funnelChartVisual);
            scatterPlotVisual(model.scatterPlotVisual);
            comboChartVisual(model.comboChartVisual);
            boxPlotVisual(model.boxPlotVisual);
            waterfallVisual(model.waterfallVisual);
            histogramVisual(model.histogramVisual);
            wordCloudVisual(model.wordCloudVisual);
            insightVisual(model.insightVisual);
            sankeyDiagramVisual(model.sankeyDiagramVisual);
            customContentVisual(model.customContentVisual);
            emptyVisual(model.emptyVisual);
            radarChartVisual(model.radarChartVisual);
            pluginVisual(model.pluginVisual);
        }

        public final TableVisual.Builder getTableVisual() {
            return tableVisual != null ? tableVisual.toBuilder() : null;
        }

        public final void setTableVisual(TableVisual.BuilderImpl tableVisual) {
            this.tableVisual = tableVisual != null ? tableVisual.build() : null;
        }

        @Override
        public final Builder tableVisual(TableVisual tableVisual) {
            this.tableVisual = tableVisual;
            return this;
        }

        public final PivotTableVisual.Builder getPivotTableVisual() {
            return pivotTableVisual != null ? pivotTableVisual.toBuilder() : null;
        }

        public final void setPivotTableVisual(PivotTableVisual.BuilderImpl pivotTableVisual) {
            this.pivotTableVisual = pivotTableVisual != null ? pivotTableVisual.build() : null;
        }

        @Override
        public final Builder pivotTableVisual(PivotTableVisual pivotTableVisual) {
            this.pivotTableVisual = pivotTableVisual;
            return this;
        }

        public final BarChartVisual.Builder getBarChartVisual() {
            return barChartVisual != null ? barChartVisual.toBuilder() : null;
        }

        public final void setBarChartVisual(BarChartVisual.BuilderImpl barChartVisual) {
            this.barChartVisual = barChartVisual != null ? barChartVisual.build() : null;
        }

        @Override
        public final Builder barChartVisual(BarChartVisual barChartVisual) {
            this.barChartVisual = barChartVisual;
            return this;
        }

        public final KPIVisual.Builder getKpiVisual() {
            return kpiVisual != null ? kpiVisual.toBuilder() : null;
        }

        public final void setKpiVisual(KPIVisual.BuilderImpl kpiVisual) {
            this.kpiVisual = kpiVisual != null ? kpiVisual.build() : null;
        }

        @Override
        public final Builder kpiVisual(KPIVisual kpiVisual) {
            this.kpiVisual = kpiVisual;
            return this;
        }

        public final PieChartVisual.Builder getPieChartVisual() {
            return pieChartVisual != null ? pieChartVisual.toBuilder() : null;
        }

        public final void setPieChartVisual(PieChartVisual.BuilderImpl pieChartVisual) {
            this.pieChartVisual = pieChartVisual != null ? pieChartVisual.build() : null;
        }

        @Override
        public final Builder pieChartVisual(PieChartVisual pieChartVisual) {
            this.pieChartVisual = pieChartVisual;
            return this;
        }

        public final GaugeChartVisual.Builder getGaugeChartVisual() {
            return gaugeChartVisual != null ? gaugeChartVisual.toBuilder() : null;
        }

        public final void setGaugeChartVisual(GaugeChartVisual.BuilderImpl gaugeChartVisual) {
            this.gaugeChartVisual = gaugeChartVisual != null ? gaugeChartVisual.build() : null;
        }

        @Override
        public final Builder gaugeChartVisual(GaugeChartVisual gaugeChartVisual) {
            this.gaugeChartVisual = gaugeChartVisual;
            return this;
        }

        public final LineChartVisual.Builder getLineChartVisual() {
            return lineChartVisual != null ? lineChartVisual.toBuilder() : null;
        }

        public final void setLineChartVisual(LineChartVisual.BuilderImpl lineChartVisual) {
            this.lineChartVisual = lineChartVisual != null ? lineChartVisual.build() : null;
        }

        @Override
        public final Builder lineChartVisual(LineChartVisual lineChartVisual) {
            this.lineChartVisual = lineChartVisual;
            return this;
        }

        public final HeatMapVisual.Builder getHeatMapVisual() {
            return heatMapVisual != null ? heatMapVisual.toBuilder() : null;
        }

        public final void setHeatMapVisual(HeatMapVisual.BuilderImpl heatMapVisual) {
            this.heatMapVisual = heatMapVisual != null ? heatMapVisual.build() : null;
        }

        @Override
        public final Builder heatMapVisual(HeatMapVisual heatMapVisual) {
            this.heatMapVisual = heatMapVisual;
            return this;
        }

        public final TreeMapVisual.Builder getTreeMapVisual() {
            return treeMapVisual != null ? treeMapVisual.toBuilder() : null;
        }

        public final void setTreeMapVisual(TreeMapVisual.BuilderImpl treeMapVisual) {
            this.treeMapVisual = treeMapVisual != null ? treeMapVisual.build() : null;
        }

        @Override
        public final Builder treeMapVisual(TreeMapVisual treeMapVisual) {
            this.treeMapVisual = treeMapVisual;
            return this;
        }

        public final GeospatialMapVisual.Builder getGeospatialMapVisual() {
            return geospatialMapVisual != null ? geospatialMapVisual.toBuilder() : null;
        }

        public final void setGeospatialMapVisual(GeospatialMapVisual.BuilderImpl geospatialMapVisual) {
            this.geospatialMapVisual = geospatialMapVisual != null ? geospatialMapVisual.build() : null;
        }

        @Override
        public final Builder geospatialMapVisual(GeospatialMapVisual geospatialMapVisual) {
            this.geospatialMapVisual = geospatialMapVisual;
            return this;
        }

        public final FilledMapVisual.Builder getFilledMapVisual() {
            return filledMapVisual != null ? filledMapVisual.toBuilder() : null;
        }

        public final void setFilledMapVisual(FilledMapVisual.BuilderImpl filledMapVisual) {
            this.filledMapVisual = filledMapVisual != null ? filledMapVisual.build() : null;
        }

        @Override
        public final Builder filledMapVisual(FilledMapVisual filledMapVisual) {
            this.filledMapVisual = filledMapVisual;
            return this;
        }

        public final LayerMapVisual.Builder getLayerMapVisual() {
            return layerMapVisual != null ? layerMapVisual.toBuilder() : null;
        }

        public final void setLayerMapVisual(LayerMapVisual.BuilderImpl layerMapVisual) {
            this.layerMapVisual = layerMapVisual != null ? layerMapVisual.build() : null;
        }

        @Override
        public final Builder layerMapVisual(LayerMapVisual layerMapVisual) {
            this.layerMapVisual = layerMapVisual;
            return this;
        }

        public final FunnelChartVisual.Builder getFunnelChartVisual() {
            return funnelChartVisual != null ? funnelChartVisual.toBuilder() : null;
        }

        public final void setFunnelChartVisual(FunnelChartVisual.BuilderImpl funnelChartVisual) {
            this.funnelChartVisual = funnelChartVisual != null ? funnelChartVisual.build() : null;
        }

        @Override
        public final Builder funnelChartVisual(FunnelChartVisual funnelChartVisual) {
            this.funnelChartVisual = funnelChartVisual;
            return this;
        }

        public final ScatterPlotVisual.Builder getScatterPlotVisual() {
            return scatterPlotVisual != null ? scatterPlotVisual.toBuilder() : null;
        }

        public final void setScatterPlotVisual(ScatterPlotVisual.BuilderImpl scatterPlotVisual) {
            this.scatterPlotVisual = scatterPlotVisual != null ? scatterPlotVisual.build() : null;
        }

        @Override
        public final Builder scatterPlotVisual(ScatterPlotVisual scatterPlotVisual) {
            this.scatterPlotVisual = scatterPlotVisual;
            return this;
        }

        public final ComboChartVisual.Builder getComboChartVisual() {
            return comboChartVisual != null ? comboChartVisual.toBuilder() : null;
        }

        public final void setComboChartVisual(ComboChartVisual.BuilderImpl comboChartVisual) {
            this.comboChartVisual = comboChartVisual != null ? comboChartVisual.build() : null;
        }

        @Override
        public final Builder comboChartVisual(ComboChartVisual comboChartVisual) {
            this.comboChartVisual = comboChartVisual;
            return this;
        }

        public final BoxPlotVisual.Builder getBoxPlotVisual() {
            return boxPlotVisual != null ? boxPlotVisual.toBuilder() : null;
        }

        public final void setBoxPlotVisual(BoxPlotVisual.BuilderImpl boxPlotVisual) {
            this.boxPlotVisual = boxPlotVisual != null ? boxPlotVisual.build() : null;
        }

        @Override
        public final Builder boxPlotVisual(BoxPlotVisual boxPlotVisual) {
            this.boxPlotVisual = boxPlotVisual;
            return this;
        }

        public final WaterfallVisual.Builder getWaterfallVisual() {
            return waterfallVisual != null ? waterfallVisual.toBuilder() : null;
        }

        public final void setWaterfallVisual(WaterfallVisual.BuilderImpl waterfallVisual) {
            this.waterfallVisual = waterfallVisual != null ? waterfallVisual.build() : null;
        }

        @Override
        public final Builder waterfallVisual(WaterfallVisual waterfallVisual) {
            this.waterfallVisual = waterfallVisual;
            return this;
        }

        public final HistogramVisual.Builder getHistogramVisual() {
            return histogramVisual != null ? histogramVisual.toBuilder() : null;
        }

        public final void setHistogramVisual(HistogramVisual.BuilderImpl histogramVisual) {
            this.histogramVisual = histogramVisual != null ? histogramVisual.build() : null;
        }

        @Override
        public final Builder histogramVisual(HistogramVisual histogramVisual) {
            this.histogramVisual = histogramVisual;
            return this;
        }

        public final WordCloudVisual.Builder getWordCloudVisual() {
            return wordCloudVisual != null ? wordCloudVisual.toBuilder() : null;
        }

        public final void setWordCloudVisual(WordCloudVisual.BuilderImpl wordCloudVisual) {
            this.wordCloudVisual = wordCloudVisual != null ? wordCloudVisual.build() : null;
        }

        @Override
        public final Builder wordCloudVisual(WordCloudVisual wordCloudVisual) {
            this.wordCloudVisual = wordCloudVisual;
            return this;
        }

        public final InsightVisual.Builder getInsightVisual() {
            return insightVisual != null ? insightVisual.toBuilder() : null;
        }

        public final void setInsightVisual(InsightVisual.BuilderImpl insightVisual) {
            this.insightVisual = insightVisual != null ? insightVisual.build() : null;
        }

        @Override
        public final Builder insightVisual(InsightVisual insightVisual) {
            this.insightVisual = insightVisual;
            return this;
        }

        public final SankeyDiagramVisual.Builder getSankeyDiagramVisual() {
            return sankeyDiagramVisual != null ? sankeyDiagramVisual.toBuilder() : null;
        }

        public final void setSankeyDiagramVisual(SankeyDiagramVisual.BuilderImpl sankeyDiagramVisual) {
            this.sankeyDiagramVisual = sankeyDiagramVisual != null ? sankeyDiagramVisual.build() : null;
        }

        @Override
        public final Builder sankeyDiagramVisual(SankeyDiagramVisual sankeyDiagramVisual) {
            this.sankeyDiagramVisual = sankeyDiagramVisual;
            return this;
        }

        public final CustomContentVisual.Builder getCustomContentVisual() {
            return customContentVisual != null ? customContentVisual.toBuilder() : null;
        }

        public final void setCustomContentVisual(CustomContentVisual.BuilderImpl customContentVisual) {
            this.customContentVisual = customContentVisual != null ? customContentVisual.build() : null;
        }

        @Override
        public final Builder customContentVisual(CustomContentVisual customContentVisual) {
            this.customContentVisual = customContentVisual;
            return this;
        }

        public final EmptyVisual.Builder getEmptyVisual() {
            return emptyVisual != null ? emptyVisual.toBuilder() : null;
        }

        public final void setEmptyVisual(EmptyVisual.BuilderImpl emptyVisual) {
            this.emptyVisual = emptyVisual != null ? emptyVisual.build() : null;
        }

        @Override
        public final Builder emptyVisual(EmptyVisual emptyVisual) {
            this.emptyVisual = emptyVisual;
            return this;
        }

        public final RadarChartVisual.Builder getRadarChartVisual() {
            return radarChartVisual != null ? radarChartVisual.toBuilder() : null;
        }

        public final void setRadarChartVisual(RadarChartVisual.BuilderImpl radarChartVisual) {
            this.radarChartVisual = radarChartVisual != null ? radarChartVisual.build() : null;
        }

        @Override
        public final Builder radarChartVisual(RadarChartVisual radarChartVisual) {
            this.radarChartVisual = radarChartVisual;
            return this;
        }

        public final PluginVisual.Builder getPluginVisual() {
            return pluginVisual != null ? pluginVisual.toBuilder() : null;
        }

        public final void setPluginVisual(PluginVisual.BuilderImpl pluginVisual) {
            this.pluginVisual = pluginVisual != null ? pluginVisual.build() : null;
        }

        @Override
        public final Builder pluginVisual(PluginVisual pluginVisual) {
            this.pluginVisual = pluginVisual;
            return this;
        }

        @Override
        public Visual build() {
            return new Visual(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
