/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The color configuration for individual groups within a waterfall visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaterfallChartGroupColorConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<WaterfallChartGroupColorConfiguration.Builder, WaterfallChartGroupColorConfiguration> {
    private static final SdkField<String> POSITIVE_BAR_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PositiveBarColor").getter(getter(WaterfallChartGroupColorConfiguration::positiveBarColor))
            .setter(setter(Builder::positiveBarColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PositiveBarColor").build()).build();

    private static final SdkField<String> NEGATIVE_BAR_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NegativeBarColor").getter(getter(WaterfallChartGroupColorConfiguration::negativeBarColor))
            .setter(setter(Builder::negativeBarColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NegativeBarColor").build()).build();

    private static final SdkField<String> TOTAL_BAR_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TotalBarColor").getter(getter(WaterfallChartGroupColorConfiguration::totalBarColor))
            .setter(setter(Builder::totalBarColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalBarColor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POSITIVE_BAR_COLOR_FIELD,
            NEGATIVE_BAR_COLOR_FIELD, TOTAL_BAR_COLOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String positiveBarColor;

    private final String negativeBarColor;

    private final String totalBarColor;

    private WaterfallChartGroupColorConfiguration(BuilderImpl builder) {
        this.positiveBarColor = builder.positiveBarColor;
        this.negativeBarColor = builder.negativeBarColor;
        this.totalBarColor = builder.totalBarColor;
    }

    /**
     * <p>
     * Defines the color for the positive bars of a waterfall chart.
     * </p>
     * 
     * @return Defines the color for the positive bars of a waterfall chart.
     */
    public final String positiveBarColor() {
        return positiveBarColor;
    }

    /**
     * <p>
     * Defines the color for the negative bars of a waterfall chart.
     * </p>
     * 
     * @return Defines the color for the negative bars of a waterfall chart.
     */
    public final String negativeBarColor() {
        return negativeBarColor;
    }

    /**
     * <p>
     * Defines the color for the total bars of a waterfall chart.
     * </p>
     * 
     * @return Defines the color for the total bars of a waterfall chart.
     */
    public final String totalBarColor() {
        return totalBarColor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(positiveBarColor());
        hashCode = 31 * hashCode + Objects.hashCode(negativeBarColor());
        hashCode = 31 * hashCode + Objects.hashCode(totalBarColor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaterfallChartGroupColorConfiguration)) {
            return false;
        }
        WaterfallChartGroupColorConfiguration other = (WaterfallChartGroupColorConfiguration) obj;
        return Objects.equals(positiveBarColor(), other.positiveBarColor())
                && Objects.equals(negativeBarColor(), other.negativeBarColor())
                && Objects.equals(totalBarColor(), other.totalBarColor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WaterfallChartGroupColorConfiguration").add("PositiveBarColor", positiveBarColor())
                .add("NegativeBarColor", negativeBarColor()).add("TotalBarColor", totalBarColor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PositiveBarColor":
            return Optional.ofNullable(clazz.cast(positiveBarColor()));
        case "NegativeBarColor":
            return Optional.ofNullable(clazz.cast(negativeBarColor()));
        case "TotalBarColor":
            return Optional.ofNullable(clazz.cast(totalBarColor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PositiveBarColor", POSITIVE_BAR_COLOR_FIELD);
        map.put("NegativeBarColor", NEGATIVE_BAR_COLOR_FIELD);
        map.put("TotalBarColor", TOTAL_BAR_COLOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaterfallChartGroupColorConfiguration, T> g) {
        return obj -> g.apply((WaterfallChartGroupColorConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaterfallChartGroupColorConfiguration> {
        /**
         * <p>
         * Defines the color for the positive bars of a waterfall chart.
         * </p>
         * 
         * @param positiveBarColor
         *        Defines the color for the positive bars of a waterfall chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder positiveBarColor(String positiveBarColor);

        /**
         * <p>
         * Defines the color for the negative bars of a waterfall chart.
         * </p>
         * 
         * @param negativeBarColor
         *        Defines the color for the negative bars of a waterfall chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder negativeBarColor(String negativeBarColor);

        /**
         * <p>
         * Defines the color for the total bars of a waterfall chart.
         * </p>
         * 
         * @param totalBarColor
         *        Defines the color for the total bars of a waterfall chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalBarColor(String totalBarColor);
    }

    static final class BuilderImpl implements Builder {
        private String positiveBarColor;

        private String negativeBarColor;

        private String totalBarColor;

        private BuilderImpl() {
        }

        private BuilderImpl(WaterfallChartGroupColorConfiguration model) {
            positiveBarColor(model.positiveBarColor);
            negativeBarColor(model.negativeBarColor);
            totalBarColor(model.totalBarColor);
        }

        public final String getPositiveBarColor() {
            return positiveBarColor;
        }

        public final void setPositiveBarColor(String positiveBarColor) {
            this.positiveBarColor = positiveBarColor;
        }

        @Override
        public final Builder positiveBarColor(String positiveBarColor) {
            this.positiveBarColor = positiveBarColor;
            return this;
        }

        public final String getNegativeBarColor() {
            return negativeBarColor;
        }

        public final void setNegativeBarColor(String negativeBarColor) {
            this.negativeBarColor = negativeBarColor;
        }

        @Override
        public final Builder negativeBarColor(String negativeBarColor) {
            this.negativeBarColor = negativeBarColor;
            return this;
        }

        public final String getTotalBarColor() {
            return totalBarColor;
        }

        public final void setTotalBarColor(String totalBarColor) {
            this.totalBarColor = totalBarColor;
        }

        @Override
        public final Builder totalBarColor(String totalBarColor) {
            this.totalBarColor = totalBarColor;
            return this;
        }

        @Override
        public WaterfallChartGroupColorConfiguration build() {
            return new WaterfallChartGroupColorConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
