/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for a web crawler data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WebCrawlerParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<WebCrawlerParameters.Builder, WebCrawlerParameters> {
    private static final SdkField<String> WEB_CRAWLER_AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebCrawlerAuthType").getter(getter(WebCrawlerParameters::webCrawlerAuthTypeAsString))
            .setter(setter(Builder::webCrawlerAuthType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebCrawlerAuthType").build())
            .build();

    private static final SdkField<String> USERNAME_FIELD_XPATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UsernameFieldXpath").getter(getter(WebCrawlerParameters::usernameFieldXpath))
            .setter(setter(Builder::usernameFieldXpath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsernameFieldXpath").build())
            .build();

    private static final SdkField<String> PASSWORD_FIELD_XPATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PasswordFieldXpath").getter(getter(WebCrawlerParameters::passwordFieldXpath))
            .setter(setter(Builder::passwordFieldXpath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PasswordFieldXpath").build())
            .build();

    private static final SdkField<String> USERNAME_BUTTON_XPATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UsernameButtonXpath").getter(getter(WebCrawlerParameters::usernameButtonXpath))
            .setter(setter(Builder::usernameButtonXpath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsernameButtonXpath").build())
            .build();

    private static final SdkField<String> PASSWORD_BUTTON_XPATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PasswordButtonXpath").getter(getter(WebCrawlerParameters::passwordButtonXpath))
            .setter(setter(Builder::passwordButtonXpath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PasswordButtonXpath").build())
            .build();

    private static final SdkField<String> LOGIN_PAGE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoginPageUrl").getter(getter(WebCrawlerParameters::loginPageUrl)).setter(setter(Builder::loginPageUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoginPageUrl").build()).build();

    private static final SdkField<String> WEB_PROXY_HOST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebProxyHostName").getter(getter(WebCrawlerParameters::webProxyHostName))
            .setter(setter(Builder::webProxyHostName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebProxyHostName").build()).build();

    private static final SdkField<Integer> WEB_PROXY_PORT_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("WebProxyPortNumber").getter(getter(WebCrawlerParameters::webProxyPortNumber))
            .setter(setter(Builder::webProxyPortNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebProxyPortNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_CRAWLER_AUTH_TYPE_FIELD,
            USERNAME_FIELD_XPATH_FIELD, PASSWORD_FIELD_XPATH_FIELD, USERNAME_BUTTON_XPATH_FIELD, PASSWORD_BUTTON_XPATH_FIELD,
            LOGIN_PAGE_URL_FIELD, WEB_PROXY_HOST_NAME_FIELD, WEB_PROXY_PORT_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String webCrawlerAuthType;

    private final String usernameFieldXpath;

    private final String passwordFieldXpath;

    private final String usernameButtonXpath;

    private final String passwordButtonXpath;

    private final String loginPageUrl;

    private final String webProxyHostName;

    private final Integer webProxyPortNumber;

    private WebCrawlerParameters(BuilderImpl builder) {
        this.webCrawlerAuthType = builder.webCrawlerAuthType;
        this.usernameFieldXpath = builder.usernameFieldXpath;
        this.passwordFieldXpath = builder.passwordFieldXpath;
        this.usernameButtonXpath = builder.usernameButtonXpath;
        this.passwordButtonXpath = builder.passwordButtonXpath;
        this.loginPageUrl = builder.loginPageUrl;
        this.webProxyHostName = builder.webProxyHostName;
        this.webProxyPortNumber = builder.webProxyPortNumber;
    }

    /**
     * <p>
     * The authentication type for the web crawler. The type can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NO_AUTH</code>: No authentication required.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BASIC_AUTH</code>: Basic authentication using username and password.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SAML</code>: SAML-based authentication.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FORM</code>: Form-based authentication.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #webCrawlerAuthType} will return {@link WebCrawlerAuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #webCrawlerAuthTypeAsString}.
     * </p>
     * 
     * @return The authentication type for the web crawler. The type can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NO_AUTH</code>: No authentication required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BASIC_AUTH</code>: Basic authentication using username and password.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SAML</code>: SAML-based authentication.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FORM</code>: Form-based authentication.
     *         </p>
     *         </li>
     * @see WebCrawlerAuthType
     */
    public final WebCrawlerAuthType webCrawlerAuthType() {
        return WebCrawlerAuthType.fromValue(webCrawlerAuthType);
    }

    /**
     * <p>
     * The authentication type for the web crawler. The type can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NO_AUTH</code>: No authentication required.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BASIC_AUTH</code>: Basic authentication using username and password.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SAML</code>: SAML-based authentication.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FORM</code>: Form-based authentication.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #webCrawlerAuthType} will return {@link WebCrawlerAuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #webCrawlerAuthTypeAsString}.
     * </p>
     * 
     * @return The authentication type for the web crawler. The type can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NO_AUTH</code>: No authentication required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BASIC_AUTH</code>: Basic authentication using username and password.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SAML</code>: SAML-based authentication.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FORM</code>: Form-based authentication.
     *         </p>
     *         </li>
     * @see WebCrawlerAuthType
     */
    public final String webCrawlerAuthTypeAsString() {
        return webCrawlerAuthType;
    }

    /**
     * <p>
     * The XPath expression for locating the username field on the login page.
     * </p>
     * 
     * @return The XPath expression for locating the username field on the login page.
     */
    public final String usernameFieldXpath() {
        return usernameFieldXpath;
    }

    /**
     * <p>
     * The XPath expression for locating the password field on the login page.
     * </p>
     * 
     * @return The XPath expression for locating the password field on the login page.
     */
    public final String passwordFieldXpath() {
        return passwordFieldXpath;
    }

    /**
     * <p>
     * The XPath expression for locating the username submit button on the login page.
     * </p>
     * 
     * @return The XPath expression for locating the username submit button on the login page.
     */
    public final String usernameButtonXpath() {
        return usernameButtonXpath;
    }

    /**
     * <p>
     * The XPath expression for locating the password submit button on the login page.
     * </p>
     * 
     * @return The XPath expression for locating the password submit button on the login page.
     */
    public final String passwordButtonXpath() {
        return passwordButtonXpath;
    }

    /**
     * <p>
     * The URL of the login page for the web crawler to authenticate.
     * </p>
     * 
     * @return The URL of the login page for the web crawler to authenticate.
     */
    public final String loginPageUrl() {
        return loginPageUrl;
    }

    /**
     * <p>
     * The hostname of the web proxy server for the web crawler.
     * </p>
     * 
     * @return The hostname of the web proxy server for the web crawler.
     */
    public final String webProxyHostName() {
        return webProxyHostName;
    }

    /**
     * <p>
     * The port number of the web proxy server for the web crawler.
     * </p>
     * 
     * @return The port number of the web proxy server for the web crawler.
     */
    public final Integer webProxyPortNumber() {
        return webProxyPortNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(webCrawlerAuthTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(usernameFieldXpath());
        hashCode = 31 * hashCode + Objects.hashCode(passwordFieldXpath());
        hashCode = 31 * hashCode + Objects.hashCode(usernameButtonXpath());
        hashCode = 31 * hashCode + Objects.hashCode(passwordButtonXpath());
        hashCode = 31 * hashCode + Objects.hashCode(loginPageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(webProxyHostName());
        hashCode = 31 * hashCode + Objects.hashCode(webProxyPortNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebCrawlerParameters)) {
            return false;
        }
        WebCrawlerParameters other = (WebCrawlerParameters) obj;
        return Objects.equals(webCrawlerAuthTypeAsString(), other.webCrawlerAuthTypeAsString())
                && Objects.equals(usernameFieldXpath(), other.usernameFieldXpath())
                && Objects.equals(passwordFieldXpath(), other.passwordFieldXpath())
                && Objects.equals(usernameButtonXpath(), other.usernameButtonXpath())
                && Objects.equals(passwordButtonXpath(), other.passwordButtonXpath())
                && Objects.equals(loginPageUrl(), other.loginPageUrl())
                && Objects.equals(webProxyHostName(), other.webProxyHostName())
                && Objects.equals(webProxyPortNumber(), other.webProxyPortNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WebCrawlerParameters").add("WebCrawlerAuthType", webCrawlerAuthTypeAsString())
                .add("UsernameFieldXpath", usernameFieldXpath()).add("PasswordFieldXpath", passwordFieldXpath())
                .add("UsernameButtonXpath", usernameButtonXpath()).add("PasswordButtonXpath", passwordButtonXpath())
                .add("LoginPageUrl", loginPageUrl()).add("WebProxyHostName", webProxyHostName())
                .add("WebProxyPortNumber", webProxyPortNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebCrawlerAuthType":
            return Optional.ofNullable(clazz.cast(webCrawlerAuthTypeAsString()));
        case "UsernameFieldXpath":
            return Optional.ofNullable(clazz.cast(usernameFieldXpath()));
        case "PasswordFieldXpath":
            return Optional.ofNullable(clazz.cast(passwordFieldXpath()));
        case "UsernameButtonXpath":
            return Optional.ofNullable(clazz.cast(usernameButtonXpath()));
        case "PasswordButtonXpath":
            return Optional.ofNullable(clazz.cast(passwordButtonXpath()));
        case "LoginPageUrl":
            return Optional.ofNullable(clazz.cast(loginPageUrl()));
        case "WebProxyHostName":
            return Optional.ofNullable(clazz.cast(webProxyHostName()));
        case "WebProxyPortNumber":
            return Optional.ofNullable(clazz.cast(webProxyPortNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WebCrawlerAuthType", WEB_CRAWLER_AUTH_TYPE_FIELD);
        map.put("UsernameFieldXpath", USERNAME_FIELD_XPATH_FIELD);
        map.put("PasswordFieldXpath", PASSWORD_FIELD_XPATH_FIELD);
        map.put("UsernameButtonXpath", USERNAME_BUTTON_XPATH_FIELD);
        map.put("PasswordButtonXpath", PASSWORD_BUTTON_XPATH_FIELD);
        map.put("LoginPageUrl", LOGIN_PAGE_URL_FIELD);
        map.put("WebProxyHostName", WEB_PROXY_HOST_NAME_FIELD);
        map.put("WebProxyPortNumber", WEB_PROXY_PORT_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WebCrawlerParameters, T> g) {
        return obj -> g.apply((WebCrawlerParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WebCrawlerParameters> {
        /**
         * <p>
         * The authentication type for the web crawler. The type can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NO_AUTH</code>: No authentication required.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BASIC_AUTH</code>: Basic authentication using username and password.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAML</code>: SAML-based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FORM</code>: Form-based authentication.
         * </p>
         * </li>
         * </ul>
         * 
         * @param webCrawlerAuthType
         *        The authentication type for the web crawler. The type can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NO_AUTH</code>: No authentication required.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BASIC_AUTH</code>: Basic authentication using username and password.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAML</code>: SAML-based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FORM</code>: Form-based authentication.
         *        </p>
         *        </li>
         * @see WebCrawlerAuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebCrawlerAuthType
         */
        Builder webCrawlerAuthType(String webCrawlerAuthType);

        /**
         * <p>
         * The authentication type for the web crawler. The type can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NO_AUTH</code>: No authentication required.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BASIC_AUTH</code>: Basic authentication using username and password.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAML</code>: SAML-based authentication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FORM</code>: Form-based authentication.
         * </p>
         * </li>
         * </ul>
         * 
         * @param webCrawlerAuthType
         *        The authentication type for the web crawler. The type can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NO_AUTH</code>: No authentication required.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BASIC_AUTH</code>: Basic authentication using username and password.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAML</code>: SAML-based authentication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FORM</code>: Form-based authentication.
         *        </p>
         *        </li>
         * @see WebCrawlerAuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebCrawlerAuthType
         */
        Builder webCrawlerAuthType(WebCrawlerAuthType webCrawlerAuthType);

        /**
         * <p>
         * The XPath expression for locating the username field on the login page.
         * </p>
         * 
         * @param usernameFieldXpath
         *        The XPath expression for locating the username field on the login page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernameFieldXpath(String usernameFieldXpath);

        /**
         * <p>
         * The XPath expression for locating the password field on the login page.
         * </p>
         * 
         * @param passwordFieldXpath
         *        The XPath expression for locating the password field on the login page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordFieldXpath(String passwordFieldXpath);

        /**
         * <p>
         * The XPath expression for locating the username submit button on the login page.
         * </p>
         * 
         * @param usernameButtonXpath
         *        The XPath expression for locating the username submit button on the login page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernameButtonXpath(String usernameButtonXpath);

        /**
         * <p>
         * The XPath expression for locating the password submit button on the login page.
         * </p>
         * 
         * @param passwordButtonXpath
         *        The XPath expression for locating the password submit button on the login page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordButtonXpath(String passwordButtonXpath);

        /**
         * <p>
         * The URL of the login page for the web crawler to authenticate.
         * </p>
         * 
         * @param loginPageUrl
         *        The URL of the login page for the web crawler to authenticate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loginPageUrl(String loginPageUrl);

        /**
         * <p>
         * The hostname of the web proxy server for the web crawler.
         * </p>
         * 
         * @param webProxyHostName
         *        The hostname of the web proxy server for the web crawler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webProxyHostName(String webProxyHostName);

        /**
         * <p>
         * The port number of the web proxy server for the web crawler.
         * </p>
         * 
         * @param webProxyPortNumber
         *        The port number of the web proxy server for the web crawler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webProxyPortNumber(Integer webProxyPortNumber);
    }

    static final class BuilderImpl implements Builder {
        private String webCrawlerAuthType;

        private String usernameFieldXpath;

        private String passwordFieldXpath;

        private String usernameButtonXpath;

        private String passwordButtonXpath;

        private String loginPageUrl;

        private String webProxyHostName;

        private Integer webProxyPortNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(WebCrawlerParameters model) {
            webCrawlerAuthType(model.webCrawlerAuthType);
            usernameFieldXpath(model.usernameFieldXpath);
            passwordFieldXpath(model.passwordFieldXpath);
            usernameButtonXpath(model.usernameButtonXpath);
            passwordButtonXpath(model.passwordButtonXpath);
            loginPageUrl(model.loginPageUrl);
            webProxyHostName(model.webProxyHostName);
            webProxyPortNumber(model.webProxyPortNumber);
        }

        public final String getWebCrawlerAuthType() {
            return webCrawlerAuthType;
        }

        public final void setWebCrawlerAuthType(String webCrawlerAuthType) {
            this.webCrawlerAuthType = webCrawlerAuthType;
        }

        @Override
        public final Builder webCrawlerAuthType(String webCrawlerAuthType) {
            this.webCrawlerAuthType = webCrawlerAuthType;
            return this;
        }

        @Override
        public final Builder webCrawlerAuthType(WebCrawlerAuthType webCrawlerAuthType) {
            this.webCrawlerAuthType(webCrawlerAuthType == null ? null : webCrawlerAuthType.toString());
            return this;
        }

        public final String getUsernameFieldXpath() {
            return usernameFieldXpath;
        }

        public final void setUsernameFieldXpath(String usernameFieldXpath) {
            this.usernameFieldXpath = usernameFieldXpath;
        }

        @Override
        public final Builder usernameFieldXpath(String usernameFieldXpath) {
            this.usernameFieldXpath = usernameFieldXpath;
            return this;
        }

        public final String getPasswordFieldXpath() {
            return passwordFieldXpath;
        }

        public final void setPasswordFieldXpath(String passwordFieldXpath) {
            this.passwordFieldXpath = passwordFieldXpath;
        }

        @Override
        public final Builder passwordFieldXpath(String passwordFieldXpath) {
            this.passwordFieldXpath = passwordFieldXpath;
            return this;
        }

        public final String getUsernameButtonXpath() {
            return usernameButtonXpath;
        }

        public final void setUsernameButtonXpath(String usernameButtonXpath) {
            this.usernameButtonXpath = usernameButtonXpath;
        }

        @Override
        public final Builder usernameButtonXpath(String usernameButtonXpath) {
            this.usernameButtonXpath = usernameButtonXpath;
            return this;
        }

        public final String getPasswordButtonXpath() {
            return passwordButtonXpath;
        }

        public final void setPasswordButtonXpath(String passwordButtonXpath) {
            this.passwordButtonXpath = passwordButtonXpath;
        }

        @Override
        public final Builder passwordButtonXpath(String passwordButtonXpath) {
            this.passwordButtonXpath = passwordButtonXpath;
            return this;
        }

        public final String getLoginPageUrl() {
            return loginPageUrl;
        }

        public final void setLoginPageUrl(String loginPageUrl) {
            this.loginPageUrl = loginPageUrl;
        }

        @Override
        public final Builder loginPageUrl(String loginPageUrl) {
            this.loginPageUrl = loginPageUrl;
            return this;
        }

        public final String getWebProxyHostName() {
            return webProxyHostName;
        }

        public final void setWebProxyHostName(String webProxyHostName) {
            this.webProxyHostName = webProxyHostName;
        }

        @Override
        public final Builder webProxyHostName(String webProxyHostName) {
            this.webProxyHostName = webProxyHostName;
            return this;
        }

        public final Integer getWebProxyPortNumber() {
            return webProxyPortNumber;
        }

        public final void setWebProxyPortNumber(Integer webProxyPortNumber) {
            this.webProxyPortNumber = webProxyPortNumber;
        }

        @Override
        public final Builder webProxyPortNumber(Integer webProxyPortNumber) {
            this.webProxyPortNumber = webProxyPortNumber;
            return this;
        }

        @Override
        public WebCrawlerParameters build() {
            return new WebCrawlerParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
