/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.ResourcePermission;
import software.amazon.awssdk.services.quicksight.model.ResourcePermissionListCopier;
import software.amazon.awssdk.services.quicksight.model.Tag;
import software.amazon.awssdk.services.quicksight.model.TagListCopier;
import software.amazon.awssdk.services.quicksight.model.TemplateSourceEntity;
import software.amazon.awssdk.services.quicksight.model.TemplateVersionDefinition;
import software.amazon.awssdk.services.quicksight.model.ValidationStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTemplateRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, CreateTemplateRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(CreateTemplateRequest.getter(CreateTemplateRequest::awsAccountId)).setter(CreateTemplateRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateId").getter(CreateTemplateRequest.getter(CreateTemplateRequest::templateId)).setter(CreateTemplateRequest.setter(Builder::templateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("TemplateId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateTemplateRequest.getter(CreateTemplateRequest::name)).setter(CreateTemplateRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<ResourcePermission>> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Permissions").getter(CreateTemplateRequest.getter(CreateTemplateRequest::permissions)).setter(CreateTemplateRequest.setter(Builder::permissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcePermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TemplateSourceEntity> SOURCE_ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceEntity").getter(CreateTemplateRequest.getter(CreateTemplateRequest::sourceEntity)).setter(CreateTemplateRequest.setter(Builder::sourceEntity)).constructor(TemplateSourceEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEntity").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateTemplateRequest.getter(CreateTemplateRequest::tags)).setter(CreateTemplateRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionDescription").getter(CreateTemplateRequest.getter(CreateTemplateRequest::versionDescription)).setter(CreateTemplateRequest.setter(Builder::versionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").build()}).build();
    private static final SdkField<TemplateVersionDefinition> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Definition").getter(CreateTemplateRequest.getter(CreateTemplateRequest::definition)).setter(CreateTemplateRequest.setter(Builder::definition)).constructor(TemplateVersionDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()}).build();
    private static final SdkField<ValidationStrategy> VALIDATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValidationStrategy").getter(CreateTemplateRequest.getter(CreateTemplateRequest::validationStrategy)).setter(CreateTemplateRequest.setter(Builder::validationStrategy)).constructor(ValidationStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, TEMPLATE_ID_FIELD, NAME_FIELD, PERMISSIONS_FIELD, SOURCE_ENTITY_FIELD, TAGS_FIELD, VERSION_DESCRIPTION_FIELD, DEFINITION_FIELD, VALIDATION_STRATEGY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateTemplateRequest.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final String templateId;
    private final String name;
    private final List<ResourcePermission> permissions;
    private final TemplateSourceEntity sourceEntity;
    private final List<Tag> tags;
    private final String versionDescription;
    private final TemplateVersionDefinition definition;
    private final ValidationStrategy validationStrategy;

    private CreateTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.templateId = builder.templateId;
        this.name = builder.name;
        this.permissions = builder.permissions;
        this.sourceEntity = builder.sourceEntity;
        this.tags = builder.tags;
        this.versionDescription = builder.versionDescription;
        this.definition = builder.definition;
        this.validationStrategy = builder.validationStrategy;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String templateId() {
        return this.templateId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasPermissions() {
        return this.permissions != null && !(this.permissions instanceof SdkAutoConstructList);
    }

    public final List<ResourcePermission> permissions() {
        return this.permissions;
    }

    public final TemplateSourceEntity sourceEntity() {
        return this.sourceEntity;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String versionDescription() {
        return this.versionDescription;
    }

    public final TemplateVersionDefinition definition() {
        return this.definition;
    }

    public final ValidationStrategy validationStrategy() {
        return this.validationStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissions() ? this.permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEntity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStrategy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTemplateRequest)) {
            return false;
        }
        CreateTemplateRequest other = (CreateTemplateRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.templateId(), other.templateId()) && Objects.equals(this.name(), other.name()) && this.hasPermissions() == other.hasPermissions() && Objects.equals(this.permissions(), other.permissions()) && Objects.equals(this.sourceEntity(), other.sourceEntity()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.versionDescription(), other.versionDescription()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.validationStrategy(), other.validationStrategy());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTemplateRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("TemplateId", (Object)this.templateId()).add("Name", (Object)this.name()).add("Permissions", this.hasPermissions() ? this.permissions() : null).add("SourceEntity", (Object)this.sourceEntity()).add("Tags", this.hasTags() ? this.tags() : null).add("VersionDescription", (Object)this.versionDescription()).add("Definition", (Object)this.definition()).add("ValidationStrategy", (Object)this.validationStrategy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "TemplateId": {
                return Optional.ofNullable(clazz.cast(this.templateId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
            case "SourceEntity": {
                return Optional.ofNullable(clazz.cast(this.sourceEntity()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "VersionDescription": {
                return Optional.ofNullable(clazz.cast(this.versionDescription()));
            }
            case "Definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "ValidationStrategy": {
                return Optional.ofNullable(clazz.cast(this.validationStrategy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("TemplateId", TEMPLATE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        map.put("SourceEntity", SOURCE_ENTITY_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("VersionDescription", VERSION_DESCRIPTION_FIELD);
        map.put("Definition", DEFINITION_FIELD);
        map.put("ValidationStrategy", VALIDATION_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTemplateRequest, T> g) {
        return obj -> g.apply((CreateTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String templateId;
        private String name;
        private List<ResourcePermission> permissions = DefaultSdkAutoConstructList.getInstance();
        private TemplateSourceEntity sourceEntity;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String versionDescription;
        private TemplateVersionDefinition definition;
        private ValidationStrategy validationStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTemplateRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.templateId(model.templateId);
            this.name(model.name);
            this.permissions(model.permissions);
            this.sourceEntity(model.sourceEntity);
            this.tags(model.tags);
            this.versionDescription(model.versionDescription);
            this.definition(model.definition);
            this.validationStrategy(model.validationStrategy);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getTemplateId() {
            return this.templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<ResourcePermission.Builder> getPermissions() {
            List<ResourcePermission.Builder> result = ResourcePermissionListCopier.copyToBuilder(this.permissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermissions(Collection<ResourcePermission.BuilderImpl> permissions) {
            this.permissions = ResourcePermissionListCopier.copyFromBuilder(permissions);
        }

        @Override
        public final Builder permissions(Collection<ResourcePermission> permissions) {
            this.permissions = ResourcePermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(ResourcePermission ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<ResourcePermission.Builder> ... permissions) {
            this.permissions(Stream.of(permissions).map(c -> (ResourcePermission)((ResourcePermission.Builder)ResourcePermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TemplateSourceEntity.Builder getSourceEntity() {
            return this.sourceEntity != null ? this.sourceEntity.toBuilder() : null;
        }

        public final void setSourceEntity(TemplateSourceEntity.BuilderImpl sourceEntity) {
            this.sourceEntity = sourceEntity != null ? sourceEntity.build() : null;
        }

        @Override
        public final Builder sourceEntity(TemplateSourceEntity sourceEntity) {
            this.sourceEntity = sourceEntity;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVersionDescription() {
            return this.versionDescription;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final TemplateVersionDefinition.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        public final void setDefinition(TemplateVersionDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(TemplateVersionDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final ValidationStrategy.Builder getValidationStrategy() {
            return this.validationStrategy != null ? this.validationStrategy.toBuilder() : null;
        }

        public final void setValidationStrategy(ValidationStrategy.BuilderImpl validationStrategy) {
            this.validationStrategy = validationStrategy != null ? validationStrategy.build() : null;
        }

        @Override
        public final Builder validationStrategy(ValidationStrategy validationStrategy) {
            this.validationStrategy = validationStrategy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTemplateRequest build() {
            return new CreateTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTemplateRequest> {
        public Builder awsAccountId(String var1);

        public Builder templateId(String var1);

        public Builder name(String var1);

        public Builder permissions(Collection<ResourcePermission> var1);

        public Builder permissions(ResourcePermission ... var1);

        public Builder permissions(Consumer<ResourcePermission.Builder> ... var1);

        public Builder sourceEntity(TemplateSourceEntity var1);

        default public Builder sourceEntity(Consumer<TemplateSourceEntity.Builder> sourceEntity) {
            return this.sourceEntity((TemplateSourceEntity)((TemplateSourceEntity.Builder)TemplateSourceEntity.builder().applyMutation(sourceEntity)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder versionDescription(String var1);

        public Builder definition(TemplateVersionDefinition var1);

        default public Builder definition(Consumer<TemplateVersionDefinition.Builder> definition) {
            return this.definition((TemplateVersionDefinition)((TemplateVersionDefinition.Builder)TemplateVersionDefinition.builder().applyMutation(definition)).build());
        }

        public Builder validationStrategy(ValidationStrategy var1);

        default public Builder validationStrategy(Consumer<ValidationStrategy.Builder> validationStrategy) {
            return this.validationStrategy((ValidationStrategy)((ValidationStrategy.Builder)ValidationStrategy.builder().applyMutation(validationStrategy)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

