/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.quicksight.model.DestinationTable;
import software.amazon.awssdk.services.quicksight.model.DestinationTableMapCopier;
import software.amazon.awssdk.services.quicksight.model.SourceTable;
import software.amazon.awssdk.services.quicksight.model.SourceTableMapCopier;
import software.amazon.awssdk.services.quicksight.model.TransformStep;
import software.amazon.awssdk.services.quicksight.model.TransformStepMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataPrepConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataPrepConfiguration> {
    private static final SdkField<Map<String, SourceTable>> SOURCE_TABLE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SourceTableMap").getter(DataPrepConfiguration.getter(DataPrepConfiguration::sourceTableMap)).setter(DataPrepConfiguration.setter(Builder::sourceTableMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTableMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceTable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, TransformStep>> TRANSFORM_STEP_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TransformStepMap").getter(DataPrepConfiguration.getter(DataPrepConfiguration::transformStepMap)).setter(DataPrepConfiguration.setter(Builder::transformStepMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformStepMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransformStep::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, DestinationTable>> DESTINATION_TABLE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("DestinationTableMap").getter(DataPrepConfiguration.getter(DataPrepConfiguration::destinationTableMap)).setter(DataPrepConfiguration.setter(Builder::destinationTableMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationTableMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DestinationTable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TABLE_MAP_FIELD, TRANSFORM_STEP_MAP_FIELD, DESTINATION_TABLE_MAP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataPrepConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, SourceTable> sourceTableMap;
    private final Map<String, TransformStep> transformStepMap;
    private final Map<String, DestinationTable> destinationTableMap;

    private DataPrepConfiguration(BuilderImpl builder) {
        this.sourceTableMap = builder.sourceTableMap;
        this.transformStepMap = builder.transformStepMap;
        this.destinationTableMap = builder.destinationTableMap;
    }

    public final boolean hasSourceTableMap() {
        return this.sourceTableMap != null && !(this.sourceTableMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, SourceTable> sourceTableMap() {
        return this.sourceTableMap;
    }

    public final boolean hasTransformStepMap() {
        return this.transformStepMap != null && !(this.transformStepMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, TransformStep> transformStepMap() {
        return this.transformStepMap;
    }

    public final boolean hasDestinationTableMap() {
        return this.destinationTableMap != null && !(this.destinationTableMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, DestinationTable> destinationTableMap() {
        return this.destinationTableMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceTableMap() ? this.sourceTableMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransformStepMap() ? this.transformStepMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationTableMap() ? this.destinationTableMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataPrepConfiguration)) {
            return false;
        }
        DataPrepConfiguration other = (DataPrepConfiguration)obj;
        return this.hasSourceTableMap() == other.hasSourceTableMap() && Objects.equals(this.sourceTableMap(), other.sourceTableMap()) && this.hasTransformStepMap() == other.hasTransformStepMap() && Objects.equals(this.transformStepMap(), other.transformStepMap()) && this.hasDestinationTableMap() == other.hasDestinationTableMap() && Objects.equals(this.destinationTableMap(), other.destinationTableMap());
    }

    public final String toString() {
        return ToString.builder((String)"DataPrepConfiguration").add("SourceTableMap", this.hasSourceTableMap() ? this.sourceTableMap() : null).add("TransformStepMap", this.hasTransformStepMap() ? this.transformStepMap() : null).add("DestinationTableMap", this.hasDestinationTableMap() ? this.destinationTableMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceTableMap": {
                return Optional.ofNullable(clazz.cast(this.sourceTableMap()));
            }
            case "TransformStepMap": {
                return Optional.ofNullable(clazz.cast(this.transformStepMap()));
            }
            case "DestinationTableMap": {
                return Optional.ofNullable(clazz.cast(this.destinationTableMap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceTableMap", SOURCE_TABLE_MAP_FIELD);
        map.put("TransformStepMap", TRANSFORM_STEP_MAP_FIELD);
        map.put("DestinationTableMap", DESTINATION_TABLE_MAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataPrepConfiguration, T> g) {
        return obj -> g.apply((DataPrepConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, SourceTable> sourceTableMap = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, TransformStep> transformStepMap = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, DestinationTable> destinationTableMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataPrepConfiguration model) {
            this.sourceTableMap(model.sourceTableMap);
            this.transformStepMap(model.transformStepMap);
            this.destinationTableMap(model.destinationTableMap);
        }

        public final Map<String, SourceTable.Builder> getSourceTableMap() {
            Map<String, SourceTable.Builder> result = SourceTableMapCopier.copyToBuilder(this.sourceTableMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSourceTableMap(Map<String, SourceTable.BuilderImpl> sourceTableMap) {
            this.sourceTableMap = SourceTableMapCopier.copyFromBuilder(sourceTableMap);
        }

        @Override
        public final Builder sourceTableMap(Map<String, SourceTable> sourceTableMap) {
            this.sourceTableMap = SourceTableMapCopier.copy(sourceTableMap);
            return this;
        }

        public final Map<String, TransformStep.Builder> getTransformStepMap() {
            Map<String, TransformStep.Builder> result = TransformStepMapCopier.copyToBuilder(this.transformStepMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setTransformStepMap(Map<String, TransformStep.BuilderImpl> transformStepMap) {
            this.transformStepMap = TransformStepMapCopier.copyFromBuilder(transformStepMap);
        }

        @Override
        public final Builder transformStepMap(Map<String, TransformStep> transformStepMap) {
            this.transformStepMap = TransformStepMapCopier.copy(transformStepMap);
            return this;
        }

        public final Map<String, DestinationTable.Builder> getDestinationTableMap() {
            Map<String, DestinationTable.Builder> result = DestinationTableMapCopier.copyToBuilder(this.destinationTableMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setDestinationTableMap(Map<String, DestinationTable.BuilderImpl> destinationTableMap) {
            this.destinationTableMap = DestinationTableMapCopier.copyFromBuilder(destinationTableMap);
        }

        @Override
        public final Builder destinationTableMap(Map<String, DestinationTable> destinationTableMap) {
            this.destinationTableMap = DestinationTableMapCopier.copy(destinationTableMap);
            return this;
        }

        public DataPrepConfiguration build() {
            return new DataPrepConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataPrepConfiguration> {
        public Builder sourceTableMap(Map<String, SourceTable> var1);

        public Builder transformStepMap(Map<String, TransformStep> var1);

        public Builder destinationTableMap(Map<String, DestinationTable> var1);
    }
}

