/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.ActionConnectorSummary;
import software.amazon.awssdk.services.quicksight.model.SearchActionConnectorsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchActionConnectorsResponse;

public class SearchActionConnectorsPublisher
implements SdkPublisher<SearchActionConnectorsResponse> {
    private final QuickSightAsyncClient client;
    private final SearchActionConnectorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchActionConnectorsPublisher(QuickSightAsyncClient client, SearchActionConnectorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchActionConnectorsPublisher(QuickSightAsyncClient client, SearchActionConnectorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchActionConnectorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchActionConnectorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ActionConnectorSummary> actionConnectorSummaries() {
        Function<SearchActionConnectorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.actionConnectorSummaries() != null) {
                return response.actionConnectorSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchActionConnectorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchActionConnectorsResponseFetcher
    implements AsyncPageFetcher<SearchActionConnectorsResponse> {
        private SearchActionConnectorsResponseFetcher() {
        }

        public boolean hasNextPage(SearchActionConnectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchActionConnectorsResponse> nextPage(SearchActionConnectorsResponse previousPage) {
            if (previousPage == null) {
                return SearchActionConnectorsPublisher.this.client.searchActionConnectors(SearchActionConnectorsPublisher.this.firstRequest);
            }
            return SearchActionConnectorsPublisher.this.client.searchActionConnectors((SearchActionConnectorsRequest)((Object)SearchActionConnectorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

