/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.User;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeUserResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DescribeUserResponse> {
    private static final SdkField<User> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeUserResponse.getter(DescribeUserResponse::user)).setter(DescribeUserResponse.setter(Builder::user)).constructor(User::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeUserResponse.getter(DescribeUserResponse::requestId)).setter(DescribeUserResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeUserResponse.getter(DescribeUserResponse::status)).setter(DescribeUserResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private final User user;
    private final String requestId;
    private final Integer status;

    private DescribeUserResponse(BuilderImpl builder) {
        super(builder);
        this.user = builder.user;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public User user() {
        return this.user;
    }

    public String requestId() {
        return this.requestId;
    }

    public Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserResponse)) {
            return false;
        }
        DescribeUserResponse other = (DescribeUserResponse)((Object)obj);
        return Objects.equals(this.user(), other.user()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"DescribeUserResponse").add("User", (Object)this.user()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "User": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserResponse, T> g) {
        return obj -> g.apply((DescribeUserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private User user;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserResponse model) {
            super(model);
            this.user(model.user);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final User.Builder getUser() {
            return this.user != null ? this.user.toBuilder() : null;
        }

        @Override
        public final Builder user(User user) {
            this.user = user;
            return this;
        }

        public final void setUser(User.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public DescribeUserResponse build() {
            return new DescribeUserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeUserResponse> {
        public Builder user(User var1);

        default public Builder user(Consumer<User.Builder> user) {
            return this.user((User)((User.Builder)User.builder().applyMutation(user)).build());
        }

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

