/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.ram.model.AcceptResourceShareInvitationRequest;
import software.amazon.awssdk.services.ram.model.AcceptResourceShareInvitationResponse;
import software.amazon.awssdk.services.ram.model.AssociateResourceShareRequest;
import software.amazon.awssdk.services.ram.model.AssociateResourceShareResponse;
import software.amazon.awssdk.services.ram.model.CreateResourceShareRequest;
import software.amazon.awssdk.services.ram.model.CreateResourceShareResponse;
import software.amazon.awssdk.services.ram.model.DeleteResourceShareRequest;
import software.amazon.awssdk.services.ram.model.DeleteResourceShareResponse;
import software.amazon.awssdk.services.ram.model.DisassociateResourceShareRequest;
import software.amazon.awssdk.services.ram.model.DisassociateResourceShareResponse;
import software.amazon.awssdk.services.ram.model.EnableSharingWithAwsOrganizationRequest;
import software.amazon.awssdk.services.ram.model.EnableSharingWithAwsOrganizationResponse;
import software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest;
import software.amazon.awssdk.services.ram.model.GetResourcePoliciesResponse;
import software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest;
import software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsResponse;
import software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest;
import software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse;
import software.amazon.awssdk.services.ram.model.GetResourceSharesRequest;
import software.amazon.awssdk.services.ram.model.GetResourceSharesResponse;
import software.amazon.awssdk.services.ram.model.ListPrincipalsRequest;
import software.amazon.awssdk.services.ram.model.ListPrincipalsResponse;
import software.amazon.awssdk.services.ram.model.ListResourcesRequest;
import software.amazon.awssdk.services.ram.model.ListResourcesResponse;
import software.amazon.awssdk.services.ram.model.RejectResourceShareInvitationRequest;
import software.amazon.awssdk.services.ram.model.RejectResourceShareInvitationResponse;
import software.amazon.awssdk.services.ram.model.TagResourceRequest;
import software.amazon.awssdk.services.ram.model.TagResourceResponse;
import software.amazon.awssdk.services.ram.model.UntagResourceRequest;
import software.amazon.awssdk.services.ram.model.UntagResourceResponse;
import software.amazon.awssdk.services.ram.model.UpdateResourceShareRequest;
import software.amazon.awssdk.services.ram.model.UpdateResourceShareResponse;
import software.amazon.awssdk.services.ram.paginators.GetResourcePoliciesPublisher;
import software.amazon.awssdk.services.ram.paginators.GetResourceShareAssociationsPublisher;
import software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsPublisher;
import software.amazon.awssdk.services.ram.paginators.GetResourceSharesPublisher;
import software.amazon.awssdk.services.ram.paginators.ListPrincipalsPublisher;
import software.amazon.awssdk.services.ram.paginators.ListResourcesPublisher;

/**
 * Service client for accessing RAM asynchronously. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Use AWS Resource Access Manager to share AWS resources between AWS accounts. To share a resource, you create a
 * resource share, associate the resource with the resource share, and specify the principals that can access the
 * resource. The following principals are supported:
 * </p>
 * <ul>
 * <li>
 * <p>
 * The ID of an AWS account
 * </p>
 * </li>
 * <li>
 * <p>
 * The Amazon Resource Name (ARN) of an OU from AWS Organizations
 * </p>
 * </li>
 * <li>
 * <p>
 * The Amazon Resource Name (ARN) of an organization from AWS Organizations
 * </p>
 * </li>
 * </ul>
 * <p>
 * If you specify an AWS account that doesn't exist in the same organization as the account that owns the resource
 * share, the owner of the specified account receives an invitation to accept the resource share. After the owner
 * accepts the invitation, they can access the resources in the resource share. An administrator of the specified
 * account can use IAM policies to restrict access resources in the resource share.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface RamAsyncClient extends SdkClient {
    String SERVICE_NAME = "ram";

    /**
     * Create a {@link RamAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static RamAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link RamAsyncClient}.
     */
    static RamAsyncClientBuilder builder() {
        return new DefaultRamAsyncClientBuilder();
    }

    /**
     * <p>
     * Accepts an invitation to a resource share from another AWS account.
     * </p>
     *
     * @param acceptResourceShareInvitationRequest
     * @return A Java Future containing the result of the AcceptResourceShareInvitation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ResourceShareInvitationArnNotFoundException The Amazon Resource Name (ARN) for an invitation was not
     *         found.</li>
     *         <li>ResourceShareInvitationAlreadyAcceptedException The invitation was already accepted.</li>
     *         <li>ResourceShareInvitationAlreadyRejectedException The invitation was already rejected.</li>
     *         <li>ResourceShareInvitationExpiredException The invitation is expired.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.AcceptResourceShareInvitation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AcceptResourceShareInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptResourceShareInvitationResponse> acceptResourceShareInvitation(
            AcceptResourceShareInvitationRequest acceptResourceShareInvitationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts an invitation to a resource share from another AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptResourceShareInvitationRequest.Builder}
     * avoiding the need to create one manually via {@link AcceptResourceShareInvitationRequest#builder()}
     * </p>
     *
     * @param acceptResourceShareInvitationRequest
     *        A {@link Consumer} that will call methods on {@link AcceptResourceShareInvitationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AcceptResourceShareInvitation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ResourceShareInvitationArnNotFoundException The Amazon Resource Name (ARN) for an invitation was not
     *         found.</li>
     *         <li>ResourceShareInvitationAlreadyAcceptedException The invitation was already accepted.</li>
     *         <li>ResourceShareInvitationAlreadyRejectedException The invitation was already rejected.</li>
     *         <li>ResourceShareInvitationExpiredException The invitation is expired.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.AcceptResourceShareInvitation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AcceptResourceShareInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptResourceShareInvitationResponse> acceptResourceShareInvitation(
            Consumer<AcceptResourceShareInvitationRequest.Builder> acceptResourceShareInvitationRequest) {
        return acceptResourceShareInvitation(AcceptResourceShareInvitationRequest.builder()
                .applyMutation(acceptResourceShareInvitationRequest).build());
    }

    /**
     * <p>
     * Associates the specified resource share with the specified principals and resources.
     * </p>
     *
     * @param associateResourceShareRequest
     * @return A Java Future containing the result of the AssociateResourceShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException A client token input parameter was reused with an operation, but
     *         at least one of the other input parameters is different from the previous call to the operation.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidStateTransitionException The requested state transition is not valid.</li>
     *         <li>ResourceShareLimitExceededException The requested resource share exceeds the limit for your account.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidStateTransitionException The requested state transition is not valid.</li>
     *         <li>InvalidClientTokenException A client token is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.AssociateResourceShare
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AssociateResourceShare" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateResourceShareResponse> associateResourceShare(
            AssociateResourceShareRequest associateResourceShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified resource share with the specified principals and resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateResourceShareRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateResourceShareRequest#builder()}
     * </p>
     *
     * @param associateResourceShareRequest
     *        A {@link Consumer} that will call methods on {@link AssociateResourceShareRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateResourceShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException A client token input parameter was reused with an operation, but
     *         at least one of the other input parameters is different from the previous call to the operation.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidStateTransitionException The requested state transition is not valid.</li>
     *         <li>ResourceShareLimitExceededException The requested resource share exceeds the limit for your account.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidStateTransitionException The requested state transition is not valid.</li>
     *         <li>InvalidClientTokenException A client token is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.AssociateResourceShare
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/AssociateResourceShare" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateResourceShareResponse> associateResourceShare(
            Consumer<AssociateResourceShareRequest.Builder> associateResourceShareRequest) {
        return associateResourceShare(AssociateResourceShareRequest.builder().applyMutation(associateResourceShareRequest)
                .build());
    }

    /**
     * <p>
     * Creates a resource share.
     * </p>
     *
     * @param createResourceShareRequest
     * @return A Java Future containing the result of the CreateResourceShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException A client token input parameter was reused with an operation, but
     *         at least one of the other input parameters is different from the previous call to the operation.</li>
     *         <li>InvalidStateTransitionException The requested state transition is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidClientTokenException A client token is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ResourceShareLimitExceededException The requested resource share exceeds the limit for your account.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.CreateResourceShare
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/CreateResourceShare" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateResourceShareResponse> createResourceShare(
            CreateResourceShareRequest createResourceShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a resource share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceShareRequest.Builder} avoiding the
     * need to create one manually via {@link CreateResourceShareRequest#builder()}
     * </p>
     *
     * @param createResourceShareRequest
     *        A {@link Consumer} that will call methods on {@link CreateResourceShareRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateResourceShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException A client token input parameter was reused with an operation, but
     *         at least one of the other input parameters is different from the previous call to the operation.</li>
     *         <li>InvalidStateTransitionException The requested state transition is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidClientTokenException A client token is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ResourceShareLimitExceededException The requested resource share exceeds the limit for your account.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.CreateResourceShare
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/CreateResourceShare" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateResourceShareResponse> createResourceShare(
            Consumer<CreateResourceShareRequest.Builder> createResourceShareRequest) {
        return createResourceShare(CreateResourceShareRequest.builder().applyMutation(createResourceShareRequest).build());
    }

    /**
     * <p>
     * Deletes the specified resource share.
     * </p>
     *
     * @param deleteResourceShareRequest
     * @return A Java Future containing the result of the DeleteResourceShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>IdempotentParameterMismatchException A client token input parameter was reused with an operation, but
     *         at least one of the other input parameters is different from the previous call to the operation.</li>
     *         <li>InvalidStateTransitionException The requested state transition is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidClientTokenException A client token is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.DeleteResourceShare
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DeleteResourceShare" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteResourceShareResponse> deleteResourceShare(
            DeleteResourceShareRequest deleteResourceShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified resource share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceShareRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourceShareRequest#builder()}
     * </p>
     *
     * @param deleteResourceShareRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourceShareRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteResourceShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>IdempotentParameterMismatchException A client token input parameter was reused with an operation, but
     *         at least one of the other input parameters is different from the previous call to the operation.</li>
     *         <li>InvalidStateTransitionException The requested state transition is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidClientTokenException A client token is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.DeleteResourceShare
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DeleteResourceShare" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteResourceShareResponse> deleteResourceShare(
            Consumer<DeleteResourceShareRequest.Builder> deleteResourceShareRequest) {
        return deleteResourceShare(DeleteResourceShareRequest.builder().applyMutation(deleteResourceShareRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified principals or resources from the specified resource share.
     * </p>
     *
     * @param disassociateResourceShareRequest
     * @return A Java Future containing the result of the DisassociateResourceShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException A client token input parameter was reused with an operation, but
     *         at least one of the other input parameters is different from the previous call to the operation.</li>
     *         <li>ResourceShareLimitExceededException The requested resource share exceeds the limit for your account.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidStateTransitionException The requested state transition is not valid.</li>
     *         <li>InvalidClientTokenException A client token is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.DisassociateResourceShare
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DisassociateResourceShare" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateResourceShareResponse> disassociateResourceShare(
            DisassociateResourceShareRequest disassociateResourceShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified principals or resources from the specified resource share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateResourceShareRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateResourceShareRequest#builder()}
     * </p>
     *
     * @param disassociateResourceShareRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateResourceShareRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateResourceShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException A client token input parameter was reused with an operation, but
     *         at least one of the other input parameters is different from the previous call to the operation.</li>
     *         <li>ResourceShareLimitExceededException The requested resource share exceeds the limit for your account.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidStateTransitionException The requested state transition is not valid.</li>
     *         <li>InvalidClientTokenException A client token is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.DisassociateResourceShare
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/DisassociateResourceShare" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateResourceShareResponse> disassociateResourceShare(
            Consumer<DisassociateResourceShareRequest.Builder> disassociateResourceShareRequest) {
        return disassociateResourceShare(DisassociateResourceShareRequest.builder()
                .applyMutation(disassociateResourceShareRequest).build());
    }

    /**
     * <p>
     * Enables resource sharing within your organization.
     * </p>
     *
     * @param enableSharingWithAwsOrganizationRequest
     * @return A Java Future containing the result of the EnableSharingWithAwsOrganization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.EnableSharingWithAwsOrganization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/EnableSharingWithAwsOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableSharingWithAwsOrganizationResponse> enableSharingWithAwsOrganization(
            EnableSharingWithAwsOrganizationRequest enableSharingWithAwsOrganizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables resource sharing within your organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableSharingWithAwsOrganizationRequest.Builder}
     * avoiding the need to create one manually via {@link EnableSharingWithAwsOrganizationRequest#builder()}
     * </p>
     *
     * @param enableSharingWithAwsOrganizationRequest
     *        A {@link Consumer} that will call methods on {@link EnableSharingWithAwsOrganizationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the EnableSharingWithAwsOrganization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.EnableSharingWithAwsOrganization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/EnableSharingWithAwsOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableSharingWithAwsOrganizationResponse> enableSharingWithAwsOrganization(
            Consumer<EnableSharingWithAwsOrganizationRequest.Builder> enableSharingWithAwsOrganizationRequest) {
        return enableSharingWithAwsOrganization(EnableSharingWithAwsOrganizationRequest.builder()
                .applyMutation(enableSharingWithAwsOrganizationRequest).build());
    }

    /**
     * <p>
     * Gets the policies for the specifies resources.
     * </p>
     *
     * @param getResourcePoliciesRequest
     * @return A Java Future containing the result of the GetResourcePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourcePolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourcePoliciesResponse> getResourcePolicies(
            GetResourcePoliciesRequest getResourcePoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the policies for the specifies resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourcePoliciesRequest#builder()}
     * </p>
     *
     * @param getResourcePoliciesRequest
     *        A {@link Consumer} that will call methods on {@link GetResourcePoliciesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetResourcePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourcePolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourcePoliciesResponse> getResourcePolicies(
            Consumer<GetResourcePoliciesRequest.Builder> getResourcePoliciesRequest) {
        return getResourcePolicies(GetResourcePoliciesRequest.builder().applyMutation(getResourcePoliciesRequest).build());
    }

    /**
     * <p>
     * Gets the policies for the specifies resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourcePolicies(software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourcePoliciesPublisher publisher = client.getResourcePoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourcePoliciesPublisher publisher = client.getResourcePoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.GetResourcePoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.GetResourcePoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourcePolicies(software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest)} operation.</b>
     * </p>
     *
     * @param getResourcePoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourcePolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourcePoliciesPublisher getResourcePoliciesPaginator(GetResourcePoliciesRequest getResourcePoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the policies for the specifies resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourcePolicies(software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourcePoliciesPublisher publisher = client.getResourcePoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourcePoliciesPublisher publisher = client.getResourcePoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.GetResourcePoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.GetResourcePoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourcePolicies(software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourcePoliciesRequest#builder()}
     * </p>
     *
     * @param getResourcePoliciesRequest
     *        A {@link Consumer} that will call methods on {@link GetResourcePoliciesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourcePolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourcePoliciesPublisher getResourcePoliciesPaginator(
            Consumer<GetResourcePoliciesRequest.Builder> getResourcePoliciesRequest) {
        return getResourcePoliciesPaginator(GetResourcePoliciesRequest.builder().applyMutation(getResourcePoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Gets the associations for the specified resource share.
     * </p>
     *
     * @param getResourceShareAssociationsRequest
     * @return A Java Future containing the result of the GetResourceShareAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShareAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceShareAssociationsResponse> getResourceShareAssociations(
            GetResourceShareAssociationsRequest getResourceShareAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the associations for the specified resource share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceShareAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetResourceShareAssociationsRequest#builder()}
     * </p>
     *
     * @param getResourceShareAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceShareAssociationsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetResourceShareAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShareAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceShareAssociationsResponse> getResourceShareAssociations(
            Consumer<GetResourceShareAssociationsRequest.Builder> getResourceShareAssociationsRequest) {
        return getResourceShareAssociations(GetResourceShareAssociationsRequest.builder()
                .applyMutation(getResourceShareAssociationsRequest).build());
    }

    /**
     * <p>
     * Gets the associations for the specified resource share.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourceShareAssociations(software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareAssociationsPublisher publisher = client.getResourceShareAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareAssociationsPublisher publisher = client.getResourceShareAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceShareAssociations(software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getResourceShareAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShareAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceShareAssociationsPublisher getResourceShareAssociationsPaginator(
            GetResourceShareAssociationsRequest getResourceShareAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the associations for the specified resource share.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourceShareAssociations(software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareAssociationsPublisher publisher = client.getResourceShareAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareAssociationsPublisher publisher = client.getResourceShareAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceShareAssociations(software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceShareAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetResourceShareAssociationsRequest#builder()}
     * </p>
     *
     * @param getResourceShareAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceShareAssociationsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShareAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceShareAssociationsPublisher getResourceShareAssociationsPaginator(
            Consumer<GetResourceShareAssociationsRequest.Builder> getResourceShareAssociationsRequest) {
        return getResourceShareAssociationsPaginator(GetResourceShareAssociationsRequest.builder()
                .applyMutation(getResourceShareAssociationsRequest).build());
    }

    /**
     * <p>
     * Gets the specified invitations for resource sharing.
     * </p>
     *
     * @param getResourceShareInvitationsRequest
     * @return A Java Future containing the result of the GetResourceShareInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceShareInvitationArnNotFoundException The Amazon Resource Name (ARN) for an invitation was not
     *         found.</li>
     *         <li>InvalidMaxResultsException The specified value for MaxResults is not valid.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShareInvitations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceShareInvitationsResponse> getResourceShareInvitations(
            GetResourceShareInvitationsRequest getResourceShareInvitationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified invitations for resource sharing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceShareInvitationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetResourceShareInvitationsRequest#builder()}
     * </p>
     *
     * @param getResourceShareInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceShareInvitationsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetResourceShareInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceShareInvitationArnNotFoundException The Amazon Resource Name (ARN) for an invitation was not
     *         found.</li>
     *         <li>InvalidMaxResultsException The specified value for MaxResults is not valid.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShareInvitations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceShareInvitationsResponse> getResourceShareInvitations(
            Consumer<GetResourceShareInvitationsRequest.Builder> getResourceShareInvitationsRequest) {
        return getResourceShareInvitations(GetResourceShareInvitationsRequest.builder()
                .applyMutation(getResourceShareInvitationsRequest).build());
    }

    /**
     * <p>
     * Gets the specified invitations for resource sharing.
     * </p>
     *
     * @return A Java Future containing the result of the GetResourceShareInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceShareInvitationArnNotFoundException The Amazon Resource Name (ARN) for an invitation was not
     *         found.</li>
     *         <li>InvalidMaxResultsException The specified value for MaxResults is not valid.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShareInvitations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceShareInvitationsResponse> getResourceShareInvitations() {
        return getResourceShareInvitations(GetResourceShareInvitationsRequest.builder().build());
    }

    /**
     * <p>
     * Gets the specified invitations for resource sharing.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourceShareInvitations(software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsPublisher publisher = client.getResourceShareInvitationsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsPublisher publisher = client.getResourceShareInvitationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceShareInvitations(software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceShareInvitationArnNotFoundException The Amazon Resource Name (ARN) for an invitation was not
     *         found.</li>
     *         <li>InvalidMaxResultsException The specified value for MaxResults is not valid.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShareInvitations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceShareInvitationsPublisher getResourceShareInvitationsPaginator() {
        return getResourceShareInvitationsPaginator(GetResourceShareInvitationsRequest.builder().build());
    }

    /**
     * <p>
     * Gets the specified invitations for resource sharing.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourceShareInvitations(software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsPublisher publisher = client.getResourceShareInvitationsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsPublisher publisher = client.getResourceShareInvitationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceShareInvitations(software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getResourceShareInvitationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceShareInvitationArnNotFoundException The Amazon Resource Name (ARN) for an invitation was not
     *         found.</li>
     *         <li>InvalidMaxResultsException The specified value for MaxResults is not valid.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShareInvitations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceShareInvitationsPublisher getResourceShareInvitationsPaginator(
            GetResourceShareInvitationsRequest getResourceShareInvitationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified invitations for resource sharing.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourceShareInvitations(software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsPublisher publisher = client.getResourceShareInvitationsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsPublisher publisher = client.getResourceShareInvitationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceShareInvitations(software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceShareInvitationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetResourceShareInvitationsRequest#builder()}
     * </p>
     *
     * @param getResourceShareInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceShareInvitationsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceShareInvitationArnNotFoundException The Amazon Resource Name (ARN) for an invitation was not
     *         found.</li>
     *         <li>InvalidMaxResultsException The specified value for MaxResults is not valid.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShareInvitations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShareInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceShareInvitationsPublisher getResourceShareInvitationsPaginator(
            Consumer<GetResourceShareInvitationsRequest.Builder> getResourceShareInvitationsRequest) {
        return getResourceShareInvitationsPaginator(GetResourceShareInvitationsRequest.builder()
                .applyMutation(getResourceShareInvitationsRequest).build());
    }

    /**
     * <p>
     * Gets the specified resource shares or all of your resource shares.
     * </p>
     *
     * @param getResourceSharesRequest
     * @return A Java Future containing the result of the GetResourceShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShares
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShares" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourceSharesResponse> getResourceShares(GetResourceSharesRequest getResourceSharesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified resource shares or all of your resource shares.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceSharesRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourceSharesRequest#builder()}
     * </p>
     *
     * @param getResourceSharesRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceSharesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetResourceShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShares
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShares" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourceSharesResponse> getResourceShares(
            Consumer<GetResourceSharesRequest.Builder> getResourceSharesRequest) {
        return getResourceShares(GetResourceSharesRequest.builder().applyMutation(getResourceSharesRequest).build());
    }

    /**
     * <p>
     * Gets the specified resource shares or all of your resource shares.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourceShares(software.amazon.awssdk.services.ram.model.GetResourceSharesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceSharesPublisher publisher = client.getResourceSharesPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceSharesPublisher publisher = client.getResourceSharesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.GetResourceSharesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.GetResourceSharesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceShares(software.amazon.awssdk.services.ram.model.GetResourceSharesRequest)} operation.</b>
     * </p>
     *
     * @param getResourceSharesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShares
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShares" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourceSharesPublisher getResourceSharesPaginator(GetResourceSharesRequest getResourceSharesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the specified resource shares or all of your resource shares.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourceShares(software.amazon.awssdk.services.ram.model.GetResourceSharesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceSharesPublisher publisher = client.getResourceSharesPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.GetResourceSharesPublisher publisher = client.getResourceSharesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.GetResourceSharesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.GetResourceSharesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceShares(software.amazon.awssdk.services.ram.model.GetResourceSharesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceSharesRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourceSharesRequest#builder()}
     * </p>
     *
     * @param getResourceSharesRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceSharesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.GetResourceShares
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/GetResourceShares" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourceSharesPublisher getResourceSharesPaginator(
            Consumer<GetResourceSharesRequest.Builder> getResourceSharesRequest) {
        return getResourceSharesPaginator(GetResourceSharesRequest.builder().applyMutation(getResourceSharesRequest).build());
    }

    /**
     * <p>
     * Lists the principals with access to the specified resource.
     * </p>
     *
     * @param listPrincipalsRequest
     * @return A Java Future containing the result of the ListPrincipals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListPrincipals
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPrincipals" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPrincipalsResponse> listPrincipals(ListPrincipalsRequest listPrincipalsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the principals with access to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPrincipalsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPrincipalsRequest#builder()}
     * </p>
     *
     * @param listPrincipalsRequest
     *        A {@link Consumer} that will call methods on {@link ListPrincipalsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListPrincipals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListPrincipals
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPrincipals" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPrincipalsResponse> listPrincipals(Consumer<ListPrincipalsRequest.Builder> listPrincipalsRequest) {
        return listPrincipals(ListPrincipalsRequest.builder().applyMutation(listPrincipalsRequest).build());
    }

    /**
     * <p>
     * Lists the principals with access to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPrincipals(software.amazon.awssdk.services.ram.model.ListPrincipalsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPrincipalsPublisher publisher = client.listPrincipalsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPrincipalsPublisher publisher = client.listPrincipalsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.ListPrincipalsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.ListPrincipalsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrincipals(software.amazon.awssdk.services.ram.model.ListPrincipalsRequest)} operation.</b>
     * </p>
     *
     * @param listPrincipalsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListPrincipals
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPrincipals" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPrincipalsPublisher listPrincipalsPaginator(ListPrincipalsRequest listPrincipalsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the principals with access to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPrincipals(software.amazon.awssdk.services.ram.model.ListPrincipalsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPrincipalsPublisher publisher = client.listPrincipalsPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListPrincipalsPublisher publisher = client.listPrincipalsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.ListPrincipalsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.ListPrincipalsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrincipals(software.amazon.awssdk.services.ram.model.ListPrincipalsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPrincipalsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPrincipalsRequest#builder()}
     * </p>
     *
     * @param listPrincipalsRequest
     *        A {@link Consumer} that will call methods on {@link ListPrincipalsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListPrincipals
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPrincipals" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPrincipalsPublisher listPrincipalsPaginator(Consumer<ListPrincipalsRequest.Builder> listPrincipalsRequest) {
        return listPrincipalsPaginator(ListPrincipalsRequest.builder().applyMutation(listPrincipalsRequest).build());
    }

    /**
     * <p>
     * Lists the resources that the specified principal can access.
     * </p>
     *
     * @param listResourcesRequest
     * @return A Java Future containing the result of the ListResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The specified resource type is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListResourcesResponse> listResources(ListResourcesRequest listResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resources that the specified principal can access.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesRequest.Builder} avoiding the need to
     * create one manually via {@link ListResourcesRequest#builder()}
     * </p>
     *
     * @param listResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListResourcesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The specified resource type is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListResourcesResponse> listResources(Consumer<ListResourcesRequest.Builder> listResourcesRequest) {
        return listResources(ListResourcesRequest.builder().applyMutation(listResourcesRequest).build());
    }

    /**
     * <p>
     * Lists the resources that the specified principal can access.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listResources(software.amazon.awssdk.services.ram.model.ListResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourcesPublisher publisher = client.listResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourcesPublisher publisher = client.listResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.ListResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.ListResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResources(software.amazon.awssdk.services.ram.model.ListResourcesRequest)} operation.</b>
     * </p>
     *
     * @param listResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The specified resource type is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourcesPublisher listResourcesPaginator(ListResourcesRequest listResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resources that the specified principal can access.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listResources(software.amazon.awssdk.services.ram.model.ListResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the forEach helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourcesPublisher publisher = client.listResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.forEach(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ram.paginators.ListResourcesPublisher publisher = client.listResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ram.model.ListResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ram.model.ListResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResources(software.amazon.awssdk.services.ram.model.ListResourcesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesRequest.Builder} avoiding the need to
     * create one manually via {@link ListResourcesRequest#builder()}
     * </p>
     *
     * @param listResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListResourcesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The specified resource type is not valid.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidNextTokenException The specified value for NextToken is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.ListResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourcesPublisher listResourcesPaginator(Consumer<ListResourcesRequest.Builder> listResourcesRequest) {
        return listResourcesPaginator(ListResourcesRequest.builder().applyMutation(listResourcesRequest).build());
    }

    /**
     * <p>
     * Rejects an invitation to a resource share from another AWS account.
     * </p>
     *
     * @param rejectResourceShareInvitationRequest
     * @return A Java Future containing the result of the RejectResourceShareInvitation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ResourceShareInvitationArnNotFoundException The Amazon Resource Name (ARN) for an invitation was not
     *         found.</li>
     *         <li>ResourceShareInvitationAlreadyAcceptedException The invitation was already accepted.</li>
     *         <li>ResourceShareInvitationAlreadyRejectedException The invitation was already rejected.</li>
     *         <li>ResourceShareInvitationExpiredException The invitation is expired.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.RejectResourceShareInvitation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/RejectResourceShareInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RejectResourceShareInvitationResponse> rejectResourceShareInvitation(
            RejectResourceShareInvitationRequest rejectResourceShareInvitationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rejects an invitation to a resource share from another AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectResourceShareInvitationRequest.Builder}
     * avoiding the need to create one manually via {@link RejectResourceShareInvitationRequest#builder()}
     * </p>
     *
     * @param rejectResourceShareInvitationRequest
     *        A {@link Consumer} that will call methods on {@link RejectResourceShareInvitationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RejectResourceShareInvitation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ResourceShareInvitationArnNotFoundException The Amazon Resource Name (ARN) for an invitation was not
     *         found.</li>
     *         <li>ResourceShareInvitationAlreadyAcceptedException The invitation was already accepted.</li>
     *         <li>ResourceShareInvitationAlreadyRejectedException The invitation was already rejected.</li>
     *         <li>ResourceShareInvitationExpiredException The invitation is expired.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.RejectResourceShareInvitation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/RejectResourceShareInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RejectResourceShareInvitationResponse> rejectResourceShareInvitation(
            Consumer<RejectResourceShareInvitationRequest.Builder> rejectResourceShareInvitationRequest) {
        return rejectResourceShareInvitation(RejectResourceShareInvitationRequest.builder()
                .applyMutation(rejectResourceShareInvitationRequest).build());
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource share.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>TagLimitExceededException The requested tags exceed the limit for your account.</li>
     *         <li>ResourceArnNotFoundException An Amazon Resource Name (ARN) was not found.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>TagLimitExceededException The requested tags exceed the limit for your account.</li>
     *         <li>ResourceArnNotFoundException An Amazon Resource Name (ARN) was not found.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource share.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the specified resource share.
     * </p>
     *
     * @param updateResourceShareRequest
     * @return A Java Future containing the result of the UpdateResourceShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException A client token input parameter was reused with an operation, but
     *         at least one of the other input parameters is different from the previous call to the operation.</li>
     *         <li>MissingRequiredParameterException A required input parameter is missing.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidClientTokenException A client token is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.UpdateResourceShare
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/UpdateResourceShare" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateResourceShareResponse> updateResourceShare(
            UpdateResourceShareRequest updateResourceShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified resource share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourceShareRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateResourceShareRequest#builder()}
     * </p>
     *
     * @param updateResourceShareRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResourceShareRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateResourceShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException A client token input parameter was reused with an operation, but
     *         at least one of the other input parameters is different from the previous call to the operation.</li>
     *         <li>MissingRequiredParameterException A required input parameter is missing.</li>
     *         <li>UnknownResourceException A specified resource was not found.</li>
     *         <li>MalformedArnException The format of an Amazon Resource Name (ARN) is not valid.</li>
     *         <li>InvalidClientTokenException A client token is not valid.</li>
     *         <li>InvalidParameterException A parameter is not valid.</li>
     *         <li>OperationNotPermittedException The requested operation is not permitted.</li>
     *         <li>ServerInternalException The service could not respond to the request due to an internal problem.</li>
     *         <li>ServiceUnavailableException The service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RamException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RamAsyncClient.UpdateResourceShare
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/UpdateResourceShare" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateResourceShareResponse> updateResourceShare(
            Consumer<UpdateResourceShareRequest.Builder> updateResourceShareRequest) {
        return updateResourceShare(UpdateResourceShareRequest.builder().applyMutation(updateResourceShareRequest).build());
    }
}
