/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceShareInvitationsRequest extends RamRequest implements
        ToCopyableBuilder<GetResourceShareInvitationsRequest.Builder, GetResourceShareInvitationsRequest> {
    private static final SdkField<List<String>> RESOURCE_SHARE_INVITATION_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetResourceShareInvitationsRequest::resourceShareInvitationArns))
            .setter(setter(Builder::resourceShareInvitationArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareInvitationArns")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RESOURCE_SHARE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetResourceShareInvitationsRequest::resourceShareArns))
            .setter(setter(Builder::resourceShareArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetResourceShareInvitationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetResourceShareInvitationsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESOURCE_SHARE_INVITATION_ARNS_FIELD, RESOURCE_SHARE_ARNS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<String> resourceShareInvitationArns;

    private final List<String> resourceShareArns;

    private final String nextToken;

    private final Integer maxResults;

    private GetResourceShareInvitationsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceShareInvitationArns = builder.resourceShareInvitationArns;
        this.resourceShareArns = builder.resourceShareArns;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of the invitations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of the invitations.
     */
    public List<String> resourceShareInvitationArns() {
        return resourceShareInvitationArns;
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of the resource shares.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of the resource shares.
     */
    public List<String> resourceShareArns() {
        return resourceShareArns;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call
     * with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return with a single call. To retrieve the remaining results, make
     *         another call with the returned <code>nextToken</code> value.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareInvitationArns());
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareArns());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceShareInvitationsRequest)) {
            return false;
        }
        GetResourceShareInvitationsRequest other = (GetResourceShareInvitationsRequest) obj;
        return Objects.equals(resourceShareInvitationArns(), other.resourceShareInvitationArns())
                && Objects.equals(resourceShareArns(), other.resourceShareArns())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    @Override
    public String toString() {
        return ToString.builder("GetResourceShareInvitationsRequest")
                .add("ResourceShareInvitationArns", resourceShareInvitationArns()).add("ResourceShareArns", resourceShareArns())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceShareInvitationArns":
            return Optional.ofNullable(clazz.cast(resourceShareInvitationArns()));
        case "resourceShareArns":
            return Optional.ofNullable(clazz.cast(resourceShareArns()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceShareInvitationsRequest, T> g) {
        return obj -> g.apply((GetResourceShareInvitationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RamRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetResourceShareInvitationsRequest> {
        /**
         * <p>
         * The Amazon Resource Names (ARN) of the invitations.
         * </p>
         * 
         * @param resourceShareInvitationArns
         *        The Amazon Resource Names (ARN) of the invitations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareInvitationArns(Collection<String> resourceShareInvitationArns);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the invitations.
         * </p>
         * 
         * @param resourceShareInvitationArns
         *        The Amazon Resource Names (ARN) of the invitations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareInvitationArns(String... resourceShareInvitationArns);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the resource shares.
         * </p>
         * 
         * @param resourceShareArns
         *        The Amazon Resource Names (ARN) of the resource shares.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareArns(Collection<String> resourceShareArns);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the resource shares.
         * </p>
         * 
         * @param resourceShareArns
         *        The Amazon Resource Names (ARN) of the resource shares.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareArns(String... resourceShareArns);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return with a single call. To retrieve the remaining results, make another
         * call with the returned <code>nextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return with a single call. To retrieve the remaining results, make
         *        another call with the returned <code>nextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RamRequest.BuilderImpl implements Builder {
        private List<String> resourceShareInvitationArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> resourceShareArns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceShareInvitationsRequest model) {
            super(model);
            resourceShareInvitationArns(model.resourceShareInvitationArns);
            resourceShareArns(model.resourceShareArns);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getResourceShareInvitationArns() {
            return resourceShareInvitationArns;
        }

        @Override
        public final Builder resourceShareInvitationArns(Collection<String> resourceShareInvitationArns) {
            this.resourceShareInvitationArns = ResourceShareInvitationArnListCopier.copy(resourceShareInvitationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShareInvitationArns(String... resourceShareInvitationArns) {
            resourceShareInvitationArns(Arrays.asList(resourceShareInvitationArns));
            return this;
        }

        public final void setResourceShareInvitationArns(Collection<String> resourceShareInvitationArns) {
            this.resourceShareInvitationArns = ResourceShareInvitationArnListCopier.copy(resourceShareInvitationArns);
        }

        public final Collection<String> getResourceShareArns() {
            return resourceShareArns;
        }

        @Override
        public final Builder resourceShareArns(Collection<String> resourceShareArns) {
            this.resourceShareArns = ResourceShareArnListCopier.copy(resourceShareArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShareArns(String... resourceShareArns) {
            resourceShareArns(Arrays.asList(resourceShareArns));
            return this;
        }

        public final void setResourceShareArns(Collection<String> resourceShareArns) {
            this.resourceShareArns = ResourceShareArnListCopier.copy(resourceShareArns);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceShareInvitationsRequest build() {
            return new GetResourceShareInvitationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
