/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResourceShareRequest extends RamRequest implements
        ToCopyableBuilder<CreateResourceShareRequest.Builder, CreateResourceShareRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateResourceShareRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateResourceShareRequest::resourceArns))
            .setter(setter(Builder::resourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PRINCIPALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateResourceShareRequest::principals))
            .setter(setter(Builder::principals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateResourceShareRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ALLOW_EXTERNAL_PRINCIPALS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateResourceShareRequest::allowExternalPrincipals)).setter(setter(Builder::allowExternalPrincipals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowExternalPrincipals").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateResourceShareRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<List<String>> PERMISSION_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateResourceShareRequest::permissionArns))
            .setter(setter(Builder::permissionArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            RESOURCE_ARNS_FIELD, PRINCIPALS_FIELD, TAGS_FIELD, ALLOW_EXTERNAL_PRINCIPALS_FIELD, CLIENT_TOKEN_FIELD,
            PERMISSION_ARNS_FIELD));

    private final String name;

    private final List<String> resourceArns;

    private final List<String> principals;

    private final List<Tag> tags;

    private final Boolean allowExternalPrincipals;

    private final String clientToken;

    private final List<String> permissionArns;

    private CreateResourceShareRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.resourceArns = builder.resourceArns;
        this.principals = builder.principals;
        this.tags = builder.tags;
        this.allowExternalPrincipals = builder.allowExternalPrincipals;
        this.clientToken = builder.clientToken;
        this.permissionArns = builder.permissionArns;
    }

    /**
     * <p>
     * The name of the resource share.
     * </p>
     * 
     * @return The name of the resource share.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of the resources to associate with the resource share.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of the resources to associate with the resource share.
     */
    public List<String> resourceArns() {
        return resourceArns;
    }

    /**
     * <p>
     * The principals to associate with the resource share. The possible values are IDs of AWS accounts, the ARN of an
     * OU or organization from AWS Organizations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The principals to associate with the resource share. The possible values are IDs of AWS accounts, the ARN
     *         of an OU or organization from AWS Organizations.
     */
    public List<String> principals() {
        return principals;
    }

    /**
     * <p>
     * One or more tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more tags.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Indicates whether principals outside your AWS organization can be associated with a resource share.
     * </p>
     * 
     * @return Indicates whether principals outside your AWS organization can be associated with a resource share.
     */
    public Boolean allowExternalPrincipals() {
        return allowExternalPrincipals;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ARNs of the permissions to associate with the resource share. If you do not specify an ARN for the
     * permission, AWS RAM automatically attaches the default version of the permission for each resource type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The ARNs of the permissions to associate with the resource share. If you do not specify an ARN for the
     *         permission, AWS RAM automatically attaches the default version of the permission for each resource type.
     */
    public List<String> permissionArns() {
        return permissionArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArns());
        hashCode = 31 * hashCode + Objects.hashCode(principals());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(allowExternalPrincipals());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(permissionArns());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceShareRequest)) {
            return false;
        }
        CreateResourceShareRequest other = (CreateResourceShareRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(resourceArns(), other.resourceArns())
                && Objects.equals(principals(), other.principals()) && Objects.equals(tags(), other.tags())
                && Objects.equals(allowExternalPrincipals(), other.allowExternalPrincipals())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(permissionArns(), other.permissionArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateResourceShareRequest").add("Name", name()).add("ResourceArns", resourceArns())
                .add("Principals", principals()).add("Tags", tags()).add("AllowExternalPrincipals", allowExternalPrincipals())
                .add("ClientToken", clientToken()).add("PermissionArns", permissionArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "resourceArns":
            return Optional.ofNullable(clazz.cast(resourceArns()));
        case "principals":
            return Optional.ofNullable(clazz.cast(principals()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "allowExternalPrincipals":
            return Optional.ofNullable(clazz.cast(allowExternalPrincipals()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "permissionArns":
            return Optional.ofNullable(clazz.cast(permissionArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceShareRequest, T> g) {
        return obj -> g.apply((CreateResourceShareRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RamRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateResourceShareRequest> {
        /**
         * <p>
         * The name of the resource share.
         * </p>
         * 
         * @param name
         *        The name of the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the resources to associate with the resource share.
         * </p>
         * 
         * @param resourceArns
         *        The Amazon Resource Names (ARN) of the resources to associate with the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(Collection<String> resourceArns);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the resources to associate with the resource share.
         * </p>
         * 
         * @param resourceArns
         *        The Amazon Resource Names (ARN) of the resources to associate with the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(String... resourceArns);

        /**
         * <p>
         * The principals to associate with the resource share. The possible values are IDs of AWS accounts, the ARN of
         * an OU or organization from AWS Organizations.
         * </p>
         * 
         * @param principals
         *        The principals to associate with the resource share. The possible values are IDs of AWS accounts, the
         *        ARN of an OU or organization from AWS Organizations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(Collection<String> principals);

        /**
         * <p>
         * The principals to associate with the resource share. The possible values are IDs of AWS accounts, the ARN of
         * an OU or organization from AWS Organizations.
         * </p>
         * 
         * @param principals
         *        The principals to associate with the resource share. The possible values are IDs of AWS accounts, the
         *        ARN of an OU or organization from AWS Organizations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(String... principals);

        /**
         * <p>
         * One or more tags.
         * </p>
         * 
         * @param tags
         *        One or more tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * One or more tags.
         * </p>
         * 
         * @param tags
         *        One or more tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * One or more tags.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Indicates whether principals outside your AWS organization can be associated with a resource share.
         * </p>
         * 
         * @param allowExternalPrincipals
         *        Indicates whether principals outside your AWS organization can be associated with a resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowExternalPrincipals(Boolean allowExternalPrincipals);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ARNs of the permissions to associate with the resource share. If you do not specify an ARN for the
         * permission, AWS RAM automatically attaches the default version of the permission for each resource type.
         * </p>
         * 
         * @param permissionArns
         *        The ARNs of the permissions to associate with the resource share. If you do not specify an ARN for the
         *        permission, AWS RAM automatically attaches the default version of the permission for each resource
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionArns(Collection<String> permissionArns);

        /**
         * <p>
         * The ARNs of the permissions to associate with the resource share. If you do not specify an ARN for the
         * permission, AWS RAM automatically attaches the default version of the permission for each resource type.
         * </p>
         * 
         * @param permissionArns
         *        The ARNs of the permissions to associate with the resource share. If you do not specify an ARN for the
         *        permission, AWS RAM automatically attaches the default version of the permission for each resource
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionArns(String... permissionArns);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RamRequest.BuilderImpl implements Builder {
        private String name;

        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> principals = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Boolean allowExternalPrincipals;

        private String clientToken;

        private List<String> permissionArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceShareRequest model) {
            super(model);
            name(model.name);
            resourceArns(model.resourceArns);
            principals(model.principals);
            tags(model.tags);
            allowExternalPrincipals(model.allowExternalPrincipals);
            clientToken(model.clientToken);
            permissionArns(model.permissionArns);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getResourceArns() {
            return resourceArns;
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnListCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String... resourceArns) {
            resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnListCopier.copy(resourceArns);
        }

        public final Collection<String> getPrincipals() {
            return principals;
        }

        @Override
        public final Builder principals(Collection<String> principals) {
            this.principals = PrincipalArnOrIdListCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(String... principals) {
            principals(Arrays.asList(principals));
            return this;
        }

        public final void setPrincipals(Collection<String> principals) {
            this.principals = PrincipalArnOrIdListCopier.copy(principals);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Boolean getAllowExternalPrincipals() {
            return allowExternalPrincipals;
        }

        @Override
        public final Builder allowExternalPrincipals(Boolean allowExternalPrincipals) {
            this.allowExternalPrincipals = allowExternalPrincipals;
            return this;
        }

        public final void setAllowExternalPrincipals(Boolean allowExternalPrincipals) {
            this.allowExternalPrincipals = allowExternalPrincipals;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Collection<String> getPermissionArns() {
            return permissionArns;
        }

        @Override
        public final Builder permissionArns(Collection<String> permissionArns) {
            this.permissionArns = PermissionArnListCopier.copy(permissionArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionArns(String... permissionArns) {
            permissionArns(Arrays.asList(permissionArns));
            return this;
        }

        public final void setPermissionArns(Collection<String> permissionArns) {
            this.permissionArns = PermissionArnListCopier.copy(permissionArns);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceShareRequest build() {
            return new CreateResourceShareRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
