/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPermissionRequest extends RamRequest implements
        ToCopyableBuilder<GetPermissionRequest.Builder, GetPermissionRequest> {
    private static final SdkField<String> PERMISSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPermissionRequest::permissionArn)).setter(setter(Builder::permissionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionArn").build()).build();

    private static final SdkField<Integer> PERMISSION_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetPermissionRequest::permissionVersion)).setter(setter(Builder::permissionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSION_ARN_FIELD,
            PERMISSION_VERSION_FIELD));

    private final String permissionArn;

    private final Integer permissionVersion;

    private GetPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.permissionArn = builder.permissionArn;
        this.permissionVersion = builder.permissionVersion;
    }

    /**
     * <p>
     * The ARN of the permission.
     * </p>
     * 
     * @return The ARN of the permission.
     */
    public String permissionArn() {
        return permissionArn;
    }

    /**
     * <p>
     * The identifier for the version of the permission.
     * </p>
     * 
     * @return The identifier for the version of the permission.
     */
    public Integer permissionVersion() {
        return permissionVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(permissionArn());
        hashCode = 31 * hashCode + Objects.hashCode(permissionVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPermissionRequest)) {
            return false;
        }
        GetPermissionRequest other = (GetPermissionRequest) obj;
        return Objects.equals(permissionArn(), other.permissionArn())
                && Objects.equals(permissionVersion(), other.permissionVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetPermissionRequest").add("PermissionArn", permissionArn())
                .add("PermissionVersion", permissionVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "permissionArn":
            return Optional.ofNullable(clazz.cast(permissionArn()));
        case "permissionVersion":
            return Optional.ofNullable(clazz.cast(permissionVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPermissionRequest, T> g) {
        return obj -> g.apply((GetPermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RamRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetPermissionRequest> {
        /**
         * <p>
         * The ARN of the permission.
         * </p>
         * 
         * @param permissionArn
         *        The ARN of the permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionArn(String permissionArn);

        /**
         * <p>
         * The identifier for the version of the permission.
         * </p>
         * 
         * @param permissionVersion
         *        The identifier for the version of the permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionVersion(Integer permissionVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RamRequest.BuilderImpl implements Builder {
        private String permissionArn;

        private Integer permissionVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPermissionRequest model) {
            super(model);
            permissionArn(model.permissionArn);
            permissionVersion(model.permissionVersion);
        }

        public final String getPermissionArn() {
            return permissionArn;
        }

        @Override
        public final Builder permissionArn(String permissionArn) {
            this.permissionArn = permissionArn;
            return this;
        }

        public final void setPermissionArn(String permissionArn) {
            this.permissionArn = permissionArn;
        }

        public final Integer getPermissionVersion() {
            return permissionVersion;
        }

        @Override
        public final Builder permissionVersion(Integer permissionVersion) {
            this.permissionVersion = permissionVersion;
            return this;
        }

        public final void setPermissionVersion(Integer permissionVersion) {
            this.permissionVersion = permissionVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPermissionRequest build() {
            return new GetPermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
