/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a resource share.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceShare implements SdkPojo, Serializable, ToCopyableBuilder<ResourceShare.Builder, ResourceShare> {
    private static final SdkField<String> RESOURCE_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceShare::resourceShareArn)).setter(setter(Builder::resourceShareArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceShare::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OWNING_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceShare::owningAccountId)).setter(setter(Builder::owningAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningAccountId").build()).build();

    private static final SdkField<Boolean> ALLOW_EXTERNAL_PRINCIPALS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ResourceShare::allowExternalPrincipals)).setter(setter(Builder::allowExternalPrincipals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowExternalPrincipals").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceShare::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceShare::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(ResourceShare::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ResourceShare::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ResourceShare::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final SdkField<String> FEATURE_SET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceShare::featureSetAsString)).setter(setter(Builder::featureSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featureSet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_ARN_FIELD,
            NAME_FIELD, OWNING_ACCOUNT_ID_FIELD, ALLOW_EXTERNAL_PRINCIPALS_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, TAGS_FIELD,
            CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, FEATURE_SET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceShareArn;

    private final String name;

    private final String owningAccountId;

    private final Boolean allowExternalPrincipals;

    private final String status;

    private final String statusMessage;

    private final List<Tag> tags;

    private final Instant creationTime;

    private final Instant lastUpdatedTime;

    private final String featureSet;

    private ResourceShare(BuilderImpl builder) {
        this.resourceShareArn = builder.resourceShareArn;
        this.name = builder.name;
        this.owningAccountId = builder.owningAccountId;
        this.allowExternalPrincipals = builder.allowExternalPrincipals;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.tags = builder.tags;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.featureSet = builder.featureSet;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource share.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource share.
     */
    public String resourceShareArn() {
        return resourceShareArn;
    }

    /**
     * <p>
     * The name of the resource share.
     * </p>
     * 
     * @return The name of the resource share.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the AWS account that owns the resource share.
     * </p>
     * 
     * @return The ID of the AWS account that owns the resource share.
     */
    public String owningAccountId() {
        return owningAccountId;
    }

    /**
     * <p>
     * Indicates whether principals outside your AWS organization can be associated with a resource share.
     * </p>
     * 
     * @return Indicates whether principals outside your AWS organization can be associated with a resource share.
     */
    public Boolean allowExternalPrincipals() {
        return allowExternalPrincipals;
    }

    /**
     * <p>
     * The status of the resource share.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the resource share.
     * @see ResourceShareStatus
     */
    public ResourceShareStatus status() {
        return ResourceShareStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the resource share.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the resource share.
     * @see ResourceShareStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A message about the status of the resource share.
     * </p>
     * 
     * @return A message about the status of the resource share.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags for the resource share.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags for the resource share.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The time when the resource share was created.
     * </p>
     * 
     * @return The time when the resource share was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time when the resource share was last updated.
     * </p>
     * 
     * @return The time when the resource share was last updated.
     */
    public Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * Indicates how the resource share was created. Possible values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATED_FROM_POLICY</code> - Indicates that the resource share was created from an AWS Identity and Access
     * Management (AWS IAM) policy attached to a resource. These resource shares are visible only to the AWS account
     * that created it. They cannot be modified in AWS RAM.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PROMOTING_TO_STANDARD</code> - The resource share is in the process of being promoted. For more
     * information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STANDARD</code> - Indicates that the resource share was created in AWS RAM using the console or APIs. These
     * resource shares are visible to all principals. They can be modified in AWS RAM.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #featureSet} will
     * return {@link ResourceShareFeatureSet#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #featureSetAsString}.
     * </p>
     * 
     * @return Indicates how the resource share was created. Possible values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATED_FROM_POLICY</code> - Indicates that the resource share was created from an AWS Identity and
     *         Access Management (AWS IAM) policy attached to a resource. These resource shares are visible only to the
     *         AWS account that created it. They cannot be modified in AWS RAM.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PROMOTING_TO_STANDARD</code> - The resource share is in the process of being promoted. For more
     *         information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STANDARD</code> - Indicates that the resource share was created in AWS RAM using the console or
     *         APIs. These resource shares are visible to all principals. They can be modified in AWS RAM.
     *         </p>
     *         </li>
     * @see ResourceShareFeatureSet
     */
    public ResourceShareFeatureSet featureSet() {
        return ResourceShareFeatureSet.fromValue(featureSet);
    }

    /**
     * <p>
     * Indicates how the resource share was created. Possible values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATED_FROM_POLICY</code> - Indicates that the resource share was created from an AWS Identity and Access
     * Management (AWS IAM) policy attached to a resource. These resource shares are visible only to the AWS account
     * that created it. They cannot be modified in AWS RAM.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PROMOTING_TO_STANDARD</code> - The resource share is in the process of being promoted. For more
     * information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STANDARD</code> - Indicates that the resource share was created in AWS RAM using the console or APIs. These
     * resource shares are visible to all principals. They can be modified in AWS RAM.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #featureSet} will
     * return {@link ResourceShareFeatureSet#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #featureSetAsString}.
     * </p>
     * 
     * @return Indicates how the resource share was created. Possible values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATED_FROM_POLICY</code> - Indicates that the resource share was created from an AWS Identity and
     *         Access Management (AWS IAM) policy attached to a resource. These resource shares are visible only to the
     *         AWS account that created it. They cannot be modified in AWS RAM.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PROMOTING_TO_STANDARD</code> - The resource share is in the process of being promoted. For more
     *         information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STANDARD</code> - Indicates that the resource share was created in AWS RAM using the console or
     *         APIs. These resource shares are visible to all principals. They can be modified in AWS RAM.
     *         </p>
     *         </li>
     * @see ResourceShareFeatureSet
     */
    public String featureSetAsString() {
        return featureSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(owningAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(allowExternalPrincipals());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(featureSetAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceShare)) {
            return false;
        }
        ResourceShare other = (ResourceShare) obj;
        return Objects.equals(resourceShareArn(), other.resourceShareArn()) && Objects.equals(name(), other.name())
                && Objects.equals(owningAccountId(), other.owningAccountId())
                && Objects.equals(allowExternalPrincipals(), other.allowExternalPrincipals())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(tags(), other.tags())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(featureSetAsString(), other.featureSetAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceShare").add("ResourceShareArn", resourceShareArn()).add("Name", name())
                .add("OwningAccountId", owningAccountId()).add("AllowExternalPrincipals", allowExternalPrincipals())
                .add("Status", statusAsString()).add("StatusMessage", statusMessage()).add("Tags", tags())
                .add("CreationTime", creationTime()).add("LastUpdatedTime", lastUpdatedTime())
                .add("FeatureSet", featureSetAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceShareArn":
            return Optional.ofNullable(clazz.cast(resourceShareArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "owningAccountId":
            return Optional.ofNullable(clazz.cast(owningAccountId()));
        case "allowExternalPrincipals":
            return Optional.ofNullable(clazz.cast(allowExternalPrincipals()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "featureSet":
            return Optional.ofNullable(clazz.cast(featureSetAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceShare, T> g) {
        return obj -> g.apply((ResourceShare) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceShare> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource share.
         * </p>
         * 
         * @param resourceShareArn
         *        The Amazon Resource Name (ARN) of the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareArn(String resourceShareArn);

        /**
         * <p>
         * The name of the resource share.
         * </p>
         * 
         * @param name
         *        The name of the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the AWS account that owns the resource share.
         * </p>
         * 
         * @param owningAccountId
         *        The ID of the AWS account that owns the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningAccountId(String owningAccountId);

        /**
         * <p>
         * Indicates whether principals outside your AWS organization can be associated with a resource share.
         * </p>
         * 
         * @param allowExternalPrincipals
         *        Indicates whether principals outside your AWS organization can be associated with a resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowExternalPrincipals(Boolean allowExternalPrincipals);

        /**
         * <p>
         * The status of the resource share.
         * </p>
         * 
         * @param status
         *        The status of the resource share.
         * @see ResourceShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the resource share.
         * </p>
         * 
         * @param status
         *        The status of the resource share.
         * @see ResourceShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareStatus
         */
        Builder status(ResourceShareStatus status);

        /**
         * <p>
         * A message about the status of the resource share.
         * </p>
         * 
         * @param statusMessage
         *        A message about the status of the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The tags for the resource share.
         * </p>
         * 
         * @param tags
         *        The tags for the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags for the resource share.
         * </p>
         * 
         * @param tags
         *        The tags for the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags for the resource share.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The time when the resource share was created.
         * </p>
         * 
         * @param creationTime
         *        The time when the resource share was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time when the resource share was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time when the resource share was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * Indicates how the resource share was created. Possible values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATED_FROM_POLICY</code> - Indicates that the resource share was created from an AWS Identity and
         * Access Management (AWS IAM) policy attached to a resource. These resource shares are visible only to the AWS
         * account that created it. They cannot be modified in AWS RAM.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROMOTING_TO_STANDARD</code> - The resource share is in the process of being promoted. For more
         * information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STANDARD</code> - Indicates that the resource share was created in AWS RAM using the console or APIs.
         * These resource shares are visible to all principals. They can be modified in AWS RAM.
         * </p>
         * </li>
         * </ul>
         * 
         * @param featureSet
         *        Indicates how the resource share was created. Possible values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATED_FROM_POLICY</code> - Indicates that the resource share was created from an AWS Identity
         *        and Access Management (AWS IAM) policy attached to a resource. These resource shares are visible only
         *        to the AWS account that created it. They cannot be modified in AWS RAM.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROMOTING_TO_STANDARD</code> - The resource share is in the process of being promoted. For more
         *        information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STANDARD</code> - Indicates that the resource share was created in AWS RAM using the console or
         *        APIs. These resource shares are visible to all principals. They can be modified in AWS RAM.
         *        </p>
         *        </li>
         * @see ResourceShareFeatureSet
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareFeatureSet
         */
        Builder featureSet(String featureSet);

        /**
         * <p>
         * Indicates how the resource share was created. Possible values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATED_FROM_POLICY</code> - Indicates that the resource share was created from an AWS Identity and
         * Access Management (AWS IAM) policy attached to a resource. These resource shares are visible only to the AWS
         * account that created it. They cannot be modified in AWS RAM.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROMOTING_TO_STANDARD</code> - The resource share is in the process of being promoted. For more
         * information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STANDARD</code> - Indicates that the resource share was created in AWS RAM using the console or APIs.
         * These resource shares are visible to all principals. They can be modified in AWS RAM.
         * </p>
         * </li>
         * </ul>
         * 
         * @param featureSet
         *        Indicates how the resource share was created. Possible values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATED_FROM_POLICY</code> - Indicates that the resource share was created from an AWS Identity
         *        and Access Management (AWS IAM) policy attached to a resource. These resource shares are visible only
         *        to the AWS account that created it. They cannot be modified in AWS RAM.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROMOTING_TO_STANDARD</code> - The resource share is in the process of being promoted. For more
         *        information, see <a>PromoteResourceShareCreatedFromPolicy</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STANDARD</code> - Indicates that the resource share was created in AWS RAM using the console or
         *        APIs. These resource shares are visible to all principals. They can be modified in AWS RAM.
         *        </p>
         *        </li>
         * @see ResourceShareFeatureSet
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareFeatureSet
         */
        Builder featureSet(ResourceShareFeatureSet featureSet);
    }

    static final class BuilderImpl implements Builder {
        private String resourceShareArn;

        private String name;

        private String owningAccountId;

        private Boolean allowExternalPrincipals;

        private String status;

        private String statusMessage;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Instant creationTime;

        private Instant lastUpdatedTime;

        private String featureSet;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceShare model) {
            resourceShareArn(model.resourceShareArn);
            name(model.name);
            owningAccountId(model.owningAccountId);
            allowExternalPrincipals(model.allowExternalPrincipals);
            status(model.status);
            statusMessage(model.statusMessage);
            tags(model.tags);
            creationTime(model.creationTime);
            lastUpdatedTime(model.lastUpdatedTime);
            featureSet(model.featureSet);
        }

        public final String getResourceShareArn() {
            return resourceShareArn;
        }

        @Override
        public final Builder resourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
            return this;
        }

        public final void setResourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOwningAccountId() {
            return owningAccountId;
        }

        @Override
        public final Builder owningAccountId(String owningAccountId) {
            this.owningAccountId = owningAccountId;
            return this;
        }

        public final void setOwningAccountId(String owningAccountId) {
            this.owningAccountId = owningAccountId;
        }

        public final Boolean getAllowExternalPrincipals() {
            return allowExternalPrincipals;
        }

        @Override
        public final Builder allowExternalPrincipals(Boolean allowExternalPrincipals) {
            this.allowExternalPrincipals = allowExternalPrincipals;
            return this;
        }

        public final void setAllowExternalPrincipals(Boolean allowExternalPrincipals) {
            this.allowExternalPrincipals = allowExternalPrincipals;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceShareStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final String getFeatureSetAsString() {
            return featureSet;
        }

        @Override
        public final Builder featureSet(String featureSet) {
            this.featureSet = featureSet;
            return this;
        }

        @Override
        public final Builder featureSet(ResourceShareFeatureSet featureSet) {
            this.featureSet(featureSet == null ? null : featureSet.toString());
            return this;
        }

        public final void setFeatureSet(String featureSet) {
            this.featureSet = featureSet;
        }

        @Override
        public ResourceShare build() {
            return new ResourceShare(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
