/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an association with a resource share.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceShareAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceShareAssociation.Builder, ResourceShareAssociation> {
    private static final SdkField<String> RESOURCE_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceShareAssociation::resourceShareArn)).setter(setter(Builder::resourceShareArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArn").build()).build();

    private static final SdkField<String> RESOURCE_SHARE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceShareAssociation::resourceShareName)).setter(setter(Builder::resourceShareName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareName").build()).build();

    private static final SdkField<String> ASSOCIATED_ENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceShareAssociation::associatedEntity)).setter(setter(Builder::associatedEntity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedEntity").build()).build();

    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceShareAssociation::associationTypeAsString)).setter(setter(Builder::associationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceShareAssociation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceShareAssociation::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ResourceShareAssociation::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ResourceShareAssociation::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final SdkField<Boolean> EXTERNAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ResourceShareAssociation::external)).setter(setter(Builder::external))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("external").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_ARN_FIELD,
            RESOURCE_SHARE_NAME_FIELD, ASSOCIATED_ENTITY_FIELD, ASSOCIATION_TYPE_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD,
            CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, EXTERNAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceShareArn;

    private final String resourceShareName;

    private final String associatedEntity;

    private final String associationType;

    private final String status;

    private final String statusMessage;

    private final Instant creationTime;

    private final Instant lastUpdatedTime;

    private final Boolean external;

    private ResourceShareAssociation(BuilderImpl builder) {
        this.resourceShareArn = builder.resourceShareArn;
        this.resourceShareName = builder.resourceShareName;
        this.associatedEntity = builder.associatedEntity;
        this.associationType = builder.associationType;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.external = builder.external;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource share.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource share.
     */
    public String resourceShareArn() {
        return resourceShareArn;
    }

    /**
     * <p>
     * The name of the resource share.
     * </p>
     * 
     * @return The name of the resource share.
     */
    public String resourceShareName() {
        return resourceShareName;
    }

    /**
     * <p>
     * The associated entity. For resource associations, this is the ARN of the resource. For principal associations,
     * this is the ID of an AWS account or the ARN of an OU or organization from AWS Organizations.
     * </p>
     * 
     * @return The associated entity. For resource associations, this is the ARN of the resource. For principal
     *         associations, this is the ID of an AWS account or the ARN of an OU or organization from AWS
     *         Organizations.
     */
    public String associatedEntity() {
        return associatedEntity;
    }

    /**
     * <p>
     * The association type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link ResourceShareAssociationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return The association type.
     * @see ResourceShareAssociationType
     */
    public ResourceShareAssociationType associationType() {
        return ResourceShareAssociationType.fromValue(associationType);
    }

    /**
     * <p>
     * The association type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link ResourceShareAssociationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return The association type.
     * @see ResourceShareAssociationType
     */
    public String associationTypeAsString() {
        return associationType;
    }

    /**
     * <p>
     * The status of the association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceShareAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the association.
     * @see ResourceShareAssociationStatus
     */
    public ResourceShareAssociationStatus status() {
        return ResourceShareAssociationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceShareAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the association.
     * @see ResourceShareAssociationStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A message about the status of the association.
     * </p>
     * 
     * @return A message about the status of the association.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The time when the association was created.
     * </p>
     * 
     * @return The time when the association was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time when the association was last updated.
     * </p>
     * 
     * @return The time when the association was last updated.
     */
    public Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * Indicates whether the principal belongs to the same AWS organization as the AWS account that owns the resource
     * share.
     * </p>
     * 
     * @return Indicates whether the principal belongs to the same AWS organization as the AWS account that owns the
     *         resource share.
     */
    public Boolean external() {
        return external;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareName());
        hashCode = 31 * hashCode + Objects.hashCode(associatedEntity());
        hashCode = 31 * hashCode + Objects.hashCode(associationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(external());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceShareAssociation)) {
            return false;
        }
        ResourceShareAssociation other = (ResourceShareAssociation) obj;
        return Objects.equals(resourceShareArn(), other.resourceShareArn())
                && Objects.equals(resourceShareName(), other.resourceShareName())
                && Objects.equals(associatedEntity(), other.associatedEntity())
                && Objects.equals(associationTypeAsString(), other.associationTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(external(), other.external());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceShareAssociation").add("ResourceShareArn", resourceShareArn())
                .add("ResourceShareName", resourceShareName()).add("AssociatedEntity", associatedEntity())
                .add("AssociationType", associationTypeAsString()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("CreationTime", creationTime())
                .add("LastUpdatedTime", lastUpdatedTime()).add("External", external()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceShareArn":
            return Optional.ofNullable(clazz.cast(resourceShareArn()));
        case "resourceShareName":
            return Optional.ofNullable(clazz.cast(resourceShareName()));
        case "associatedEntity":
            return Optional.ofNullable(clazz.cast(associatedEntity()));
        case "associationType":
            return Optional.ofNullable(clazz.cast(associationTypeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "external":
            return Optional.ofNullable(clazz.cast(external()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceShareAssociation, T> g) {
        return obj -> g.apply((ResourceShareAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceShareAssociation> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource share.
         * </p>
         * 
         * @param resourceShareArn
         *        The Amazon Resource Name (ARN) of the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareArn(String resourceShareArn);

        /**
         * <p>
         * The name of the resource share.
         * </p>
         * 
         * @param resourceShareName
         *        The name of the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareName(String resourceShareName);

        /**
         * <p>
         * The associated entity. For resource associations, this is the ARN of the resource. For principal
         * associations, this is the ID of an AWS account or the ARN of an OU or organization from AWS Organizations.
         * </p>
         * 
         * @param associatedEntity
         *        The associated entity. For resource associations, this is the ARN of the resource. For principal
         *        associations, this is the ID of an AWS account or the ARN of an OU or organization from AWS
         *        Organizations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedEntity(String associatedEntity);

        /**
         * <p>
         * The association type.
         * </p>
         * 
         * @param associationType
         *        The association type.
         * @see ResourceShareAssociationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareAssociationType
         */
        Builder associationType(String associationType);

        /**
         * <p>
         * The association type.
         * </p>
         * 
         * @param associationType
         *        The association type.
         * @see ResourceShareAssociationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareAssociationType
         */
        Builder associationType(ResourceShareAssociationType associationType);

        /**
         * <p>
         * The status of the association.
         * </p>
         * 
         * @param status
         *        The status of the association.
         * @see ResourceShareAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareAssociationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the association.
         * </p>
         * 
         * @param status
         *        The status of the association.
         * @see ResourceShareAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceShareAssociationStatus
         */
        Builder status(ResourceShareAssociationStatus status);

        /**
         * <p>
         * A message about the status of the association.
         * </p>
         * 
         * @param statusMessage
         *        A message about the status of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The time when the association was created.
         * </p>
         * 
         * @param creationTime
         *        The time when the association was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time when the association was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time when the association was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * Indicates whether the principal belongs to the same AWS organization as the AWS account that owns the
         * resource share.
         * </p>
         * 
         * @param external
         *        Indicates whether the principal belongs to the same AWS organization as the AWS account that owns the
         *        resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder external(Boolean external);
    }

    static final class BuilderImpl implements Builder {
        private String resourceShareArn;

        private String resourceShareName;

        private String associatedEntity;

        private String associationType;

        private String status;

        private String statusMessage;

        private Instant creationTime;

        private Instant lastUpdatedTime;

        private Boolean external;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceShareAssociation model) {
            resourceShareArn(model.resourceShareArn);
            resourceShareName(model.resourceShareName);
            associatedEntity(model.associatedEntity);
            associationType(model.associationType);
            status(model.status);
            statusMessage(model.statusMessage);
            creationTime(model.creationTime);
            lastUpdatedTime(model.lastUpdatedTime);
            external(model.external);
        }

        public final String getResourceShareArn() {
            return resourceShareArn;
        }

        @Override
        public final Builder resourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
            return this;
        }

        public final void setResourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
        }

        public final String getResourceShareName() {
            return resourceShareName;
        }

        @Override
        public final Builder resourceShareName(String resourceShareName) {
            this.resourceShareName = resourceShareName;
            return this;
        }

        public final void setResourceShareName(String resourceShareName) {
            this.resourceShareName = resourceShareName;
        }

        public final String getAssociatedEntity() {
            return associatedEntity;
        }

        @Override
        public final Builder associatedEntity(String associatedEntity) {
            this.associatedEntity = associatedEntity;
            return this;
        }

        public final void setAssociatedEntity(String associatedEntity) {
            this.associatedEntity = associatedEntity;
        }

        public final String getAssociationTypeAsString() {
            return associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        @Override
        public final Builder associationType(ResourceShareAssociationType associationType) {
            this.associationType(associationType == null ? null : associationType.toString());
            return this;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceShareAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final Boolean getExternal() {
            return external;
        }

        @Override
        public final Builder external(Boolean external) {
            this.external = external;
            return this;
        }

        public final void setExternal(Boolean external) {
            this.external = external;
        }

        @Override
        public ResourceShareAssociation build() {
            return new ResourceShareAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
