/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ResourceOwner {
    SELF("SELF"),
    OTHER_ACCOUNTS("OTHER-ACCOUNTS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ResourceOwner(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceOwner fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ResourceOwner.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceOwner> knownValues() {
        return Stream.of(ResourceOwner.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

