/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an AWS RAM permission.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceSharePermissionDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceSharePermissionDetail.Builder, ResourceSharePermissionDetail> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ResourceSharePermissionDetail::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(ResourceSharePermissionDetail::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<Boolean> DEFAULT_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("defaultVersion").getter(getter(ResourceSharePermissionDetail::defaultVersion))
            .setter(setter(Builder::defaultVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVersion").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ResourceSharePermissionDetail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(ResourceSharePermissionDetail::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> PERMISSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("permission").getter(getter(ResourceSharePermissionDetail::permission))
            .setter(setter(Builder::permission))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permission").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(ResourceSharePermissionDetail::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedTime").getter(getter(ResourceSharePermissionDetail::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, VERSION_FIELD,
            DEFAULT_VERSION_FIELD, NAME_FIELD, RESOURCE_TYPE_FIELD, PERMISSION_FIELD, CREATION_TIME_FIELD,
            LAST_UPDATED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String version;

    private final Boolean defaultVersion;

    private final String name;

    private final String resourceType;

    private final String permission;

    private final Instant creationTime;

    private final Instant lastUpdatedTime;

    private ResourceSharePermissionDetail(BuilderImpl builder) {
        this.arn = builder.arn;
        this.version = builder.version;
        this.defaultVersion = builder.defaultVersion;
        this.name = builder.name;
        this.resourceType = builder.resourceType;
        this.permission = builder.permission;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * <p>
     * The ARN of the permission.
     * </p>
     * 
     * @return The ARN of the permission.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The identifier for the version of the permission.
     * </p>
     * 
     * @return The identifier for the version of the permission.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * The identifier for the version of the permission that is set as the default version.
     * </p>
     * 
     * @return The identifier for the version of the permission that is set as the default version.
     */
    public Boolean defaultVersion() {
        return defaultVersion;
    }

    /**
     * <p>
     * The name of the permission.
     * </p>
     * 
     * @return The name of the permission.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The resource type to which the permission applies.
     * </p>
     * 
     * @return The resource type to which the permission applies.
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The permission's effect and actions in JSON format. The <code>effect</code> indicates whether the actions are
     * allowed or denied. The <code>actions</code> list the API actions to which the principal is granted or denied
     * access.
     * </p>
     * 
     * @return The permission's effect and actions in JSON format. The <code>effect</code> indicates whether the actions
     *         are allowed or denied. The <code>actions</code> list the API actions to which the principal is granted or
     *         denied access.
     */
    public String permission() {
        return permission;
    }

    /**
     * <p>
     * The date and time when the permission was created.
     * </p>
     * 
     * @return The date and time when the permission was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time when the permission was last updated.
     * </p>
     * 
     * @return The date and time when the permission was last updated.
     */
    public Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(defaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(permission());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSharePermissionDetail)) {
            return false;
        }
        ResourceSharePermissionDetail other = (ResourceSharePermissionDetail) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(version(), other.version())
                && Objects.equals(defaultVersion(), other.defaultVersion()) && Objects.equals(name(), other.name())
                && Objects.equals(resourceType(), other.resourceType()) && Objects.equals(permission(), other.permission())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceSharePermissionDetail").add("Arn", arn()).add("Version", version())
                .add("DefaultVersion", defaultVersion()).add("Name", name()).add("ResourceType", resourceType())
                .add("Permission", permission()).add("CreationTime", creationTime()).add("LastUpdatedTime", lastUpdatedTime())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "defaultVersion":
            return Optional.ofNullable(clazz.cast(defaultVersion()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "permission":
            return Optional.ofNullable(clazz.cast(permission()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceSharePermissionDetail, T> g) {
        return obj -> g.apply((ResourceSharePermissionDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceSharePermissionDetail> {
        /**
         * <p>
         * The ARN of the permission.
         * </p>
         * 
         * @param arn
         *        The ARN of the permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The identifier for the version of the permission.
         * </p>
         * 
         * @param version
         *        The identifier for the version of the permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The identifier for the version of the permission that is set as the default version.
         * </p>
         * 
         * @param defaultVersion
         *        The identifier for the version of the permission that is set as the default version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVersion(Boolean defaultVersion);

        /**
         * <p>
         * The name of the permission.
         * </p>
         * 
         * @param name
         *        The name of the permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The resource type to which the permission applies.
         * </p>
         * 
         * @param resourceType
         *        The resource type to which the permission applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The permission's effect and actions in JSON format. The <code>effect</code> indicates whether the actions are
         * allowed or denied. The <code>actions</code> list the API actions to which the principal is granted or denied
         * access.
         * </p>
         * 
         * @param permission
         *        The permission's effect and actions in JSON format. The <code>effect</code> indicates whether the
         *        actions are allowed or denied. The <code>actions</code> list the API actions to which the principal is
         *        granted or denied access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permission(String permission);

        /**
         * <p>
         * The date and time when the permission was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time when the permission was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date and time when the permission was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The date and time when the permission was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String version;

        private Boolean defaultVersion;

        private String name;

        private String resourceType;

        private String permission;

        private Instant creationTime;

        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSharePermissionDetail model) {
            arn(model.arn);
            version(model.version);
            defaultVersion(model.defaultVersion);
            name(model.name);
            resourceType(model.resourceType);
            permission(model.permission);
            creationTime(model.creationTime);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Boolean getDefaultVersion() {
            return defaultVersion;
        }

        @Override
        public final Builder defaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
            return this;
        }

        public final void setDefaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getPermission() {
            return permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public ResourceSharePermissionDetail build() {
            return new ResourceSharePermissionDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
