/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPendingInvitationResourcesResponse extends RamResponse implements
        ToCopyableBuilder<ListPendingInvitationResourcesResponse.Builder, ListPendingInvitationResourcesResponse> {
    private static final SdkField<List<Resource>> RESOURCES_FIELD = SdkField
            .<List<Resource>> builder(MarshallingType.LIST)
            .memberName("resources")
            .getter(getter(ListPendingInvitationResourcesResponse::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Resource> builder(MarshallingType.SDK_POJO)
                                            .constructor(Resource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPendingInvitationResourcesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Resource> resources;

    private final String nextToken;

    private ListPendingInvitationResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.resources = builder.resources;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Resources property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the resources included the resource share.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the resources included the resource share.
     */
    public List<Resource> resources() {
        return resources;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPendingInvitationResourcesResponse)) {
            return false;
        }
        ListPendingInvitationResourcesResponse other = (ListPendingInvitationResourcesResponse) obj;
        return hasResources() == other.hasResources() && Objects.equals(resources(), other.resources())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPendingInvitationResourcesResponse").add("Resources", hasResources() ? resources() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPendingInvitationResourcesResponse, T> g) {
        return obj -> g.apply((ListPendingInvitationResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RamResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPendingInvitationResourcesResponse> {
        /**
         * <p>
         * Information about the resources included the resource share.
         * </p>
         * 
         * @param resources
         *        Information about the resources included the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<Resource> resources);

        /**
         * <p>
         * Information about the resources included the resource share.
         * </p>
         * 
         * @param resources
         *        Information about the resources included the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Resource... resources);

        /**
         * <p>
         * Information about the resources included the resource share.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Resource>.Builder} avoiding the need to
         * create one manually via {@link List<Resource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Resource>.Builder#build()} is called immediately and its
         * result is passed to {@link #resources(List<Resource>)}.
         * 
         * @param resources
         *        a consumer that will call methods on {@link List<Resource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(List<Resource>)
         */
        Builder resources(Consumer<Resource.Builder>... resources);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends RamResponse.BuilderImpl implements Builder {
        private List<Resource> resources = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPendingInvitationResourcesResponse model) {
            super(model);
            resources(model.resources);
            nextToken(model.nextToken);
        }

        public final Collection<Resource.Builder> getResources() {
            if (resources instanceof SdkAutoConstructList) {
                return null;
            }
            return resources != null ? resources.stream().map(Resource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resources(Collection<Resource> resources) {
            this.resources = ResourceListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Resource... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<Resource.Builder>... resources) {
            resources(Stream.of(resources).map(c -> Resource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResources(Collection<Resource.BuilderImpl> resources) {
            this.resources = ResourceListCopier.copyFromBuilder(resources);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPendingInvitationResourcesResponse build() {
            return new ListPendingInvitationResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
