/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPrincipalsResponse extends RamResponse implements
        ToCopyableBuilder<ListPrincipalsResponse.Builder, ListPrincipalsResponse> {
    private static final SdkField<List<Principal>> PRINCIPALS_FIELD = SdkField
            .<List<Principal>> builder(MarshallingType.LIST)
            .memberName("principals")
            .getter(getter(ListPrincipalsResponse::principals))
            .setter(setter(Builder::principals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Principal> builder(MarshallingType.SDK_POJO)
                                            .constructor(Principal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPrincipalsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPALS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Principal> principals;

    private final String nextToken;

    private ListPrincipalsResponse(BuilderImpl builder) {
        super(builder);
        this.principals = builder.principals;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Principals property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPrincipals() {
        return principals != null && !(principals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The principals.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPrincipals()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The principals.
     */
    public final List<Principal> principals() {
        return principals;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPrincipals() ? principals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPrincipalsResponse)) {
            return false;
        }
        ListPrincipalsResponse other = (ListPrincipalsResponse) obj;
        return hasPrincipals() == other.hasPrincipals() && Objects.equals(principals(), other.principals())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPrincipalsResponse").add("Principals", hasPrincipals() ? principals() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "principals":
            return Optional.ofNullable(clazz.cast(principals()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPrincipalsResponse, T> g) {
        return obj -> g.apply((ListPrincipalsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RamResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPrincipalsResponse> {
        /**
         * <p>
         * The principals.
         * </p>
         * 
         * @param principals
         *        The principals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(Collection<Principal> principals);

        /**
         * <p>
         * The principals.
         * </p>
         * 
         * @param principals
         *        The principals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(Principal... principals);

        /**
         * <p>
         * The principals.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Principal>.Builder} avoiding the need to
         * create one manually via {@link List<Principal>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Principal>.Builder#build()} is called immediately and its
         * result is passed to {@link #principals(List<Principal>)}.
         * 
         * @param principals
         *        a consumer that will call methods on {@link List<Principal>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principals(List<Principal>)
         */
        Builder principals(Consumer<Principal.Builder>... principals);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends RamResponse.BuilderImpl implements Builder {
        private List<Principal> principals = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPrincipalsResponse model) {
            super(model);
            principals(model.principals);
            nextToken(model.nextToken);
        }

        public final List<Principal.Builder> getPrincipals() {
            List<Principal.Builder> result = PrincipalListCopier.copyToBuilder(this.principals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder principals(Collection<Principal> principals) {
            this.principals = PrincipalListCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(Principal... principals) {
            principals(Arrays.asList(principals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(Consumer<Principal.Builder>... principals) {
            principals(Stream.of(principals).map(c -> Principal.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPrincipals(Collection<Principal.BuilderImpl> principals) {
            this.principals = PrincipalListCopier.copyFromBuilder(principals);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPrincipalsResponse build() {
            return new ListPrincipalsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
