/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResourceShareResponse extends RamResponse implements
        ToCopyableBuilder<UpdateResourceShareResponse.Builder, UpdateResourceShareResponse> {
    private static final SdkField<ResourceShare> RESOURCE_SHARE_FIELD = SdkField
            .<ResourceShare> builder(MarshallingType.SDK_POJO).memberName("resourceShare")
            .getter(getter(UpdateResourceShareResponse::resourceShare)).setter(setter(Builder::resourceShare))
            .constructor(ResourceShare::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShare").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(UpdateResourceShareResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_FIELD,
            CLIENT_TOKEN_FIELD));

    private final ResourceShare resourceShare;

    private final String clientToken;

    private UpdateResourceShareResponse(BuilderImpl builder) {
        super(builder);
        this.resourceShare = builder.resourceShare;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Information about the resource share.
     * </p>
     * 
     * @return Information about the resource share.
     */
    public final ResourceShare resourceShare() {
        return resourceShare;
    }

    /**
     * <p>
     * The idempotency identifier associated with this request. If you want to repeat the same operation in an
     * idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that
     * later call. All other parameters must also have the same values that you used in the first call.
     * </p>
     * 
     * @return The idempotency identifier associated with this request. If you want to repeat the same operation in an
     *         idempotent manner then you must include this value in the <code>clientToken</code> request parameter of
     *         that later call. All other parameters must also have the same values that you used in the first call.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceShare());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceShareResponse)) {
            return false;
        }
        UpdateResourceShareResponse other = (UpdateResourceShareResponse) obj;
        return Objects.equals(resourceShare(), other.resourceShare()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateResourceShareResponse").add("ResourceShare", resourceShare())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceShare":
            return Optional.ofNullable(clazz.cast(resourceShare()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourceShareResponse, T> g) {
        return obj -> g.apply((UpdateResourceShareResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RamResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateResourceShareResponse> {
        /**
         * <p>
         * Information about the resource share.
         * </p>
         * 
         * @param resourceShare
         *        Information about the resource share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShare(ResourceShare resourceShare);

        /**
         * <p>
         * Information about the resource share.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceShare.Builder} avoiding the need to
         * create one manually via {@link ResourceShare#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceShare.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceShare(ResourceShare)}.
         * 
         * @param resourceShare
         *        a consumer that will call methods on {@link ResourceShare.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceShare(ResourceShare)
         */
        default Builder resourceShare(Consumer<ResourceShare.Builder> resourceShare) {
            return resourceShare(ResourceShare.builder().applyMutation(resourceShare).build());
        }

        /**
         * <p>
         * The idempotency identifier associated with this request. If you want to repeat the same operation in an
         * idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that
         * later call. All other parameters must also have the same values that you used in the first call.
         * </p>
         * 
         * @param clientToken
         *        The idempotency identifier associated with this request. If you want to repeat the same operation in
         *        an idempotent manner then you must include this value in the <code>clientToken</code> request
         *        parameter of that later call. All other parameters must also have the same values that you used in the
         *        first call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);
    }

    static final class BuilderImpl extends RamResponse.BuilderImpl implements Builder {
        private ResourceShare resourceShare;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceShareResponse model) {
            super(model);
            resourceShare(model.resourceShare);
            clientToken(model.clientToken);
        }

        public final ResourceShare.Builder getResourceShare() {
            return resourceShare != null ? resourceShare.toBuilder() : null;
        }

        public final void setResourceShare(ResourceShare.BuilderImpl resourceShare) {
            this.resourceShare = resourceShare != null ? resourceShare.build() : null;
        }

        @Override
        @Transient
        public final Builder resourceShare(ResourceShare resourceShare) {
            this.resourceShare = resourceShare;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public UpdateResourceShareResponse build() {
            return new UpdateResourceShareResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
